/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class TestCaseDBVersionScope {
    public static final int CHAR_ENC_TYPE_UNSPECIFIED = 0;
    public static final int CHAR_ENC_TYPE_ASCII = 1;
    public static final int CHAR_ENC_TYPE_UNICODE = 2;
    public static final int CHAR_ENC_TYPE_MIXED = 3;
    public static final int SQLMODE_UNSPECIFIED = 0;
    public static final int SQLMODE_INTERNAL = 1;
    public static final int SQLMODE_ORACLE = 2;
    private Collection m_collExcludes = new LinkedList();
    private static final int ST_EXP_OPENING_BRACKET = 0;
    private static final int ST_EXP_VERSION_OR_NEXT_ELEMENT = 1;
    private static final int ST_EXP_COMMA_OR_NEXT_ELEMENT = 2;
    private static final int ST_EXP_NEXT_VERSION = 3;
    private static final int ST_EXP_CHAR_ENC_TYPE_OR_NEXT_ELEMENT = 4;
    private static final int ST_EXP_NEXT_ELEMENT_AFTER_CHAR_ENC_TYPE = 5;
    private static final int ST_EXP_SQLMODE_OR_CLOSING_BRACKET = 6;
    private static final int ST_EXP_CLOSING_BRACKET_AFTER_SQLMODE = 7;

    public TestCaseDBVersionScope() {
    }

    public TestCaseDBVersionScope(String strRestrictions) throws IllegalArgumentException {
        this.m_collExcludes = this.parse(strRestrictions);
    }

    public boolean hasSQLModeRestriction(String sqlmode) {
        return this.hasSQLModeRestriction(Exclude.sqlmode(sqlmode));
    }

    public boolean hasSQLModeRestriction(int sqlmode) {
        Iterator it = this.m_collExcludes.iterator();
        while (it.hasNext()) {
            Exclude ex = (Exclude)it.next();
            if (ex.m_sqlmode != sqlmode) continue;
            return true;
        }
        return false;
    }

    public boolean hasCharacterEncodingTypeRestriction(String charEncType) {
        return this.hasCharacterEncodingTypeRestriction(Exclude.charEncType(charEncType));
    }

    public boolean hasCharacterEncodingTypeRestriction(int charEncType) {
        Iterator it = this.m_collExcludes.iterator();
        while (it.hasNext()) {
            Exclude ex = (Exclude)it.next();
            if (ex.m_charEncType != charEncType) continue;
            return true;
        }
        return false;
    }

    public boolean hasDBVersionRestriction(String res) {
        Iterator it = this.m_collExcludes.iterator();
        while (it.hasNext()) {
            Exclude ex = (Exclude)it.next();
            if (!ex.hasVersionIntersection(res)) continue;
            return true;
        }
        return false;
    }

    public boolean hasExclusionSetIntersection(TestCaseDBVersionScope scope) {
        Iterator it1 = this.m_collExcludes.iterator();
        while (it1.hasNext()) {
            Exclude ex1 = (Exclude)it1.next();
            Iterator it2 = scope.m_collExcludes.iterator();
            while (it2.hasNext()) {
                Exclude ex2 = (Exclude)it2.next();
                if (!ex1.intersects(ex2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInScope(String charEncType, String sqlmode, String version) throws IllegalArgumentException {
        return this.isInScope(Exclude.charEncType(charEncType), Exclude.sqlmode(sqlmode), version);
    }

    public boolean isInScope(int charEncType, int sqlmode, String version) throws IllegalArgumentException {
        return !this.isOutOfScope(charEncType, sqlmode, version);
    }

    public boolean isOutOfScope(String charEncType, String sqlmode, String version) throws IllegalArgumentException {
        return this.isOutOfScope(Exclude.charEncType(charEncType), Exclude.sqlmode(sqlmode), version);
    }

    public boolean isOutOfScope(int charEncType, int sqlmode, String version) throws IllegalArgumentException {
        return this.hasMatchingExclude(charEncType, sqlmode, version);
    }

    private boolean hasMatchingExclude(int charEncType, int sqlmode, String version) {
        Iterator it = this.m_collExcludes.iterator();
        while (it.hasNext()) {
            if (!((Exclude)it.next()).matches(charEncType, sqlmode, version)) continue;
            return true;
        }
        return false;
    }

    protected Collection parse(String str) throws IllegalArgumentException {
        StreamTokenizer st = new StreamTokenizer(new StringReader(str));
        st.resetSyntax();
        st.whitespaceChars(32, 32);
        st.whitespaceChars(9, 9);
        st.whitespaceChars(13, 13);
        st.whitespaceChars(10, 10);
        st.wordChars(42, 42);
        st.wordChars(48, 57);
        st.wordChars(46, 46);
        st.wordChars(45, 45);
        st.wordChars(97, 122);
        st.wordChars(65, 90);
        st.eolIsSignificant(false);
        st.slashSlashComments(false);
        st.slashStarComments(false);
        int state = 0;
        Exclude curExclude = new Exclude();
        LinkedList<Exclude> collExcludes = new LinkedList<Exclude>();
        try {
            while (st.nextToken() != -1) {
                switch (state) {
                    case 0: {
                        if (st.ttype == 40) {
                            state = 1;
                            break;
                        }
                        throw new IllegalArgumentException("Expecting '(', got '" + st.toString() + "'");
                    }
                    case 1: {
                        if (st.ttype == 59) {
                            state = 4;
                            break;
                        }
                        if (st.ttype == -3) {
                            curExclude.addVersion(st.sval);
                            state = 2;
                            break;
                        }
                        throw new IllegalArgumentException("Expecting version or next element, got '" + st.toString() + "'");
                    }
                    case 2: {
                        if (st.ttype == 59) {
                            state = 4;
                            break;
                        }
                        if (st.ttype == 44) {
                            state = 3;
                            break;
                        }
                        throw new IllegalArgumentException("Expecting comma or next element, got '" + st.toString() + "'");
                    }
                    case 3: {
                        if (st.ttype == -3) {
                            curExclude.addVersion(st.sval);
                            state = 2;
                            break;
                        }
                        throw new IllegalArgumentException("Expecting next version, got '" + st.toString() + "'");
                    }
                    case 4: {
                        if (st.ttype == 59) {
                            state = 6;
                            break;
                        }
                        if (st.ttype == -3) {
                            curExclude.setCharacterEncodingType(st.sval);
                            state = 5;
                            break;
                        }
                        throw new IllegalArgumentException("Expecting character encoding type or next element, got '" + st.toString() + "'");
                    }
                    case 5: {
                        if (st.ttype == 59) {
                            state = 6;
                            break;
                        }
                        throw new IllegalArgumentException("Expecting next element, got '" + st.toString() + "'");
                    }
                    case 6: {
                        if (st.ttype == 41) {
                            collExcludes.add(curExclude);
                            curExclude = new Exclude();
                            state = 0;
                            break;
                        }
                        if (st.ttype == -3) {
                            curExclude.setSQLMode(st.sval);
                            state = 7;
                            break;
                        }
                        throw new IllegalArgumentException("Expecing sqlmode or closing bracket, got '" + st.toString() + "'");
                    }
                    case 7: {
                        if (st.ttype == 41) {
                            collExcludes.add(curExclude);
                            curExclude = new Exclude();
                            state = 0;
                            break;
                        }
                        throw new IllegalArgumentException("Expecting closing bracket, got '" + st.toString() + "'");
                    }
                }
            }
            if (state != 0) {
                throw new IllegalArgumentException("Unexpected end of string");
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Got IOException while parsing: " + ex.getMessage());
        }
        return collExcludes;
    }

    public String toString() {
        String str = "";
        Iterator it = this.m_collExcludes.iterator();
        while (it.hasNext()) {
            str = str + it.next();
        }
        return str;
    }

    private static class Exclude {
        private static final String[] CHAR_ENC_TYPES_AS_STRING = new String[]{"", "ascii", "unicode", "mixed"};
        private static final String[] SQLMODES_AS_STRING = new String[]{"", "internal", "oracle"};
        private Collection m_collVersions = new LinkedList();
        private int m_charEncType = 0;
        private int m_sqlmode = 0;

        public void addVersion(String strVersion) throws IllegalArgumentException {
            this.m_collVersions.add(new Version(strVersion));
        }

        public static final int charEncType(String encType) throws IllegalArgumentException {
            if (encType.equalsIgnoreCase("ascii")) {
                return 1;
            }
            if (encType.equalsIgnoreCase("unicode")) {
                return 2;
            }
            if (encType.equalsIgnoreCase("mixed")) {
                return 3;
            }
            throw new IllegalArgumentException("Illegal character encoding type '" + encType + "';\n choose 'ascii', 'unicode' or 'mixed'");
        }

        public static final int sqlmode(String sqlmode) throws IllegalArgumentException {
            if (sqlmode.equalsIgnoreCase("internal")) {
                return 1;
            }
            if (sqlmode.equalsIgnoreCase("oracle")) {
                return 2;
            }
            throw new IllegalArgumentException("Illegal sqlmode '" + sqlmode + "', choose 'internal' or 'oracle'");
        }

        public void setCharacterEncodingType(String encType) throws IllegalArgumentException {
            this.m_charEncType = Exclude.charEncType(encType);
        }

        public void setSQLMode(String sqlmode) throws IllegalArgumentException {
            this.m_sqlmode = Exclude.sqlmode(sqlmode);
        }

        public String toString() {
            String str = "( ";
            boolean first = true;
            Iterator it = this.m_collVersions.iterator();
            while (it.hasNext()) {
                str = str + (first ? "" : ", ") + it.next();
                first = false;
            }
            return str + "; " + CHAR_ENC_TYPES_AS_STRING[this.m_charEncType] + "; " + SQLMODES_AS_STRING[this.m_sqlmode] + " )";
        }

        public boolean matches(int charEncType, int sqlmode, String version) throws IllegalArgumentException {
            return !(this.m_charEncType != 0 && this.m_charEncType != charEncType || this.m_sqlmode != 0 && this.m_sqlmode != sqlmode || !this.noVersionSpecified() && !this.hasMatchingVersion(version));
        }

        public boolean intersects(Exclude ex) {
            return !(this.m_charEncType != 0 && ex.m_charEncType != 0 && this.m_charEncType != ex.m_charEncType || this.m_sqlmode != 0 && ex.m_sqlmode != 0 && this.m_sqlmode != ex.m_sqlmode || !this.noVersionSpecified() && !ex.noVersionSpecified() && !this.hasVersionIntersection(ex));
        }

        private boolean hasVersionIntersection(Exclude ex) {
            Iterator it1 = this.m_collVersions.iterator();
            while (it1.hasNext()) {
                Version v1 = (Version)it1.next();
                Iterator it2 = ex.m_collVersions.iterator();
                while (it2.hasNext()) {
                    Version v2 = (Version)it2.next();
                    if (!v1.intersects(v2)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean hasVersionIntersection(String str) {
            Version v = new Version(str);
            Iterator it1 = this.m_collVersions.iterator();
            while (it1.hasNext()) {
                Version v1 = (Version)it1.next();
                if (!v.intersects(v1)) continue;
                return true;
            }
            return false;
        }

        private boolean noVersionSpecified() {
            return this.m_collVersions.size() == 0;
        }

        private boolean hasMatchingVersion(String version) throws IllegalArgumentException {
            Iterator it = this.m_collVersions.iterator();
            while (it.hasNext()) {
                if (!((Version)it.next()).matches(version)) continue;
                return true;
            }
            return false;
        }

        private static class Version {
            private long m_version = 0L;
            private long m_rightBoundVersion = 0L;
            private boolean m_matchFrom = false;
            private boolean m_matchUntil = false;
            private boolean m_matchAllBelow = false;
            private boolean m_matchInterval = false;
            private static final int VERSION_LEVELS = 5;
            private static final int VERSION_ELEMENT_WIDTH = 3;

            public boolean intersects(Version v) {
                return this.matches(v.m_version) || v.matches(this.m_version);
            }

            public Version(String str) throws IllegalArgumentException {
                int pos;
                String origStr = str;
                if (str.startsWith("-")) {
                    this.m_matchUntil = true;
                    str = str.substring(1);
                }
                if (str.endsWith("-")) {
                    if (this.m_matchUntil) {
                        throw new IllegalArgumentException("Illegal version specification '" + origStr + "'");
                    }
                    this.m_matchFrom = true;
                    str = str.substring(0, str.length() - 1);
                }
                if (str.endsWith("*")) {
                    if (this.m_matchUntil || this.m_matchFrom) {
                        throw new IllegalArgumentException("Illegal version specification '" + origStr + "'");
                    }
                    this.m_matchAllBelow = true;
                    str = str.substring(0, str.length() - 1);
                }
                if ((pos = str.indexOf(45)) != -1) {
                    if (this.m_matchUntil || this.m_matchFrom || this.m_matchAllBelow) {
                        throw new IllegalArgumentException("Illegal version specification '" + origStr + "'");
                    }
                    this.m_matchInterval = true;
                    this.m_rightBoundVersion = this.parse(str.substring(pos + 1));
                    str = str.substring(0, pos);
                }
                this.m_version = this.parse(str);
                if (this.m_matchInterval && this.m_rightBoundVersion <= this.m_version) {
                    throw new IllegalArgumentException("Illegal version specification (wrong interval) '" + origStr + "'");
                }
            }

            public boolean matches(String str) throws IllegalArgumentException {
                return this.matches(this.parse(str));
            }

            public boolean matches(long v) {
                boolean allBelowResult = false;
                if (this.m_matchAllBelow) {
                    char[] str = (v + "").toCharArray();
                    char[] mask = (this.m_version + "").toCharArray();
                    boolean r = false;
                    allBelowResult = true;
                    for (int i = str.length - 1; i >= 0; --i) {
                        if (r) {
                            if (str[i] == mask[i]) continue;
                            allBelowResult = false;
                            break;
                        }
                        boolean bl = r = mask[i] != '0';
                        if (!r) continue;
                        ++i;
                    }
                }
                return v == this.m_version || this.m_matchUntil && v < this.m_version || this.m_matchFrom && v > this.m_version || this.m_matchInterval && v >= this.m_version && v <= this.m_rightBoundVersion || this.m_matchAllBelow && allBelowResult;
            }

            private long parse(String str) {
                long r = 0L;
                long curExp = (long)Math.pow(10.0, 12.0);
                StringTokenizer st = new StringTokenizer(str, ".", false);
                int n = 0;
                while (st.hasMoreTokens()) {
                    try {
                        n = Integer.parseInt(st.nextToken());
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Illegal version specification '" + str + "'");
                    }
                    r += (long)n * curExp;
                    curExp = (long)((double)curExp / Math.pow(10.0, 3.0));
                }
                return r;
            }

            public String toString() {
                return (this.m_matchUntil ? "-" : "") + this.m_version + (this.m_matchFrom ? "-" : "") + (this.m_matchAllBelow ? "*" : "") + (this.m_matchInterval ? "-" + this.m_rightBoundVersion : "");
            }
        }
    }
}

