/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.Table;
import com.sap.sapdb.testframe.utilities.TableFillerThread;
import java.sql.Connection;
import java.sql.SQLException;

public class TableFiller
extends Thread {
    private Table mTable;
    private TestCase mTestCase;
    private TestDatabase mDatabase;
    private int mTableEntries;
    private int mNoOfThreads;
    private String mUser;
    private String mPassword;
    private Exception mException;
    private boolean mHasError;
    private boolean mUpdateStatistics = false;

    public TableFiller(Table pTable, TestCase pTestCase, TestDatabase pDatabase, String pUser, String pPassword, int pTableEntries, int pNoOfThreads) {
        this(pTable, pTestCase, pDatabase, pUser, pPassword, pTableEntries, pNoOfThreads, false);
    }

    public TableFiller(Table pTable, TestCase pTestCase, TestDatabase pDatabase, String pUser, String pPassword, int pTableEntries, int pNoOfThreads, boolean pUpdateStatistics) {
        this.mTable = pTable;
        this.mTestCase = pTestCase;
        this.mDatabase = pDatabase;
        this.mUser = pUser;
        this.mPassword = pPassword;
        this.mTableEntries = pTableEntries;
        this.mNoOfThreads = pNoOfThreads;
        this.mUpdateStatistics = pUpdateStatistics;
    }

    public Exception getException() {
        return this.mException;
    }

    public Table getTable() {
        return this.mTable;
    }

    public boolean hasError() {
        return this.mHasError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block18: {
            Connection[] lc;
            block17: {
                int i;
                this.mHasError = false;
                lc = new Connection[this.mNoOfThreads];
                TableFillerThread[] tft = new TableFillerThread[this.mNoOfThreads];
                if (this.mNoOfThreads == 0) {
                    this.mNoOfThreads = 1;
                }
                int lEntries = this.mTableEntries / this.mNoOfThreads;
                for (int i2 = 0; i2 < this.mNoOfThreads; ++i2) {
                    if (i2 == this.mNoOfThreads - 1) {
                        lEntries += this.mTableEntries % this.mNoOfThreads;
                    }
                    lc[i2] = this.mDatabase.connect(this.mUser, this.mPassword);
                    lc[i2].setAutoCommit(false);
                    tft[i2] = new TableFillerThread(this.mTable, this.mTestCase, lc[i2], lEntries);
                    tft[i2].setName("Table filler #" + i2);
                    tft[i2].start();
                }
                boolean isOneAlive = true;
                block9: while (isOneAlive) {
                    Thread.sleep(2000L);
                    isOneAlive = false;
                    for (i = 0; i < this.mNoOfThreads; ++i) {
                        if (!tft[i].isAlive()) continue;
                        isOneAlive = true;
                        continue block9;
                    }
                }
                for (i = 0; i < this.mNoOfThreads; ++i) {
                    if (!tft[i].hasError()) continue;
                    throw tft[i].getException();
                }
                if (!this.mUpdateStatistics) break block17;
                TestStatement stmt = new TestStatement(this.mTestCase, this.mDatabase.connect(this.mUser, this.mPassword));
                this.mTable.updateStatistics(stmt);
            }
            Object var7_9 = null;
            try {
                for (int i = 0; i < this.mNoOfThreads; ++i) {
                    lc[i].commit();
                    lc[i].close();
                }
            }
            catch (SQLException esql) {
                System.err.println("SQL Error in TableFillerThread");
                esql.printStackTrace(System.err);
                {
                    break block18;
                }
            }
            break block18;
            {
                catch (Exception e) {
                    this.mHasError = true;
                    this.mException = e;
                    Object var7_10 = null;
                    try {
                        for (int i = 0; i < this.mNoOfThreads; ++i) {
                            lc[i].commit();
                            lc[i].close();
                        }
                        break block18;
                    }
                    catch (SQLException esql) {
                        System.err.println("SQL Error in TableFillerThread");
                        esql.printStackTrace(System.err);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                try {
                    for (int i = 0; i < this.mNoOfThreads; ++i) {
                        lc[i].commit();
                        lc[i].close();
                    }
                }
                catch (SQLException esql) {
                    System.err.println("SQL Error in TableFillerThread");
                    esql.printStackTrace(System.err);
                }
                throw throwable;
            }
        }
    }
}

