/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import com.sap.sapdb.testframe.utilities.DBInputStream;
import com.sap.sapdb.testframe.utilities.TableField;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Random;

final class RandomFieldValueGenerator {
    private Random rg;
    private long[] mPosCounter = new long[255];
    private static final String ABC = new String("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz");
    private long mSystemTime = System.currentTimeMillis();

    public RandomFieldValueGenerator() {
        this.rg = new Random();
    }

    public RandomFieldValueGenerator(long pRandomInit) {
        this.rg = new Random(pRandomInit);
    }

    public DBInputStream determineAsciiStream(TableField pField) {
        int i;
        if (!pField.isRandom()) {
            return new DBInputStream(new ByteArrayInputStream(pField.getDefaultValue().getBytes()), pField.getDefaultValue().getBytes().length);
        }
        int l = pField.getLength();
        if (l == -1) {
            l = this.rg.nextInt(0x100000);
        }
        byte[] bb = new byte[l];
        int size = 1024;
        byte[] yy = new byte[size];
        int y = l / size;
        int x = l % size;
        for (i = 0; i < size; ++i) {
            yy[i] = (byte)ABC.charAt(this.rg.nextInt(ABC.length()));
        }
        for (i = 0; i < y; ++i) {
            System.arraycopy(yy, 0, bb, i * size, size);
        }
        System.arraycopy(yy, 0, bb, y * size, x);
        return new DBInputStream(new ByteArrayInputStream(bb), bb.length);
    }

    public BigDecimal determineBigDecimal(TableField pField) {
        return new BigDecimal(this.determineDouble(pField));
    }

    public DBInputStream determineBinaryStream(TableField pField) {
        if (!pField.isRandom()) {
            int l = pField.getDefaultValue().length();
            byte[] bb = new byte[l];
            bb = pField.getDefaultValue().getBytes();
            return new DBInputStream(new ByteArrayInputStream(bb), bb.length);
        }
        int l = pField.getLength();
        if (l == -1) {
            l = this.rg.nextInt(0x100000);
        }
        byte[] bb = new byte[l];
        int size = 1024;
        byte[] yy = new byte[size];
        int y = l / size;
        int x = l % size;
        this.rg.nextBytes(yy);
        for (int i = 0; i < y; ++i) {
            System.arraycopy(yy, 0, bb, i * size, size);
        }
        System.arraycopy(yy, 0, bb, y * size, x);
        return new DBInputStream(new ByteArrayInputStream(bb), bb.length);
    }

    public boolean determineBoolean(TableField pField) {
        boolean Result = !pField.isRandom() ? Boolean.valueOf(pField.getDefaultValue()).booleanValue() : this.rg.nextBoolean();
        pField.setLastValue(String.valueOf(Result));
        return Result;
    }

    public byte determineByte(TableField pField) {
        byte Result;
        if (pField.isUnique()) {
            Result = (byte)(this.determineUniqueCounter(pField.getPosition()) - 128L);
        }
        Result = !pField.isRandom() ? Byte.parseByte(pField.getDefaultValue()) : (byte)(this.rg.nextInt(255) - 128);
        pField.setLastValue(String.valueOf(Result));
        return Result;
    }

    public byte[] determineBytes(TableField pField) {
        if (pField.isUnique()) {
            return (pField.getDefaultValue() + Long.toString(this.determineUniqueCounter(pField.getPosition()))).getBytes();
        }
        if (!pField.isRandom()) {
            return pField.getDefaultValue().getBytes();
        }
        int len = pField.getLength();
        if (len == 0) {
            len = 1 + this.rg.nextInt(4096);
        }
        byte[] bytes = new byte[len];
        this.rg.nextBytes(bytes);
        return bytes;
    }

    public Date determineDate(TableField pField) {
        long size;
        Date Result;
        if (pField.isUnique()) {
            Result = new Date(this.mSystemTime + 86400000L * this.determineUniqueCounter(pField.getPosition()));
        }
        Result = !pField.isRandom() ? (pField.getDefaultValue().trim() == "" ? new Date(this.mSystemTime) : Date.valueOf(pField.getDefaultValue())) : ((size = pField.getMaxRandomValue() - pField.getMinRandomValue()) <= 0L ? new Date(this.rg.nextLong()) : new Date(Math.abs(this.rg.nextLong() % size) + pField.getMinRandomValue()));
        pField.setLastValue(String.valueOf(Result));
        return Result;
    }

    public double determineDouble(TableField pField) {
        double Result;
        if (pField.isUnique()) {
            long dec = pField.getDecimals();
            if (dec == -1L) {
                dec = this.rg.nextInt(5);
            }
            double div = Math.pow(10.0, dec);
            Result = (double)this.determineUniqueCounter(pField.getPosition()) / div;
        }
        if (!pField.isRandom()) {
            Result = Double.parseDouble(pField.getDefaultValue());
        } else {
            double size = pField.getMaxRandomValue() - pField.getMinRandomValue();
            if (size == 0.0) {
                size = 3.4028234663852886E38;
            }
            Result = this.rg.nextDouble() * size + (double)pField.getMinRandomValue();
        }
        pField.setLastValue(String.valueOf(Result));
        return Result;
    }

    public float determineFloat(TableField pField) {
        float Result;
        if (pField.isUnique()) {
            long dec = pField.getDecimals();
            if (dec == -1L) {
                dec = this.rg.nextInt(5);
            }
            float div = (float)Math.pow(10.0, dec);
            Result = (float)this.determineUniqueCounter(pField.getPosition()) / div;
        }
        if (!pField.isRandom()) {
            Result = Float.parseFloat(pField.getDefaultValue());
        } else {
            float size = pField.getMaxRandomValue() - pField.getMinRandomValue();
            if (size == 0.0f) {
                size = Float.MAX_VALUE;
            }
            Result = this.rg.nextFloat() * size + (float)pField.getMinRandomValue();
        }
        pField.setLastValue(String.valueOf(Result));
        return Result;
    }

    public int determineInt(TableField pField) {
        int size;
        int Result = pField.isUnique() ? (int)this.determineUniqueCounter(pField.getPosition()) : (!pField.isRandom() ? Integer.parseInt(pField.getDefaultValue()) : ((size = (int)(pField.getMaxRandomValue() - pField.getMinRandomValue())) <= 0 ? this.rg.nextInt() : this.rg.nextInt(size) + (int)pField.getMinRandomValue()));
        pField.setLastValue(String.valueOf(Result));
        return Result;
    }

    public long determineLong(TableField pField) {
        long size;
        long Result;
        if (pField.isUnique()) {
            Result = this.determineUniqueCounter(pField.getPosition());
        }
        Result = !pField.isRandom() ? Long.parseLong(pField.getDefaultValue()) : ((size = pField.getMaxRandomValue() - pField.getMinRandomValue()) <= 0L ? this.rg.nextLong() : Math.abs(this.rg.nextLong() % size) + pField.getMinRandomValue());
        pField.setLastValue(String.valueOf(Result));
        return Result;
    }

    public short determineShort(TableField pField) {
        long size;
        short Result;
        if (pField.isUnique()) {
            Result = (short)this.determineUniqueCounter(pField.getPosition());
        }
        Result = !pField.isRandom() ? Short.parseShort(pField.getDefaultValue()) : ((size = pField.getMaxRandomValue() - pField.getMinRandomValue()) <= 0L ? (short)this.rg.nextInt(32768) : (short)(this.rg.nextInt((int)size) + (int)pField.getMinRandomValue()));
        pField.setLastValue(String.valueOf(Result));
        return Result;
    }

    public String determineString(TableField pField) {
        String Result;
        if (pField.isUnique()) {
            Result = pField.getDefaultValue() + this.determineUniqueCounter(pField.getPosition());
        } else if (!pField.isRandom()) {
            Result = pField.getDefaultValue();
        } else {
            int llen = this.rg.nextInt(pField.getLength()) + 1;
            StringBuffer sb = new StringBuffer(llen);
            for (int i = 0; i < llen; ++i) {
                sb.append(ABC.charAt(this.rg.nextInt(ABC.length())));
            }
            Result = sb.toString();
        }
        pField.setLastValue(String.valueOf(Result));
        return Result;
    }

    public Time determineTime(TableField pField) {
        long size;
        Time Result;
        if (pField.isUnique()) {
            Result = new Time(this.mSystemTime + 1000L * this.determineUniqueCounter(pField.getPosition()));
        }
        Result = !pField.isRandom() ? (pField.getDefaultValue().trim() == "" ? new Time(this.mSystemTime) : Time.valueOf(pField.getDefaultValue())) : ((size = pField.getMaxRandomValue() - pField.getMinRandomValue()) <= 0L ? new Time(this.rg.nextLong()) : new Time(Math.abs(this.rg.nextLong() % size) + pField.getMinRandomValue()));
        pField.setLastValue(String.valueOf(Result));
        return Result;
    }

    public Timestamp determineTimestamp(TableField pField) {
        long size;
        Timestamp Result;
        if (pField.isUnique()) {
            Result = new Timestamp(this.mSystemTime + 1000L * this.determineUniqueCounter(pField.getPosition()));
        }
        Result = !pField.isRandom() ? (pField.getDefaultValue().trim() == "" ? new Timestamp(this.mSystemTime) : Timestamp.valueOf(pField.getDefaultValue())) : ((size = pField.getMaxRandomValue() - pField.getMinRandomValue()) <= 0L ? new Timestamp(this.rg.nextLong()) : new Timestamp(Math.abs(this.rg.nextLong() % size) + pField.getMinRandomValue()));
        pField.setLastValue(String.valueOf(Result));
        return Result;
    }

    private synchronized long determineUniqueCounter(int pIndex) {
        int n = pIndex;
        long l = this.mPosCounter[n];
        this.mPosCounter[n] = l + 1L;
        return l;
    }
}

