/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.driver;

import com.sap.sapdb.testframe.driver.DatabaseConstants;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class TestResultDatabase
implements DatabaseConstants {
    static final String JDBC_DRIVER = "com.sap.dbtech.jdbc.DriverSapDB";
    private String mUrl;
    private String mHost;
    private String mName;
    private String mUser;
    private String mPassword;

    public TestResultDatabase(String pHost, String pName, String pUser, String pPassword) throws TestDatabaseException {
        this.mUrl = "jdbc:sapdb://" + pHost + "/" + pName;
        this.mHost = pHost;
        this.mName = pName;
        this.mUser = pUser;
        this.mPassword = pPassword;
        try {
            Class.forName(JDBC_DRIVER);
        }
        catch (ClassNotFoundException e) {
            throw new TestDatabaseException("Class com.sap.dbtech.jdbc.DriverSapDB not found");
        }
    }

    public Connection connect() throws TestDatabaseException {
        try {
            Connection connection = DriverManager.getConnection(this.mUrl, this.mUser, this.mPassword);
            return connection;
        }
        catch (SQLException e) {
            throw new TestDatabaseException(e.getMessage());
        }
    }

    private Connection connect(String pUser, String pPassword) throws TestDatabaseException {
        try {
            Connection connection = DriverManager.getConnection(this.mUrl, pUser, pPassword);
            return connection;
        }
        catch (SQLException e) {
            throw new TestDatabaseException(e.getMessage());
        }
    }

    private void createUserAndTables() throws SQLException, TestDatabaseException {
        Connection lConnection = this.connect("DBA", "DBA");
        Statement lstmt = lConnection.createStatement();
        try {
            lstmt.executeUpdate("drop user testall");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            lstmt.executeUpdate("drop user test");
        }
        catch (Exception e) {
            // empty catch block
        }
        lstmt.executeUpdate("create user testall password test resource not exclusive");
        lstmt.executeUpdate("create user test password test resource not exclusive");
        lConnection.commit();
        lstmt.close();
        lConnection.close();
        String lTestResultColumn = " (TESTID varchar(20), DBSYSNAME varchar(20), VERSION int, STEP varchar(20), STATEMENT char(1024), RES_COUNT int, RUNTIME fixed(38,0), EXEC_TIME fixed(38,0), ERROR_IND varchar(20), EXCEPTION_TEXT varchar(256), VERIFICATION_TYPE char(1), EXPLAIN_OBJECT_LENGTH int, EXPLAIN_OBJECT long byte, primary key (TESTID, DBSYSNAME, VERSION, STEP))";
        String lTestResultDataColumn = " (TESTID varchar(20), DBSYSNAME varchar(20), VERSION int, STEP varchar(20), SEQNR int, DATA varchar(1024), primary key (TESTID, DBSYSNAME, VERSION, STEP, SEQNR))";
        lConnection = this.connect("test", "test");
        lstmt = lConnection.createStatement();
        lstmt.executeUpdate("create table TEST_RESULT_TEST " + lTestResultColumn);
        lstmt.executeUpdate("create table TEST_RESULT_TEST_DATA " + lTestResultDataColumn);
        lstmt.execute("Grant ALL on TEST_RESULT_TEST to TESTALL");
        lstmt.execute("Grant SELECT on TEST_RESULT_TEST to PUBLIC");
        lstmt.execute("Grant ALL on TEST_RESULT_TEST_DATA to TESTALL");
        lstmt.execute("Grant SELECT on TEST_RESULT_TEST_DATA to PUBLIC");
        lstmt.execute("Create PUBLIC synonym TT for TEST_RESULT_TEST");
        lstmt.execute("Create PUBLIC synonym TTD for TEST_RESULT_TEST_DATA");
        lConnection.commit();
        lstmt.close();
        lConnection.close();
        lConnection = this.connect("testall", "test");
        lstmt = lConnection.createStatement();
        lstmt.executeUpdate("create table TEST_RESULT_REFERENCE " + lTestResultColumn);
        lstmt.executeUpdate("create table TEST_RESULT_REFERENCE_DATA " + lTestResultDataColumn);
        lstmt.execute("Grant SELECT on TEST_RESULT_REFERENCE to PUBLIC");
        lstmt.execute("Grant SELECT on TEST_RESULT_REFERENCE_DATA to PUBLIC");
        lstmt.execute("Create PUBLIC synonym TR for TEST_RESULT_REFERENCE");
        lstmt.execute("Create PUBLIC synonym TRD for TEST_RESULT_REFERENCE_DATA");
        lConnection.commit();
        lstmt.close();
        lConnection.close();
    }

    public void disconnect(Connection pCon) throws SQLException {
        pCon.close();
    }

    public static void main(String[] args) {
        System.out.println("Starting to create test result database ...");
        Properties options = TestResultDatabase.parseCommandLineOptions(args);
        if (options.getProperty("dbhost") == null) {
            options.put("dbhost", "localhost");
        }
        if (options.getProperty("user") == null) {
            options.put("user", "DBA");
        }
        if (options.getProperty("password") == null) {
            options.put("password", "DBA");
        }
        if (options.getProperty("dbsize") == null) {
            options.put("dbsize", "MEDIUM");
        }
        try {
            if (options.getProperty("dbsize") != null) {
                TestDatabaseSap db = new TestDatabaseSap(options.getProperty("dbhost"), options.getProperty("dbname"));
                db.setDBMUser("DBM");
                db.setDBMPassword("DBM");
                db.setDBAUser("DBA");
                db.setDBAPassword("DBA");
                db.setRoot(options.getProperty("dbroot"));
                db.setInstanceType("OLTP");
                db.setSize(options.getProperty("dbsize"));
                db.setOsUser(options.getProperty("osuser"));
                db.setOsPassword(options.getProperty("ospassword"));
                db.createInstance();
            }
            TestResultDatabase lDatabase = new TestResultDatabase(options.getProperty("dbhost"), options.getProperty("dbname"), options.getProperty("user"), options.getProperty("password"));
            lDatabase.createUserAndTables();
            System.out.println("\nTest result database " + options.getProperty("dbname") + " sucessfully created");
            System.out.println("Test results will be stored in table TEST_RESULT_TEST, Synonym TT, Owner/User: TEST, Password: TEST");
            System.out.println("Reference results will be stored in table TEST_RESULT_REFERENCE, Synonym TR, Owner/User: TESTALL, Password: TEST");
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (TestDatabaseException e) {
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        catch (SQLException e) {
            System.out.println(e.getClass() + e.getMessage());
        }
    }

    private static Properties parseCommandLineOptions(String[] args) {
        String currentArg;
        Properties Options = new Properties();
        boolean hasDb = false;
        boolean hasOsUser = false;
        boolean hasDbRoot = false;
        boolean hasDbSize = false;
        block9: for (int i = 0; i < args.length && (currentArg = args[i]).charAt(0) == '-'; ++i) {
            char currentOpt = currentArg.charAt(1);
            switch (currentOpt) {
                case 'h': {
                    TestResultDatabase.usageOptions(false);
                    continue block9;
                }
                case 'n': {
                    Options.put("dbhost", args[++i]);
                    continue block9;
                }
                case 'd': {
                    Options.put("dbname", args[++i]);
                    hasDb = true;
                    continue block9;
                }
                case 'u': {
                    currentArg = args[++i];
                    Options.put("user", currentArg.substring(0, currentArg.indexOf(44)));
                    Options.put("password", currentArg.substring(currentArg.indexOf(44) + 1));
                    continue block9;
                }
                case 'O': {
                    currentArg = args[++i];
                    Options.put("osuser", currentArg.substring(0, currentArg.indexOf(44)));
                    Options.put("ospassword", currentArg.substring(currentArg.indexOf(44) + 1));
                    hasOsUser = true;
                    continue block9;
                }
                case 'R': {
                    Options.put("dbroot", args[++i]);
                    hasDbRoot = true;
                    continue block9;
                }
                case 'S': {
                    Options.put("dbsize", args[++i]);
                    hasDbSize = true;
                    continue block9;
                }
                default: {
                    TestResultDatabase.usageOptions(true);
                    System.err.println("Invalid option " + currentOpt);
                }
            }
        }
        if (!hasDb) {
            TestResultDatabase.usageOptions(true);
        }
        if (!(!hasDbSize || hasDbRoot && hasOsUser)) {
            System.out.println("- R <dbroot> -S <SMALL|MEDIUM|LARGE> -O <osuser, ospassword> required");
            System.exit(0);
        }
        return Options;
    }

    void testConnection() throws TestDatabaseException {
        this.testConnection(this.mUser, this.mPassword);
    }

    void testConnection(String pUser, String pPassword) throws TestDatabaseException {
        Connection con = null;
        try {
            con = DriverManager.getConnection(this.mUrl, pUser, pPassword);
            con.close();
        }
        catch (SQLException e) {
            throw new TestDatabaseException("No connection to database " + this.mHost + ":" + this.mName + " for " + pUser + "," + pPassword);
        }
    }

    private static void usageOptions(boolean pError) {
        System.out.println("Usage: java TestResultDatabase -d <dbname> [<options>]");
        System.out.println("    <options>:");
        System.out.println("         -h     help menue                           ");
        System.out.println("         -n     <dbhost>                             ");
        System.out.println("         -u     <user,password>                      ");
        System.out.println("         -R     <dbroot>                             ");
        System.out.println("         -O     <osuser,ospassword>                  ");
        System.out.println("         -S     <SMALL|MEDIUM|LARGE|HUGE> (default: SMALL)");
        if (pError) {
            System.exit(2);
        } else {
            System.exit(0);
        }
    }
}

