/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.sqlmanager;

import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class LockFreeCreateIndex
extends TestCase {
    private static final String VERSION = "1.0";
    private static int maxRepetitionCount = 3;
    private static int inserterCount = 2;
    private static int initialTableRowCount = 20000;
    private static int inserterMaxLoopCount = 15000;
    private static int deleterMaxLoopCount = 18000;
    private static int minLogEntryCount = 15;

    private static Connection connect() throws SQLException, TestDatabaseException {
        Connection con = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
        return con;
    }

    public void prepareTable() throws TestCaseException {
        try {
            Connection con = LockFreeCreateIndex.connect();
            Statement stmt = con.createStatement();
            try {
                stmt.execute("Drop Table IndexTest");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            stmt.execute("Create Table IndexTest ( k1 char(150), k2 char(100), k3 char(150), k4 char(5), c1 char(20), primary key (k1, k2, k3, k4) )");
            con.commit();
            PreparedStatement prepStmt = con.prepareStatement("Insert IndexTest Values ( ?, ?, ?, ?, ? )");
            int rowNo = 0;
            while (rowNo < initialTableRowCount) {
                int paramNo = 0;
                prepStmt.setString(++paramNo, Integer.toString(rowNo));
                prepStmt.setString(++paramNo, Integer.toString(rowNo));
                prepStmt.setString(++paramNo, Integer.toString(rowNo));
                prepStmt.setString(++paramNo, Integer.toString(rowNo));
                prepStmt.setString(++paramNo, Integer.toString(rowNo));
                prepStmt.execute();
                ++rowNo;
            }
            con.commit();
        }
        catch (Exception e) {
            throw new TestCaseException("prepare failed:" + e.toString());
        }
    }

    public void run() {
        maxRepetitionCount = TestCase.getParameterInt((String)"MaximumRepetitionCount", (int)3);
        inserterCount = TestCase.getParameterInt((String)"NoOfInserterThreads", (int)2);
        initialTableRowCount = TestCase.getParameterInt((String)"NoOfTableRows", (int)20000);
        inserterMaxLoopCount = TestCase.getParameterInt((String)"NoOfInserterThreadLoops", (int)15000);
        deleterMaxLoopCount = TestCase.getParameterInt((String)"NoOfDeleterThreadLoops", (int)8000);
        minLogEntryCount = 15;
        this.addMessage("run", 'I', "LockFreeCreateIndex V1.0.");
        try {
            int repetitionNo = 0;
            int logFileEntryCount = 0;
            while (repetitionNo < maxRepetitionCount) {
                WorkerThread thread;
                this.addMessage("run", 'I', "Parameters for current run:\nrun no " + (repetitionNo + 1) + "\ntable rows: " + initialTableRowCount + "\ndeleter loop count: " + deleterMaxLoopCount);
                this.prepareTable();
                ArrayList<WorkerThread> threadList = new ArrayList<WorkerThread>(10);
                this.addMessage("run", 'I', "Starting threads...");
                CreateIndexThread createIndexThread = new CreateIndexThread();
                SupervisorThread supervisorThread = new SupervisorThread();
                int testNo = 1;
                while (testNo <= inserterCount) {
                    InserterThread inserterThread = new InserterThread(inserterMaxLoopCount);
                    ((AbstractList)threadList).add(inserterThread);
                    inserterThread.start();
                    ++testNo;
                }
                supervisorThread.start();
                createIndexThread.start();
                DeleterThread deleterThread = new DeleterThread(deleterMaxLoopCount);
                deleterThread.start();
                ((AbstractList)threadList).add(deleterThread);
                this.addMessage("run", 'I', "Waiting for CreateIndexThread to finish...");
                createIndexThread.join();
                supervisorThread.setDoExit();
                if (createIndexThread.getErrorText() != null) {
                    this.addMessage("run", 'E', "Thread exited with error:\n" + createIndexThread.getErrorText());
                }
                this.addMessage("run", 'I', "Waiting for worker threads to finish...");
                Iterator listIt = ((AbstractList)threadList).iterator();
                while (listIt.hasNext()) {
                    thread = (WorkerThread)listIt.next();
                    thread.setDoExit();
                }
                listIt = ((AbstractList)threadList).iterator();
                while (listIt.hasNext()) {
                    thread = (WorkerThread)listIt.next();
                    thread.join();
                    if (thread.getErrorText() == null) continue;
                    this.addMessage("run", 'E', "Thread exited with error:\n" + thread.getErrorText());
                }
                supervisorThread.join();
                logFileEntryCount = supervisorThread.getLogFileEntryCount();
                if (logFileEntryCount > minLogEntryCount) break;
                this.addMessage("run", 'I', "This run had less than " + minLogEntryCount + " entries in the index log file.");
                System.out.println("Preparing next run...");
                initialTableRowCount *= 2;
                deleterMaxLoopCount *= 2;
                ++repetitionNo;
            }
            if (logFileEntryCount > minLogEntryCount) {
                this.addMessage("run", 'I', "Indexlog file had at least " + logFileEntryCount + " entries.");
            } else {
                this.addMessage("run", 'W', "Index log file had only " + logFileEntryCount + " entries or could not be found.\n" + "Maybe your test box is too fast for this test.\n" + "Try increasing the table row count.");
            }
            this.verifyIndex();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("failed: " + e + "\n");
        }
    }

    private void verifyIndex() throws NumberFormatException {
        this.addMessage("verify", 'I', "Now verifying index integrity, stand by...");
        String dbUser = TestCase.getUser();
        String dbmResult = this.executeDBMCmd("db_execute diagnose index " + dbUser + ".indextest.c1");
        boolean verifyOk = true;
        int eqIdx = 0;
        while ((eqIdx = dbmResult.indexOf(61, eqIdx)) != -1) {
            int eolIdx = dbmResult.indexOf(10, eqIdx + 1);
            int deltaVal = Integer.parseInt(dbmResult.substring(eqIdx + 1, eolIdx).trim());
            if (deltaVal != 0) {
                verifyOk = false;
                break;
            }
            eqIdx = eolIdx + 1;
        }
        if (verifyOk) {
            this.addMessage("verify", 'I', "Index verification successful:\n" + dbmResult);
        } else {
            this.addMessage("verify", 'E', "Error during index verification:\n" + dbmResult);
        }
    }

    public String executeDBMCmd(String pCmd) {
        DBM dBMan = null;
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = TestCase.getDatabase().getHost();
            mName = TestCase.getDatabase().getName();
            int mPort = TestCase.getDatabase().getPort();
            dBMan = DBM.dbDBM((String)(String.valueOf(mHost) + ":" + mPort), (String)mName);
            logon = "USER_LOGON " + TestCase.getDatabase().getDBMUser() + "," + TestCase.getDatabase().getDBMPassword();
            dBMan.cmd(logon);
            return dBMan.cmd(pCmd);
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + pCmd);
            System.out.println("Exception: " + e.toString() + "\n" + e.getClass());
            this.addMessage("executeDBMCmd()", 'E', "Command failed: " + pCmd + "\nException: " + e.toString());
            return "error";
        }
    }

    public static void cleanUp() throws TestCaseException {
        try {
            Connection con = LockFreeCreateIndex.connect();
            Statement stmt = con.createStatement();
            stmt.execute("Drop Table IndexTest");
            con.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class WorkerThread
    extends Thread {
        private boolean doExit = false;
        private StringWriter errorTextWriter = new StringWriter();

        WorkerThread() {
        }

        public void setDoExit() {
            this.doExit = true;
        }

        public String getErrorText() {
            if (this.errorTextWriter.getBuffer().length() > 0) {
                return this.errorTextWriter.toString();
            }
            return null;
        }

        protected boolean getDoExit() {
            return this.doExit;
        }

        protected void addExceptionText(String title, Exception e) {
            this.errorTextWriter.write(String.valueOf(this.getName()) + ", " + title + "\n");
            e.printStackTrace(new PrintWriter(this.errorTextWriter));
        }

        protected void addErrorText(String errorText) {
            this.errorTextWriter.write(errorText);
        }
    }

    class CreateIndexThread
    extends WorkerThread {
        CreateIndexThread() {
        }

        public void run() {
            try {
                Connection con = LockFreeCreateIndex.connect();
                con.commit();
                Statement stmt = con.createStatement();
                stmt.execute("Create Index I on IndexTest( c1 )");
                con.commit();
                con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Error during Create Index: " + e + "\n");
                this.addExceptionText("Error in CreateIndexThread", e);
            }
        }
    }

    class SupervisorThread
    extends WorkerThread {
        private int entryCount = 0;

        SupervisorThread() {
        }

        public void run() {
            try {
                Connection con = LockFreeCreateIndex.connect();
                PreparedStatement stmt = con.prepareStatement("Select Entrycount from Files where type = 'INDEXLOGFILE'");
                while (!this.getDoExit()) {
                    ResultSet rs = stmt.executeQuery();
                    while (rs.next()) {
                        int curEntryCount = rs.getInt(1);
                        if (curEntryCount <= this.entryCount) continue;
                        this.entryCount = curEntryCount;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("SupervisorThread error during execution: " + e + "\n");
                this.addExceptionText("Error in SupervisorThread", e);
            }
        }

        int getLogFileEntryCount() {
            return this.entryCount;
        }
    }

    class InserterThread
    extends WorkerThread {
        private int maxLoopCount;

        public InserterThread(int maxLoopCount) {
            this.maxLoopCount = maxLoopCount;
        }

        public void run() {
            try {
                Connection con = LockFreeCreateIndex.connect();
                Random rndGen = new Random();
                PreparedStatement stmt = con.prepareStatement("Insert IndexTest Values ( ?, ?, ?, ?, ? )");
                int rowNo = 0;
                while (rowNo < this.maxLoopCount && !this.getDoExit()) {
                    int paramNo = 0;
                    stmt.setString(++paramNo, this.getName());
                    stmt.setInt(++paramNo, rowNo);
                    stmt.setInt(++paramNo, rowNo);
                    stmt.setInt(++paramNo, rowNo);
                    stmt.setInt(++paramNo, rowNo);
                    stmt.execute();
                    int action = rndGen.nextInt(9);
                    switch (action) {
                        case 0: {
                            con.commit();
                            break;
                        }
                        case 1: {
                            con.rollback();
                        }
                    }
                    ++rowNo;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("InserterThread error during execution: " + e + "\n");
                this.addExceptionText("Error in InserterThread", e);
            }
        }
    }

    class DeleterThread
    extends WorkerThread {
        private int maxLoopCount;
        private int deletedRowsCount = 0;

        public DeleterThread(int maxLoopCount) {
            this.maxLoopCount = maxLoopCount;
        }

        public void run() {
            try {
                Connection con = LockFreeCreateIndex.connect();
                Random rndGen = new Random();
                PreparedStatement stmt = con.prepareStatement("Delete IndexTest where c1 = ? and k2 = ? and k3 = ? and k4 = ?");
                int rowNo = 0;
                while (rowNo < this.maxLoopCount && !this.getDoExit()) {
                    int paramNo = 0;
                    stmt.setInt(++paramNo, rowNo);
                    stmt.setInt(++paramNo, rowNo);
                    stmt.setInt(++paramNo, rowNo);
                    stmt.setInt(++paramNo, rowNo);
                    this.deletedRowsCount += stmt.executeUpdate();
                    int action = rndGen.nextInt(9);
                    switch (action) {
                        case 0: {
                            System.out.println(String.valueOf(this.getName()) + " D: Commit");
                            con.commit();
                            break;
                        }
                        case 1: {
                            System.out.println(String.valueOf(this.getName()) + " D: Rollback");
                            con.rollback();
                        }
                    }
                    ++rowNo;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("DeleterThread error during execution: " + e + "\n");
                this.addExceptionText("Error in DeleterThread", e);
            }
            System.out.println(String.valueOf(this.getName()) + " deleted " + this.deletedRowsCount + " rows.");
        }

        public int getDeletedRowCount() {
            return this.deletedRowsCount;
        }
    }
}

