/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.simple;

import com.sap.sapdb.oltptest.mut.OLTPTestActor;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class MultiConnect
extends TestCase {
    private static int dauUser = 200;
    private static int workUser = 8;
    private static int workTime = 30;
    private static int timeOut = 600;
    protected Connection[] workConnection = null;
    protected Connection[] dauConnection = null;
    protected boolean abortTest = false;

    public static String getTestClassId() {
        return "MultiConnect";
    }

    public static void prepare() throws TestCaseException {
        MultiConnect.readParameters();
        MultiConnect.printParameters();
    }

    private static void readParameters() throws TestCaseException {
        workUser = TestCase.getParameterInt((String)"WORKUSER", (int)3);
        dauUser = TestCase.getParameterInt((String)"DAUUSER", (int)50);
        workTime = TestCase.getParameterInt((String)"WORKTIME", (int)30);
        timeOut = TestCase.getParameterInt((String)"TIMEOUT", (int)900);
    }

    private static void printParameters() throws TestCaseException {
        System.out.println("Parameter:\n");
        System.out.println("\tWORKUSER: " + workUser);
        System.out.println("\tDAUUSER : " + dauUser);
        System.out.println("\tWORKTIME: " + workTime);
        System.out.println("\tTIMEOUT: " + timeOut);
        System.out.println();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.workConnection = new Connection[workUser];
        WorkUser[] myWorkUser = new WorkUser[workUser];
        this.dauConnection = new Connection[dauUser];
        Properties props = new Properties();
        props.put("user", TestCase.getDatabase().getDBAUser());
        props.put("password", TestCase.getDatabase().getDBAPassword());
        props.put("timeout", "" + timeOut);
        try {
            try {
                System.out.println("Create all connections...");
                int i = 0;
                while (true) {
                    if (i >= workUser) break;
                    this.workConnection[i] = TestCase.getDatabase().connect(props);
                    myWorkUser[i] = new WorkUser(i);
                    ++i;
                }
                i = 0;
                while (true) {
                    if (i >= dauUser) break;
                    this.dauConnection[i] = TestCase.getDatabase().connect(props);
                    ++i;
                }
                System.out.println("Start the worker....");
                i = 0;
                while (true) {
                    if (i >= workUser) break;
                    myWorkUser[i].start();
                    ++i;
                }
                Thread.sleep(1000 * workTime);
                this.abortTest = true;
                Thread.sleep(1000L);
                i = 0;
                while (true) {
                    if (i >= workUser) break;
                    myWorkUser[i].pleaseStop();
                    ++i;
                }
                Thread.sleep(5000L);
                i = 0;
                while (true) {
                    if (i >= workUser) break;
                    this.workConnection[i].close();
                    ++i;
                }
                i = 0;
                while (true) {
                    if (i >= dauUser) {
                        System.out.println();
                        MultiConnect.printParameters();
                    }
                    this.dauConnection[i].close();
                    ++i;
                }
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.abortTest = true;
            throw throwable;
        }
        {
            Object var4_7 = null;
            this.abortTest = true;
            return;
        }
    }

    public static void cleanUp() throws TestCaseException {
        System.out.println("Test ready.");
    }

    public static long getTimeout() {
        return 0L;
    }

    public static boolean isReferenceEnabled() {
        return false;
    }

    public static boolean isSAPOnly() {
        return true;
    }

    class WorkUser
    extends OLTPTestActor {
        boolean keepRunning = true;
        int mNumber;
        int stmtCount = 0;

        WorkUser(int writerNo) {
            this.mNumber = writerNo;
        }

        public void check() {
        }

        public void run() {
            try {
                Connection con = MultiConnect.this.workConnection[this.mNumber];
                TestStatement mStatement = new TestStatement(null, con);
                ResultSet mResult = null;
                String cmd = "select * from readerwriterlockstatistics";
                while (this.keepRunning && !MultiConnect.this.abortTest) {
                    ++this.stmtCount;
                    mResult = mStatement.executeQuery(cmd);
                    if (!mResult.next()) continue;
                    while (mResult.next()) {
                    }
                }
            }
            catch (Exception e) {
                System.out.println(String.valueOf(this.mNumber) + " -> Exception:" + e.getLocalizedMessage());
                this.keepRunning = false;
            }
        }

        public void pleaseStop() {
            System.out.print("\nWorker " + this.mNumber + " did " + this.stmtCount + " steps.");
            this.keepRunning = false;
        }
    }
}

