/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.simple;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class FDirCounter
extends TestCase {
    private static final String mExUser = "SUT";
    private static final String mExPassword = "SUT";
    private static final int maxEntries = 5;
    private static boolean dbHasLOBType;

    public static void cleanUp() throws TestCaseException {
        System.out.println("End of " + FDirCounter.getTestClassId());
    }

    public static String getMinimumRelease() {
        return "7.6.00.12";
    }

    public static String getTestClassId() {
        return "FDirCounter";
    }

    public static long getTimeout() {
        return 1800000L;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void prepare() throws TestCaseException {
        block14: {
            myConnection = null;
            myStatement = null;
            System.out.println("Start of " + FDirCounter.getTestClassId());
            try {
                FDirCounter.dbHasLOBType = TestDriver.compareRelease((String)(String.valueOf(((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion()) + "." + ((TestDatabaseSap)TestCase.getDatabase()).getKernelBuild().substring(0, 3)), (String)">=", (String)"7.7.0.0");
            }
            catch (TestDatabaseException e) {
                e.printStackTrace(System.err);
            }
            try {
                try {
                    myConnection = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
                    myStatement = new TestStatement(null, myConnection);
                    myStatement.enableExceptions(false);
                    myStatement.executeUpdate("Drop user SUT");
                    myStatement.enableExceptions(true);
                    myStatement.executeUpdate("Create user SUT password SUT resource not exclusive");
                    myStatement.close();
                    myConnection.close();
                }
                catch (Exception e) {
                    TestCase.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
                    throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
                }
            }
            catch (Throwable var4_4) {
                var3_5 = null;
                try {
                    myStatement.close();
                }
                catch (Exception var5_7) {
                    // empty catch block
                }
                try {
                    myConnection.commit();
                    myConnection.close();
                    throw var4_4;
                }
                catch (Exception var5_7) {
                    // empty catch block
                }
                throw var4_4;
            }
            {
                var3_6 = null;
            }
            ** try [egrp 3[TRYBLOCK] [4 : 206->213)] { 
lbl43:
            // 1 sources

            myStatement.close();
            break block14;
lbl45:
            // 1 sources

            catch (Exception var5_8) {
                // empty catch block
            }
        }
        try {}
        catch (Exception var5_8) {
            return;
        }
        myConnection.commit();
        myConnection.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block12: {
            myConnection = null;
            myStatement = null;
            miniShort = 20;
            bigShort = 8000;
            miniLong = 8200;
            bigLong = 0x100000;
            lobType = FDirCounter.dbHasLOBType != false ? "CLOB" : "LONG";
            try {
                try {
                    myConnection = TestCase.getDatabase().connect("SUT", "SUT");
                    myConnection.setAutoCommit(false);
                    this.insertDeleteTest(myConnection, lobType, 20);
                    this.insertDeleteTest(myConnection, lobType, 8000);
                    this.insertDeleteTest(myConnection, lobType, 8200);
                    this.insertDeleteTest(myConnection, lobType, 0x100000);
                    this.insertDeleteTest(myConnection, "LONGFILE", 20);
                    this.insertDeleteTest(myConnection, "LONGFILE", 8000);
                    this.insertDeleteTest(myConnection, "LONGFILE", 8200);
                    this.insertDeleteTest(myConnection, "LONGFILE", 0x100000);
                    this.updateTest(myConnection, lobType, 20, 8000);
                    this.updateTest(myConnection, lobType, 20, 8200);
                    this.updateTest(myConnection, lobType, 20, 0x100000);
                    this.updateTest(myConnection, lobType, 8200, 8000);
                    this.updateTest(myConnection, lobType, 0x100000, 8200);
                    this.updateTest(myConnection, lobType, 8200, 0x100000);
                    this.updateTest(myConnection, "LONGFILE", 20, 8000);
                    this.updateTest(myConnection, "LONGFILE", 20, 8200);
                    this.updateTest(myConnection, "LONGFILE", 20, 0x100000);
                    this.updateTest(myConnection, "LONGFILE", 8200, 8000);
                    this.updateTest(myConnection, "LONGFILE", 0x100000, 8200);
                    this.updateTest(myConnection, "LONGFILE", 8200, 0x100000);
                    this.unqualDeleteTest(myConnection, lobType, 20);
                    this.unqualDeleteTest(myConnection, lobType, 8000);
                    this.unqualDeleteTest(myConnection, lobType, 8200);
                    this.unqualDeleteTest(myConnection, lobType, 0x100000);
                    this.unqualDeleteTest(myConnection, "LONGFILE", 20);
                    this.unqualDeleteTest(myConnection, "LONGFILE", 8000);
                    this.unqualDeleteTest(myConnection, "LONGFILE", 8200);
                    this.unqualDeleteTest(myConnection, "LONGFILE", 0x100000);
                    this.createInsertAsSelectTest(myConnection, lobType, 20);
                    this.createInsertAsSelectTest(myConnection, lobType, 8000);
                    this.createInsertAsSelectTest(myConnection, lobType, 8200);
                    this.createInsertAsSelectTest(myConnection, lobType, 0x100000);
                    this.createInsertAsSelectTest(myConnection, "LONGFILE", 20);
                    this.createInsertAsSelectTest(myConnection, "LONGFILE", 8000);
                    this.createInsertAsSelectTest(myConnection, "LONGFILE", 8200);
                    this.createInsertAsSelectTest(myConnection, "LONGFILE", 0x100000);
                    this.insertDefaultTest(myConnection, lobType);
                    this.insertDefaultTest(myConnection, "LONGFILE");
                }
                catch (Exception e) {
                    this.handleExceptions(e);
                }
            }
            catch (Throwable var10_9) {
                var9_10 = null;
                try {
                    myStatement.close();
                }
                catch (Exception var11_12) {
                    // empty catch block
                }
                try {
                    myConnection.rollback();
                    myConnection.close();
                    throw var10_9;
                }
                catch (Exception var11_12) {
                    // empty catch block
                }
                throw var10_9;
            }
            {
                var9_11 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 466->473)] { 
lbl72:
            // 1 sources

            myStatement.close();
            break block12;
lbl74:
            // 1 sources

            catch (Exception var11_13) {
                // empty catch block
            }
        }
        try {}
        catch (Exception var11_13) {
            return;
        }
        myConnection.rollback();
        myConnection.close();
    }

    void insertDeleteTest(Connection c, String columnType, int size) throws SQLException, TestCaseException {
        TestStatement statement = new TestStatement((TestCase)this, c);
        this.addMessage(this.nextStep("insertDeleteTest"), 'I', String.valueOf(columnType) + " size:" + size + " bytes.");
        statement.enableExceptions(false);
        statement.execute("DROP TABLE FDIR1");
        statement.enableExceptions(true);
        statement.execute("CREATE TABLE FDIR1 (KEY1 CHAR(15), COL1 CHAR(15), PRIMARY KEY (KEY1), LONGCOL " + columnType + ")");
        TestPreparedStatement prepS = new TestPreparedStatement(null, c, "INSERT FDIR1 values (?,?,?)");
        byte[] buffer = new byte[size];
        int loop = 1;
        while (loop <= 5) {
            prepS.setString(1, "key" + loop);
            prepS.setString(2, "col1");
            prepS.setAsciiStream(3, (InputStream)new ByteArrayInputStream(buffer), size);
            prepS.execute();
            c.commit();
            this.compareLOBCounter(c, "FDIR1", "insertDeleteTest");
            this.compareCounter(c, "FDIR1", "insertDeleteTest", loop);
            ++loop;
        }
        loop = 1;
        while (loop <= 5) {
            statement.execute("DELETE FDIR1 where KEY1 = 'key" + loop + "'");
            this.compareLOBCounter(c, "FDIR1", "insertDeleteTest");
            this.compareCounter(c, "FDIR1", "insertDeleteTest", 5 - loop);
            ++loop;
        }
        statement.execute("DROP TABLE FDIR1");
        c.commit();
    }

    void unqualDeleteTest(Connection c, String columnType, int size) throws SQLException, TestCaseException {
        TestStatement statement = new TestStatement((TestCase)this, c);
        this.addMessage(this.nextStep("unqualDeleteTest"), 'I', String.valueOf(columnType) + " size:" + size + " bytes.");
        statement.enableExceptions(false);
        statement.execute("DROP TABLE FDIR1");
        statement.enableExceptions(true);
        statement.execute("CREATE TABLE FDIR1 (KEY1 CHAR(15), COL1 CHAR(15), PRIMARY KEY (KEY1), LONGCOL " + columnType + ")");
        TestPreparedStatement prepS = new TestPreparedStatement(null, c, "INSERT FDIR1 values (?,?,?)");
        byte[] buffer = new byte[size];
        int loop = 5;
        while (loop > 0) {
            prepS.setString(1, "key" + loop);
            prepS.setString(2, "col1");
            prepS.setAsciiStream(3, (InputStream)new ByteArrayInputStream(buffer), size);
            prepS.execute();
            --loop;
        }
        c.commit();
        this.compareLOBCounter(c, "FDIR1", "unqualDeleteTest");
        this.compareCounter(c, "FDIR1", "unqualDeleteTest", 5);
        statement.execute("DELETE FDIR1");
        this.compareLOBCounter(c, "FDIR1", "unqualDeleteTest");
        this.compareCounter(c, "FDIR1", "unqualDeleteTest", 0);
        statement.execute("DROP TABLE FDIR1");
        c.commit();
    }

    void updateTest(Connection c, String columnType, int initSize, int updateSize) throws SQLException, TestCaseException {
        TestStatement statement = new TestStatement((TestCase)this, c);
        this.addMessage(this.nextStep("updateTest"), 'I', String.valueOf(columnType) + " size:" + initSize + "/" + updateSize + " bytes.");
        statement.enableExceptions(false);
        statement.execute("DROP TABLE FDIR1");
        statement.enableExceptions(true);
        statement.execute("CREATE TABLE FDIR1 (KEY1 CHAR(15), COL1 CHAR(15), PRIMARY KEY (KEY1), LONGCOL " + columnType + ")");
        byte[] buffer = new byte[initSize];
        byte[] updbuffer = new byte[updateSize];
        TestPreparedStatement prepInsertS = new TestPreparedStatement(null, c, "INSERT FDIR1 values (?,?,?)");
        TestPreparedStatement prepUpdateS = new TestPreparedStatement(null, c, "UPDATE FDIR1 set LONGCOL = (?) where KEY1 = (?) ");
        int loop = 5;
        while (loop > 0) {
            prepInsertS.setString(1, "key" + loop);
            prepInsertS.setString(2, "col1");
            prepInsertS.setAsciiStream(3, (InputStream)new ByteArrayInputStream(buffer), initSize);
            prepInsertS.execute();
            prepUpdateS.setAsciiStream(1, (InputStream)new ByteArrayInputStream(updbuffer), updateSize);
            prepUpdateS.setString(2, "key" + loop);
            prepUpdateS.execute();
            c.commit();
            this.compareLOBCounter(c, "FDIR1", "updateTest");
            this.compareCounter(c, "FDIR1", "updateTest", 5 - loop + 1);
            --loop;
        }
        statement.execute("DROP TABLE FDIR1");
        c.commit();
    }

    void createInsertAsSelectTest(Connection c, String columnType, int size) throws SQLException, TestCaseException {
        TestStatement statement = new TestStatement((TestCase)this, c);
        this.addMessage(this.nextStep("createInsertAsSelectTest"), 'I', String.valueOf(columnType) + " size:" + size + " bytes.");
        statement.enableExceptions(false);
        statement.execute("DROP TABLE FDIR1");
        statement.execute("DROP TABLE FDIR2");
        statement.enableExceptions(true);
        statement.execute("CREATE TABLE FDIR1 (KEY1 CHAR(15), COL1 CHAR(15), PRIMARY KEY (KEY1), LONGCOL " + columnType + ")");
        TestPreparedStatement prepS = new TestPreparedStatement(null, c, "INSERT FDIR1 values (?,?,?)");
        byte[] buffer = new byte[size];
        int loop = 5;
        while (loop > 0) {
            prepS.setString(1, "key" + loop);
            prepS.setString(2, "col1");
            prepS.setAsciiStream(3, (InputStream)new ByteArrayInputStream(buffer), size);
            prepS.execute();
            c.commit();
            --loop;
        }
        int baseCounter = this.compareLOBCounter(c, "FDIR1", "createInsertAsSelectTest");
        this.compareCounter(c, "FDIR1", "createInsertAsSelectTest", 5);
        statement.execute("CREATE TABLE FDIR2 AS SELECT * FROM FDIR1");
        int copyCounter = this.compareLOBCounter(c, "FDIR2", "createInsertAsSelectTest");
        this.compareCounter(c, "FDIR2", "createInsertAsSelectTest", 5);
        if (copyCounter != baseCounter) {
            this.addMessage(this.nextStep("createInsertAsSelectTest"), 'E', "org table counter: " + baseCounter + "kb\n" + "copy table counter: " + copyCounter + "kb");
        }
        statement.execute("DROP TABLE FDIR2");
        statement.execute("CREATE TABLE FDIR2 (KEY1 CHAR(15), COL1 CHAR(15), PRIMARY KEY (KEY1), LONGCOL " + columnType + ")");
        statement.execute("insert into FDIR2 AS SELECT * FROM FDIR1");
        copyCounter = this.compareLOBCounter(c, "FDIR2", "createInsertAsSelectTest");
        this.compareCounter(c, "FDIR2", "createInsertAsSelectTest", 5);
        if (copyCounter != baseCounter) {
            this.addMessage(this.nextStep("createInsertAsSelectTest"), 'E', "org table counter: " + baseCounter + "kb\n" + "copy table counter: " + copyCounter + "kb");
        }
        statement.execute("DROP TABLE FDIR1");
        statement.execute("DROP TABLE FDIR2");
        c.commit();
    }

    void insertDefaultTest(Connection c, String columnType) throws SQLException, TestCaseException {
        TestStatement statement = new TestStatement((TestCase)this, c);
        this.addMessage(this.nextStep("insertDefaultTest"), 'I', columnType);
        statement.enableExceptions(false);
        statement.execute("DROP TABLE FDIR1");
        statement.enableExceptions(true);
        statement.execute("CREATE TABLE FDIR1 (KEY1 CHAR(15), datum date default date, PRIMARY KEY (KEY1), LONGCOL " + columnType + " DEFAULT 'xxxxx')");
        statement.execute("INSERT INTO FDIR1 (key1,datum) values ('hubsa','2005-04-03')");
        statement.execute("INSERT INTO FDIR1 (key1,datum) select 4711, date from dual");
        statement.execute("INSERT INTO FDIR1 (key1,datum) values ('hubsa2',date('2005-04-03'))");
        statement.execute("INSERT INTO FDIR1 (key1,datum, longcol) values ('hubsa3',date('2005-04-03'),'yyyyyyyyyyy')");
        statement.execute("INSERT INTO FDIR1 (key1,datum, longcol) values ('hubsa4','2005-04-03','yyyyyyyyyyy')");
        c.commit();
        this.compareLOBCounter(c, "FDIR1", "InsertDefaultTest");
        this.compareCounter(c, "FDIR1", "InsertDefaultTest", 5);
        statement.execute("DROP TABLE FDIR1");
        c.commit();
    }

    int compareLOBCounter(Connection c, String tablename, String testName) throws SQLException {
        TestStatement statement = new TestStatement((TestCase)this, c);
        ResultSet result = statement.executeQuery("select FILES.LOBSIZE from FILES,ROOTS where roots.tablename = '" + tablename + "' and roots.tableid = files.fileid and files.type = 'TABLE'");
        result.next();
        int fdirCounter = result.getInt(1);
        result = dbHasLOBType ? statement.executeQuery("select numeric_value from TABLESTATISTICS where tablename = '" + tablename + "' and description = 'LOB column pages'") : statement.executeQuery("select numeric_value from TABLESTATISTICS where tablename = '" + tablename + "' and description = 'LONG column pages'");
        result.next();
        int tabStatsCounter = result.getInt(1) * 8;
        if (tabStatsCounter != fdirCounter) {
            this.addMessage(this.nextStep(testName), 'E', "FDIR LOB counter: " + fdirCounter + "kb\n" + "TABLESTATISTICS counter: " + tabStatsCounter + "kb");
        }
        return fdirCounter;
    }

    int compareCounter(Connection c, String tablename, String testName, int recordCount) throws SQLException {
        TestStatement statement = new TestStatement((TestCase)this, c);
        ResultSet result = statement.executeQuery("select FILES.ENTRYCOUNT from FILES,ROOTS where roots.tablename = '" + tablename + "' and roots.tableid = files.fileid and files.type = 'TABLE'");
        result.next();
        int fdirCounter = result.getInt(1);
        if (recordCount != fdirCounter) {
            this.addMessage(this.nextStep(testName), 'E', "FDIR entry counter: " + fdirCounter + "\n" + "entries: " + recordCount);
        }
        return fdirCounter;
    }
}

