/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.optimizer;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestStatementMonitor;
import com.sap.sapdb.testframe.driver.TestStatementMonitorException;
import com.sap.sapdb.testframe.testcase.ExplainDataIteratorPretty;
import com.sap.sapdb.testframe.testcase.ExplainException;
import com.sap.sapdb.testframe.testcase.ExplainObject;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.Table;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class SingleTableV73
extends TestCase {
    private static String sUser = null;
    private static String sTableName = null;
    private static String sPassword = null;
    private static Table sTable;
    private static String sValueK0;
    private static String sValueFx;
    private static String sValueFxformat;
    private static String sValueK2;
    private int mMaxNoOfVirtualReads = 0;
    private long mMaxRuntime = Long.MAX_VALUE;
    private int mDiffInteger = 0;
    private int mDiffString = 0;
    private int mTableRows = 0;
    private Connection mMainConnection = null;
    private TestPreparedStatement mMainPreparedStatement = null;
    private TestStatement mHelpStatement = null;
    private TestStatementMonitor mMainMonitor = null;
    private ExplainObject mMainExplainObject = new ExplainObject();
    private boolean mDropIndexesAfterBlockFinished = true;
    private TestStatementMonitor mAlternativeMonitor = null;
    private static final DecimalFormat K2_FORMAT;
    private String mMethodName = null;
    public static boolean mTraceOn;
    private static final String DEFAULT_BLOCK_SEQUENCE = "1;2;3;4";

    static {
        sValueK0 = null;
        sValueFx = null;
        sValueFxformat = null;
        sValueK2 = "String-";
        K2_FORMAT = new DecimalFormat("#####");
        K2_FORMAT.setMinimumIntegerDigits(5);
        mTraceOn = false;
    }

    private void addAlternativeStrategieMessage(TestPreparedStatement pOriginalStmt, int pOriginalReads, TestPreparedStatement pAlternativelStmt, int pAlternativeReads) {
        StringBuffer ls1 = new StringBuffer();
        ls1.append("Alternative strategie needs " + pAlternativeReads + " virtual reads. Optimizer strat. needs " + pOriginalReads + " virtual reads");
        ls1.append("\n Optimizer strategie: \n");
        ExplainDataIteratorPretty it = pOriginalStmt.getExplainObject().iteratorPretty();
        if (it != null) {
            while (it.hasNext()) {
                ls1.append(it.next());
            }
        }
        ls1.append("\n Alternative strategie: \n");
        it = null;
        it = pAlternativelStmt.getExplainObject().iteratorPretty();
        if (it != null) {
            while (it.hasNext()) {
                ls1.append(it.next());
            }
        }
        this.addMessage(this.getStep(), 'W', ls1.toString(), pOriginalStmt.getSqlString());
    }

    public void block_1() throws SQLException, TestCaseException, ExplainException, TestStatementMonitorException {
        String ID = "Block_001";
        this.addMessage(ID, 'I', "Primary Key on the columns k0, k1, k2");
        String lSql = "select * from  " + sTableName;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select k1 from  " + sTableName;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select k2 from  " + sTableName;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select * from " + sTableName + " where k0 =" + SingleTableV73.buildK0() + " and k1 =" + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select k1 from " + sTableName + " where k0 =" + SingleTableV73.buildK0() + " and k1 =" + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select k0, k1, k2 from " + sTableName + " where k0 =" + SingleTableV73.buildK0() + " and k1 =" + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select * from " + sTableName + " where k0 =" + SingleTableV73.buildK0() + " and k1 in (" + (this.mDiffInteger - 10) + "," + (this.mDiffInteger - 1) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("In Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger + this.mDiffString, ID);
        lSql = "select * from " + sTableName + " where k0 =" + SingleTableV73.buildK0() + " and k2 in (" + SingleTableV73.buildK2(this.mDiffString - 10) + "," + SingleTableV73.buildK2(this.mDiffString - 1) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Range Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger + this.mDiffString, ID);
        lSql = "select * from " + sTableName + " where k1 =" + (this.mDiffInteger - 1) + " and k2 in (" + SingleTableV73.buildK2(this.mDiffString - 10) + "," + SingleTableV73.buildK2(this.mDiffString - 1) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 2, ID);
        lSql = "select * from " + sTableName + " where k0 =" + SingleTableV73.buildK0() + " and k1 =" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Range Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where k1 =" + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select * from " + sTableName + " where k0 between " + SingleTableV73.buildK0() + " and " + SingleTableV73.buildK0();
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Range Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * this.mDiffString, ID);
        lSql = "select * from " + sTableName + " where k1 between " + (this.mDiffInteger - 10) + " and " + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 10, ID);
        lSql = "select * from " + sTableName + " where k2 between " + SingleTableV73.buildK2(this.mDiffString - 10) + " and " + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 10, ID);
        lSql = "select * from " + sTableName + " where k0 =" + SingleTableV73.buildK0() + "and k1 between " + (this.mDiffInteger - 10) + " and " + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Range Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 10, ID);
        lSql = "select * from " + sTableName + " where k1 =" + (this.mDiffInteger - 1) + " and k2 between " + SingleTableV73.buildK2(this.mDiffString - 10) + " and " + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger / 5, ID);
        lSql = "select * from " + sTableName + " where k0 =" + SingleTableV73.buildK0() + " and k2 between " + SingleTableV73.buildK2(this.mDiffString - 10) + " and " + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Range Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 10, ID);
        lSql = "select * from " + sTableName + " where k0 like " + SingleTableV73.buildK0();
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Range Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select * from " + sTableName + " where k2 like " + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
        lSql = "select * from " + sTableName + " where k0 like '%" + sValueK0 + "'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Range Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select * from " + sTableName + " where k2 like '%" + SingleTableV73.buildK2format(this.mDiffString - 1) + "'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
        lSql = "select * from " + sTableName + " where k0 like '%" + sValueK0 + "%'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Range Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select * from " + sTableName + " where k2 like '%" + SingleTableV73.buildK2format(this.mDiffString - 1) + "%'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
        lSql = "select * from " + sTableName + " where k0 like '" + sValueK0 + "%'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Range Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select * from " + sTableName + " where k2 like '" + SingleTableV73.buildK2format(this.mDiffString - 1) + "%'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select * from " + sTableName + " where k1<" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows - this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where k1<=" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select * from " + sTableName + " where k1>" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select * from " + sTableName + " where k1>=" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where k1<" + (this.mDiffInteger - 1) + " and num(substr(k2,8,4))>num(" + SingleTableV73.buildK2format(this.mDiffString - 10) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select * from " + sTableName + " where k0=(select k0 from " + sTableName + " where k0 =" + SingleTableV73.buildK0() + " and k1 =" + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select * from " + sTableName + " where k1=(select k1 from " + sTableName + " where k0 =" + SingleTableV73.buildK0() + " and k1 =" + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where k2=(select k2 from " + sTableName + " where k0 =" + SingleTableV73.buildK0() + " and k1 =" + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K1");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where k0=(select k0 from " + sTableName + " where k1 =" + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select * from " + sTableName + " where k1 in (select k1 from " + sTableName + " where k0 =" + SingleTableV73.buildK0() + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Range Condition For Key Column");
        this.mMainExplainObject.addStrategy("(USED KEY COLUMN)", "K0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
    }

    public void block_2() throws SQLException, TestCaseException, ExplainException, TestStatementMonitorException {
        String ID = "Block_002";
        this.addMessage(ID, 'I', "Multiple Index on the columns f0, f1, f2");
        String lSql = null;
        sTable.setConnection(this.mMainConnection);
        sTable.dropIndex("b20", false);
        sTable.createIndex("b20", new String[]{"f0, f1, f2"}, true, this.mHelpStatement);
        sTable.updateStatistics(this.mHelpStatement);
        lSql = "select * from  " + sTableName;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select f0 from  " + sTableName;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select distinct f0 from " + sTableName;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.setResultIsCopied(false);
        this.mMainExplainObject.add();
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select f1 from  " + sTableName;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select f2 from  " + sTableName;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select f0,f1,f2 from  " + sTableName;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select * from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select f0 from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select f1 from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select f2 from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select f0, f1, f2 from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select * from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f1 in (" + (this.mDiffInteger - 10) + "," + (this.mDiffInteger - 1) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("In Condition For Multiple Index", "B20", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger + this.mDiffString, ID);
        lSql = "select f0, f1 from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f1 in (" + (this.mDiffInteger - 10) + "," + (this.mDiffInteger - 1) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("In Condition For Multiple Index", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger + this.mDiffString, ID);
        lSql = "select * from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f2 in (" + SingleTableV73.buildK2(this.mDiffString - 10) + "," + SingleTableV73.buildK2(this.mDiffString - 1) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger + this.mDiffString, ID);
        lSql = "select f0, f2 from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f2 in (" + SingleTableV73.buildK2(this.mDiffString - 10) + "," + SingleTableV73.buildK2(this.mDiffString - 1) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger + this.mDiffString, ID);
        lSql = "select * from " + sTableName + " where f1 =" + (this.mDiffInteger - 1) + " and f2 in (" + SingleTableV73.buildK2(this.mDiffString - 10) + "," + SingleTableV73.buildK2(this.mDiffString - 1) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 2, ID);
        lSql = "select f1, f2 from " + sTableName + " where f1 =" + (this.mDiffInteger - 1) + " and f2 in (" + SingleTableV73.buildK2(this.mDiffString - 10) + "," + SingleTableV73.buildK2(this.mDiffString - 1) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 2, ID);
        lSql = "select * from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f1 =" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select f0, f1 from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f1 =" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select f1, f2 from " + sTableName + " where f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select * from " + sTableName + " where f0 between " + SingleTableV73.buildK0() + " and " + SingleTableV73.buildK0();
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * this.mDiffString, ID);
        lSql = "select f0 from " + sTableName + " where f0 between " + SingleTableV73.buildK0() + " and " + SingleTableV73.buildK0();
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * this.mDiffString, ID);
        lSql = "select * from " + sTableName + " where f1 between " + (this.mDiffInteger - 10) + " and " + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 10, ID);
        lSql = "select f1 from " + sTableName + " where f1 between " + (this.mDiffInteger - 10) + " and " + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 10, ID);
        lSql = "select * from " + sTableName + " where f2 between " + SingleTableV73.buildK2(this.mDiffString - 10) + " and " + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 10, ID);
        lSql = "select f2 from " + sTableName + " where f2 between " + SingleTableV73.buildK2(this.mDiffString - 10) + " and " + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 10, ID);
        lSql = "select * from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + "and f1 between " + (this.mDiffInteger - 10) + " and " + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 10, ID);
        lSql = "select f0, f1 from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + "and f1 between " + (this.mDiffInteger - 10) + " and " + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 10, ID);
        lSql = "select * from " + sTableName + " where f1 =" + (this.mDiffInteger - 1) + " and f2 between " + SingleTableV73.buildK2(this.mDiffString - 10) + " and " + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger / 5, ID);
        lSql = "select f1, f2 from " + sTableName + " where f1 =" + (this.mDiffInteger - 1) + " and f2 between " + SingleTableV73.buildK2(this.mDiffString - 10) + " and " + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger / 5, ID);
        lSql = "select * from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f2 between " + SingleTableV73.buildK2(this.mDiffString - 10) + " and " + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 10, ID);
        lSql = "select f0, f2 from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f2 between " + SingleTableV73.buildK2(this.mDiffString - 10) + " and " + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 10, ID);
        lSql = "select * from " + sTableName + " where f0 like " + SingleTableV73.buildK0();
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select f0 from " + sTableName + " where f0 like " + SingleTableV73.buildK0();
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select f1, f2 from " + sTableName + " where f0 like " + SingleTableV73.buildK0();
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select * from " + sTableName + " where f2 like " + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
        lSql = "select f2 from " + sTableName + " where f2 like " + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
        lSql = "select f0, f1, f2 from " + sTableName + " where f2 like " + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
        lSql = "select * from " + sTableName + " where f0 like '%" + sValueK0 + "'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select f0, f1, f2 from " + sTableName + " where f0 like '%" + sValueK0 + "'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select * from " + sTableName + " where f2 like '%" + SingleTableV73.buildK2format(this.mDiffString - 1) + "'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
        lSql = "select f0, f1, f2 from " + sTableName + " where f2 like '%" + SingleTableV73.buildK2format(this.mDiffString - 1) + "'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
        lSql = "select f2 from " + sTableName + " where f2 like '%" + SingleTableV73.buildK2format(this.mDiffString - 1) + "'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
        lSql = "select * from " + sTableName + " where f0 like '%" + sValueK0 + "%'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select f0 from " + sTableName + " where f0 like '%" + sValueK0 + "%'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select f1, f2 from " + sTableName + " where f0 like '%" + sValueK0 + "%'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select * from " + sTableName + " where f2 like '%" + SingleTableV73.buildK2format(this.mDiffString - 1) + "%'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
        lSql = "select f2 from " + sTableName + " where f2 like '%" + SingleTableV73.buildK2format(this.mDiffString - 1) + "%'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
        lSql = "select f0, f1, f2 from " + sTableName + " where f2 like '%" + SingleTableV73.buildK2format(this.mDiffString - 1) + "%'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
        lSql = "select * from " + sTableName + " where f0 like '" + sValueK0 + "%'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select f0, f1, f2 from " + sTableName + " where f0 like '" + sValueK0 + "%'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select * from " + sTableName + " where f2 like '" + SingleTableV73.buildK2format(this.mDiffString - 1) + "%'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select f0, f1, f2 from " + sTableName + " where f2 like '" + SingleTableV73.buildK2format(this.mDiffString - 1) + "%'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select * from " + sTableName + " where f1<" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows - this.mDiffInteger, ID);
        lSql = "select f1 from " + sTableName + " where f1<" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows - this.mDiffInteger, ID);
        lSql = "select f0, f1, f2 from " + sTableName + " where f1<" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows - this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where f1<=" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select f0, f1, f2 from " + sTableName + " where f1<=" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select * from " + sTableName + " where f1>" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select f0, f1, f2 from " + sTableName + " where f1>" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select * from " + sTableName + " where f1>=" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select f0, f1, f2 from " + sTableName + " where f1>=" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where f1<" + (this.mDiffInteger - 1) + " and num(substr(f2,8,4))>num(" + SingleTableV73.buildK2format(this.mDiffString - 10) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select f1, f2 from " + sTableName + " where f1<" + (this.mDiffInteger - 1) + " and num(substr(f2,8,4))>num(" + SingleTableV73.buildK2format(this.mDiffString - 10) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select * from " + sTableName + " where f0=(select f0 from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select f0, f1, f2 from " + sTableName + " where f0=(select f0 from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX(SUBQ)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        int help = this.mMaxNoOfVirtualReads;
        this.mMaxNoOfVirtualReads += 2000;
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        this.mMaxNoOfVirtualReads = help;
        lSql = "select * from " + sTableName + " where f1=(select f1 from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select f0, f1, f2 from " + sTableName + " where f1=(select f1 from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where f2=(select f2 from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select f0, f1, f2 from " + sTableName + " where f2=(select f2 from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where f0=(select f0 from " + sTableName + " where f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select f0, f1, f2 from " + sTableName + " where f0=(select f0 from " + sTableName + " where f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX(SUBQ)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        help = this.mMaxNoOfVirtualReads;
        this.mMaxNoOfVirtualReads += 2000;
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        this.mMaxNoOfVirtualReads = help;
        lSql = "select * from " + sTableName + " where f1 in (select f1 from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select f0, f1, f2 from " + sTableName + " where f1 in (select f1 from " + sTableName + " where f0 =" + SingleTableV73.buildK0() + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f0");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        if (this.mDropIndexesAfterBlockFinished) {
            sTable.dropIndex("b20", false);
        }
    }

    public void block_3() throws SQLException, TestCaseException, ExplainException, TestStatementMonitorException {
        String ID = "Block_003";
        this.addMessage(ID, 'I', "Single Index on the column f1");
        String lSql = null;
        sTable.setConnection(this.mMainConnection);
        sTable.dropIndex("b20", false);
        sTable.createIndex("b20", new String[]{"f1"}, false, this.mHelpStatement);
        sTable.updateStatistics(this.mHelpStatement);
        lSql = "select f1 from  " + sTableName;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select f1 from " + sTableName + " where f1 =" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEXED COLUMN", "f1", true, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where f1 =" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEXED COLUMN", "f1", false, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select f1 from " + sTableName + " where f1 between " + (this.mDiffInteger - 10) + " and " + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEXED COLUMN", "f1", true, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 10, ID);
        lSql = "select * from " + sTableName + " where f1 between " + (this.mDiffInteger - 10) + " and " + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 10, ID);
        lSql = "select f1 from " + sTableName + " where f1 in (" + (this.mDiffInteger - 10) + "," + (this.mDiffInteger - 1) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("In Condition For Indexed Column", "f1", true, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger + this.mDiffString, ID);
        lSql = "select * from " + sTableName + " where f1 in (" + (this.mDiffInteger - 10) + "," + (this.mDiffInteger - 1) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("In Condition For Indexed Column", "f1", false, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger + this.mDiffString, ID);
        lSql = "select f1 from " + sTableName + " where f1<" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEXED COLUMN", "f1", true, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows - this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where f1<" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows - this.mDiffInteger, ID);
        lSql = "select f1 from " + sTableName + " where f1<=" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEXED COLUMN", "f1", true, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select * from " + sTableName + " where f1<=" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select f1 from " + sTableName + " where f1>" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEXED COLUMN", "f1", true, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select * from " + sTableName + " where f1>" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEXED COLUMN", "f1", false, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select f1 from " + sTableName + " where f1>=" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEXED COLUMN", "f1", true, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where f1>=" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEXED COLUMN", "f1", false, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select f1 from " + sTableName + " where f1>" + (this.mDiffInteger - 10) + " and f1<" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEXED COLUMN", "f1", true, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 8, ID);
        lSql = "select * from " + sTableName + " where f1>" + (this.mDiffInteger - 10) + " and f1<" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 8, ID);
        lSql = "select f1 from " + sTableName + " where f1>=" + (this.mDiffInteger - 10) + " and f1<=" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEXED COLUMN", "f1", true, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 10, ID);
        lSql = "select * from " + sTableName + " where f1>=" + (this.mDiffInteger - 10) + " and f1<=" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 10, ID);
        if (this.mDropIndexesAfterBlockFinished) {
            sTable.dropIndex("b20", false);
        }
    }

    public void block_4() throws SQLException, TestCaseException, ExplainException, TestStatementMonitorException {
        String ID = "Block_004";
        this.addMessage(ID, 'I', "Multiple Indexes on the columns k1, k2, f1, f2, f4");
        String lSql = null;
        sTable.setConnection(this.mMainConnection);
        sTable.dropIndex("b20", false);
        sTable.dropIndex("b21", false);
        sTable.dropIndex("b22", false);
        sTable.dropIndex("b23", false);
        sTable.createIndex("b20", new String[]{"k1, k2"}, false, this.mHelpStatement);
        sTable.createIndex("b21", new String[]{"k2, f1, f2"}, false, this.mHelpStatement);
        sTable.createIndex("b22", new String[]{"f2, f4"}, false, this.mHelpStatement);
        sTable.createIndex("b23", new String[]{"f1"}, false, this.mHelpStatement);
        sTable.updateStatistics(this.mHelpStatement);
        lSql = "select k1, k2 from  " + sTableName;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B22", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f4");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select k2, f1, f2 from  " + sTableName;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B21", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "k2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select f2, f4 from  " + sTableName;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B22", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f4");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select f1 from  " + sTableName;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("MULTIPLE INDEX COLUMN USED (INDEX SCAN)", "B21", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "k2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select k1, k2, f1, f2, f4 from " + sTableName;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mTableRows, ID);
        lSql = "select * from " + sTableName + " where k1 =" + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "k1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "k2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select k1, k2 from " + sTableName + " where k1 =" + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "k1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "k2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select k1, k2, k0 from " + sTableName + " where k1 =" + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "k1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "k2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select k2, k1 from " + sTableName + " where k1 =" + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "k1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "k2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select k1, k2, f5  from " + sTableName + " where k1 =" + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "k1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "k2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select * from " + sTableName + " where k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", false, false, false, true);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select k2, f1, f2 from " + sTableName + " where k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B21", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "k2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select f2, k2, f1 from " + sTableName + " where k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f1=" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B21", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "k2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select k2, k1, f5 from " + sTableName + " where k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f1=" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", false, false, false, true);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select f1, f2, k0 from " + sTableName + " where k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B21", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "k2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select * from " + sTableName + " where f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f4 =" + sValueFxformat;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B22", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f4");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select f2, f4 from " + sTableName + " where f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f4 =" + sValueFxformat;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B22", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f4");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select f2, f4, f5 from " + sTableName + " where f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f4 =" + sValueFxformat;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B22", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f4");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select f2, f4, k1, f1 from " + sTableName + " where f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f4 =" + sValueFxformat;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B22", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f4");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select k0, f1, f2, f4 from " + sTableName + " where f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f4 =" + sValueFxformat;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B22", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f4");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select * from " + sTableName + " where f1 = " + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEXED COLUMN", "f1", false, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select f1 from " + sTableName + " where f1 = " + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEXED COLUMN", "f1", true, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select f0, f1, k2, f5 from " + sTableName + " where f1 = " + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEXED COLUMN", "f1", false, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select k1, k2 from " + sTableName + " where k1 in (" + (this.mDiffInteger - 10) + "," + (this.mDiffInteger - 1) + ") and k2=" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("In Condition For Multiple Index", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "k1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "k2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, 2, ID);
        lSql = "select * from " + sTableName + " where k1 in (" + (this.mDiffInteger - 10) + "," + (this.mDiffInteger - 1) + ") and k2=" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B21", false, false, false, true);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 2, ID);
        lSql = "select k1, k2 from " + sTableName + " where k1 in (" + (this.mDiffInteger - 10) + "," + (this.mDiffInteger - 1) + ") and f2=" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 2, ID);
        lSql = "select * from " + sTableName + " where k2 = " + SingleTableV73.buildK2(this.mDiffString - 1) + " and f1 in (" + (this.mDiffInteger - 10) + "," + (this.mDiffInteger - 1) + ") and f2=" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", false, false, false, true);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 2, ID);
        lSql = "select k2, f1, f2  from " + sTableName + " where k2 = " + SingleTableV73.buildK2(this.mDiffString - 1) + " and f1 in (" + (this.mDiffInteger - 10) + "," + (this.mDiffInteger - 1) + ") and f2=" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("In Condition For Multiple Index", "B21", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "k2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, 2, ID);
        lSql = "select k2, f1, f2  from " + sTableName + " where f1 in (" + (this.mDiffInteger - 10) + "," + (this.mDiffInteger - 1) + ") and f2=" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 2, ID);
        lSql = "select * from " + sTableName + " where f1 in (" + (this.mDiffInteger - 10) + "," + (this.mDiffInteger - 1) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("In Condition For Indexed Column", "f1", false, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 2, ID);
        lSql = "select f1 from " + sTableName + " where f1 in (" + (this.mDiffInteger - 10) + "," + (this.mDiffInteger - 1) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("In Condition For Indexed Column", "f1", true, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * 2, ID);
        lSql = "select f1 from " + sTableName + " where f1 in (" + (this.mDiffInteger - 10) + "," + (this.mDiffInteger - 1) + ") and f6 = " + sValueFxformat;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("In Condition For Indexed Column", "f1", false, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select * from " + sTableName + " where k1 =" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where k1 =" + (this.mDiffInteger - 1) + " and f2=" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", false, false, false, true);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select * from " + sTableName + " where  k2=" + SingleTableV73.buildK2(this.mDiffString - 1) + " and k1 =" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select * from " + sTableName + " where  k2=" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f2=" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", false, false, false, true);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
        lSql = "select * from " + sTableName + " where  f2=" + SingleTableV73.buildK2(this.mDiffString - 1) + " and k1=" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", false, false, false, true);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select * from " + sTableName + " where  f1= " + (this.mDiffInteger - 1) + " and f2=" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select * from " + sTableName + " where  f1=" + (this.mDiffInteger - 1) + " and f4=" + sValueFxformat;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEXED COLUMN", "F1", false, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select * from " + sTableName + " where  k1= " + (this.mDiffInteger - 10) + " and k2 between " + SingleTableV73.buildK2(this.mDiffString - 10) + " and " + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 10, ID);
        lSql = "select * from " + sTableName + " where  k2=" + SingleTableV73.buildK2(this.mDiffString - 1) + " and k1 between " + (this.mDiffInteger - 10) + " and " + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B21", false, false, false, true);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 10, ID);
        lSql = "select * from " + sTableName + " where  k2 between " + SingleTableV73.buildK2(this.mDiffString - 10) + " and " + SingleTableV73.buildK2(this.mDiffString - 1) + " and f2=" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", false, false, false, true);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
        lSql = "select * from " + sTableName + " where  f2 between " + SingleTableV73.buildK2(this.mDiffString - 10) + " and " + SingleTableV73.buildK2(this.mDiffString - 1) + " and k1=" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 10, ID);
        lSql = "select * from " + sTableName + " where  f1 between " + (this.mDiffInteger - 10) + " and " + (this.mDiffInteger - 1) + " and f2=" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 10, ID);
        lSql = "select * from " + sTableName + " where  f1 between " + (this.mDiffInteger - 10) + " and " + (this.mDiffInteger - 1) + " and f4=" + sValueFxformat;
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select * from " + sTableName + " where  k1<=" + (this.mDiffInteger - 1) + " and k2= " + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B21", false, false, false, true);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where  k1<=" + (this.mDiffInteger - 1) + " and k2 like '%" + SingleTableV73.buildK2format(this.mDiffString - 1) + "%'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where  k2 like " + SingleTableV73.buildK2(this.mDiffString - 1) + " and k1>" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", false, false, false, true);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select * from " + sTableName + " where  k2=" + SingleTableV73.buildK2(this.mDiffString - 1) + " and num(substr(f2,8,4))>num(" + SingleTableV73.buildK2format(this.mDiffString - 10) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B21", false, false, false, true);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select * from " + sTableName + " where  k2 like '%" + SingleTableV73.buildK2format(this.mDiffString - 1) + "%' and num(substr(f2,8,4))>num(" + SingleTableV73.buildK2format(this.mDiffString - 10) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select * from " + sTableName + " where  f2 like '%" + SingleTableV73.buildK2format(this.mDiffString - 1) + "' and  k1>=" + (this.mDiffInteger - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B20", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 1, ID);
        lSql = "select * from " + sTableName + " where  f1<=" + (this.mDiffInteger - 1) + " and f2=" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "F2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where  f1<=" + (this.mDiffInteger - 1) + " and f2 like '%" + SingleTableV73.buildK2format(this.mDiffString - 1) + "%'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where  f1>" + (this.mDiffInteger - 1) + " and f4 like '%" + sValueFx.substring(2, 6) + "%'";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR INDEXED COLUMN", "F1", false, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(false);
        this.executePreparedStep(lSql, this.mMainExplainObject, 0, ID);
        lSql = "select * from " + sTableName + " where k1=(select k1 from " + sTableName + " where k1 =" + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select k1 from " + sTableName + " where k1=(select k1 from " + sTableName + " where k1 =" + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX(SUBQ)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select k1, k2, f1 from " + sTableName + " where k1=(select k1 from " + sTableName + " where k1 =" + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where k1=(select k1 from " + sTableName + " where k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B21", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select k1 from " + sTableName + " where k1=(select k1 from " + sTableName + " where k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B21", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX(SUBQ)", "B20", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K1");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select * from " + sTableName + " where k2=(select k2 from " + sTableName + " where k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B21", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select k2, k1 from " + sTableName + " where k2=(select k2 from " + sTableName + " where k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B21", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX(SUBQ)", "B21", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select k2, k1, f5 from " + sTableName + " where k2=(select k2 from " + sTableName + " where k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f1 =" + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Equal Condition For Multiple Index", "B21", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "K2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f1");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger, ID);
        lSql = "select f1 from " + sTableName + " where f1 in (select f1 from " + sTableName + " where f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f4 like '%" + sValueFx.substring(2, 6) + "%' )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f4");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("EQUAL CONDITION FOR INDEXED COLUMN(SUBQ)", "F1", true, false, false, false);
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        int help = this.mMaxNoOfVirtualReads;
        this.mMaxNoOfVirtualReads += 2000;
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * this.mDiffString, ID);
        this.mMaxNoOfVirtualReads = help;
        lSql = "select * from " + sTableName + " where f1 in (select f1 from " + sTableName + " where f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f4 like '%" + sValueFx.substring(2, 6) + "%' )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", false, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f4");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * this.mDiffString, ID);
        lSql = "select f2 from " + sTableName + " where f2 in (select f2 from " + sTableName + " where f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f4 like '%" + sValueFx.substring(2, 6) + "%' ) ";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f4");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX(SUBQ)", "B22", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
        lSql = "select * from " + sTableName + " where f2 in (select f2 from " + sTableName + " where f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f4 like '%" + sValueFx.substring(2, 6) + "%' ) and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1);
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", true, false, false, false);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f4");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffString, ID);
        lSql = "select k0 from " + sTableName + " where k0 = (select k0 from " + sTableName + " where k1 = " + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f1 = " + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f4 like '%" + sValueFx.substring(2, 6) + "%' )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", false, false, false, true);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f4");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * this.mDiffString, ID);
        lSql = "select * from " + sTableName + " where k0 = (select k0 from " + sTableName + " where k1 = " + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f1 = " + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f4 like '%" + sValueFx.substring(2, 6) + "%' )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", false, false, false, true);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f4");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * this.mDiffString, ID);
        lSql = "select f4 from " + sTableName + " where f4 = (select f4 from " + sTableName + " where k1 = " + (this.mDiffInteger - 1) + " and k2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + " and f1 = " + (this.mDiffInteger - 1) + " and f2 =" + SingleTableV73.buildK2(this.mDiffString - 1) + ")";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("RANGE CONDITION FOR MULTIPLE INDEX", "B22", false, false, false, true);
        this.mMainExplainObject.addStrategy("(USED INDEX COLUMN)", "f2");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("NO STRATEGY NOW (ONLY AT EXECUTION TIME)");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * this.mDiffString, ID);
        lSql = "select f5 from " + sTableName + " where f5 in (select f5 from " + sTableName + " where f4 like '%" + sValueFx.substring(2, 6) + "%' )";
        this.mMainExplainObject.clear();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.addTable(sTableName);
        this.mMainExplainObject.addStrategy("Table Scan");
        this.mMainExplainObject.add();
        this.mMainExplainObject.setResultIsCopied(true);
        help = this.mMaxNoOfVirtualReads;
        this.mMaxNoOfVirtualReads *= 4;
        this.executePreparedStep(lSql, this.mMainExplainObject, this.mDiffInteger * this.mDiffString, ID);
        this.mMaxNoOfVirtualReads = help;
        if (this.mDropIndexesAfterBlockFinished) {
            sTable.dropIndex("b20", false);
            sTable.dropIndex("b21", false);
            sTable.dropIndex("b22", false);
            sTable.dropIndex("b23", false);
        }
    }

    private static String buildK0() {
        return " '" + sValueK0 + "' ";
    }

    private static String buildK2(int pInt) {
        return " '" + sValueK2 + K2_FORMAT.format(pInt) + "' ";
    }

    private static String buildK2format(int pInt) {
        return K2_FORMAT.format(pInt);
    }

    protected boolean check(TestPreparedStatement ps, ExplainObject pEx, int pResultCounter, int pVr, long pMaxRuntime, String pStep) throws TestCaseException {
        return this.check(ps, pEx, pResultCounter, pVr, pMaxRuntime, pStep, 'E', "");
    }

    protected boolean check(TestPreparedStatement ps, ExplainObject pex, int pResultCounter, int pvr, long pMaxRuntime, String pStep, char pExplainErrorType, String pSql) throws TestCaseException {
        boolean ret = this.check((TestStatement)ps, pex, pResultCounter, pMaxRuntime, pStep, pExplainErrorType, pSql);
        if (TestCase.getParameterBoolean((String)"Check_Virtual_Reads", (boolean)true) && pvr > 0) {
            try {
                int ivr = ps.getMonitor().getNumberOfVirtualReads();
                int lvr = pvr == Integer.MAX_VALUE ? pvr : pvr + (int)((double)pvr * 0.1);
                if (ivr > lvr) {
                    this.addMessage(this.getStep(), 'W', "Too many virtual reads. Limit = " + lvr + " Actual = " + ivr, ps.getSqlString());
                    ret = false;
                }
            }
            catch (NullPointerException tnpe) {
                System.err.println("Couldn't monitor statement!!!");
                tnpe.printStackTrace(System.err);
                ret = false;
            }
        }
        return ret;
    }

    protected boolean check(TestStatement ps, ExplainObject pex, int pResultCounter, long pMaxRuntime, String pStep) throws TestCaseException {
        return this.check(ps, pex, pResultCounter, pMaxRuntime, pStep, 'E', "");
    }

    protected boolean check(TestStatement ps, ExplainObject pex, int pResultCounter, long pMaxRuntime, String pStep, char pExplainMessageType, String pSql) throws TestCaseException {
        boolean ret = true;
        boolean b = true;
        pStep = this.nextStep(pStep);
        this.printTrace("SQL statement: " + pSql);
        this.printTrace("Expected optimizer strategy: " + pex.getExplainData().getStrategyList() + " \n Chosen optimizer strategy: " + ps.getResultData().getExplainObject().getExplainData().getStrategyList());
        ret = this.checkResultCounter(ps, pResultCounter, pStep);
        if (TestCase.getParameterBoolean((String)"Check_Strategy", (boolean)true) && !(b = this.checkStrategy(ps, pex, pStep, pExplainMessageType))) {
            ret = b;
        }
        if (TestCase.getParameterBoolean((String)"Check_Statement_Runtime", (boolean)true) && pMaxRuntime != Long.MAX_VALUE && ps.getRuntime() > pMaxRuntime * 2L) {
            this.addMessage(this.getStep(), 'W', "Runtime of statement too long. Limit: " + pMaxRuntime * 10L + " Actual = " + ps.getRuntime(), ps.getSqlString());
            ret = false;
        }
        return ret;
    }

    protected boolean executePreparedStep(String pSql, ExplainObject pExplainObject, int pResultCounter, String pStep) throws SQLException, TestCaseException, TestStatementMonitorException {
        return this.executePreparedStep(pSql, pExplainObject, pResultCounter, pStep, 'E');
    }

    protected boolean executePreparedStep(String pSql, ExplainObject pExplainObject, int pResultCounter, String pStep, char pExplainErrorType) throws SQLException, TestCaseException, TestStatementMonitorException {
        this.mMainPreparedStatement = new TestPreparedStatement((TestCase)this, this.mMainConnection, pSql, this.mMainMonitor, 1005, 1007);
        this.mMainPreparedStatement.execute();
        boolean result = this.check(this.mMainPreparedStatement, pExplainObject, pResultCounter, this.mMaxNoOfVirtualReads, this.mMaxRuntime, pStep, pExplainErrorType, pSql);
        if (TestCase.getParameterBoolean((String)"CHECK_ALTERNATIVE_STRATEGIES", (boolean)false) && pSql.toUpperCase().startsWith("SELECT")) {
            if (this.mAlternativeMonitor == null) {
                this.mAlternativeMonitor = new TestStatementMonitor(this.mMainConnection);
            }
            this.mAlternativeMonitor.activate();
            int lReadsOptimizer = this.mMainMonitor.getNumberOfVirtualReads();
            String ls = pSql.substring(7);
            TestPreparedStatement lps = null;
            String lsql = null;
            int lReadsAlternative = 0;
            Set lSet = sTable.getIndexNames();
            if (lSet != null && !lSet.isEmpty()) {
                Iterator lIt = lSet.iterator();
                while (lIt.hasNext()) {
                    String lIndexName = (String)lIt.next();
                    lsql = "Select /*+INDEXACCESS(" + lIndexName + ")*/ " + ls;
                    lps = new TestPreparedStatement((TestCase)this, this.mMainConnection, lsql, this.mAlternativeMonitor, 1005, 1007);
                    lps.execute();
                    lReadsAlternative = this.mAlternativeMonitor.getNumberOfVirtualReads();
                    if (lReadsOptimizer > lReadsAlternative) {
                        this.addAlternativeStrategieMessage(this.mMainPreparedStatement, lReadsOptimizer, lps, lReadsAlternative);
                    }
                    lsql = "Select /*+INDEXSCAN(" + lIndexName + ")*/ " + ls;
                    lps = new TestPreparedStatement((TestCase)this, this.mMainConnection, lsql, this.mAlternativeMonitor, 1005, 1007);
                    lps.execute();
                    lReadsAlternative = this.mAlternativeMonitor.getNumberOfVirtualReads();
                    if (lReadsOptimizer <= lReadsAlternative) continue;
                    this.addAlternativeStrategieMessage(this.mMainPreparedStatement, lReadsOptimizer, lps, lReadsAlternative);
                }
            }
            lsql = "Select /*+KEYACCESS*/ " + ls;
            lps = new TestPreparedStatement((TestCase)this, this.mMainConnection, lsql, this.mAlternativeMonitor, 1005, 1007);
            lps.execute();
            lReadsAlternative = this.mAlternativeMonitor.getNumberOfVirtualReads();
            if (lReadsOptimizer > lReadsAlternative) {
                this.addAlternativeStrategieMessage(this.mMainPreparedStatement, lReadsOptimizer, lps, lReadsAlternative);
            }
            lsql = "Select /*+KEYSCAN*/ " + ls;
            lps = new TestPreparedStatement((TestCase)this, this.mMainConnection, lsql, this.mAlternativeMonitor, 1005, 1007);
            lps.execute();
            lReadsAlternative = this.mAlternativeMonitor.getNumberOfVirtualReads();
            if (lReadsOptimizer > lReadsAlternative) {
                this.addAlternativeStrategieMessage(this.mMainPreparedStatement, lReadsOptimizer, lps, lReadsAlternative);
            }
            this.mAlternativeMonitor.deactivate();
        }
        return result;
    }

    public static String getTestClassId() {
        return "SingleTableV73";
    }

    public static long getTimeout() {
        return 0L;
    }

    public static boolean isReferenceEnabled() {
        return false;
    }

    public static boolean isSAPOnly() {
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void prepare() throws TestCaseException {
        lDefConnection = null;
        lDefTstmt = null;
        lp = null;
        try {
            try {
                block29: {
                    SingleTableV73.sTableName = TestCase.getParameterString((String)"Table_Name", (String)"ST").toUpperCase();
                    lDiffInteger = TestCase.getParameterInt((String)"Different_Integer_Values", (int)50);
                    lDiffString = TestCase.getParameterInt((String)"Different_String_Values", (int)50);
                    lDummyKeyLength = TestCase.getParameterInt((String)"Length_of_Static_Key_Field", (int)3);
                    SingleTableV73.sUser = TestCase.getParameterString((String)"User_Name", (String)"ST");
                    SingleTableV73.sPassword = TestCase.getParameterString((String)"User_Password", (String)"ST");
                    if (lDiffInteger * lDiffString < 1000) {
                        throw new TestCaseException("Too few different integer or string values defined. Please choose a higher value for Different_Integer_Values and/or Different_String_Values");
                    }
                    if (lDiffInteger < 10) {
                        throw new TestCaseException("Too few different integer values (minimum 10) defined. Please choose a higher value for Different_Integer_Values");
                    }
                    if (lDiffString < 10) {
                        throw new TestCaseException("Too few different string values (minimum 10) defined. Please choose a higher value for Different_String_Values");
                    }
                    if (lDummyKeyLength < 1) {
                        throw new TestCaseException("Cannot create table with a key field of length " + lDummyKeyLength + " (minimum 1)");
                    }
                    lDefConnection = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
                    lDefTstmt = new TestStatement(null, lDefConnection);
                    lDefTstmt.enableExceptions(false);
                    lDefTstmt.executeUpdate("Create user " + SingleTableV73.sUser + " password " + SingleTableV73.sPassword + " dba not exclusive");
                    lDefTstmt.close();
                    lDefConnection.close();
                    lDefConnection = TestCase.getDatabase().connect(SingleTableV73.sUser, SingleTableV73.sPassword);
                    lDefTstmt = new TestStatement(null, lDefConnection, 1005, 1007);
                    lDefTstmt.enableExceptions(false);
                    SingleTableV73.sTable = new Table(SingleTableV73.sTableName);
                    SingleTableV73.sTable.setConnection(lDefConnection);
                    u = "u";
                    su = new StringBuffer(lDummyKeyLength);
                    i = 0;
                    while (true) {
                        if (i >= lDummyKeyLength) break;
                        su.append(u);
                        ++i;
                    }
                    SingleTableV73.sValueK0 = su.toString();
                    sv = new StringBuffer(300);
                    i = 0;
                    while (true) {
                        if (i >= 300) {
                            SingleTableV73.sValueFx = "'" + sv.toString() + "'";
                            SingleTableV73.sValueFxformat = "'" + sv.toString().substring(1, 5) + "'";
                            SingleTableV73.sTable.addVarchar("k0", lDummyKeyLength, true, false, false, SingleTableV73.buildK0());
                            SingleTableV73.sTable.addInteger("k1", true, false, false, 0, 0, 0);
                            SingleTableV73.sTable.addVarchar("k2", 14, true, false, false, null);
                            SingleTableV73.sTable.addVarchar("f0", lDummyKeyLength, false, false, false, SingleTableV73.buildK0());
                            SingleTableV73.sTable.addInteger("f1", false, false, false, 0, 0, 0);
                            SingleTableV73.sTable.addVarchar("f2", 14, false, false, false, null);
                            SingleTableV73.sTable.addInteger("f3", false, false, false, 0, 0, 0);
                            SingleTableV73.sTable.addCharacter("f4", 300, false, false, false, SingleTableV73.sValueFx);
                            SingleTableV73.sTable.addCharacter("f5", 300, false, false, false, SingleTableV73.sValueFx);
                            SingleTableV73.sTable.addCharacter("f6", 300, false, false, false, SingleTableV73.sValueFx);
                            lMode = TestCase.getParameterString((String)"Test_Data", (String)"CHECK");
                            lCreateNewTable = false;
                            if (!lMode.equals("KEEP")) break;
                            lCreateNewTable = false;
                            break block29;
                        }
                        sv.append("d");
                        ++i;
                    }
                    if (lMode.equals("REBUILD")) {
                        lCreateNewTable = true;
                    } else {
                        lDefTstmt.executeQuery("select count(distinct k1) from  " + SingleTableV73.sTableName);
                        if (lDefTstmt.getResultCounter() != lDiffInteger) {
                            lCreateNewTable = true;
                        } else {
                            lDefTstmt.executeQuery("select count(distinct k2) from  " + SingleTableV73.sTableName);
                            if (lDefTstmt.getResultCounter() != lDiffString) {
                                lCreateNewTable = true;
                            } else {
                                lss = "select len from columns where owner = '" + SingleTableV73.sUser + "' and  tablename = '" + SingleTableV73.sTable.getName() + "' and columnname = 'K0'";
                                rs = lDefTstmt.executeQuery(lss);
                                if (rs != null && rs.next() && (llen = rs.getInt(1)) != lDummyKeyLength) {
                                    lCreateNewTable = true;
                                }
                            }
                        }
                    }
                }
                if (!lCreateNewTable) ** GOTO lbl-1000
                System.out.println("Creating new table...");
                TestCase.addGlobalMessage((String)"prepare", (char)'I', (String)("Creating new table with " + lDiffInteger + " integers and " + lDiffString + " character values"));
                lDefTstmt.enableExceptions(true);
                SingleTableV73.sTable.create(true);
                s = "insert into  " + SingleTableV73.sTableName + " (k1,k2,f1,f2,f3) values (?,?,?,?,?)";
                lp = new TestPreparedStatement(null, lDefConnection, s);
                k = 0;
                j = 0;
                block10: while (true) {
                    block30: {
                        if (j < lDiffInteger) break block30;
                        lp.executeBatch();
                        lDefConnection.commit();
                        SingleTableV73.sTable.updateStatistics(lDefTstmt);
                        break;
                    }
                    lp.setInt(1, j);
                    lp.setInt(3, j);
                    i = 0;
                    while (true) {
                        if (i >= lDiffString) {
                            lp.executeBatch();
                            lp.clearBatch();
                            lDefConnection.commit();
                            ++j;
                            continue block10;
                        }
                        lp.setString(2, String.valueOf(SingleTableV73.sValueK2) + SingleTableV73.K2_FORMAT.format(i));
                        lp.setString(4, String.valueOf(SingleTableV73.sValueK2) + SingleTableV73.K2_FORMAT.format(i));
                        lp.setInt(5, k++);
                        lp.addBatch();
                        ++i;
                    }
                    break;
                }
            }
            catch (Exception e) {
                TestCase.handleGlobalExceptions((Exception)e);
                throw new TestCaseException(e.getMessage());
            }
        }
        catch (Throwable var16_19) {
            var15_20 = null;
            try {
                if (lp != null) {
                    lp.close();
                }
                if (lDefTstmt != null) {
                    lDefTstmt.close();
                }
                if (lDefConnection == null) throw var16_19;
                lDefConnection.close();
                throw var16_19;
            }
            catch (Exception var17_22) {
                // empty catch block
            }
            throw var16_19;
        }
lbl-1000:
        // 2 sources

        {
            var15_21 = null;
        }
        try {}
        catch (Exception var17_23) {
            return;
        }
        if (lp != null) {
            lp.close();
        }
        if (lDefTstmt != null) {
            lDefTstmt.close();
        }
        if (lDefConnection == null) return;
        lDefConnection.close();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        lConnection = null;
        try {
            try {
                this.mDiffInteger = TestCase.getParameterInt((String)"Different_Integer_Values", (int)50);
                this.mDiffString = TestCase.getParameterInt((String)"Different_String_Values", (int)50);
                this.mDropIndexesAfterBlockFinished = TestCase.getParameterBoolean((String)"Drop_Indexes_After_Block_Finished", (boolean)true);
                SingleTableV73.mTraceOn = TestCase.getParameterBoolean((String)"TraceOn", (boolean)true);
                if (!this.mDropIndexesAfterBlockFinished) {
                    this.addMessage("Index drop", 'E', "Warning: Indexes were not dropped after a test block finished.\nIf more than one block will be executed, unexpected errors might occur!!!!");
                }
                this.mTableRows = this.mDiffInteger * this.mDiffString;
                this.setAutoStep(false);
                TestCase.setInfoMessageFilter((boolean)false);
                this.mMainConnection = TestCase.getDatabase().connect(SingleTableV73.sUser, SingleTableV73.sPassword);
                this.mMainConnection.setTransactionIsolation(1);
                lConnection = TestCase.getDatabase().connect(SingleTableV73.sUser, SingleTableV73.sPassword);
                this.mHelpStatement = new TestStatement((TestCase)this, lConnection, 1005, 1007);
                this.mMainMonitor = new TestStatementMonitor(this.mMainConnection);
                this.mMainMonitor.clear();
                this.mMainMonitor.activate();
                this.mMainExplainObject.addTable(SingleTableV73.sTableName);
                this.mMainExplainObject.addStrategy("Table Scan");
                SingleTableV73.mTraceOn = false;
                this.mMainExplainObject.add();
                this.mMainExplainObject.setResultIsCopied(true);
                this.executePreparedStep("select * from  " + SingleTableV73.sTableName + " for reuse", this.mMainExplainObject, this.mTableRows, "Max");
                SingleTableV73.mTraceOn = TestCase.getParameterBoolean((String)"TraceOn", (boolean)false);
                this.mMaxNoOfVirtualReads = this.mMainMonitor.getNumberOfVirtualReads() * 2;
                this.mMaxRuntime = this.mMainPreparedStatement.getRuntime();
                this.addMessage("Initial select", 'I', "Strategie: TABLE SCAN # virtual reads: " + this.mMainMonitor.getNumberOfVirtualReads() + " #records read: " + this.mMainPreparedStatement.getResultCounter(), this.mMainPreparedStatement.getSqlString());
                if (TestCase.getParameterBoolean((String)"Print_All_Virtual_Reads_To_Protocol", (boolean)false)) {
                    this.mMaxNoOfVirtualReads = 0;
                    this.addMessage("Virtual Reads", 'I', "All virtual reads will be reported to protocol as a WARNING, because the max. of virtual reads is set to 0");
                }
                lSteps = TestCase.getParameterString((String)"Block_Sequence", (String)"1;2;3;4");
                lSt = new StringTokenizer(lSteps, ";");
                lThisClass = this.getClass();
                lTheMethod = null;
                this.mMethodName = null;
                while (lSt.hasMoreTokens()) {
                    this.mMethodName = "block_" + lSt.nextToken().trim();
                    System.out.println("Running method " + this.mMethodName + " ... ");
                    try {
                        lTheMethod = lThisClass.getMethod(this.mMethodName, new Class[0]);
                    }
                    catch (NoSuchMethodException nme) {
                        this.addMessage("running step sequence", 'E', "Unknown method " + this.mMethodName + ". Maybe method is not public?", nme);
                    }
                    try {
                        lTheMethod.invoke((Object)this, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        this.addMessage("running step sequence", 'E', "Invalid Step_Sequence " + lSteps + " Method " + lTheMethod.getName() + " is unknown!!!", e);
                    }
                    catch (IllegalArgumentException e) {
                        this.addMessage("running step sequence", 'E', "Invalid Step_Sequence " + lSteps + " Method " + lTheMethod.getName() + " is unknown!!!", e);
                    }
                    catch (InvocationTargetException e) {
                        throw (Exception)e.getTargetException();
                    }
                }
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
            var7_14 = null;
            ** GOTO lbl77
        }
        catch (Throwable var8_12) {
            var7_13 = null;
            try {
                TestCase.printParametersToProtocol();
                this.mMainMonitor.deactivate();
                this.mHelpStatement.close();
                lConnection.close();
                this.mMainPreparedStatement.close();
                this.mMainConnection.close();
                throw var8_12;
lbl77:
                // 1 sources

                ** try [egrp 4[TRYBLOCK] [7 : 683->725)] { 
lbl78:
                // 1 sources

                TestCase.printParametersToProtocol();
                this.mMainMonitor.deactivate();
                this.mHelpStatement.close();
                lConnection.close();
                this.mMainPreparedStatement.close();
                this.mMainConnection.close();
                return;
            }
            catch (Exception var9_15) {
                // empty catch block
            }
            throw var8_12;
        }
lbl88:
        // 1 sources

        catch (Exception var9_16) {
            return;
        }
    }

    public void printTrace(String textMessage) {
        if (mTraceOn) {
            this.addMessage(this.getStep(), 'I', textMessage);
        }
    }
}

