/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.multiversion;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Random;

public class MVMut
extends TestCase {
    private static final String mExUser = "MVMut";
    private static final String mExPassword = "MVMut";
    private static final int TEST1 = 1;
    private static final int CONSISTENTVIEWHOLDER = 2;
    private static boolean m_runTimeLimit = false;
    private static volatile boolean m_stop = false;
    private static int m_tasks = 0;
    private static int m_maxTasks = 20;
    private static int m_checkSumRowCount = 1000;
    private static int m_checksum = 0;
    private static int m_sqlError = 0;
    private static String m_sqlErrorMsg;
    private static int m_maxRunTime;
    private static int m_consistentViewLifeTime;
    private static int m_traceLevel;
    private static int m_keyLen;
    private static int m_secKeyLen;

    static {
        m_maxRunTime = 30;
        m_consistentViewLifeTime = 60;
        m_traceLevel = 0;
        m_keyLen = 1000;
        m_secKeyLen = 1000;
    }

    synchronized int getRunningTasks() {
        return m_tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void incRunningTask() {
        MVMut mVMut = this;
        synchronized (mVMut) {
            ++m_tasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void decRunningTasks() {
        MVMut mVMut = this;
        synchronized (mVMut) {
            --m_tasks;
        }
    }

    synchronized void setGlobalSqlError(SQLException e) {
        if (m_sqlError == 0) {
            m_sqlError = e.getErrorCode();
            m_sqlErrorMsg = e.getMessage();
        }
    }

    synchronized int sqlError() {
        return m_sqlError;
    }

    private static void Trace(String msg) {
        System.out.println(msg);
        TestCase.addGlobalMessage((String)"", (char)'I', (String)msg);
    }

    private void Trace(int level, String msg) {
        if (m_traceLevel > level) {
            System.out.println(msg);
            TestCase.addGlobalMessage((String)"", (char)'I', (String)msg);
        }
    }

    private void TraceError(String msg) {
        System.out.println(msg);
        this.addMessage("Error", 'E', msg);
        m_stop = true;
    }

    private void startTask(int processId, int test, int sleepDuration) throws SQLException, TestDatabaseException {
        this.incRunningTask();
        Task task = new Task(processId, test, sleepDuration);
    }

    public static void cleanUp() throws TestCaseException {
        System.out.println("End of " + MVMut.getTestClassId());
    }

    public static String getTestClassId() {
        return "MVMulti1";
    }

    void FillCheckSumTable(Connection conn) throws SQLException {
        MVMut.Trace("Filling CheckSumTable ...");
        TestPreparedStatement insertStmt = new TestPreparedStatement(null, conn, "Insert CHECKSUMTAB values (?, ?, ?, ?, ?, ?)");
        Random r = new Random(13L);
        conn.setAutoCommit(false);
        long rowIndex = 0L;
        int row = 0;
        while (row < m_checkSumRowCount) {
            String key1 = "X" + row;
            int key2 = row;
            int indexVal = row % 1000;
            int checkSumValue = r.nextInt() % 1000;
            int taskId = 0;
            while (taskId < m_maxTasks) {
                int idx = 0;
                insertStmt.setInt(++idx, taskId);
                insertStmt.setString(++idx, key1);
                insertStmt.setInt(++idx, key2);
                insertStmt.setInt(++idx, indexVal);
                insertStmt.setInt(++idx, checkSumValue);
                insertStmt.setLong(++idx, rowIndex);
                insertStmt.executeUpdate();
                if (indexVal == 0) {
                    conn.commit();
                }
                ++rowIndex;
                ++taskId;
            }
            m_checksum += checkSumValue;
            ++row;
        }
        conn.commit();
        MVMut.Trace("CheckSumTable filled, check sum is " + m_checksum);
    }

    public static void writeProt(Connection con, String msg) {
        try {
            TestStatement stmt = new TestStatement(null, con);
            stmt.executeUpdate("### Error : " + msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void prepare() throws TestCaseException {
        block18: {
            block17: {
                conn = null;
                stmt = null;
                prepstmt = null;
                System.out.println("Start of " + MVMut.getTestClassId());
                lNoOfTableRows = TestCase.getParameterInt((String)"NoOfTableRows", (int)2000);
                try {
                    try {
                        conn = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
                        stmt = new TestStatement(null, conn);
                        stmt.enableExceptions(false);
                        stmt.executeUpdate("Drop user MVMut");
                        stmt.enableExceptions(true);
                        stmt.executeUpdate("Create user MVMut password MVMut resource not exclusive");
                        stmt.close();
                        conn.commit();
                        conn.close();
                        conn = TestCase.getDatabase().connect("MVMut", "MVMut");
                        stmt = new TestStatement(null, conn);
                        createTable = "CREATE TABLE CHECKSUMTAB (TASKID INT, KEY1 CHAR(" + MVMut.m_keyLen + "), KEY2 FIXED(10), INDEXFIELD FIXED(10), CHECKSUMVAL FIXED(10), ROWINDEX FIXED(20), PRIMARY KEY(TASKID,KEY1,KEY2))";
                        stmt.executeUpdate(createTable);
                        stmt.execute("CREATE INDEX IDX1 on CHECKSUMTAB (INDEXFIELD)");
                        stmt.execute("CREATE INDEX IDX2 on CHECKSUMTAB (ROWINDEX)");
                        stmt.execute("CREATE TABLE PROT (MSG CHAR(2000))");
                        conn.commit();
                        TestCase.addGlobalMessage((String)"Method prepare", (char)'I', (String)"just created MVMulti1");
                        conn.close();
                    }
                    catch (SQLException e) {
                        MVMut.Trace("*** stop because of error during prepare():" + e.getErrorCode() + " " + e.getMessage());
                        throw new TestCaseException("Error during preparation: " + e.getClass() + e.getErrorCode() + " " + e.getMessage());
                    }
                    catch (Exception e) {
                        TestCase.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
                        throw new TestCaseException("Error during preparation: " + e.getClass() + " " + e.getMessage());
                    }
                }
                catch (Throwable var6_7) {
                    var5_8 = null;
                    try {
                        stmt.close();
                    }
                    catch (Exception var7_10) {
                        // empty catch block
                    }
                    try {
                        prepstmt.close();
                    }
                    catch (Exception var7_10) {
                        // empty catch block
                    }
                    try {
                        conn.commit();
                        conn.close();
                        throw var6_7;
                    }
                    catch (Exception var7_10) {
                        // empty catch block
                    }
                    throw var6_7;
                }
                {
                    var5_9 = null;
                }
                ** try [egrp 2[TRYBLOCK] [4 : 366->373)] { 
lbl64:
                // 1 sources

                stmt.close();
                break block17;
lbl66:
                // 1 sources

                catch (Exception var7_11) {
                    // empty catch block
                }
            }
            ** try [egrp 3[TRYBLOCK] [5 : 375->382)] { 
lbl70:
            // 1 sources

            prepstmt.close();
            break block18;
lbl72:
            // 1 sources

            catch (Exception var7_11) {
                // empty catch block
            }
        }
        try {}
        catch (Exception var7_11) {
            return;
        }
        conn.commit();
        conn.close();
    }

    public void TraceTestStatistics(Connection connection) {
        try {
            CallableStatement selectInto = connection.prepareCall("select HISTORYANCHORFROMFILECOUNT, HISTORYANCHORFROMPAGECOUNT into ?,?  from MULTIVERSIONREADSTATISTICS");
            selectInto.registerOutParameter(1, 4);
            selectInto.registerOutParameter(2, 4);
            selectInto.execute();
            MVMut.Trace("HistoryFrom File : " + selectInto.getLong(1) + ", HistoryFromPage : " + selectInto.getLong(2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Connection connection = null;
        try {
            try {
                connection = TestCase.getDatabase().connect("MVMut", "MVMut");
                connection.setAutoCommit(false);
                this.FillCheckSumTable(connection);
                MaxRunTimeTimer timer = new MaxRunTimeTimer(m_maxRunTime);
                int task = 0;
                while (true) {
                    if (task >= m_maxTasks) {
                        this.startTask(m_maxTasks, 2, m_consistentViewLifeTime);
                        Thread t = Thread.currentThread();
                        break;
                    }
                    this.startTask(task, 1, 0);
                    ++task;
                }
                while (this.getRunningTasks() > 0) {
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                this.TraceError(e.getMessage());
                e.printStackTrace();
                this.handleExceptions(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            try {
                this.TraceTestStatistics(connection);
                connection.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var4_8 = null;
        }
        try {}
        catch (SQLException sQLException) {
            return;
        }
        this.TraceTestStatistics(connection);
        connection.close();
    }

    class MaxRunTimeTimer
    implements Runnable {
        private int m_intervall = 0;
        private Thread m_thread = null;

        MaxRunTimeTimer(int minutes) {
            this.m_intervall = minutes * 60000;
            this.start();
        }

        public void run() {
            try {
                Thread.sleep(this.m_intervall);
            }
            catch (Exception exception) {
                // empty catch block
            }
            m_stop = true;
            m_runTimeLimit = true;
        }

        public void start() {
            this.m_thread = new Thread(this);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }
    }

    abstract class MVMulti1Test {
        Connection m_connection = null;
        int m_processId = -1;
        int m_sleep = 0;
        int m_test = 0;
        Random m_random = null;
        int m_key2Counter;
        int m_rowTaskId;
        String m_rowKey1;
        int m_rowKey2;
        int m_rowIndexVal;
        int m_rowCheckSumVal;
        int m_rowIndex;
        PreparedStatement m_verifyCheckSumStmt = null;
        PreparedStatement m_deleteStatement = null;
        PreparedStatement m_massUpdateStatement = null;
        PreparedStatement m_updateStatement = null;
        PreparedStatement m_insertStatement = null;
        CallableStatement m_verifyCheckSumViaSumStmt = null;

        MVMulti1Test(int processId) {
            this.m_processId = processId;
            this.m_random = new Random(17 * processId);
            this.m_key2Counter = m_checkSumRowCount;
        }

        void TaskTrace(int level, String msg) {
            MVMut.this.Trace(level, "TASK" + this.m_processId + " : " + msg);
        }

        int nextRand(int max) {
            int r = Math.abs(this.m_random.nextInt()) % max;
            this.TaskTrace(9, "nextRand(" + max + ") : " + r);
            return r;
        }

        protected void exceptionHandler(Exception e) {
            MVMut.this.TraceError("Unknown exception in task " + this.m_processId + " " + e.getClass() + " " + e.getMessage());
            e.printStackTrace();
        }

        protected void setSqlError(SQLException e) {
            MVMut.this.TraceError("SQL Error in Task " + this.m_processId + " : " + e.getErrorCode() + " " + e.getMessage() + " " + e.getSQLState());
            MVMut.this.setGlobalSqlError(e);
        }
    }

    class Task
    extends MVMulti1Test
    implements Runnable {
        Task(int processId, int test, int sleepDurationSeconds) throws SQLException, TestDatabaseException {
            super(processId);
            Thread t = new Thread(this);
            this.m_test = test;
            if (sleepDurationSeconds <= 0) {
                sleepDurationSeconds = 1;
            }
            this.m_sleep = sleepDurationSeconds * 1000;
            t.setDaemon(true);
            t.start();
        }

        int chooseRow() {
            int rowIndex = this.m_processId + m_maxTasks * this.nextRand(m_checkSumRowCount);
            this.TaskTrace(10, "chooseRow : " + rowIndex + "(" + this.m_processId + ")");
            return rowIndex;
        }

        void TransEnd() throws SQLException, TestCaseException {
            if (this.nextRand(100) > 40) {
                this.TaskTrace(9, "commit");
                this.m_connection.commit();
            } else {
                this.TaskTrace(9, "rollback");
                this.m_connection.rollback();
            }
        }

        private void randomSelectRow() throws SQLException, TestCaseException {
            int rowIndex = this.chooseRow();
            this.TaskTrace(8, "select rowIndex " + rowIndex);
            CallableStatement selectInto = this.m_connection.prepareCall("select * into ?,?,?,?,?,?  from CHECKSUMTAB where ROWINDEX = ?");
            selectInto.registerOutParameter(1, 4);
            selectInto.registerOutParameter(2, 1);
            selectInto.registerOutParameter(3, 4);
            selectInto.registerOutParameter(4, 4);
            selectInto.registerOutParameter(5, 4);
            selectInto.registerOutParameter(6, 4);
            selectInto.setInt(7, rowIndex);
            selectInto.execute();
            this.m_rowTaskId = selectInto.getInt(1);
            if (this.m_rowTaskId != this.m_processId) {
                MVMut.this.TraceError("unexpeected taskId " + this.m_rowTaskId);
            }
            this.m_rowKey1 = selectInto.getString(2);
            this.m_rowKey2 = selectInto.getInt(3);
            this.m_rowIndexVal = selectInto.getInt(4);
            this.m_rowCheckSumVal = selectInto.getInt(5);
            this.m_rowIndex = selectInto.getInt(6);
            this.TaskTrace(9, "read row (" + this.m_rowTaskId + "," + this.m_rowKey1 + "," + this.m_rowKey2 + "," + this.m_rowIndexVal + "," + this.m_rowCheckSumVal + "," + this.m_rowIndex);
        }

        private void insertRow() throws SQLException, TestCaseException {
            ++this.m_key2Counter;
            this.TaskTrace(9, "InsertRow (" + this.m_rowTaskId + "," + this.m_rowKey1 + "," + this.m_key2Counter + "," + this.m_rowIndexVal + "," + this.m_rowCheckSumVal + "," + this.m_rowIndex + ")");
            int idx = 0;
            this.m_insertStatement.setInt(++idx, this.m_rowTaskId);
            this.m_insertStatement.setString(++idx, this.m_rowKey1);
            this.m_insertStatement.setInt(++idx, this.m_key2Counter);
            this.m_insertStatement.setInt(++idx, this.m_rowIndexVal);
            this.m_insertStatement.setInt(++idx, this.m_rowCheckSumVal);
            this.m_insertStatement.setLong(++idx, this.m_rowIndex);
            this.m_insertStatement.execute();
        }

        private void deleteRow(long rowIndex) throws SQLException, TestCaseException {
            this.TaskTrace(9, "DeleteRow : " + rowIndex);
            this.m_deleteStatement.setLong(1, rowIndex);
            this.m_deleteStatement.execute();
            if (this.m_deleteStatement.getUpdateCount() != 1) {
                MVMut.this.TraceError("unexpected delete count");
            }
        }

        private void massUpdate() throws SQLException, TestCaseException {
            this.TaskTrace(5, "Mass Update");
            this.m_massUpdateStatement.setInt(1, this.m_processId);
            this.m_massUpdateStatement.execute();
            if (this.m_massUpdateStatement.getUpdateCount() != m_checkSumRowCount - 1) {
                MVMut.this.TraceError("unexpected mass update count : " + this.m_massUpdateStatement.getUpdateCount());
            }
        }

        private void updateRow(long rowIndex, int delta) throws SQLException, TestCaseException {
            this.TaskTrace(9, "UpdateRow : " + rowIndex + ", delta : " + delta);
            this.m_updateStatement.setLong(1, delta);
            this.m_updateStatement.setLong(2, rowIndex);
            this.m_updateStatement.execute();
            if (this.m_deleteStatement.getUpdateCount() != 1) {
                MVMut.this.TraceError("unexpected update count");
            }
        }

        private void executeUpdateTrans() throws SQLException, TestCaseException {
            boolean massUpd = false;
            int ix = 0;
            while (ix < 10 && !massUpd) {
                this.randomSelectRow();
                this.deleteRow(this.m_rowIndex);
                int delta = 0;
                if (this.nextRand(100) < 0) {
                    this.massUpdate();
                    massUpd = true;
                    delta = m_checkSumRowCount - 1;
                } else {
                    long updateRowIndex;
                    delta = this.m_rowCheckSumVal / 2;
                    while ((updateRowIndex = (long)this.chooseRow()) == (long)this.m_rowIndex) {
                    }
                    this.updateRow(updateRowIndex, delta);
                }
                this.m_rowCheckSumVal -= delta;
                this.insertRow();
                ++ix;
            }
        }

        private void verifyCheckSum() throws SQLException, TestCaseException {
            int taskId = this.nextRand(m_maxTasks);
            this.m_verifyCheckSumStmt.setInt(1, taskId);
            ResultSet rs = this.m_verifyCheckSumStmt.executeQuery();
            int checkSum = 0;
            while (rs.next()) {
                int val = rs.getInt(1);
                long rowIndex = rs.getLong(2);
                MVMut.this.Trace(10, "RowIndex : " + rowIndex + ", Value : " + val);
                checkSum += val;
            }
            MVMut.this.Trace(9, "TASK" + this.m_processId + " : selected checkSum(TaskId = " + taskId + ") : " + checkSum);
            if (checkSum != m_checksum) {
                MVMut.writeProt(this.m_connection, "wrong checksum");
                MVMut.this.TraceError("unexpected checksum : found " + checkSum + ", expected " + m_checksum);
            }
            rs.close();
        }

        private void verifyCheckSumViaSumFunction() throws SQLException, TestCaseException {
            int taskId = this.nextRand(m_maxTasks);
            this.m_verifyCheckSumViaSumStmt.setInt(2, taskId);
            this.m_verifyCheckSumViaSumStmt.registerOutParameter(1, 4);
            this.m_verifyCheckSumViaSumStmt.execute();
            long checkSum = this.m_verifyCheckSumViaSumStmt.getLong(1);
            MVMut.this.Trace(9, "TASK" + this.m_processId + " : selected checkSum via SUM (TaskId = " + taskId + ") : " + checkSum);
            if (checkSum != (long)m_checksum) {
                MVMut.writeProt(this.m_connection, "wrong checksum");
                MVMut.this.TraceError("unexpected checksum : found " + checkSum + ", expected " + m_checksum);
            }
        }

        private void verifySum() throws SQLException, TestCaseException {
            int rand = this.nextRand(200);
            if (rand > 100) {
                return;
            }
            if (this.nextRand(100) > 40) {
                this.verifyCheckSumViaSumFunction();
            } else {
                this.verifyCheckSum();
            }
        }

        private void runtest1() throws SQLException, TestCaseException {
            MVMut.Trace("Task " + this.m_processId + " : runtest1 started");
            this.m_verifyCheckSumStmt = this.m_connection.prepareStatement("SELECT CHECKSUMVAL,ROWINDEX FROM CHECKSUMTAB WHERE TASKID = ?", 1005, 1007);
            this.m_verifyCheckSumViaSumStmt = this.m_connection.prepareCall("SELECT SUM(CHECKSUMVAL) INTO ? FROM CHECKSUMTAB WHERE TASKID = ?");
            this.m_deleteStatement = this.m_connection.prepareStatement("DELETE FROM CHECKSUMTAB WHERE ROWINDEX = ?");
            this.m_massUpdateStatement = this.m_connection.prepareStatement("UPDATE CHECKSUMTAB SET CHECKSUMVAL = CHECKSUMVAL + 1 WHERE TASKID = ?");
            this.m_updateStatement = this.m_connection.prepareStatement("UPDATE CHECKSUMTAB SET CHECKSUMVAL = CHECKSUMVAL + ? WHERE ROWINDEX = ?");
            this.m_insertStatement = this.m_connection.prepareStatement("INSERT INTO CHECKSUMTAB VALUES (?,?,?,?,?,?)");
            while (!m_stop) {
                this.executeUpdateTrans();
                this.verifySum();
                this.TransEnd();
            }
        }

        private void runConsistentViewHolder() throws SQLException, TestCaseException {
            this.TaskTrace(5, "runConsistentViewHolder started");
            TestStatement stmt = new TestStatement(null, this.m_connection);
            stmt.executeUpdate("SET ISOLATION LEVEL 60");
            Thread t = Thread.currentThread();
            while (!m_stop) {
                try {
                    Thread.sleep(this.m_sleep);
                    this.verifySum();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.TaskTrace(9, "runConsistentViewHolder commit");
                this.m_connection.commit();
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block16: {
                try {
                    try {
                        t = Thread.currentThread();
                        this.m_connection = TestCase.getDatabase().connect("MVMut", "MVMut");
                        this.m_connection.setAutoCommit(false);
                        call = null;
                        switch (this.m_test) {
                            case 1: {
                                this.runtest1();
                                break;
                            }
                            case 2: {
                                this.runConsistentViewHolder();
                                break;
                            }
                        }
                    }
                    catch (SQLException sql_e) {
                        this.setSqlError(sql_e);
                        MVMut.access$4(MVMut.this, sql_e.getMessage());
                        sql_e.printStackTrace();
                    }
                    catch (Exception e) {
                        MVMut.access$4(MVMut.this, e.getMessage());
                        e.printStackTrace();
                        this.exceptionHandler(e);
                    }
                }
                catch (Throwable var5_6) {
                    var4_7 = null;
                    try {
                        this.m_connection.close();
                    }
                    catch (SQLException var6_9) {
                        // empty catch block
                    }
                    MVMut.this.decRunningTasks();
                    throw var5_6;
                }
                {
                    var4_8 = null;
                }
                ** try [egrp 3[TRYBLOCK] [5 : 138->150)] { 
lbl41:
                // 1 sources

                this.m_connection.close();
                break block16;
lbl43:
                // 1 sources

                catch (SQLException var6_10) {
                    // empty catch block
                }
            }
            MVMut.this.decRunningTasks();
        }
    }
}

