/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.loader;

import com.sap.sapdb.oltptest.loader.FastloaderTestProgramRunner;
import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;

public class FastloaderTest
extends TestCase {
    private static ArrayList testList;
    private int testInterruptionStatus = 0;
    private static long timeOut;
    private static String jtestRoot;
    private static boolean good;
    private static PrintStream protocolStream;
    private static File FastloaderTestRoot;
    private static Object semaphore;
    private static File protocolDir;
    private static String protocolStreamName;
    private static String testHostname;
    private static boolean testVariableInput;

    private static String getHostName() throws Exception {
        try {
            String result = InetAddress.getLocalHost().getHostName();
            if (result.equals("localhost")) {
                throw new Exception("Local host name not found, only localhost.");
            }
            return result;
        }
        catch (UnknownHostException unknownHost) {
            throw new Exception("Could not determine the local host name, stopping test.");
        }
    }

    public static String getTestUser() {
        String result = null;
        result = testHostname.length() > 30 ? ("FL" + testHostname.substring(0, 30)).toUpperCase().trim() : ("FL" + testHostname).toUpperCase().trim();
        if (result.indexOf(".") != -1) {
            result = result.substring(0, result.indexOf("."));
        }
        return result;
    }

    public static boolean isTestVariableInput() {
        return testVariableInput;
    }

    public static void prepare() {
        good = true;
        try {
            testHostname = FastloaderTest.getHostName();
            testList = FastloaderTest.getUnnamedParameterList();
            if (testList.isEmpty()) {
                FastloaderTest.addGlobalMessage((String)"", (char)'E', (String)"There are no tests for execution available.");
                good = false;
                return;
            }
            timeOut = FastloaderTest.getParameterLong((String)"TIMEOUT", (long)-1L);
            if (timeOut == -1L) {
                timeOut = 60000 * testList.size();
            }
            FastloaderTest.addGlobalMessage((String)"", (char)'I', (String)("Test timeout is " + timeOut));
            testVariableInput = FastloaderTest.getParameterBoolean((String)"VARIABLEINPUT", (boolean)false);
            FastloaderTest.addGlobalMessage((String)"", (char)'I', (String)("Variable input is  " + testVariableInput));
            jtestRoot = TestDriver.getJTestRoot();
            FastloaderTest.addGlobalMessage((String)"", (char)'I', (String)("Test root is " + jtestRoot));
            String protocolBaseName = FastloaderTest.getParameterString((String)"PROTOCOLNAME", (String)"FastloaderTest");
            FastloaderTest.initProtocol(protocolBaseName);
            FastloaderTestRoot = new File(jtestRoot + File.separator + "tests" + File.separator + "input" + File.separator + "loader" + File.separator + "FastloaderTest");
        }
        catch (Exception ex) {
            good = false;
            FastloaderTest.addGlobalMessage((String)"", (char)'E', (String)("Exception in prepare: " + ex.getMessage()));
        }
    }

    public static File getFastloaderTestRoot() {
        return FastloaderTestRoot;
    }

    public void run() {
        if (!good) {
            FastloaderTest.addGlobalMessage((String)"", (char)'E', (String)"Error in prepare phase, see previous messages.");
        } else {
            String testuser = FastloaderTest.getTestUser();
            Connection serviceConnection = null;
            Statement stmt = null;
            try {
                TestDatabase db = FastloaderTest.getDatabase();
                serviceConnection = db.connect();
                stmt = serviceConnection.createStatement();
                try {
                    stmt.execute("DROP USER \"" + testuser + "\"");
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                stmt.execute("CREATE USER \"" + testuser + "\" PASSWORD \"" + "ABC123" + "\" DBA NOT EXCLUSIVE");
            }
            catch (Exception sqlEx) {
                FastloaderTest.addGlobalMessage((String)"", (char)'E', (String)("Exception in user creation:" + sqlEx.getMessage()));
                if (serviceConnection != null) {
                    try {
                        serviceConnection.close();
                    }
                    catch (SQLException ign) {
                        // empty catch block
                    }
                }
                return;
            }
            for (int i = 0; i < testList.size(); ++i) {
                String command = (String)testList.get(i);
                FastloaderTestProgramRunner currentTest = new FastloaderTestProgramRunner(command, this);
                currentTest.start();
                try {
                    currentTest.join();
                    continue;
                }
                catch (InterruptedException interruptedEx) {
                    this.handleInterruption(currentTest);
                    for (int k = i + 1; k < testList.size(); ++k) {
                        FastloaderTestProgramRunner tp = new FastloaderTestProgramRunner((String)testList.get(k), this);
                        FastloaderTest.addGlobalMessage((String)"", (char)'E', (String)("Test " + tp.getCommandLine() + " did not run (previous test was killed)."));
                    }
                    return;
                }
            }
            if (this.getErrorCounter() == 0) {
                FastloaderTest.addGlobalMessage((String)"", (char)'I', (String)("Tests successful, dropping user " + testuser));
                try {
                    stmt.execute("DROP USER \"" + testuser + "\"");
                }
                catch (SQLException sqlEx) {}
            } else {
                FastloaderTest.addGlobalMessage((String)"", (char)'I', (String)("Tests had errors, keeping user " + testuser));
            }
            try {
                serviceConnection.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInterruption(FastloaderTestProgramRunner test) {
        test.interruptExecution();
        try {
            Object object = semaphore;
            synchronized (object) {
                semaphore.wait(15000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.testInterruptionStatus == 0) {
            FastloaderTest.addGlobalMessage((String)"", (char)'E', (String)("Could not interrupt test program, please cleanup by yourself.\nThe called program was:\n" + test.getCommandLine()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySuccessfulInterrupt(int status) {
        this.testInterruptionStatus = status;
        Object object = semaphore;
        synchronized (object) {
            semaphore.notify();
        }
    }

    public static long getTimeout() {
        return timeOut;
    }

    public void message(String messageId, char messageCategory, String message) {
        TestCase.addGlobalMessage((String)messageId, (char)messageCategory, (String)message);
    }

    public static synchronized void println(String string) {
        if (protocolStream != null) {
            protocolStream.println(string);
        }
    }

    public File getProtocolDir() {
        return protocolDir;
    }

    private static void initProtocol(String protocolBaseName) throws Exception {
        protocolDir = new File(jtestRoot + File.separator + "protocols");
        File directory = protocolDir;
        File basefile = new File(directory, protocolBaseName + ".prt");
        if (basefile.exists()) {
            File tempfile = FastloaderTest.makeTempFile(protocolBaseName, ".prt", directory);
            basefile.renameTo(tempfile);
            FastloaderTest.addGlobalMessage((String)"", (char)'I', (String)("Renaming old protocol file FastloaderTest.prt to " + tempfile.getCanonicalPath()));
        }
        protocolStreamName = basefile.getCanonicalPath();
        FileOutputStream fs = new FileOutputStream(basefile);
        protocolStream = new PrintStream(fs);
        protocolStream.println("----------------------------------------------------------------------");
        protocolStream.println("FastloaderTest started on " + new Date());
        protocolStream.println("----------------------------------------------------------------------");
    }

    private static File makeTempFile(String prefix, String suffix, File directory) {
        int idx = 1;
        while (true) {
            String istr = Integer.toString(idx);
            String tname = prefix + "0000".substring(0, 4 - istr.length()) + istr + suffix;
            File f = new File(directory, tname);
            if (!f.exists()) {
                return f;
            }
            ++idx;
        }
    }

    public String getLogFile() {
        return protocolStreamName;
    }

    static {
        semaphore = new Object();
    }

    private static class OutputReader
    extends Thread {
        private BufferedReader input;

        OutputReader(InputStream input) {
            this.input = new BufferedReader(new InputStreamReader(input));
        }

        public void run() {
            try {
                String line = null;
                while ((line = this.input.readLine()) != null) {
                    FastloaderTest.println(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

