/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation.unittests;

import com.sap.sapdb.oltptest.join.simulation.CharacterCell;
import com.sap.sapdb.oltptest.join.simulation.CharacterColumn;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.IntegerColumn;
import com.sap.sapdb.oltptest.join.simulation.NullValueCell;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class TableTest
extends TestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        System.out.println("Start.");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sap.sapdb.oltptest.join.simulation.unittests.TableTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
        System.out.println("End.");
    }

    public void testTableint() {
    }

    public void testAddColumn() {
        System.out.println("Basic test: int column");
        DatabaseTable table = new DatabaseTable();
        Assert.assertEquals((int)table.getColumnCount(), (int)0);
        IntegerColumn c = new IntegerColumn();
        table.addColumn(c);
        Assert.assertEquals((int)table.getColumnCount(), (int)1);
        IntegerColumn c1 = new IntegerColumn();
        table.addColumn(c1);
        Assert.assertEquals((int)table.getColumnCount(), (int)2);
        Iterator it = table.columnIterator();
        IntegerColumn compCol = (IntegerColumn)it.next();
        Assert.assertEquals((Object)compCol, (Object)c);
        compCol = (IntegerColumn)it.next();
        Assert.assertEquals((Object)compCol, (Object)c1);
        Assert.assertEquals((int)table.getRowCount(), (int)0);
    }

    public void testSingleColumnSingleRow() {
        System.out.println("Single column, single row.");
        DatabaseTable table = new DatabaseTable();
        IntegerColumn c = new IntegerColumn();
        table.addColumn(c);
        TableRow row = new TableRow(table);
        row.setValue(1, new IntegerCell(1));
        Assert.assertEquals((String)row.getValue(1).getValue(), (String)"1");
        table.insert(row);
        Assert.assertEquals((int)table.getRowCount(), (int)1);
        TableRow verify = (TableRow)table.rowIterator().next();
        Assert.assertEquals((String)verify.getValue(1).getValue(), (String)"1");
    }

    public void testSingleColumnSingleRowChar() {
        System.out.println("Single column, single row: char");
        DatabaseTable table = new DatabaseTable();
        CharacterColumn c = new CharacterColumn();
        table.addColumn(c);
        TableRow row = new TableRow(table);
        row.setValue(1, new CharacterCell("1"));
        Assert.assertEquals((String)row.getValue(1).getValue(), (String)"1");
        table.insert(row);
        Assert.assertEquals((int)table.getRowCount(), (int)1);
        TableRow verify = (TableRow)table.rowIterator().next();
        Assert.assertEquals((String)verify.getValue(1).getValue(), (String)"1");
    }

    public void testSingleColumnMultipleRows() {
        System.out.println("Single column, multiple rows");
        int c_rowCount = 100;
        DatabaseTable table = new DatabaseTable();
        IntegerColumn c = new IntegerColumn();
        table.addColumn(c);
        int i = 1;
        while (i <= 100) {
            TableRow row = new TableRow(table);
            row.setValue(1, new IntegerCell(i));
            Assert.assertEquals((String)row.getValue(1).getValue(), (String)Integer.toString(i));
            table.insert(row);
            Assert.assertEquals((int)i, (int)table.getRowCount());
            ++i;
        }
        Iterator rowIt = table.rowIterator();
        int rowCount = 0;
        while (rowIt.hasNext()) {
            TableRow checkRow = (TableRow)rowIt.next();
            Assert.assertEquals((String)checkRow.getValue(1).getValue(), (String)Integer.toString(++rowCount));
        }
        Assert.assertEquals((int)100, (int)rowCount);
    }

    public void testMultipleColumnsSingleRow() {
        System.out.println("Multiple columns, single row.");
        int c_maxColumns = 15;
        DatabaseTable table = new DatabaseTable();
        int i = 1;
        while (i <= 15) {
            IntegerColumn c = new IntegerColumn();
            table.addColumn(c);
            Assert.assertEquals((int)i, (int)table.getColumnCount());
            ++i;
        }
        TableRow row = new TableRow(table);
        int i2 = 1;
        while (i2 <= 15) {
            row.setValue(i2, new IntegerCell(i2));
            ++i2;
        }
        table.insert(row);
        Assert.assertEquals((int)table.getRowCount(), (int)1);
        TableRow checkRow = (TableRow)table.rowIterator().next();
        int counter = 0;
        Iterator valueIt = checkRow.getValueIterator();
        while (valueIt.hasNext()) {
            IntegerCell c = (IntegerCell)valueIt.next();
            Assert.assertEquals((String)Integer.toString(++counter), (String)c.getValue());
            Assert.assertEquals((String)Integer.toString(counter), (String)checkRow.getValue(counter).getValue());
        }
    }

    public void testMultipleColumnsMupltipeRows() {
        System.out.println("Multiple columns, multiple rows.");
        int c_maxColumns = 15;
        int c_rowCount = 100;
        DatabaseTable table = new DatabaseTable();
        int i = 1;
        while (i <= 15) {
            IntegerColumn c = new IntegerColumn();
            table.addColumn(c);
            Assert.assertEquals((int)i, (int)table.getColumnCount());
            ++i;
        }
        i = 1;
        while (i <= 100) {
            TableRow row = new TableRow(table);
            int j = 1;
            while (j <= 15) {
                row.setValue(j, new IntegerCell(i + j));
                ++j;
            }
            table.insert(row);
            Assert.assertEquals((int)table.getRowCount(), (int)i);
            ++i;
        }
        Iterator rowIt = table.rowIterator();
        int rowCount = 0;
        while (rowIt.hasNext()) {
            ++rowCount;
            TableRow checkRow = (TableRow)rowIt.next();
            int counter = 0;
            Iterator valueIt = checkRow.getValueIterator();
            while (valueIt.hasNext()) {
                IntegerCell c = (IntegerCell)valueIt.next();
                Assert.assertEquals((String)Integer.toString(++counter + rowCount), (String)c.getValue());
                Assert.assertEquals((String)Integer.toString(counter + rowCount), (String)checkRow.getValue(counter).getValue());
            }
        }
    }

    public void testSort() {
        System.out.println("DatabaseTable: sort.");
        int c_maxColumns = 2;
        int c_rowCount = 100;
        DatabaseTable table = new DatabaseTable();
        int i = 1;
        while (i <= 2) {
            IntegerColumn c = new IntegerColumn();
            table.addColumn(c);
            ++i;
        }
        TableRow row = new TableRow(table);
        row.setValue(1, new IntegerCell(3));
        row.setValue(2, new IntegerCell(5));
        table.insert(row);
        row.setValue(1, new IntegerCell(4));
        row.setValue(2, new IntegerCell(3));
        table.insert(row);
        row.setValue(1, new IntegerCell(3));
        row.setValue(2, new IntegerCell(4));
        table.insert(row);
        row.setValue(1, new IntegerCell(3));
        row.setValue(2, new NullValueCell());
        table.insert(row);
        row.setValue(1, new NullValueCell());
        row.setValue(2, new IntegerCell(4));
        table.insert(row);
        row.setValue(1, new NullValueCell());
        row.setValue(2, new NullValueCell());
        table.insert(row);
        row.setValue(1, new IntegerCell(3));
        row.setValue(2, new IntegerCell(5));
        table.insert(row);
        table.sort();
        table.dump();
        Iterator rowIt = table.rowIterator();
        row = (TableRow)rowIt.next();
        Assert.assertEquals((String)"3", (String)row.getValue(1).getValue());
        Assert.assertEquals((String)"4", (String)row.getValue(2).getValue());
        row = (TableRow)rowIt.next();
        Assert.assertEquals((String)"3", (String)row.getValue(1).getValue());
        Assert.assertEquals((String)"5", (String)row.getValue(2).getValue());
        row = (TableRow)rowIt.next();
        Assert.assertEquals((String)"3", (String)row.getValue(1).getValue());
        Assert.assertEquals((String)"5", (String)row.getValue(2).getValue());
        row = (TableRow)rowIt.next();
        Assert.assertEquals((String)"3", (String)row.getValue(1).getValue());
        Assert.assertEquals((String)"Null", (String)row.getValue(2).getValue());
        row = (TableRow)rowIt.next();
        Assert.assertEquals((String)"4", (String)row.getValue(1).getValue());
        Assert.assertEquals((String)"3", (String)row.getValue(2).getValue());
        row = (TableRow)rowIt.next();
        Assert.assertEquals((String)"Null", (String)row.getValue(1).getValue());
        Assert.assertEquals((String)"4", (String)row.getValue(2).getValue());
        row = (TableRow)rowIt.next();
        Assert.assertEquals((String)"Null", (String)row.getValue(1).getValue());
        Assert.assertEquals((String)"Null", (String)row.getValue(2).getValue());
    }

    public void testSortAndCompare() {
        System.out.println("DatabaseTable: sortAndCompare.");
        int c_maxColumns = 15;
        int c_rowCount = 100;
        DatabaseTable table1 = new DatabaseTable();
        DatabaseTable table2 = new DatabaseTable();
        int i = 1;
        while (i <= 15) {
            table1.addColumn(new IntegerColumn());
            table2.addColumn(new IntegerColumn());
            ++i;
        }
        i = 1;
        while (i <= 100) {
            TableRow row = new TableRow(table1);
            int j = 1;
            while (j <= 15) {
                row.setValue(j, new IntegerCell(i + j));
                ++j;
            }
            table1.insert(row);
            table2.insert(row);
            ++i;
        }
        Assert.assertTrue((boolean)table1.sortAndCompare(table2, true));
        TableRow row = new TableRow(table1);
        int j = 1;
        while (j <= 15) {
            row.setValue(j, new IntegerCell(j));
            ++j;
        }
        table1.insert(row);
        Assert.assertFalse((boolean)table1.sortAndCompare(table2, true));
    }
}

