/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.AbstractCell;
import com.sap.sapdb.oltptest.join.simulation.Assertion;
import com.sap.sapdb.oltptest.join.simulation.Column;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.Table;
import com.sap.sapdb.oltptest.join.simulation.TableDefinition;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DatabaseTable
extends Table {
    private AbstractList rows;
    private boolean isSorted = false;
    private int tableId = DatabaseTable.getNewTableId();
    private TableDefinition tableDef = new TableDefinition();
    private static int idCounter = 0;

    private static int getNewTableId() {
        return idCounter++;
    }

    public void addColumn(Column col) {
        this.tableDef.addColumn(col);
        col.setColumnNo(this.tableDef.getColumnCount());
    }

    public int getColumnCount() {
        return this.tableDef.getColumnCount();
    }

    public Column getColumnInfo(int columnNumber) {
        return this.tableDef.getColumnInfo(columnNumber);
    }

    public Iterator columnIterator() {
        return this.tableDef.columnIterator();
    }

    public void setTableName(String tableName) {
        this.tableDef.setTableName(tableName);
    }

    public String getTableName() {
        return this.tableDef.getTableName();
    }

    public void dumpStructure(PrintStream s, String indentStr) {
        s.println(String.valueOf(indentStr) + "Table " + this.getTableName());
    }

    public TableDefinition getTableDefinition() {
        return this.tableDef;
    }

    protected void setTableDefinition(TableDefinition tableDefinition) {
        this.tableDef = tableDefinition;
    }

    public DatabaseTable() {
        this.tableDef.setTableName("Table" + Integer.toString(this.tableId));
        this.rows = new ArrayList();
    }

    public DatabaseTable(String tableName) {
        this();
        this.tableDef.setTableName(tableName);
    }

    public DatabaseTable(Table table) {
        this();
        this.tableDef = table.getTableDefinition();
    }

    public DatabaseTable(TableDefinition tableDefinition) {
        this();
        this.setTableDefinition((TableDefinition)tableDefinition.clone());
    }

    public Iterator rowIterator() {
        return this.rows.iterator();
    }

    public void insert(TableRow row) {
        Assertion.assertTrue(row.getColumnCount() == this.getColumnCount());
        this.isSorted = false;
        this.rows.add(row.clone());
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream s) {
        s.println("Dumping table: " + this.getTableName());
        s.println();
        Iterator colInfoIt = this.columnIterator();
        while (colInfoIt.hasNext()) {
            Column colInfo = (Column)colInfoIt.next();
            s.print(String.valueOf(colInfo.getColumnName()) + "\t");
        }
        s.println();
        Iterator rowIt = this.rows.iterator();
        while (rowIt.hasNext()) {
            TableRow row = (TableRow)rowIt.next();
            s.println(row.toString());
            s.println();
        }
        s.println("Table '" + this.getTableName() + "' contains " + Integer.toString(this.rows.size()) + " rows.");
        s.println();
    }

    public int getColumnBaseOffset(DatabaseTable table) {
        if (table != this) {
            throw new NoSuchElementException();
        }
        return 1;
    }

    public void dumpSQL() {
        System.out.println("Dumping SQL table: " + this.getTableName());
        System.out.println();
        Iterator rowIt = this.rows.iterator();
        while (rowIt.hasNext()) {
            System.out.print("INSERT INTO " + this.getTableName() + " VALUES (");
            TableRow row = (TableRow)rowIt.next();
            Iterator valIt = row.getValueIterator();
            if (!valIt.hasNext()) continue;
            while (true) {
                AbstractCell val = (AbstractCell)valIt.next();
                System.out.print(val.getValue());
                if (!valIt.hasNext()) break;
                System.out.print(", ");
            }
            System.out.println(")\n//");
        }
        System.out.println();
    }

    public void clear() {
        this.rows.clear();
    }

    public void sort() {
        if (this.isSorted) {
            return;
        }
        ArrayList<Integer> columnList = new ArrayList<Integer>(this.getColumnCount());
        int i = 1;
        while (i <= this.getColumnCount()) {
            ((AbstractList)columnList).add(new Integer(i));
            ++i;
        }
        Comparator c = TableRow.createAscendingComparator(columnList);
        Collections.sort(this.rows, c);
        this.isSorted = true;
    }

    public void sort(Comparator comparator) {
        Collections.sort(this.rows, comparator);
    }

    public boolean sortAndCompare(DatabaseTable table, boolean dump) {
        this.sort();
        table.sort();
        ArrayList<Integer> columnList = new ArrayList<Integer>(this.getColumnCount());
        int i = 1;
        while (i <= this.getColumnCount()) {
            ((AbstractList)columnList).add(new Integer(i));
            ++i;
        }
        Comparator c = TableRow.createAscendingComparator(columnList);
        Iterator it1 = this.rowIterator();
        Iterator it2 = table.rowIterator();
        int rowCount = 1;
        while (true) {
            TableRow row2;
            if (!it1.hasNext() && it2.hasNext() || it1.hasNext() && !it2.hasNext()) {
                if (dump) {
                    if (!it1.hasNext()) {
                        System.out.println("first table ended early");
                    } else {
                        System.out.println("second table ended early");
                    }
                }
                return false;
            }
            if (!it1.hasNext()) break;
            TableRow row1 = (TableRow)it1.next();
            if (c.compare(row1, row2 = (TableRow)it2.next()) != 0) {
                if (dump) {
                    System.out.println("Mismatch in row " + String.valueOf(rowCount) + ":");
                    System.out.println("  " + row1);
                    System.out.println("  " + row2);
                }
                return false;
            }
            ++rowCount;
        }
        return true;
    }

    public ResultTable getTableAccessor() {
        return new DbResultTable(this);
    }
}

