/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.Column;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.SimpleJoinedTable;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CrossProductIterator
implements Iterator {
    private AbstractList tableList;
    private SimpleStack stack;
    private AbstractList tableStack;
    private ResultTable curTable;
    private TableRow currentRow;
    private int curValueIndex;
    private int currentTableIndex;
    private ResultTable resultTable;
    private boolean valueReady;
    private boolean cycleComplete = false;

    public CrossProductIterator(AbstractList tableList) {
        this.tableList = new ArrayList(tableList);
        this.resultTable = new SimpleJoinedTable(this.tableList);
        this.currentRow = new TableRow(this.resultTable);
        this.currentTableIndex = 0;
        this.curValueIndex = 1;
        this.stack = new SimpleStack();
        this.curTable = (ResultTable)this.tableList.get(0);
        this.curTable.resetIterator();
        this.valueReady = false;
    }

    public ResultTable getResultTableDefinition() {
        return this.resultTable;
    }

    public boolean hasNext() {
        if (this.valueReady) {
            return true;
        }
        if (this.cycleComplete) {
            return false;
        }
        return this.nextRow();
    }

    private boolean nextRow() {
        if (!this.stack.empty()) {
            while (!this.curTable.hasNext() && !this.stack.empty()) {
                StackElement s = (StackElement)this.stack.pop();
                --this.currentTableIndex;
                this.curTable = s.getTable();
                this.curValueIndex = s.getBaseIndex();
            }
        }
        if (!this.curTable.hasNext()) {
            this.cycleComplete = true;
            return false;
        }
        return this.recurse();
    }

    private boolean recurse() {
        block1: {
            do {
                TableRow iteratorRow = this.curTable.next();
                this.currentRow.setValues(this.curValueIndex, iteratorRow);
                if (this.currentTableIndex + 1 == this.tableList.size()) break block1;
                this.stack.push(new StackElement(this.curTable, this.curValueIndex));
                this.curValueIndex += iteratorRow.getColumnCount();
                ++this.currentTableIndex;
                this.curTable = (ResultTable)this.tableList.get(this.currentTableIndex);
                this.curTable.resetIterator();
            } while (this.curTable.hasNext());
            return false;
        }
        this.valueReady = true;
        return true;
    }

    public Object next() {
        if (!this.valueReady && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.valueReady = false;
        return this.currentRow;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        this.currentTableIndex = 0;
        this.curValueIndex = 1;
        this.stack.clear();
        this.curTable = (ResultTable)this.tableList.get(0);
        this.curTable.resetIterator();
        this.valueReady = false;
        this.cycleComplete = false;
    }

    private void addInputTable(DatabaseTable resultTable, DatabaseTable inputTable) {
        Iterator it = inputTable.columnIterator();
        while (it.hasNext()) {
            Column originalCol = (Column)it.next();
            Column newCol = (Column)originalCol.clone();
            newCol.setColumnName(String.valueOf(inputTable.getTableName()) + "." + originalCol.getColumnName());
            resultTable.addColumn(newCol);
        }
    }

    class StackElement {
        ResultTable table;
        int baseIndex;

        StackElement(ResultTable table, int baseIndex) {
            this.table = table;
            this.baseIndex = baseIndex;
        }

        public ResultTable getTable() {
            return this.table;
        }

        public int getBaseIndex() {
            return this.baseIndex;
        }
    }

    class SimpleStack {
        private Object[] stack = new Object[65];
        private int pos = -1;

        public void push(Object o) {
            ++this.pos;
            this.stack[this.pos] = o;
        }

        public Object pop() {
            Object o = this.stack[this.pos];
            --this.pos;
            return o;
        }

        public void clear() {
            this.pos = -1;
        }

        public boolean empty() {
            return this.pos == -1;
        }
    }
}

