/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.description;

public class IntPermutation {
    int[] current;
    int size;

    public IntPermutation(int size) {
        this.size = size;
        this.current = new int[size];
        int i = 0;
        while (i < size) {
            this.current[i] = i;
            ++i;
        }
        this.current[size - 1] = this.current[size - 1] - 1;
    }

    public int[] next() {
        boolean nextFound = this.increment(this.size - 1);
        if (!nextFound) {
            return null;
        }
        int[] result = new int[this.size];
        System.arraycopy(this.current, 0, result, 0, this.size);
        return result;
    }

    protected boolean increment(int column) {
        int currentValue = this.current[column];
        int newValue = currentValue + 1;
        while (newValue < this.size) {
            if (!this.alreadyUsed(column, newValue)) {
                this.current[column] = newValue;
                this.initColumns(column + 1);
                return true;
            }
            ++newValue;
        }
        if (column > 0) {
            return this.increment(column - 1);
        }
        return false;
    }

    protected boolean alreadyUsed(int column, int newValue) {
        int i = 0;
        while (i < column) {
            if (this.current[i] == newValue) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void initColumns(int startColumn) {
        if (startColumn >= this.size) {
            return;
        }
        int i = 0;
        while (i < this.size) {
            if (!this.alreadyUsed(startColumn, i)) {
                this.current[startColumn] = i;
                this.initColumns(startColumn + 1);
                return;
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        int[] value;
        int width = 4;
        IntPermutation iter = new IntPermutation(width);
        while ((value = iter.next()) != null) {
            System.out.print("!!! ");
            int i = 0;
            while (i < width) {
                System.out.print(" " + value[i]);
                ++i;
            }
            System.out.println("");
        }
    }
}

