/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.util;

import java.util.NoSuchElementException;

public final class SyncManTokenizer {
    public static final int SQLTT_NOTHING = -4;
    public static final int SQLTT_EOF = -1;
    public static final int SQLTT_WORD = -5;
    public static final int SQLTT_STRLIT = -6;
    public String sval;
    public int ttype;
    public int pos;
    private static final char SQL_CHR_QUOTE = '\"';
    private static final char SQL_CHR_LESSTHAN = '<';
    private static final char SQL_CHR_GREATERTHAN = '>';
    private static final char SQL_CHR_EQUAL = '=';
    private static final char SQL_CHR_OPENPAREN = '(';
    private static final char SQL_CHR_CLOSEPAREN = ')';
    private static final char SQL_CHR_COMMA = ',';
    private static final char SQL_CHR_PLUS = '+';
    private static final char SQL_CHR_MINUS = '-';
    private static final char SQL_CHR_TIMES = '*';
    private static final char SQL_CHR_DIV = '/';
    private int m_len;
    private char[] m_buf;
    private int m_nextpos;

    private SyncManTokenizer() {
    }

    public SyncManTokenizer(char[] buf) {
        this.m_len = buf.length;
        this.m_buf = buf;
        this.m_nextpos = 0;
        this.sval = null;
        this.ttype = -4;
        this.pos = 0;
    }

    public String nextWordToken() throws Exception {
        int next = this.nextToken();
        if (next == -1) {
            throw new NoSuchElementException();
        }
        if (next != -6 && next != -5) {
            throw new Exception("Invalid token " + new String(this.m_buf) + " at:" + this.pos);
        }
        return this.sval;
    }

    public int nextToken() throws Exception {
        int retval = -4;
        int state = -4;
        boolean string_literal_complete = false;
        StringBuffer tok = new StringBuffer("");
        this.sval = null;
        if (this.m_nextpos < this.m_len && Character.isWhitespace(this.m_buf[this.m_nextpos])) {
            ++this.m_nextpos;
            while (this.m_nextpos < this.m_len && Character.isWhitespace(this.m_buf[this.m_nextpos])) {
                ++this.m_nextpos;
            }
        }
        this.pos = this.m_nextpos + 1;
        if (this.m_nextpos >= this.m_len) {
            state = -1;
        } else {
            while (this.m_nextpos < this.m_len) {
                if (this.m_buf[this.m_nextpos] == '\"' && state == -4) {
                    state = -6;
                } else if (this.m_buf[this.m_nextpos] == '\"' && this.m_nextpos + 1 < this.m_len && state == -6 && this.m_buf[this.m_nextpos + 1] == '\"') {
                    ++this.m_nextpos;
                    tok.append('\"');
                } else {
                    if (this.m_buf[this.m_nextpos] == '\"' && state == -6) {
                        string_literal_complete = true;
                        ++this.m_nextpos;
                        break;
                    }
                    if (state == -6) {
                        tok.append(this.m_buf[this.m_nextpos]);
                    } else {
                        if (state == -5 && (Character.isWhitespace(this.m_buf[this.m_nextpos]) || this.m_buf[this.m_nextpos] == '\"' || this.m_buf[this.m_nextpos] == '<' || this.m_buf[this.m_nextpos] == '>' || this.m_buf[this.m_nextpos] == '=' || this.m_buf[this.m_nextpos] == '(' || this.m_buf[this.m_nextpos] == ')' || this.m_buf[this.m_nextpos] == '+' || this.m_buf[this.m_nextpos] == '-' || this.m_buf[this.m_nextpos] == '*' || this.m_buf[this.m_nextpos] == '/')) break;
                        if (this.m_buf[this.m_nextpos] == '(' || this.m_buf[this.m_nextpos] == ')') {
                            tok.append(this.m_buf[this.m_nextpos]);
                            state = -5;
                            break;
                        }
                        if (this.m_buf[this.m_nextpos] == ',') {
                            ++this.m_nextpos;
                            break;
                        }
                        if (state == -4 && (this.m_buf[this.m_nextpos] == '=' || this.m_buf[this.m_nextpos] == '+' || this.m_buf[this.m_nextpos] == '-' || this.m_buf[this.m_nextpos] == '*' || this.m_buf[this.m_nextpos] == '/')) {
                            tok.append(this.m_buf[this.m_nextpos++]);
                            state = -5;
                            break;
                        }
                        if (this.m_buf[this.m_nextpos] == '<') {
                            tok.append(this.m_buf[this.m_nextpos]);
                            if (this.m_nextpos + 1 < this.m_len && (this.m_buf[this.m_nextpos + 1] == '=' || this.m_buf[this.m_nextpos + 1] == '>')) {
                                tok.append(this.m_buf[++this.m_nextpos]);
                            }
                            ++this.m_nextpos;
                            state = -5;
                            break;
                        }
                        if (this.m_buf[this.m_nextpos] == '>') {
                            tok.append(this.m_buf[this.m_nextpos]);
                            if (this.m_nextpos + 1 < this.m_len && this.m_buf[this.m_nextpos + 1] == '=') {
                                tok.append(this.m_buf[++this.m_nextpos]);
                            }
                            ++this.m_nextpos;
                            state = -5;
                            break;
                        }
                        tok.append(this.m_buf[this.m_nextpos]);
                        state = -5;
                    }
                }
                ++this.m_nextpos;
            }
            if (this.m_nextpos == this.m_len && state == -6 && !string_literal_complete) {
                throw new Exception("String literal not delimited. at: " + this.m_nextpos + 1);
            }
        }
        if (state != -4 && state != -1) {
            this.sval = tok.toString();
        }
        retval = state;
        this.ttype = state;
        return retval;
    }
}

