/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.util;

import com.sap.sdb.programmargs.Convert;
import com.sap.sdb.syncMan.tool.ProtocolViewer;
import com.sap.sdb.syncMan.tool.Resources;
import com.sap.sdb.syncMan.util.ColumnDesc;
import com.sap.sdb.syncMan.util.SQLNames;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class SQLBuilder
implements SQLNames {
    private static SQLBuilder s_sqlBuilder = null;
    private Object m_textFrame = null;
    static final int MYSQL_SQL_ERROR_DUPLICATE_TABLE = 1050;
    static final int MYSQL_SQL_ERROR_DUPLICATE_INDEX = 1061;
    public static final int MAXDB_DUPLICATE_SECONDARY_KEY = 250;
    static final int MAXDB_SQL_ERROR_DUPLICATE_TABLE = -6000;
    static final int MAXDB_SQL_ERROR_DUPLICATE_INDEX = -6008;
    static final int MAXDB_SQL_ERROR_DUPLICATE_INDEX_COL = -7055;
    static final int MAXDB_SQL_ERROR_DUPLICATE_NAME = -6006;
    static final int MAXDB_SQL_ERROR_REPLICATION_TABLE_NOT_ALLOWED = -7083;
    public static final int MAXDB_SQL_ERROR_DUPLICATE_KEY = 200;
    public static final int MYSQL_SQL_ERROR_DUPLICATE_KEY = 1062;
    static final int MINDB_SQL_ERROR_DUPLICATE_TABLE = -6000;
    private static final String REP_INSERT_TRIGGER_PREFIX = "IT";
    private static final String REP_UPDATE_TRIGGER_PREFIX = "UT";
    private static final String REP_DELETE_TRIGGER_PREFIX = "DT";
    private static final String LINE_SEP = "\r\n";
    private static final String DEST_PREFIX = "DEST";

    private SQLBuilder(Object textFrame) {
        this.m_textFrame = textFrame;
    }

    public static synchronized void createInstance(Object textFrame) throws Exception {
        if (s_sqlBuilder != null) {
            throw new IllegalStateException("SQLBuilder singleton already created.");
        }
        s_sqlBuilder = new SQLBuilder(textFrame);
    }

    public static synchronized boolean isCreated() {
        return s_sqlBuilder != null;
    }

    public static synchronized void destroyInstance() {
        if (s_sqlBuilder == null) {
            throw new IllegalStateException("SQLBuilder singleton not created.");
        }
        s_sqlBuilder = null;
    }

    private static SQLBuilder getInstance() {
        if (s_sqlBuilder == null) {
            throw new IllegalStateException("SQLBuilder singleton not created.");
        }
        return s_sqlBuilder;
    }

    public static void writeProt(Exception ex) {
        SQLBuilder.writeProt(SQLBuilder.getStackTraceAsString(ex), true);
    }

    public static void writeProtAsync(Exception ex) {
        SQLBuilder.writeProtAsync(SQLBuilder.getStackTraceAsString(ex), true);
    }

    public static void writeProt(String msg, boolean color) {
        if (SQLBuilder.getInstance().m_textFrame != null) {
            if (((ProtocolViewer)SQLBuilder.getInstance().m_textFrame).isVisible()) {
                ((ProtocolViewer)SQLBuilder.getInstance().m_textFrame).println(msg, color);
            }
        } else {
            System.out.println(msg);
        }
    }

    public static boolean hasLogWindow() {
        return SQLBuilder.getInstance().m_textFrame != null;
    }

    public static void writeProtAsync(String msg, boolean color) {
        if (SQLBuilder.getInstance().m_textFrame != null) {
            ((ProtocolViewer)SQLBuilder.getInstance().m_textFrame).printlnasync(msg, color);
        } else {
            System.out.println(msg);
        }
    }

    public static void clearLog() {
        if (SQLBuilder.getInstance().m_textFrame instanceof ProtocolViewer && SQLBuilder.getInstance().m_textFrame != null && ((ProtocolViewer)SQLBuilder.getInstance().m_textFrame).isVisible()) {
            ((ProtocolViewer)SQLBuilder.getInstance().m_textFrame).clear();
            ((ProtocolViewer)SQLBuilder.getInstance().m_textFrame).println(Resources.getString((String)"SyncManGUI.Welcome"), false);
        }
    }

    public static void markMinDBTableForRep(Connection dbTarget, String syncUser, String syncSchema, String tableOwner, String table, Vector repColumns, long unitID, boolean isMaster, String shadowTableName, String versionTableName, String auditTableName) throws SQLException {
        Statement stmt;
        block8: {
            block7: {
                block6: {
                    SQLBuilder.internalMarkForForRep(dbTarget, syncSchema, tableOwner, table, repColumns, shadowTableName, versionTableName, auditTableName);
                    stmt = dbTarget.createStatement();
                    SQLBuilder.writeProtAsync("Create MinDB Trigger", false);
                    try {
                        stmt.execute(SQLBuilder.buildCreateMinDBInsertTrigger(syncUser, syncSchema, tableOwner, table, shadowTableName, versionTableName, repColumns, unitID, isMaster));
                    }
                    catch (SQLException ex) {
                        if (ex.getErrorCode() == -3008) break block6;
                        throw ex;
                    }
                }
                try {
                    stmt.execute(SQLBuilder.buildCreateMinDBUpdateTrigger(syncUser, syncSchema, tableOwner, table, shadowTableName, versionTableName, repColumns, unitID, isMaster));
                }
                catch (SQLException ex) {
                    if (ex.getErrorCode() == -3008) break block7;
                    throw ex;
                }
            }
            try {
                stmt.execute(SQLBuilder.buildCreateMinDBDeleteTrigger(syncUser, syncSchema, tableOwner, table, shadowTableName, versionTableName, repColumns, unitID, isMaster));
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == -3008) break block8;
                throw ex;
            }
        }
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markMaxDBTableForRep(Connection dbTarget, String syncUser, String syncSchema, String tableOwner, String table, Vector repColumns, long unitID, boolean isMaster, String shadowTableName, String versionTableName, String auditTableName) throws SQLException {
        Statement stmt;
        block11: {
            block10: {
                SQLBuilder.internalMarkForForRep(dbTarget, syncSchema, tableOwner, table, repColumns, shadowTableName, versionTableName, auditTableName);
                stmt = dbTarget.createStatement();
                SQLBuilder.writeProtAsync("Lock table " + table, false);
                SQLBuilder.writeProtAsync("Create MaxDB Trigger", false);
                try {
                    stmt.execute(SQLBuilder.buildCreateMaxDBInsertTrigger(syncUser, syncSchema, tableOwner, table, shadowTableName, versionTableName, repColumns, unitID, isMaster));
                }
                catch (SQLException ex) {
                    if (ex.getErrorCode() == -6006) break block10;
                    throw ex;
                }
            }
            try {
                stmt.execute(SQLBuilder.buildCreateMaxDBUpdateTrigger(syncUser, syncSchema, tableOwner, table, shadowTableName, versionTableName, repColumns, unitID, isMaster));
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == -6006) break block11;
                throw ex;
            }
        }
        try {
            stmt.execute(SQLBuilder.buildCreateMaxDBDeleteTrigger(syncUser, syncSchema, tableOwner, table, shadowTableName, versionTableName, repColumns, unitID, isMaster));
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() != -6006) {
                throw ex;
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalMarkForForRep(Connection dbTarget, String syncSchema, String tableOwner, String table, Vector repColumns, String shadowTableName, String versionTableName, String auditTableName) throws SQLException {
        Statement stmt = dbTarget.createStatement();
        try {
            SQLBuilder.writeProtAsync("Create shadow table  " + shadowTableName, false);
            stmt.execute(SQLBuilder.buildCreateTable(syncSchema, tableOwner, table, shadowTableName, repColumns));
            SQLBuilder.writeProtAsync("Create version table " + versionTableName, false);
            stmt.execute(SQLBuilder.buildCreateVersionTable(syncSchema, tableOwner, table, versionTableName, repColumns));
            SQLBuilder.writeProtAsync("Create conflict table " + auditTableName, false);
            stmt.execute(SQLBuilder.buildCreateAuditTable(syncSchema, auditTableName, repColumns));
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() != -6000) {
                throw ex;
            }
        }
        finally {
            stmt.close();
        }
    }

    public static void unMarkMaxTableForRep(Connection dbTarget, String syncSchema, String sourceUser, String table, String shadowTableName, String versionTableName, String auditTableName) throws SQLException {
        block2: {
            SQLBuilder.internalUnMarkTableForRep(dbTarget, syncSchema, sourceUser, table, shadowTableName, versionTableName, auditTableName);
            try {
                Statement stmt = dbTarget.createStatement();
                SQLBuilder.writeProtAsync("Drop Trigger", false);
                stmt.execute(SQLBuilder.buildDropMaxDBInsertTrigger(sourceUser, table, shadowTableName));
                stmt.execute(SQLBuilder.buildDropMaxDBUpdateTrigger(sourceUser, table, shadowTableName));
                stmt.execute(SQLBuilder.buildDropMaxDBDeleteTrigger(sourceUser, table, shadowTableName));
                stmt.close();
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == -4019 || ex.getErrorCode() == -4004) break block2;
                throw ex;
            }
        }
    }

    public static void unMarkMinTableForRep(Connection dbTarget, String syncSchema, String sourceUser, String table, String shadowTableName, String versionTableName, String auditTableName) throws SQLException {
        block2: {
            SQLBuilder.internalUnMarkTableForRep(dbTarget, syncSchema, sourceUser, table, shadowTableName, versionTableName, auditTableName);
            try {
                Statement stmt = dbTarget.createStatement();
                SQLBuilder.writeProtAsync("Drop Trigger", false);
                stmt.execute(SQLBuilder.buildDropMinDBInsertTrigger(sourceUser, table));
                stmt.execute(SQLBuilder.buildDropMinDBUpdateTrigger(sourceUser, table));
                stmt.execute(SQLBuilder.buildDropMinDBDeleteTrigger(sourceUser, table));
                stmt.close();
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == -4019) break block2;
                throw ex;
            }
        }
    }

    private static void internalUnMarkTableForRep(Connection dbTarget, String syncSchema, String sourceUser, String table, String shadowTableName, String versionTableName, String auditTableName) throws SQLException {
        block2: {
            try {
                Statement stmt = dbTarget.createStatement();
                SQLBuilder.writeProtAsync("Drop shadow table " + shadowTableName, false);
                stmt.execute(SQLBuilder.buildDropTable(syncSchema, shadowTableName));
                SQLBuilder.writeProtAsync("Drop version table " + versionTableName, false);
                stmt.execute(SQLBuilder.buildDropVersionTable(syncSchema, versionTableName));
                SQLBuilder.writeProtAsync("Drop Conflict table " + auditTableName, false);
                stmt.execute(SQLBuilder.buildDropAuditTable(syncSchema, auditTableName));
                SQLBuilder.writeProtAsync("Delete transactions REPLICATION_TRANSACTION_LIST", false);
                stmt.execute(SQLBuilder.buildDeleteTransactions(syncSchema, sourceUser, table));
                stmt.close();
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == -4004) break block2;
                throw ex;
            }
        }
    }

    public static byte[] newByteArrayFromID(long id) {
        byte[] bytes = new byte[]{(byte)(id >>> 56), (byte)(id >>> 48), (byte)(id >>> 40), (byte)(id >>> 32), (byte)(id >>> 24), (byte)(id >>> 16), (byte)(id >>> 8), (byte)(id >>> 0)};
        return bytes;
    }

    public static long getIDFromByteArray(byte[] bytes) {
        if (bytes.length < 8) {
            return -1L;
        }
        return ((long)bytes[0] << 56) + ((long)(bytes[1] & 0xFF) << 48) + ((long)(bytes[2] & 0xFF) << 40) + ((long)(bytes[3] & 0xFF) << 32) + ((long)(bytes[4] & 0xFF) << 24) + (long)((bytes[5] & 0xFF) << 16) + (long)((bytes[6] & 0xFF) << 8) + (long)((bytes[7] & 0xFF) << 0);
    }

    private static String buildCreateTable(String syncSchema, String owner, String table, String shadowTableName, Vector repColumns) throws SQLException {
        String keys = "";
        String temp = "create table \"" + syncSchema + "\".\"" + shadowTableName + "\"(" + LINE_SEP;
        if (repColumns.size() < 1) {
            throw new SQLException("Table " + owner + "." + table + " has no replication columns");
        }
        int i = 0;
        for (i = 0; i < repColumns.size(); ++i) {
            ColumnDesc col = (ColumnDesc)repColumns.get(i);
            String colName = col.columnName();
            String colTypeName = col.typeName();
            temp = temp + "\"_" + colName + "\" ";
            if (colTypeName.startsWith("CHAR") || colTypeName.startsWith("VARCHAR")) {
                int parenthesis = colTypeName.indexOf("()");
                if (parenthesis > 0) {
                    temp = temp + colTypeName.substring(0, parenthesis) + " ";
                    temp = temp + "(" + col.precision() + ") ";
                    temp = temp + colTypeName.substring(parenthesis + 2, colTypeName.length()) + " ";
                } else {
                    temp = temp + colTypeName + " (" + col.precision() + ") ";
                }
            } else {
                temp = colTypeName.startsWith("FLOAT") ? temp + colTypeName + " (" + col.precision() + ") " : (colTypeName.startsWith("FIXED") ? temp + colTypeName + " (" + col.precision() + "," + col.scale() + ") " : temp + colTypeName + " ");
            }
            temp = temp + ", \r\n";
            if (col.keyPos() <= 0) continue;
            keys = keys + "\"_" + colName + "\",";
        }
        if (keys.length() < 1) {
            throw new SQLException("Table " + owner + "." + table + " has no primary keys");
        }
        keys = keys.substring(0, keys.length() - 1);
        temp = temp + "REP_TRANSID char (6) byte, \r\n";
        temp = temp + "REP_COUNTER fixed (20,0) not null, \r\n";
        temp = temp + "REP_TYPE int, \r\n";
        temp = temp + "REP_CHANGE char(" + Math.max(i, 20) + ") byte, " + LINE_SEP;
        temp = temp + "ROW_CREATOR fixed (20) ,\r\n";
        temp = temp + "ROW_VERSION fixed (20) ,\r\n";
        temp = temp + "UPDATER_ID fixed (20) ,\r\n";
        temp = temp + "COL_GROUP_VERSION fixed (20) ,\r\n";
        temp = temp + "primary key (REP_TRANSID,REP_COUNTER,REP_TYPE)\r\n";
        temp = temp + ")";
        return temp;
    }

    public static String makeQueueDestName(long destId) {
        return "SYNC_QUEUE_DEST_" + String.valueOf(destId);
    }

    public static String makeTopicDestName(long destId) {
        return "SYNC_TOPIC_DEST_" + String.valueOf(destId);
    }

    private static String buildCreateVersionTable(String syncSchema, String owner, String table, String versionTableName, Vector repColumns) throws SQLException {
        String keys = "";
        String keyCols = "";
        String temp = "create table \"" + syncSchema + "\".\"" + versionTableName + "\" (" + LINE_SEP;
        for (int i = 0; i < repColumns.size(); ++i) {
            ColumnDesc col = (ColumnDesc)repColumns.get(i);
            String colTypeName = col.typeName();
            if (col.keyPos() <= 0) continue;
            keys = keys + "\"_" + col.columnName() + "\",";
            keyCols = keyCols + "\"_" + col.columnName() + "\" ";
            if (colTypeName.startsWith("CHAR") || colTypeName.startsWith("VARCHAR")) {
                int parenthesis = colTypeName.indexOf("()");
                if (parenthesis > 0) {
                    keyCols = keyCols + colTypeName.substring(0, parenthesis) + " ";
                    keyCols = keyCols + "(" + col.precision() + ") ";
                    keyCols = keyCols + colTypeName.substring(parenthesis + 2, colTypeName.length()) + " ";
                } else {
                    keyCols = keyCols + colTypeName + " (" + col.precision() + ") ";
                }
            } else {
                keyCols = colTypeName.startsWith("FLOAT") ? keyCols + colTypeName + " (" + col.precision() + ") " : (colTypeName.startsWith("FIXED") ? keyCols + colTypeName + " (" + col.precision() + "," + col.scale() + ") " : keyCols + colTypeName + " ");
            }
            keyCols = keyCols + ", \r\n";
        }
        if (keys.length() < 1) {
            throw new SQLException("Table " + owner + "." + table + " has no primary keys");
        }
        keys = keys.substring(0, keys.length() - 1);
        temp = temp + keyCols;
        temp = temp + "ROW_CREATOR fixed (20) ,\r\n";
        temp = temp + "ROW_VERSION fixed (20) ,\r\n";
        temp = temp + "LAST_UPDATER fixed (20) ,\r\n";
        temp = temp + "COL_GROUP_VERSION fixed (20) ,\r\n";
        temp = temp + "primary key (" + keys + ")" + LINE_SEP;
        temp = temp + ")";
        return temp;
    }

    private static String buildCreateAuditTable(String syncSchema, String auditTableName, Vector repColumns) throws SQLException {
        String keyCols = "";
        String temp = "create table \"" + syncSchema + "\".\"" + auditTableName + "\" (" + LINE_SEP;
        for (int i = 0; i < repColumns.size(); ++i) {
            ColumnDesc col = (ColumnDesc)repColumns.get(i);
            String colTypeName = col.typeName();
            if (col.keyPos() <= 0) continue;
            keyCols = keyCols + "\"_" + col.columnName() + "\" ";
            if (colTypeName.startsWith("CHAR") || colTypeName.startsWith("VARCHAR")) {
                int parenthesis = colTypeName.indexOf("()");
                if (parenthesis > 0) {
                    keyCols = keyCols + colTypeName.substring(0, parenthesis) + " ";
                    keyCols = keyCols + "(" + col.precision() + ") ";
                    keyCols = keyCols + colTypeName.substring(parenthesis + 2, colTypeName.length()) + " ";
                } else {
                    keyCols = keyCols + colTypeName + " (" + col.precision() + ") ";
                }
            } else {
                keyCols = colTypeName.startsWith("FLOAT") ? keyCols + colTypeName + " (" + col.precision() + ") " : (colTypeName.startsWith("FIXED") ? keyCols + colTypeName + " (" + col.precision() + "," + col.scale() + ") " : keyCols + colTypeName + " ");
            }
            keyCols = keyCols + ", \r\n";
        }
        temp = temp + keyCols;
        temp = temp + "LAST_UPDATER fixed (20) ,\r\n";
        temp = temp + "AUDIT_TIME timestamp ,\r\n";
        temp = temp + "CONFLICT_TYPE int ,\r\n";
        temp = temp + "ROW_CREATOR fixed (20) ,\r\n";
        temp = temp + "ROW_VERSION fixed (20) ,\r\n";
        temp = temp + "REP_TYPE int\r\n";
        temp = temp + ")";
        return temp;
    }

    private static String buildCreateMaxDBInsertTrigger(String syncUser, String syncSchema, String owner, String table, String shadowTableName, String versionTableName, Vector repColumns, long unitID, boolean bMaster) {
        String createTrigger = "create trigger \"IT" + shadowTableName + "\" for \"" + owner + "\".\"" + table + "\" after insert execute" + LINE_SEP + "(" + LINE_SEP + "var" + LINE_SEP + "TRANS" + " char(6) byte;" + LINE_SEP + SQLBuilder.versionVariables() + "try" + LINE_SEP + SQLBuilder.checkForRepUser(bMaster, syncUser) + "set " + "TRANS" + " = transaction;" + LINE_SEP;
        String versionTable = "";
        if (bMaster) {
            versionTable = "if user != '" + syncUser + "' then" + LINE_SEP;
        }
        versionTable = versionTable + "\tinsert into \"" + syncSchema + "\".\"" + versionTableName + "\"" + LINE_SEP + "\tvalues (";
        String keyClause = " where ";
        String triggerColumns = "";
        String IDs = bMaster ? String.valueOf(0L) : ":UPDATER_ID";
        boolean bOneVersionCol = false;
        ColumnDesc col = null;
        String colName = null;
        for (int i = 0; i < repColumns.size(); ++i) {
            col = (ColumnDesc)repColumns.get(i);
            colName = col.columnName();
            triggerColumns = triggerColumns + ":\"" + colName + "\"," + LINE_SEP + "\t";
            if (col.keyPos() > 0) {
                versionTable = versionTable + ":\"" + colName + "\"," + LINE_SEP + "\t";
                keyClause = keyClause + "\"_" + colName + "\"" + " = :\"" + colName + "\" and " + LINE_SEP + "\t";
                continue;
            }
            if (bOneVersionCol || !col.versioned()) continue;
            bOneVersionCol = true;
        }
        keyClause = keyClause.substring(0, keyClause.length() - 8);
        createTrigger = createTrigger + SQLBuilder.initVersionValuesForInsert(syncUser, syncSchema, unitID, bMaster, bOneVersionCol);
        createTrigger = createTrigger + "    insert into \"" + syncSchema + "\".\"" + shadowTableName + "\"" + LINE_SEP + "\tvalues (" + triggerColumns;
        versionTable = versionTable + IDs + ",:" + "ROW_VERSION" + LINE_SEP + "\t," + IDs + ",:" + "COL_GROUP_VERSION" + ");" + LINE_SEP + "\t";
        createTrigger = createTrigger + ":TRANS,\r\n\t\"" + syncSchema + "\".\"" + "REPLICATION_ID" + "\".NextVal," + LINE_SEP + "\t" + 0 + "," + LINE_SEP + "\tNULL" + SQLBuilder.versionColumnsToInsert() + ");" + LINE_SEP + "  catch" + LINE_SEP + "  if $rc <> 0" + LINE_SEP + "    Then stop ($rc,'Insert Trigger Error:'& $ERRMSG);" + LINE_SEP;
        createTrigger = createTrigger + "try\r\n" + versionTable + LINE_SEP + "  catch" + LINE_SEP + "  if $rc <> 0" + LINE_SEP + "    Then stop ($rc,'Insert Trigger Error:'& $ERRMSG);" + LINE_SEP;
        createTrigger = createTrigger + SQLBuilder.buildTransListTrigger(syncSchema, owner, table) + ") internal" + LINE_SEP;
        return createTrigger;
    }

    private static String buildCreateMaxDBUpdateTrigger(String syncUser, String syncSchema, String owner, String table, String shadowTableName, String versionTableName, Vector repColumns, long unitID, boolean bMaster) {
        String colOldNames = "";
        String colNames = "";
        String updateFlag = "\t\r\n";
        String keyUpdate = "if ";
        String keyClause = " where ";
        String updateLongs = "";
        boolean oneBlob = false;
        boolean bOneBeforeImageCol = false;
        boolean bOneVersionCol = false;
        boolean bOneNoVersionCol = false;
        ColumnDesc col = null;
        String colName = null;
        String IDs = bMaster ? String.valueOf(0L) : String.valueOf(unitID);
        int i = 0;
        for (i = 0; i < repColumns.size(); ++i) {
            col = (ColumnDesc)repColumns.get(i);
            if (col.keyPos() >= 1) continue;
            if (!bOneVersionCol && col.versioned()) {
                bOneVersionCol = true;
            }
            if (!bOneNoVersionCol && !col.versioned()) {
                bOneNoVersionCol = true;
            }
            if (oneBlob || !col.isLOB()) continue;
            oneBlob = true;
        }
        for (i = 0; i < repColumns.size(); ++i) {
            col = (ColumnDesc)repColumns.get(i);
            colName = col.columnName();
            if (col.keyPos() > 0) {
                keyUpdate = keyUpdate + "isupdatedcolumn(\"" + colName + "\") or " + LINE_SEP;
                keyClause = keyClause + "\"_" + colName + "\"" + " = :Old.\"" + colName + "\" and " + LINE_SEP + "\t";
            }
            colNames = col.keyPos() > 0 ? colNames + ":New.\"" + colName + "\"," + LINE_SEP + "\t" : (col.isLOB() ? colNames + "NULL,\r\n\t" : colNames + "decode(substr(:change," + (1 + i) + ",1),x'01',:New.\"" + colName + "\")," + LINE_SEP + "\t");
            if (!bMaster) {
                if (!col.versioned()) {
                    colOldNames = colOldNames + ":Old.\"" + colName + "\"," + LINE_SEP + "\t";
                    if (!bOneBeforeImageCol && col.keyPos() < 1) {
                        bOneBeforeImageCol = true;
                    }
                } else {
                    colOldNames = colOldNames + "null,\r\n\t";
                }
            }
            if (col.keyPos() < 1) {
                updateFlag = updateFlag + "if isupdatedcolumn(\"" + colName + "\")" + " then" + LINE_SEP + "\t";
                updateFlag = updateFlag + "begin\r\n\t";
                if (col.versioned() && bOneVersionCol && bOneNoVersionCol) {
                    updateFlag = updateFlag + "set versionColChanged = 1;\r\n\t";
                }
                updateFlag = updateFlag + "set change = change || x'01';\r\n\t";
                updateFlag = updateFlag + "end\r\n\t";
                updateFlag = updateFlag + "else\r\n\t";
                updateFlag = updateFlag + "begin\r\n\t";
                updateFlag = updateFlag + "set change = change || x'FF';\r\n\t";
                updateFlag = updateFlag + "end;\r\n";
                continue;
            }
            updateFlag = updateFlag + "set change = change || x'FF';\r\n";
        }
        String updateVersionTable = "";
        if (bMaster) {
            updateVersionTable = "if user != '" + syncUser + "' then" + LINE_SEP;
        }
        updateVersionTable = updateVersionTable + "\tupdate \"" + syncSchema + "\".\"" + versionTableName + "\"" + " set " + "COL_GROUP_VERSION" + "=:new_col_version," + "LAST_UPDATER" + "=" + IDs + LINE_SEP + "\t";
        String updateUpdaterID = "";
        if (bMaster) {
            updateUpdaterID = "if user != '" + syncUser + "' then" + LINE_SEP;
        }
        updateUpdaterID = updateUpdaterID + "update \"" + syncSchema + "\".\"" + versionTableName + "\"" + " set " + "LAST_UPDATER" + "=" + IDs + LINE_SEP + "\t";
        keyClause = keyClause.substring(0, keyClause.length() - 8);
        if (oneBlob) {
            for (i = 0; i < repColumns.size(); ++i) {
                col = (ColumnDesc)repColumns.get(i);
                colName = col.columnName();
                if (col.keyPos() >= 1 || !col.isLOB()) continue;
                updateLongs = updateLongs + "try\r\n\tupdate \"" + syncSchema + "\".\"" + shadowTableName + "\"" + " set \"" + "_" + colName + "\" = " + ":New.\"" + colName + "\"" + LINE_SEP + "\t" + " where " + "REP_TRANSID" + "=:" + "TRANS" + LINE_SEP + "\t" + " and " + "REP_COUNTER" + "=:" + "REP_SEQ_VAL" + LINE_SEP + "\t" + " and " + "REP_TYPE" + "=" + 1 + LINE_SEP + "\t" + " and (substr(:change," + (1 + i) + ",1) = x'01')" + ";" + LINE_SEP + "catch" + LINE_SEP + "  if $rc <> 100" + LINE_SEP + "    Then stop ($rc,'Update Trigger Set Long Column(" + i + ") Error:'& $ERRMSG);" + LINE_SEP;
            }
        }
        String createTrigger = "create trigger \"UT" + shadowTableName + "\" for \"" + owner + "\".\"" + table + "\" after update execute" + LINE_SEP + "(" + LINE_SEP + "var" + LINE_SEP;
        if (bOneVersionCol && bOneNoVersionCol) {
            createTrigger = createTrigger + "versionColChanged fixed(1,0);\r\n";
        }
        createTrigger = createTrigger + "TRANS char(6) byte;\r\nnew_col_version fixed(20,0);\r\n" + SQLBuilder.versionVariables() + "REP_SEQ_VAL" + " FIXED(20,0);" + LINE_SEP + "change char(" + i + ") byte;" + LINE_SEP + "try" + LINE_SEP + SQLBuilder.checkForRepUser(bMaster, syncUser) + "  set change = x'';" + LINE_SEP + "  set " + "REP_SEQ_VAL" + " = \"" + syncSchema + "\".\"" + "REPLICATION_ID" + "\".NextVal;" + LINE_SEP + "  set " + "TRANS" + " = transaction;" + LINE_SEP;
        if (bOneVersionCol && bOneNoVersionCol) {
            createTrigger = createTrigger + "  versionColChanged = 0;\r\n\r\n";
        }
        String temp = updateFlag;
        temp = temp + SQLBuilder.initVersionValuesForDeleteOrUpdate(syncUser, unitID, bMaster);
        temp = temp + SQLBuilder.getLastUpdateVersion(syncSchema, versionTableName, keyClause);
        if (bOneVersionCol || bOneNoVersionCol) {
            temp = temp + "\r\ntry\r\n";
        }
        if (bOneVersionCol && bOneNoVersionCol) {
            temp = temp + "if versionColChanged = 1 then \r\nbegin \r\n";
        }
        if (bOneVersionCol) {
            temp = temp + "set new_col_version = COL_GROUP_VERSION+1;\r\n" + updateVersionTable + keyClause + ";" + LINE_SEP;
        }
        if (bOneVersionCol && bOneNoVersionCol) {
            temp = temp + "end\r\nelse\r\nbegin\r\n";
        }
        if (bOneNoVersionCol) {
            temp = temp + "set new_col_version = -1;\r\n" + updateUpdaterID + keyClause + ";" + LINE_SEP;
        }
        if (bOneVersionCol && bOneNoVersionCol) {
            temp = temp + "end;\r\n";
        }
        if (bOneVersionCol || bOneNoVersionCol) {
            temp = temp + "catch\r\n  if $rc <> 100\r\n    Then stop ($rc,'Update Trigger Error:'& $ERRMSG);\r\n\r\n";
        }
        temp = temp + "insert into \"" + syncSchema + "\".\"" + shadowTableName + "\"";
        temp = temp + "\r\n\tvalues (";
        temp = temp + colNames;
        keyUpdate = keyUpdate.substring(0, keyUpdate.length() - 5);
        keyUpdate = keyUpdate + " then stop (-7083,'Replicated table not allowed: Primary Key Update');\r\n";
        createTrigger = createTrigger + keyUpdate;
        createTrigger = createTrigger + temp;
        String beforeImage = "";
        if (!bMaster && bOneBeforeImageCol) {
            beforeImage = "\r\n  insert into \"" + syncSchema + "\".\"" + shadowTableName + "\"";
            beforeImage = beforeImage + "\r\n\tvalues (";
            beforeImage = beforeImage + colOldNames;
        }
        createTrigger = createTrigger + ":TRANS,\r\n\t:REP_SEQ_VAL,\r\n\t1,\r\n\t:change,\r\n\t:ROW_CREATOR,\r\n\t:ROW_VERSION,\r\n\t:UPDATER_ID,\r\n\t:new_col_version);\r\n";
        if (!bMaster && bOneBeforeImageCol) {
            createTrigger = createTrigger + beforeImage + ":" + "TRANS" + "," + LINE_SEP + "\t:" + "REP_SEQ_VAL" + "," + LINE_SEP + "\t" + 3 + "," + LINE_SEP + "\tNULL" + "," + LINE_SEP + "\tNULL" + "," + LINE_SEP + "\tNULL" + "," + LINE_SEP + "\tNULL" + "," + LINE_SEP + "\t:" + "COL_GROUP_VERSION" + ");" + LINE_SEP;
        }
        createTrigger = createTrigger + "  catch\r\n  if $rc <> 0\r\n    Then stop ($rc,'Update Trigger (Insert Shadow Values) Error:'& $ERRMSG);\r\n\r\n";
        createTrigger = createTrigger + updateLongs;
        createTrigger = createTrigger + SQLBuilder.buildTransListTrigger(syncSchema, owner, table) + ") internal" + LINE_SEP;
        return createTrigger;
    }

    private static String buildCreateMaxDBDeleteTrigger(String syncUser, String syncSchema, String owner, String table, String shadowTableName, String versionTableName, Vector repColumns, long unitID, boolean bMaster) {
        String createTrigger = "create trigger \"DT" + shadowTableName + "\" for \"" + owner + "\".\"" + table + "\" after delete execute" + LINE_SEP + "(" + LINE_SEP + "var" + LINE_SEP + "TRANS" + " char(6) byte;" + LINE_SEP + SQLBuilder.versionVariables() + "try" + LINE_SEP + SQLBuilder.checkForRepUser(bMaster, syncUser) + "\tset " + "TRANS" + " = transaction;" + LINE_SEP;
        String versionTable = "\tdelete \"" + syncSchema + "\".\"" + versionTableName + "\"";
        String keyClause = " where ";
        String triggerColumns = "";
        for (int i = 0; i < repColumns.size(); ++i) {
            ColumnDesc col = (ColumnDesc)repColumns.get(i);
            String colName = col.columnName();
            if (col.keyPos() > 0) {
                triggerColumns = triggerColumns + ":\"" + colName + "\"," + LINE_SEP + "\t";
                keyClause = keyClause + "\"_" + colName + "\"" + " = :Old.\"" + colName + "\" and " + LINE_SEP + "\t";
                continue;
            }
            triggerColumns = triggerColumns + "null,\r\n\t";
        }
        keyClause = keyClause.substring(0, keyClause.length() - 8);
        versionTable = versionTable + keyClause;
        versionTable = versionTable + ";";
        createTrigger = createTrigger + SQLBuilder.initVersionValuesForDeleteOrUpdate(syncUser, unitID, bMaster);
        createTrigger = createTrigger + SQLBuilder.getLastDeleteVersion(syncSchema, versionTableName, keyClause);
        createTrigger = createTrigger + "  insert into \"" + syncSchema + "\".\"" + shadowTableName + "\"" + LINE_SEP + "\tvalues (" + triggerColumns + ":" + "TRANS" + "," + LINE_SEP + "\t" + "\"" + syncSchema + "\".\"" + "REPLICATION_ID" + "\".NextVal," + LINE_SEP + "\t" + 2 + "," + LINE_SEP + "\tNULL" + SQLBuilder.versionColumnsToInsert() + ");" + LINE_SEP + "  catch" + LINE_SEP + "  if $rc <> 0" + LINE_SEP + "    Then stop ($rc,'Delete Trigger Error:'& $ERRMSG);" + LINE_SEP;
        createTrigger = createTrigger + "try\r\n" + versionTable + LINE_SEP + "  catch" + LINE_SEP + "  if $rc <> 100" + LINE_SEP + "    Then stop ($rc,'Delete Trigger Error:'& $ERRMSG);" + LINE_SEP;
        createTrigger = createTrigger + SQLBuilder.buildTransListTrigger(syncSchema, owner, table) + ") internal" + LINE_SEP;
        return createTrigger;
    }

    private static String buildTransListTrigger(String syncSchema, String owner, String table) {
        String transList = "try\r\n insert into \"" + syncSchema + "\"." + "REPLICATION_TRANSACTION_LIST" + LINE_SEP + " values (:" + "TRANS" + "," + LINE_SEP + " '" + owner + "'," + LINE_SEP + " '" + table + "'," + LINE_SEP + " \"" + syncSchema + "\"." + "REPLICATION_ID" + ".NEXTVAL)" + LINE_SEP + " update duplicates;" + LINE_SEP + "catch" + LINE_SEP + "  if $rc <> 0" + LINE_SEP + "  Then stop ($rc,'Trigger trans list Error:'& $ERRMSG);" + LINE_SEP;
        return transList;
    }

    private static String buildDeleteTransactions(String syncSchema, String owner, String table) {
        String deleteTable = "delete \"" + syncSchema + "\"." + "REPLICATION_TRANSACTION_LIST" + " where " + "TABLE_SCHEMA" + " = '" + owner + "' and " + " " + "TABLE_NAME" + " = '" + table + "'";
        return deleteTable;
    }

    private static String buildDropTable(String syncSchema, String shadowTableName) {
        String dropTable = "drop table \"" + syncSchema + "\".\"" + shadowTableName + "\"";
        return dropTable;
    }

    private static String buildDropVersionTable(String syncSchema, String versionTableName) {
        String dropTable = "drop table \"" + syncSchema + "\".\"" + versionTableName + "\"";
        return dropTable;
    }

    private static String buildDropAuditTable(String syncSchema, String auditTableName) {
        String dropTable = "drop table \"" + syncSchema + "\".\"" + auditTableName + "\"";
        return dropTable;
    }

    private static String buildDropMaxDBInsertTrigger(String owner, String table, String shadowTableName) {
        String dropTrigger = "drop trigger \"IT" + shadowTableName + "\" of \"" + owner + "\".\"" + table + "\"";
        return dropTrigger;
    }

    private static String buildDropMaxDBUpdateTrigger(String owner, String table, String shadowTableName) {
        String dropTrigger = "drop trigger \"UT" + shadowTableName + "\" of \"" + owner + "\".\"" + table + "\"";
        return dropTrigger;
    }

    private static String buildDropMaxDBDeleteTrigger(String owner, String table, String shadowTableName) {
        String dropTrigger = "drop trigger \"DT" + shadowTableName + "\" of \"" + owner + "\".\"" + table + "\"";
        return dropTrigger;
    }

    private static String buildDropMinDBInsertTrigger(String owner, String table) {
        return "drop trigger insert for \"" + owner + "\".\"" + table + "\"";
    }

    private static String buildDropMinDBUpdateTrigger(String owner, String table) {
        return "drop trigger update for \"" + owner + "\".\"" + table + "\"";
    }

    private static String buildDropMinDBDeleteTrigger(String owner, String table) {
        return "drop trigger delete for \"" + owner + "\".\"" + table + "\"";
    }

    private static String checkForRepUser(boolean isMaster, String syncUser) {
        if (isMaster) {
            return "";
        }
        return "  if user = '" + syncUser + "' then return;" + LINE_SEP;
    }

    private static String initVersionValuesForInsert(String syncUser, String syncSchema, long unitID, boolean isMaster, boolean bOneVersionCol) {
        String tmp = "\tCOL_GROUP_VERSION =";
        String next_row_ver = " = \"" + syncSchema + "\".\"" + "REPLICATION_ID" + "\".NextVal;" + LINE_SEP;
        tmp = !bOneVersionCol ? tmp + "-1;\r\n" : tmp + " 0;\r\n";
        if (!isMaster) {
            tmp = tmp + "\tROW_CREATOR = " + unitID + ";" + LINE_SEP;
            tmp = tmp + "\tROW_VERSION" + next_row_ver;
            tmp = tmp + "\tUPDATER_ID = " + unitID + ";" + LINE_SEP;
        } else {
            tmp = tmp + "\tif user = '" + syncUser + "' then" + LINE_SEP + "\tbegin" + LINE_SEP;
            tmp = tmp + "\t\tROW_CREATOR=-2;\r\n";
            tmp = tmp + "\t\tROW_VERSION=-1;\r\n";
            tmp = tmp + "\t\tUPDATER_ID=-2;\r\n";
            tmp = tmp + "\tend\r\n";
            tmp = tmp + "\telse\r\n\tbegin\r\n";
            tmp = tmp + "\t\tROW_CREATOR=0;\r\n";
            tmp = tmp + "\t\tROW_VERSION" + next_row_ver;
            tmp = tmp + "\t\tUPDATER_ID=0;\r\n";
            tmp = tmp + "\tend;\r\n";
        }
        return tmp;
    }

    private static String initVersionValuesForDeleteOrUpdate(String syncUser, long unitID, boolean isMaster) {
        String IDs = isMaster ? String.valueOf(0L) : String.valueOf(unitID);
        String tmp = "\tROW_CREATOR = " + IDs + ";" + LINE_SEP;
        tmp = tmp + "\tROW_VERSION=-1;\r\n";
        if (!isMaster) {
            tmp = tmp + "\tUPDATER_ID=" + IDs + ";" + LINE_SEP;
        } else {
            tmp = tmp + "\tif user = '" + syncUser + "' then" + LINE_SEP + "\tbegin" + LINE_SEP;
            tmp = tmp + "\t\tUPDATER_ID=-2;\r\n";
            tmp = tmp + "\tend\r\n";
            tmp = tmp + "\telse\r\n\tbegin\r\n";
            tmp = tmp + "\t\tUPDATER_ID=0;\r\n";
            tmp = tmp + "\tend;\r\n";
        }
        tmp = tmp + "\tCOL_GROUP_VERSION=-1;\r\n";
        return tmp;
    }

    private static String getLastUpdateVersion(String syncSchema, String versionTableName, String keyClause) {
        String temp = "\ttry\r\n\tDECLARE temp CURSOR FOR \r\n\tSELECT ROW_CREATOR,ROW_VERSION,COL_GROUP_VERSION FROM \"" + syncSchema + "\".\"" + versionTableName + "\"" + keyClause + ";" + LINE_SEP + "\t\tWHILE ($rc = 0) DO" + LINE_SEP + "\tBEGIN " + LINE_SEP + "\t\tFETCH temp INTO :" + "ROW_CREATOR" + ",:" + "ROW_VERSION" + ",:" + "COL_GROUP_VERSION" + ";" + LINE_SEP + "\tEND; " + LINE_SEP + "\tCLOSE temp; " + LINE_SEP + "\tcatch" + LINE_SEP + "\t  if $rc <> 100" + LINE_SEP + "\t    Then stop ($rc,'Trigger (Fetch Version) Error:'& $ERRMSG);" + LINE_SEP;
        return temp;
    }

    private static String getLastDeleteVersion(String syncSchema, String versionTableName, String keyClause) {
        String temp = "\ttry\r\n\t\tDECLARE temp CURSOR FOR \r\n\t\tSELECT ROW_CREATOR,ROW_VERSION FROM \"" + syncSchema + "\".\"" + versionTableName + "\"" + keyClause + ";" + LINE_SEP + "\t\tWHILE ($rc = 0) DO" + LINE_SEP + "\tBEGIN " + LINE_SEP + "\t\tFETCH temp INTO :" + "ROW_CREATOR" + ",:" + "ROW_VERSION" + ";" + LINE_SEP + "\tEND; " + LINE_SEP + "\tCLOSE temp; " + LINE_SEP + "\tcatch" + LINE_SEP + "\t  if $rc <> 100" + LINE_SEP + "\t    Then stop ($rc,'Trigger (Fetch Version) Error:'& $ERRMSG);" + LINE_SEP;
        return temp;
    }

    private static String versionVariables() {
        String tmp = "ROW_CREATOR fixed(20,0);\r\nROW_VERSION fixed(20,0);\r\nUPDATER_ID fixed(20,0);\r\nCOL_GROUP_VERSION fixed(20,0);\r\n";
        return tmp;
    }

    private static String versionColumnsToInsert() {
        String tmp = ",\r\n\t:ROW_CREATOR,\r\n\t:ROW_VERSION,\r\n\t:UPDATER_ID,\r\n\t:COL_GROUP_VERSION";
        return tmp;
    }

    private static String buildCreateMinDBUpdateTrigger(String syncUser, String syncSchema, String owner, String table, String shadowTableName, String versionTableName, Vector repColumns, long unitID, boolean bMaster) throws SQLException {
        if (bMaster) {
            throw new SQLException("create MinDB delete trigger on table " + owner + "." + table + " of master database not supported");
        }
        int beforeImage = 0;
        int keyColNum = 0;
        int verColNum = 0;
        String keyCols = "";
        String cols = "";
        String versionedCols = "";
        for (int i = 0; i < repColumns.size(); ++i) {
            ColumnDesc col = (ColumnDesc)repColumns.get(i);
            String colName = col.columnName();
            cols = cols + ", col" + Integer.toString(i + 1) + " = '" + colName + "' ";
            if (beforeImage == 0 && !col.versioned() && col.keyPos() < 1) {
                beforeImage = 1;
            }
            if (col.keyPos() > 0) {
                keyCols = keyCols + ", key" + Integer.toString(++keyColNum) + " = '" + colName + "' ";
                continue;
            }
            if (!col.versioned()) continue;
            versionedCols = versionedCols + ", ver" + Integer.toString(++verColNum) + " = '" + colName + "' ";
        }
        String trigger = "create trigger update for \"" + owner + "\".\"" + table + "\"" + " class '" + "com.sap.sdb.syncMan.triggerMinDB.ClientUpdateTrigger" + "'" + LINE_SEP + " set " + LINE_SEP + "syncman_user = '" + syncUser + "'" + LINE_SEP + ",syncman_schema = '" + syncSchema + "'" + LINE_SEP + ", shadow_table = '" + shadowTableName + "'" + LINE_SEP + ", version_table = '" + versionTableName + "'" + LINE_SEP + ", sequence_name = '" + "REPLICATION_ID" + "'" + LINE_SEP + ", updater_id = '" + Long.toString(unitID) + "'" + LINE_SEP + ", before_image = " + Integer.toString(beforeImage) + LINE_SEP + ", key_count = " + Integer.toString(keyColNum) + LINE_SEP + keyCols + LINE_SEP + ", column_count = " + Integer.toString(repColumns.size()) + LINE_SEP + cols + ", ver_count = " + Integer.toString(verColNum) + LINE_SEP + versionedCols;
        return trigger;
    }

    private static String buildCreateMinDBDeleteTrigger(String syncUser, String syncSchema, String owner, String table, String shadowTableName, String versionTableName, Vector repColumns, long unitID, boolean bMaster) throws SQLException {
        if (bMaster) {
            throw new SQLException("create MinDB delete trigger on table " + owner + "." + table + " of master database not supported");
        }
        int keyColNum = 0;
        String keyCols = "";
        for (int i = 0; i < repColumns.size(); ++i) {
            ColumnDesc col = (ColumnDesc)repColumns.get(i);
            String colName = col.columnName();
            if (col.keyPos() <= 0) continue;
            keyCols = keyCols + ", key" + Integer.toString(++keyColNum) + " = '" + colName + "' ";
        }
        String deleteTrigger = "create trigger delete for \"" + owner + "\".\"" + table + "\"" + " class '" + "com.sap.sdb.syncMan.triggerMinDB.ClientDeleteTrigger" + "'" + LINE_SEP + " set " + LINE_SEP + "syncman_user = '" + syncUser + "'" + LINE_SEP + ",syncman_schema = '" + syncSchema + "'" + LINE_SEP + ", shadow_table = '" + shadowTableName + "'" + LINE_SEP + ", version_table = '" + versionTableName + "'" + LINE_SEP + ", sequence_name = '" + "REPLICATION_ID" + "'" + LINE_SEP + ", updater_id = '" + Long.toString(unitID) + "'" + LINE_SEP + ", key_count = " + Integer.toString(keyColNum) + LINE_SEP + keyCols + LINE_SEP;
        return deleteTrigger;
    }

    private static String buildCreateMinDBInsertTrigger(String syncUser, String syncSchema, String owner, String table, String shadowTableName, String versionTableName, Vector repColumns, long unitID, boolean bMaster) throws SQLException {
        if (bMaster) {
            throw new SQLException("create MinDB insert trigger on table " + owner + "." + table + " of master database not supported");
        }
        int keyColNum = 0;
        String keyCols = "";
        String cols = "";
        for (int i = 0; i < repColumns.size(); ++i) {
            ColumnDesc col = (ColumnDesc)repColumns.get(i);
            String colName = col.columnName();
            cols = cols + ", col" + Integer.toString(i + 1) + " = '" + colName + "' ";
            if (col.keyPos() <= 0) continue;
            keyCols = keyCols + ", key" + Integer.toString(++keyColNum) + " = '" + colName + "' ";
        }
        String insertTrigger = "create trigger insert for \"" + owner + "\".\"" + table + "\"" + " class '" + "com.sap.sdb.syncMan.triggerMinDB.ClientInsertTrigger" + "'" + LINE_SEP + " set " + LINE_SEP + "syncman_user = '" + syncUser + "'" + LINE_SEP + ",syncman_schema = '" + syncSchema + "'" + LINE_SEP + ", shadow_table = '" + shadowTableName + "'" + LINE_SEP + ", version_table = '" + versionTableName + "'" + LINE_SEP + ", sequence_name = '" + "REPLICATION_ID" + "'" + LINE_SEP + ", row_creator = '" + Long.toString(unitID) + "'" + LINE_SEP + ", key_count = " + Integer.toString(keyColNum) + LINE_SEP + keyCols + LINE_SEP + ", column_count = " + Integer.toString(repColumns.size()) + LINE_SEP + cols;
        return insertTrigger;
    }

    private static String toMD5(String data) throws NoSuchAlgorithmException {
        char[] charArray = data.toCharArray();
        byte[] byteArray = new byte[charArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            byteArray[i] = (byte)charArray[i];
        }
        byte[] md5bytes = MessageDigest.getInstance("MD5").digest(byteArray);
        return Convert.bytesToHexStr(md5bytes);
    }

    public static String makeMsgSvrPassword(String unitPass, String salt) throws NoSuchAlgorithmException {
        return SQLBuilder.toMD5(unitPass + salt);
    }

    private static String getStackTraceAsString(Exception ex) {
        ByteArrayOutputStream byteStream = null;
        PrintWriter printWriter = null;
        String stackTrace = null;
        byteStream = new ByteArrayOutputStream();
        printWriter = new PrintWriter(byteStream, true);
        ex.printStackTrace(printWriter);
        printWriter.flush();
        stackTrace = byteStream.toString();
        printWriter.close();
        return stackTrace;
    }

    public static String getReplicationTypeAsString(int type) {
        if (type == 0) {
            return "INSERT";
        }
        if (type == 1) {
            return "UPDATE";
        }
        if (type == 2) {
            return "DELETE";
        }
        if (type == 3) {
            return "UPD_BEFORE_IMAGE";
        }
        if (type == 4) {
            return "REFRESH_WITH_ACK";
        }
        if (type == 5) {
            return "REFRESH_WITHOUT_ACK";
        }
        if (type == 6) {
            return "ACK_REFRESH_DONE";
        }
        if (type == 7) {
            return "END_OF_TRANS";
        }
        return "unkown replication type:" + Integer.toString(type);
    }

    public static String getConflictTypeAsString(int type) {
        if (type == 0) {
            return "NO_CONFLICT";
        }
        if (type == 1) {
            return "BEFORE_IMAGE_MISMATCH";
        }
        if (type == 2) {
            return "ROW_VERSION_MISMATCH";
        }
        if (type == 4) {
            return "CRITICAL_PHASE";
        }
        if (type == 8) {
            return "DUPLICATE_INSERT";
        }
        if (type == 16) {
            return "ACK_REFRESH_DONE";
        }
        if (type == 32) {
            return "ROW_NOT_FOUND";
        }
        if (type == 64) {
            return "REFRESH_WITH_ACK";
        }
        if (type == 128) {
            return "SEPARATE_END_OF_TRANS";
        }
        if (type == 256) {
            return "REFRESH_OUT_OF_ROW_VERSION";
        }
        return "unkown conflict type:" + Integer.toString(type);
    }
}

