/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.xni.QName;

public class SymbolHash {
    protected int fTableSize = 101;
    protected Entry[] fBuckets;

    public SymbolHash() {
        this.fBuckets = new Entry[this.fTableSize];
    }

    public SymbolHash(int size) {
        this.fTableSize = size;
        this.fBuckets = new Entry[this.fTableSize];
    }

    public String put(String key, Object value) {
        int bucket = this.hash(key) % this.fTableSize;
        Entry entry = this.search(key, bucket);
        if (entry != null) {
            return entry.key;
        }
        this.fBuckets[bucket] = entry = new Entry(key, value, this.fBuckets[bucket]);
        return key;
    }

    public String put(QName qName, Object value) {
        int bucket;
        String key = qName.uri == null ? qName.localpart : qName.uri.concat(qName.localpart);
        Entry entry = this.search(key, bucket = this.hash(key) % this.fTableSize);
        if (entry != null) {
            return entry.key;
        }
        this.fBuckets[bucket] = entry = new Entry(key, value, this.fBuckets[bucket]);
        return entry.key;
    }

    public Object get(String key) {
        int bucket = this.hash(key) % this.fTableSize;
        Entry entry = this.search(key, bucket);
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    public void clear() {
        int i = 0;
        while (i < this.fTableSize) {
            this.fBuckets[i] = new Entry();
            ++i;
        }
    }

    public Object get(QName qName) {
        int bucket;
        String key = qName.uri.concat(qName.localpart);
        Entry entry = this.search(key, bucket = this.hash(key) % this.fTableSize);
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    protected Entry search(String key, int bucket) {
        int length = key.length();
        Entry entry = this.fBuckets[bucket];
        while (entry != null) {
            block4: {
                if (entry.characters != null && length == entry.characters.length) {
                    int i = 0;
                    while (i < length) {
                        if (key.charAt(i) == entry.characters[i]) {
                            ++i;
                            continue;
                        }
                        break block4;
                    }
                    return entry;
                }
            }
            entry = entry.next;
        }
        return null;
    }

    public int hash(String key) {
        int code = 0;
        int length = key.length();
        int i = 0;
        while (i < length) {
            code = code * 37 + key.charAt(i);
            ++i;
        }
        return code & 0x7FFFFFF;
    }

    protected static final class Entry {
        public String key;
        public Object value;
        public char[] characters;
        public Entry next;

        public Entry() {
            this.key = null;
            this.value = null;
            this.characters = null;
            this.next = null;
        }

        public Entry(String key, Object value, Entry next) {
            this.key = key;
            this.value = value;
            this.next = next;
            this.characters = new char[key.length()];
            key.getChars(0, this.characters.length, this.characters, 0);
        }
    }
}

