/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import org.apache.xerces.impl.validation.GrammarPool;
import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.impl.xs.XSMessageFormatter;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.util.SymbolTable;

public class DTDXSParserConfiguration
extends StandardParserConfiguration {
    protected static final String SCHEMA_VALIDATOR = "http://apache.org/xml/properties/internal/validator/schema";
    protected XMLSchemaValidator fSchemaValidator = this.createSchemaValidator();

    public DTDXSParserConfiguration() {
        this((SymbolTable)null, (GrammarPool)null);
    }

    public DTDXSParserConfiguration(SymbolTable symbolTable) {
        this(symbolTable, (GrammarPool)null);
    }

    public DTDXSParserConfiguration(SymbolTable symbolTable, GrammarPool grammarPool) {
        super(symbolTable, grammarPool);
        if (this.fSchemaValidator != null) {
            this.fProperties.put(SCHEMA_VALIDATOR, this.fSchemaValidator);
            this.addComponent(this.fSchemaValidator);
        }
        if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
            XSMessageFormatter xmft = new XSMessageFormatter();
            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", xmft);
        }
    }

    protected void configurePipeline() {
        super.configurePipeline();
        if (this.fSchemaValidator != null) {
            this.fNamespaceBinder.setDocumentHandler(this.fSchemaValidator);
            this.fSchemaValidator.setDocumentHandler(this.fDocumentHandler);
        }
    }

    protected XMLSchemaValidator createSchemaValidator() {
        return new XMLSchemaValidator();
    }
}

