/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.AbstractDatatypeValidator;
import org.apache.xerces.impl.dv.xs.AbstractNumericValidator;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.ListDatatypeValidator;
import org.apache.xerces.impl.validation.ValidationContext;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.apache.xerces.impl.xs.SchemaSymbols;

public class UnionDatatypeValidator
extends AbstractDatatypeValidator {
    private boolean fIsRestriction;
    private Vector fBaseValidators;
    private int fValidatorsSize;
    private Vector fEnumeration;
    private StringBuffer errorMsg;

    public UnionDatatypeValidator() {
        this(null, null, false, null);
    }

    public UnionDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedBy, XMLErrorReporter reporter) {
        block8: {
            this.fIsRestriction = false;
            this.fBaseValidators = null;
            this.fValidatorsSize = 0;
            this.fEnumeration = null;
            this.errorMsg = null;
            this.fErrorReporter = reporter;
            this.fBaseValidator = base;
            this.fIsRestriction = true;
            try {
                if (facets == null) break block8;
                Enumeration e = facets.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (key.equals(SchemaSymbols.ELT_ENUMERATION)) {
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                        this.fEnumeration = (Vector)facets.get(key);
                        continue;
                    }
                    if (key.equals(SchemaSymbols.ELT_PATTERN)) {
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                        this.fPattern = (String)facets.get(key);
                        this.fRegex = new RegularExpression(this.fPattern, "X");
                        continue;
                    }
                    String msg = "union datatype, facet " + key + " with value " + (String)facets.get(key);
                    throw new InvalidDatatypeFacetException(msg);
                }
                if (base == null || (this.fFacetsDefined & 0x10) == 0 || this.fEnumeration == null) break block8;
                int i = 0;
                try {
                    while (i < this.fEnumeration.size()) {
                        base.validate((String)this.fEnumeration.elementAt(i), null);
                        ++i;
                    }
                }
                catch (Exception idve) {
                    throw new InvalidDatatypeFacetException("Value of enumeration = '" + this.fEnumeration.elementAt(i) + "' must be from the value space of base.");
                }
            }
            catch (Exception e) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "DatatypeFacetError", new Object[]{e.getMessage()}, (short)1);
            }
        }
    }

    public UnionDatatypeValidator(Vector base, XMLErrorReporter reporter) {
        this.fIsRestriction = false;
        this.fBaseValidators = null;
        this.fValidatorsSize = 0;
        this.fEnumeration = null;
        this.errorMsg = null;
        this.fErrorReporter = reporter;
        this.fIsRestriction = false;
        if (base != null) {
            this.fValidatorsSize = base.size();
            this.fBaseValidators = base;
            if (this.fValidatorsSize > 0) {
                this.fBaseValidator = (DatatypeValidator)base.elementAt(0);
            }
        }
    }

    public Object validate(String content, ValidationContext state) throws InvalidDatatypeValueException {
        if (content == null && state != null) {
            this.fBaseValidator.validate(content, state);
        } else {
            this.checkContentEnum(content, state, false, null);
        }
        return null;
    }

    public Hashtable getFacets() {
        return null;
    }

    public int compare(String value1, String value2) {
        if (this.fIsRestriction) {
            return this.fBaseValidator.compare(value1, value2);
        }
        int index = -1;
        while (++index < this.fValidatorsSize) {
            DatatypeValidator currentDV = (DatatypeValidator)this.fBaseValidators.elementAt(index);
            if (currentDV.compare(value1, value2) != 0) continue;
            return 0;
        }
        return -1;
    }

    public Object clone() throws CloneNotSupportedException {
        UnionDatatypeValidator newObj = null;
        newObj = new UnionDatatypeValidator();
        newObj.fLocale = this.fLocale;
        newObj.fBaseValidator = this.fBaseValidator;
        newObj.fBaseValidators = (Vector)this.fBaseValidators.clone();
        newObj.fPattern = this.fPattern;
        newObj.fEnumeration = this.fEnumeration;
        newObj.fFacetsDefined = this.fFacetsDefined;
        return newObj;
    }

    public Vector getBaseValidators() {
        return this.fBaseValidators;
    }

    private boolean verifyEnum(Vector vector) {
        if ((this.fFacetsDefined & 0x10) != 0) {
            Enumeration e = vector.elements();
            while (e.hasMoreElements()) {
                if (this.fEnumeration.contains(e.nextElement())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected void checkContentEnum(String content, ValidationContext state, boolean pattern, Vector enumeration) throws InvalidDatatypeValueException {
        index = -1;
        valid = false;
        currentDV = null;
        if (!this.fIsRestriction) ** GOTO lbl42
        if ((this.fFacetsDefined & 8) != 0) {
            if (this.fRegex == null || !this.fRegex.matches(content)) {
                throw new InvalidDatatypeValueException("Value '" + content + "' does not match regular expression facet '" + this.fPattern + "'.");
            }
            pattern = true;
        }
        if (enumeration != null) {
            if (!this.verifyEnum(enumeration)) {
                throw new InvalidDatatypeValueException("Enumeration '" + enumeration + "' for value '" + content + "' is based on enumeration '" + this.fEnumeration + "'");
            }
        } else {
            enumeration = this.fEnumeration != null ? this.fEnumeration : null;
        }
        ((UnionDatatypeValidator)this.fBaseValidator).checkContentEnum(content, state, pattern, enumeration);
        return;
lbl-1000:
        // 1 sources

        {
            currentDV = (DatatypeValidator)this.fBaseValidators.elementAt(index);
            if (valid) break;
            try {
                if (currentDV instanceof ListDatatypeValidator) {
                    if (pattern) {
                        throw new InvalidDatatypeValueException("Facet \"Pattern\" can not be applied to a list datatype");
                    }
                    ((ListDatatypeValidator)currentDV).checkContentEnum(content, state, enumeration);
                } else if (currentDV instanceof UnionDatatypeValidator) {
                    ((UnionDatatypeValidator)currentDV).checkContentEnum(content, state, pattern, enumeration);
                } else if (enumeration != null) {
                    if (currentDV instanceof AbstractNumericValidator) {
                        ((AbstractNumericValidator)currentDV).checkContentEnum(content, state, enumeration);
                    } else {
                        if (!enumeration.contains(content)) {
                            throw new InvalidDatatypeValueException("Value '" + content + "' must be one of " + enumeration);
                        }
                        currentDV.validate(content, state);
                    }
                } else {
                    currentDV.validate(content, state);
                }
                valid = true;
                continue;
            }
            catch (InvalidDatatypeValueException e) {
                // empty catch block
            }
lbl42:
            // 3 sources

            ** while (++index < this.fValidatorsSize)
        }
lbl43:
        // 2 sources

        if (!valid) {
            throw new InvalidDatatypeValueException("Content '" + content + "' does not match any union types");
        }
    }
}

