/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.util.Hashtable;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.AbstractStringValidator;
import org.apache.xerces.impl.dv.xs.DatatypeMessageProvider;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;
import org.apache.xerces.impl.validation.ValidationContext;

public class NOTATIONDatatypeValidator
extends AbstractStringValidator {
    public NOTATIONDatatypeValidator() {
        this(null, null, false, null);
    }

    public NOTATIONDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList, XMLErrorReporter reporter) {
        super(base, facets, derivedByList, reporter);
    }

    protected void assignAdditionalFacets(String key, Hashtable facets) throws InvalidDatatypeFacetException {
        String msg = this.getErrorString(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.ILLEGAL_STRING_FACET], new Object[]{key});
        throw new InvalidDatatypeFacetException(msg);
    }

    public Object validate(String content, ValidationContext state) throws InvalidDatatypeValueException {
        this.checkContent(content, state, false);
        return null;
    }

    protected void checkContent(String content, ValidationContext state, boolean asBase) throws InvalidDatatypeValueException {
        if (this.fBaseValidator instanceof NOTATIONDatatypeValidator) {
            ((NOTATIONDatatypeValidator)this.fBaseValidator).checkContent(content, state, true);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(content))) {
            throw new InvalidDatatypeValueException("Value '" + content + "' does not match regular expression facet '" + this.fPattern + "'.");
        }
        if (this.fTokenType != "NONE") {
            AbstractStringValidator.validateToken(this.fTokenType, content);
        }
        if (asBase) {
            return;
        }
        int length = this.getLength(content);
        if (state != null && (this.fFacetsDefined & 0x10) != 0 && this.fEnumeration != null) {
            String prefix = "";
            String localpart = content;
            int colonptr = content.indexOf(":");
            if (colonptr > 0) {
                prefix = content.substring(0, colonptr);
                localpart = content.substring(colonptr + 1);
            }
            String uriStr = state.getURI(state.getSymbol(prefix));
            String fullName = null;
            if (uriStr == null) {
                if (prefix.length() != 0) {
                    throw new InvalidDatatypeValueException("Cannot resolve the prefix of the NOTATION  value '" + content + "'");
                }
                fullName = localpart;
            } else {
                fullName = uriStr + "," + localpart;
            }
            if (!this.fEnumeration.contains(fullName)) {
                throw new InvalidDatatypeValueException("Value '" + content + "' must be one of " + this.fEnumeration);
            }
        }
    }

    protected void checkValueSpace(String content) throws InvalidDatatypeValueException {
    }

    public int compare(String content1, String content2) {
        return content1.equals(content2) ? 0 : -1;
    }
}

