/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.util.Hashtable;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.DateTimeValidator;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class DayDatatypeValidator
extends DateTimeValidator {
    private static final int DAY_SIZE = 5;

    public DayDatatypeValidator() {
    }

    public DayDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList, XMLErrorReporter reporter) {
        super(base, facets, derivedByList, reporter);
    }

    protected int[] parse(String str, int[] date) throws SchemaDateTimeException {
        this.resetBuffer(str);
        if (date == null) {
            date = new int[8];
        }
        this.resetDateObj(date);
        if (this.fBuffer.charAt(0) != '-' || this.fBuffer.charAt(1) != '-' || this.fBuffer.charAt(2) != '-') {
            throw new SchemaDateTimeException("Error in day parsing");
        }
        date[0] = 2000;
        date[1] = 1;
        date[2] = this.parseInt(this.fStart + 3, this.fStart + 5);
        if (5 < this.fEnd) {
            int sign = this.findUTCSign(5, this.fEnd);
            if (sign < 0) {
                throw new SchemaDateTimeException("Error in day parsing");
            }
            this.getTimeZone(date, sign);
        }
        this.validateDateTime(date);
        if (date[7] != 0 && date[7] != 90) {
            this.normalize(date);
        }
        return date;
    }

    protected String dateToString(int[] date) {
        this.message.setLength(0);
        this.message.append('-');
        this.message.append('-');
        this.message.append('-');
        this.message.append(date[2]);
        this.message.append((char)date[7]);
        return this.message.toString();
    }
}

