/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.AbstractNumericFacetValidator;
import org.apache.xerces.impl.dv.xs.DatatypeMessageProvider;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;
import org.apache.xerces.impl.validation.ValidationContext;

public abstract class AbstractNumericValidator
extends AbstractNumericFacetValidator {
    public AbstractNumericValidator() {
        super(null, null, false, null);
    }

    public AbstractNumericValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList, XMLErrorReporter reporter) {
        super(base, facets, derivedByList, reporter);
    }

    public Object validate(String content, ValidationContext state) throws InvalidDatatypeValueException {
        this.checkContent(content, state, null, false);
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    protected void checkContentEnum(String content, ValidationContext state, Vector enumeration) throws InvalidDatatypeValueException {
        this.checkContent(content, state, enumeration, false);
    }

    protected abstract void checkContent(String var1, ValidationContext var2, Vector var3, boolean var4) throws InvalidDatatypeValueException;

    protected void boundsCheck(Object d) throws InvalidDatatypeValueException {
        int compare;
        boolean minOk = true;
        boolean maxOk = true;
        String upperBound = "";
        String lowerBound = "";
        String lowerBoundIndicator = "";
        String upperBoundIndicator = "";
        if ((this.fFacetsDefined & 0x20) != 0) {
            compare = this.compareValues(d, this.fMaxInclusive);
            maxOk = compare != 1;
            upperBound = this.getMaxInclusive(false);
            if (upperBound != null) {
                upperBoundIndicator = "<=";
            } else {
                upperBound = "";
            }
        }
        if ((this.fFacetsDefined & 0x40) != 0) {
            compare = this.compareValues(d, this.fMaxExclusive);
            maxOk = compare == -1;
            upperBound = this.getMaxExclusive(false);
            if (upperBound != null) {
                upperBoundIndicator = "<";
            } else {
                upperBound = "";
            }
        }
        if ((this.fFacetsDefined & 0x80) != 0) {
            compare = this.compareValues(d, this.fMinInclusive);
            minOk = compare != -1;
            lowerBound = this.getMinInclusive(false);
            if (lowerBound != null) {
                lowerBoundIndicator = "<=";
            } else {
                lowerBound = "";
            }
        }
        if ((this.fFacetsDefined & 0x100) != 0) {
            compare = this.compareValues(d, this.fMinExclusive);
            minOk = compare == 1;
            lowerBound = this.getMinExclusive(false);
            if (lowerBound != null) {
                lowerBoundIndicator = "<";
            } else {
                lowerBound = "";
            }
        }
        if (!minOk || !maxOk) {
            String msg = this.getErrorString(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.OUT_OF_BOUNDS], new Object[]{d.toString(), lowerBound, upperBound, lowerBoundIndicator, upperBoundIndicator});
            throw new InvalidDatatypeValueException(msg);
        }
    }
}

