/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.dtd;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import org.apache.xerces.impl.dv.dtd.DatatypeValidator;
import org.apache.xerces.impl.dv.dtd.DatatypeValidatorFactory;
import org.apache.xerces.impl.dv.dtd.ENTITYDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.IDDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.IDREFDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.dtd.ListDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.NMTOKENDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.NOTATIONDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.StringDatatypeValidator;

public class DatatypeValidatorFactoryImpl
implements DatatypeValidatorFactory {
    private static final boolean fDebug = false;
    protected static final Hashtable fgBaseTypes = new Hashtable();
    protected static boolean fgRegistryExpanded = false;
    protected Hashtable fUserDefinedTypes = new Hashtable();
    static /* synthetic */ Class class$org$apache$xerces$impl$dv$dtd$DatatypeValidatorFactoryImpl;
    static /* synthetic */ Class class$org$apache$xerces$impl$dv$dtd$DatatypeValidator;
    static /* synthetic */ Class class$java$util$Hashtable;

    public void initializeDTDRegistry() {
        if (!fgRegistryExpanded) {
            try {
                fgBaseTypes.put("string", new StringDatatypeValidator());
                fgBaseTypes.put("ID", new IDDatatypeValidator());
                fgBaseTypes.put("IDREF", new IDREFDatatypeValidator());
                fgBaseTypes.put("ENTITY", new ENTITYDatatypeValidator());
                fgBaseTypes.put("NOTATION", new NOTATIONDatatypeValidator());
                this.createDatatypeValidator("IDREFS", new IDREFDatatypeValidator(), null, true);
                this.createDatatypeValidator("ENTITIES", new ENTITYDatatypeValidator(), null, true);
                this.createDatatypeValidator("NMTOKEN", new NMTOKENDatatypeValidator(), null, false);
                this.createDatatypeValidator("NMTOKENS", this.getDatatypeValidator("NMTOKEN"), null, true);
            }
            catch (InvalidDatatypeFacetException ex) {
                ex.printStackTrace();
            }
            catch (InvalidDatatypeValueException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void resetRegistry() {
        if (fgBaseTypes != null) {
            fgBaseTypes.clear();
            fgRegistryExpanded = false;
        }
    }

    public DatatypeValidator createDatatypeValidator(String name, DatatypeValidator base, Hashtable facets, boolean list) throws InvalidDatatypeFacetException, InvalidDatatypeValueException {
        DatatypeValidator simpleType = null;
        if (false) {
            System.out.println("type name = " + name);
        }
        if (base == null) {
            Class clazz = class$org$apache$xerces$impl$dv$dtd$DatatypeValidatorFactoryImpl == null ? (class$org$apache$xerces$impl$dv$dtd$DatatypeValidatorFactoryImpl = DatatypeValidatorFactoryImpl.class$("org.apache.xerces.impl.dv.dtd.DatatypeValidatorFactoryImpl")) : class$org$apache$xerces$impl$dv$dtd$DatatypeValidatorFactoryImpl;
            synchronized (clazz) {
                if (!fgBaseTypes.containsKey(name) && !fgBaseTypes.containsKey("NMTOKEN")) {
                    this.initializeDTDRegistry();
                }
            }
            base = this.getDatatypeValidator(name);
        }
        if (base != null) {
            if (list) {
                simpleType = new ListDatatypeValidator(base, facets, list);
            } else {
                try {
                    Class<?> validatorDef = base.getClass();
                    Class[] validatorArgsClass = new Class[]{class$org$apache$xerces$impl$dv$dtd$DatatypeValidator == null ? (class$org$apache$xerces$impl$dv$dtd$DatatypeValidator = DatatypeValidatorFactoryImpl.class$("org.apache.xerces.impl.dv.dtd.DatatypeValidator")) : class$org$apache$xerces$impl$dv$dtd$DatatypeValidator, class$java$util$Hashtable == null ? (class$java$util$Hashtable = DatatypeValidatorFactoryImpl.class$("java.util.Hashtable")) : class$java$util$Hashtable, Boolean.TYPE};
                    Object[] validatorArgs = new Object[]{base, facets, Boolean.FALSE};
                    Constructor<?> validatorConstructor = validatorDef.getConstructor(validatorArgsClass);
                    simpleType = (DatatypeValidator)DatatypeValidatorFactoryImpl.createDatatypeValidator(validatorConstructor, validatorArgs);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            if (simpleType != null) {
                this.addValidator(name, simpleType);
            }
        }
        return simpleType;
    }

    private static Object createDatatypeValidator(Constructor validatorConstructor, Object[] arguments) throws InvalidDatatypeFacetException {
        Object validator = null;
        try {
            validator = validatorConstructor.newInstance(arguments);
            return validator;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            throw new InvalidDatatypeFacetException(e.getTargetException().getMessage());
        }
    }

    public DatatypeValidator getDatatypeValidator(String type) {
        DatatypeValidator validator = (DatatypeValidator)this.fUserDefinedTypes.get(type);
        if (validator == null) {
            validator = (DatatypeValidator)fgBaseTypes.get(type);
        }
        return validator;
    }

    private void addValidator(String name, DatatypeValidator v) {
        this.fUserDefinedTypes.put(name, v);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

