/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest2.util;

import com.sap.sapdb.upgradetest2.util.Logger;
import com.sap.sapdb.upgradetest2.util.StringJoiner;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;

public class Executor {
    private String[] cmdline;
    private String[] envp;
    private File workdir;
    private File logfile;
    private String input;
    private ParallelStreamReader stdoutR;
    private ParallelStreamReader stderrR;
    private Process process;

    public Executor(String[] stringArray) throws IllegalArgumentException {
        this(stringArray, null, null, null, null);
    }

    public Executor(String[] stringArray, String[] stringArray2, File file, String string) throws IllegalArgumentException {
        this(stringArray, stringArray2, file, string, null);
    }

    public Executor(String[] stringArray, String[] stringArray2, File file, String string, File file2) throws IllegalArgumentException {
        if (stringArray == null) {
            throw new IllegalArgumentException("Can't call with a cmdline == null");
        }
        this.cmdline = stringArray;
        this.envp = stringArray2;
        this.workdir = file;
        this.input = string;
        this.setLogfile(file2);
    }

    public void setLogfile(File file) {
        if (file != null) {
            Logger.log(Logger.VERBOSE, "Setting logfile to " + file.toString());
            this.logfile = file;
        }
    }

    public int run() {
        return this.run(false);
    }

    public int run(boolean bl) {
        Logger.log(Logger.VERBOSE, "UpgradeTest.Executor: preparing to call " + this.cmdline[0]);
        if (this.cmdline.length > 1) {
            Logger.log(Logger.VERBOSE, "UpgradeTest.Executor: arguments: " + StringJoiner.join(this.cmdline, 1, " "));
        } else {
            Logger.log(Logger.VERBOSE, "UpgradeTest.Executor: no arguments");
        }
        if (bl) {
            Logger.log(Logger.VERBOSE, "UpgradeTest.Executor: running FAKE - returning without calling the program!");
            return 0;
        }
        if (this.envp != null) {
            Logger.log(Logger.DEBUG, "UpgradeTest.Executor: environment is: ");
            int n = 0;
            while (n < this.envp.length) {
                Logger.log(Logger.DEBUG, "          * " + this.envp[n]);
                ++n;
            }
        }
        try {
            this.process = Runtime.getRuntime().exec(this.cmdline, this.envp, this.workdir);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Logger.log(Logger.VERBOSE, "UpgradeTest.Executor.run(): failed w/ Exception " + iOException.getMessage());
            return -1;
        }
        try {
            if (this.logfile != null) {
                if (this.logfile.exists() && this.logfile.isFile()) {
                    if (!this.logfile.canWrite()) {
                        Logger.error("UpgradeTest.Executor: Can't write to existing logfile!");
                        this.logfile = null;
                    }
                } else if (!this.logfile.exists()) {
                    if (!this.logfile.createNewFile()) {
                        Logger.error("UpgradeTest.Executor: Failed to create logfile!");
                        this.logfile = null;
                    }
                } else {
                    Logger.error("UpgradeTest.Executor: Can't log to a directory!");
                    this.logfile = null;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.stdoutR = new ParallelStreamReader(this.process.getInputStream(), this.logfile);
            this.stderrR = new ParallelStreamReader(this.process.getErrorStream(), this.logfile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.stackTrace(fileNotFoundException);
        }
        this.stdoutR.start();
        this.stderrR.start();
        if (this.input != null && !this.input.equals("")) {
            OutputStream outputStream = this.process.getOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            try {
                Logger.log(Logger.VERBOSE, "UpgradeTest.Executor: Input to program: \n" + this.input);
                Logger.log(Logger.VERBOSE, "UpgradeTest.Executor: End of input to program.");
                bufferedWriter.write(this.input);
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                Logger.log(Logger.VERBOSE, "Executor: writing input to the program failed with exception " + iOException.getMessage());
                return -1;
            }
        }
        Logger.log(Logger.DEBUG, "Waiting for process...");
        try {
            this.process.waitFor();
            this.stdoutR.join(100L);
            this.stderrR.join(100L);
        }
        catch (InterruptedException interruptedException) {
            Logger.error("Executor: got interrupted while waiting for process - this should not happen at all " + interruptedException.getMessage());
        }
        return this.process.exitValue();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"perl", "c:/SapDevelop/Devtool/bin/packdistrib.pl", "-profile", "\"APO LiveCache\"", "-os", "AIX564", "-version", "740216", "-build_cd", "-dir", "c:/tmp", "-lca_version", "310015"};
        Executor executor = new Executor(stringArray2);
        executor.run();
    }

    private class ParallelStreamReader
    extends Thread {
        private BufferedReader br;
        private PrintStream ps;
        private boolean logToFile = false;

        public ParallelStreamReader(InputStream inputStream) throws FileNotFoundException {
            this(inputStream, null);
        }

        public ParallelStreamReader(InputStream inputStream, File file) throws FileNotFoundException {
            this.br = new BufferedReader(new InputStreamReader(inputStream));
            if (file != null) {
                this.ps = new PrintStream(new FileOutputStream(file));
                this.logToFile = true;
            }
        }

        public void run() {
            try {
                String string;
                while ((string = this.br.readLine()) != null) {
                    if (this.logToFile) {
                        this.ps.println(string);
                        continue;
                    }
                    Logger.log(Logger.VERBOSE, string);
                }
                this.br.close();
                if (this.logToFile) {
                    this.ps.close();
                }
            }
            catch (IOException iOException) {
                Logger.error("An IOException occured when reading from a programs Output/Error-Stream " + iOException.getMessage());
            }
        }
    }
}

