/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest2;

import com.sap.sapdb.upgradetest2.Configuration;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ConfigurationTest
extends TestCase {
    private Configuration conf;
    static /* synthetic */ Class class$com$sap$sapdb$upgradetest2$ConfigurationTest;

    public ConfigurationTest(String string) {
        super(string);
    }

    private static void db(Object object) {
        System.out.println(object);
    }

    protected void setUp() throws Exception {
        this.conf = new Configuration("89346");
    }

    protected void tearDown() throws Exception {
        this.conf.destroy();
        this.conf = null;
    }

    public void testAssociatedLCMakes() throws Exception {
        Configuration.LCMakeTableRow lCMakeTableRow;
        Configuration.LCMakeTableRowIterator lCMakeTableRowIterator = this.conf.getMiddleRelease().associatedLCMakes();
        while ((lCMakeTableRow = lCMakeTableRowIterator.next()) != null) {
        }
    }

    public void testUpgradableMakes() throws Exception {
        Configuration.MakeTableRow makeTableRow;
        Configuration.MakeTableRow makeTableRow2 = this.conf.getMiddleRelease();
        Configuration.MakeTableRowIterator makeTableRowIterator = makeTableRow2.lowerUpgradableOLTPMakes();
        while ((makeTableRow = makeTableRowIterator.next()) != null) {
        }
        makeTableRowIterator = makeTableRow2.lowerUpgradableLCMakes();
        while ((makeTableRow = makeTableRowIterator.next()) != null) {
        }
    }

    public void testPlatforms() {
        Configuration.PlatformRowIterator platformRowIterator = this.conf.platforms();
        while (platformRowIterator.hasNext()) {
            Configuration.Platform platform = platformRowIterator.next();
            String string = platform.descText.toUpperCase();
        }
    }

    public void testLowerHigher() throws Exception {
        Configuration.MakeTableRowIterator makeTableRowIterator;
        Configuration.MakeTableRow makeTableRow = this.conf.getMiddleRelease();
        String[] stringArray = makeTableRow.higherRelevantOLTPVersions();
        String[] stringArray2 = makeTableRow.lowerRelevantOLTPVersions();
        String[] stringArray3 = makeTableRow.higherRelevantLiveCacheVersions();
        String[] stringArray4 = makeTableRow.lowerRelevantLiveCacheVersions();
        int n = 0;
        while (n < stringArray2.length) {
            String string = stringArray2[n];
            makeTableRowIterator = makeTableRow.lowerUpgradableOLTPMakes(string);
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            makeTableRowIterator = makeTableRow.higherUpgradableOLTPMakes(string);
            ++n2;
        }
        int n3 = 0;
        while (n3 < stringArray4.length) {
            String string = stringArray4[n3];
            makeTableRowIterator = this.conf.lowerUpgradableLCMakes(string, makeTableRow);
            ++n3;
        }
        int n4 = 0;
        while (n4 < stringArray3.length) {
            String string = stringArray3[n4];
            makeTableRowIterator = this.conf.higherUpgradableLCMakes(string, makeTableRow);
            ++n4;
        }
    }

    public void testConditions() throws Exception {
        Configuration.OLTPVC oLTPVC = this.conf.oltpConditionForTarget(this.conf.getMiddleRelease());
        Assert.assertNotNull((Object)oLTPVC);
    }

    public void testRelevantOLTPVersions() throws Exception {
        Object object;
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        boolean bl = this.conf.getMiddleRelease().isLiveCacheRelevant();
        Assert.assertTrue((boolean)bl);
        String[] stringArray4 = this.conf.getMiddleRelease().higherRelevantOLTPVersions();
        int n = 0;
        while (n < stringArray4.length) {
            stringArray3 = stringArray4[n];
            Configuration.MakeTableRowIterator makeTableRowIterator = this.conf.getMiddleRelease().relevantOLTPMakes((String)stringArray3);
            while ((stringArray2 = makeTableRowIterator.next()) != null) {
            }
            ++n;
        }
        stringArray3 = this.conf.getMiddleRelease().lowerRelevantOLTPVersions();
        int n2 = 0;
        while (n2 < stringArray3.length) {
            stringArray2 = stringArray3[n2];
            Configuration.MakeTableRowIterator makeTableRowIterator = this.conf.getMiddleRelease().relevantOLTPMakes((String)stringArray2);
            while ((stringArray = makeTableRowIterator.next()) != null) {
            }
            ++n2;
        }
        stringArray2 = this.conf.getMiddleRelease().higherRelevantLiveCacheVersions();
        int n3 = 0;
        while (n3 < stringArray2.length) {
            stringArray = stringArray2[n3];
            Configuration.MakeTableRowIterator makeTableRowIterator = this.conf.getMiddleRelease().relevantLiveCacheMakes((String)stringArray);
            while ((object = makeTableRowIterator.next()) != null) {
            }
            ++n3;
        }
        stringArray = this.conf.getMiddleRelease().lowerRelevantLiveCacheVersions();
        int n4 = 0;
        while (n4 < stringArray.length) {
            Configuration.MakeTableRow makeTableRow;
            object = stringArray[n4];
            Configuration.MakeTableRowIterator makeTableRowIterator = this.conf.getMiddleRelease().relevantLiveCacheMakes((String)object);
            while ((makeTableRow = makeTableRowIterator.next()) != null) {
            }
            ++n4;
        }
    }

    public void testMatches() throws Exception {
        Configuration.MakeTableRow makeTableRow = this.conf.new Configuration.MakeTableRow();
        makeTableRow.version = "7403";
        makeTableRow.build = "26";
        Configuration.OLTPVC oLTPVC = new Configuration.OLTPVC("74", 3, 10000, 25);
        Assert.assertTrue((boolean)oLTPVC.matches(makeTableRow));
        makeTableRow.version = "7403";
        makeTableRow.build = "07";
        oLTPVC = new Configuration.OLTPVC("74", 3, -1);
        Assert.assertTrue((boolean)oLTPVC.matches(makeTableRow));
    }

    public void testUpgradableOLTPMakes() throws Exception {
        Configuration.MakeTableRow makeTableRow;
        Configuration.MakeTableRowIterator makeTableRowIterator = this.conf.getMiddleRelease().lowerUpgradableOLTPMakes();
        while ((makeTableRow = makeTableRowIterator.next()) != null) {
        }
        makeTableRowIterator = this.conf.getMiddleRelease().higherUpgradableOLTPMakes();
        while ((makeTableRow = makeTableRowIterator.next()) != null) {
        }
    }

    public void testUpgradableLCMakes() throws Exception {
        Configuration.MakeTableRow makeTableRow;
        Configuration.MakeTableRowIterator makeTableRowIterator = this.conf.getMiddleRelease().lowerUpgradableLCMakes();
        while ((makeTableRow = makeTableRowIterator.next()) != null) {
        }
        makeTableRowIterator = this.conf.getMiddleRelease().higherUpgradableLCMakes();
        while ((makeTableRow = makeTableRowIterator.next()) != null) {
        }
    }

    public void testLowerVersions() throws Exception {
        String[] stringArray = new String[]{"7600", "7700"};
        String string = "7700";
        String[] stringArray2 = Configuration.lowerVersions(stringArray, string, true);
        Assert.assertNotNull((Object)stringArray2);
        Assert.assertEquals((int)2, (int)stringArray2.length);
    }

    public void testHigherVersions() throws Exception {
        String[] stringArray = new String[]{"7600", "7700"};
        String string = "7600";
        String[] stringArray2 = Configuration.higherVersions(stringArray, string, false);
        Assert.assertNotNull((Object)stringArray2);
        Assert.assertEquals((int)1, (int)stringArray2.length);
        Assert.assertEquals((String)"7700", (String)stringArray2[0]);
    }

    public void testPlatform() throws Exception {
        Configuration.PlatformRowIterator platformRowIterator = this.conf.platforms();
        while (platformRowIterator.hasNext()) {
            Configuration.Platform platform = platformRowIterator.next();
        }
    }

    public void testVersionComparison() throws Exception {
        String[] stringArray = this.conf.higherRelevantLiveCacheVersions("7500");
        Assert.assertNotNull((Object)stringArray);
        Assert.assertEquals((int)2, (int)stringArray.length);
        Assert.assertEquals((String)"7600", (String)stringArray[0]);
        Assert.assertEquals((String)"7700", (String)stringArray[1]);
        stringArray = this.conf.higherRelevantOLTPVersions("7500");
        Assert.assertNotNull((Object)stringArray);
        Assert.assertEquals((int)2, (int)stringArray.length);
        Assert.assertEquals((String)"7600", (String)stringArray[0]);
        Assert.assertEquals((String)"7700", (String)stringArray[1]);
        stringArray = this.conf.lowerRelevantLiveCacheVersions("7500");
        Assert.assertNotNull((Object)stringArray);
        Assert.assertEquals((int)3, (int)stringArray.length);
        Assert.assertEquals((String)"7402", (String)stringArray[0]);
        Assert.assertEquals((String)"7403", (String)stringArray[1]);
        Assert.assertEquals((String)"7500", (String)stringArray[2]);
        stringArray = this.conf.lowerRelevantLiveCacheVersions("7700");
        Assert.assertNotNull((Object)stringArray);
        Assert.assertEquals((int)5, (int)stringArray.length);
        Assert.assertEquals((String)"7402", (String)stringArray[0]);
        Assert.assertEquals((String)"7700", (String)stringArray[4]);
        stringArray = this.conf.higherRelevantLiveCacheVersions("7402");
        Assert.assertNotNull((Object)stringArray);
        Assert.assertEquals((int)4, (int)stringArray.length);
    }

    public static Test suite() {
        return new TestSuite(class$com$sap$sapdb$upgradetest2$ConfigurationTest == null ? (class$com$sap$sapdb$upgradetest2$ConfigurationTest = ConfigurationTest.class$("com.sap.sapdb.upgradetest2.ConfigurationTest")) : class$com$sap$sapdb$upgradetest2$ConfigurationTest);
    }

    public static void main(String[] stringArray) throws Exception {
        TestRunner.run((Test)ConfigurationTest.suite());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

