/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest2;

import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class Configuration {
    static final Platform LINUXS390X = new Platform("linuxs390x;linux;Linux S390X;Linux S390X;null;LINUX390X;18");
    static final Platform LINUX2_6IA32 = new Platform("linux2.6ia32;linux;Linux 2.6 on i386;Linux;2.6;SLES9;21");
    static final Platform RS6000_51 = new Platform("rs6000_51;aix;AIX 5.1 on PPC, 32 Bit only;null;null;AIX532;11");
    static final Platform LINUXINTEL = new Platform("linuxintel;linux;Linux on x86;null;null;LINUX32;6");
    static final Platform LINUXIA64 = new Platform("linuxia64;linux;Linux on IA64;null;null;LINUX64;13");
    static final Platform LINUX2_6IA64 = new Platform("linux2.6ia64;linux;Linux 2.6 on itanium;Linux;2.6;SLES9;20");
    static final Platform HPIA64 = new Platform("hpia64;hpux;HP-UX on IA64 (HP-IPF);HP-UX;11;HPIA64;14");
    static final Platform RS6000_64 = new Platform("rs6000_64;aix;AIX 4.3 on PPC;null;null;AIX64;4");
    static final Platform SUN_64 = new Platform("sun_64;solaris;SunOS on Sparc;null;null;SUN64;1");
    static final Platform NTINTEL = new Platform("NTintel;MSWin32;null;null;null;WIN32;7");
    static final Platform SUN = new Platform("sun;solaris;SunOS on Sparc, 32 Bit only;null;null;SUN32;9");
    static final Platform HP_64 = new Platform("hp_64;hpux;HP-UX on HPPA;null;null;HP64;5");
    static final Platform NTX86_64 = new Platform("NTx86_64;MSWin32;Windows on Opteron/Nocona;Windows;2003;null;19");
    static final Platform LINUXX86_64 = new Platform("linuxx86_64;linux;Linux on Opteron/Nocona;Linux;null;LINUXX8664;16");
    static final Platform LINUXPPC64 = new Platform("linuxppc64;linux;Linux on PPC;Linux;null;LINUXPPC64;15");
    static final Platform RS6000_52_64 = new Platform("rs6000_52_64;aix;AIX 5.2 PPC;AIX;5.2;AIX564;17");
    static final Platform ALPHAOSF = new Platform("alphaosf;dec_osf;Tru64 on Alpha;null;null;DEC64;2");
    static final Platform RS6000 = new Platform("rs6000;aix;AIX 4.3 on PPC, 32 Bit only;null;null;AIX32;10");
    static final Platform HP = new Platform("hp;hpux;HP-UX on HPPA, 21 Bit only;null;null;HP32;12");
    static final Platform RS6000_51_64 = new Platform("rs6000_51_64;aix;AIX 5.1 on PPC;null;null;AIX564;3");
    static final Platform NTIA64 = new Platform("NTia64;MSWin32;null;null;null;WIN64;8");
    Connection conn;
    Collection PLATFORMS;
    String[] OLTPVERSIONS;
    String[] OLTP7300BUILDS;
    String[] OLTP7402BUILDS;
    String[] OLTP7403BUILDS;
    String[] OLTP7500BUILDS;
    String[] OLTP7600BUILDS;
    HashMap OLTPRELEVANT;
    MakeTableRow[] OLTP73MAKES;
    String[] LCVERSIONS;
    String[] LC7402BUILDS;
    String[] LC7403BUILDS;
    String[] LC7500BUILDS;
    String[] LC7600BUILDS;
    HashMap LCRELEVANT;
    OLTPVC[] OLTPUPGRADETARGETS;
    OLTPVC[] OLTP_72_GT4_ORIGINS;
    OLTPVC[] OLTP_73_ORIGINS;
    OLTPVC[] OLTP_74_GT3_ORIGINS;
    OLTPVC[] OLTP_75_ORIGINS;
    OLTPVC[] OLTP_76_ORIGINS;
    OLTPVC[] OLTP_77_ORIGINS;
    HashMap OLTPUPGRADES;
    LCVC[] LCUPGRADETARGETS;
    LCVC[] LC_72_300_ORIGINS;
    LCVC[] LC_741_300_ORIGINS;
    LCVC[] LC_741_310_ORIGINS;
    LCVC[] LC_74_GT2_300_ORIGINS;
    LCVC[] LC_74_GT2_310_ORIGINS;
    LCVC[] LC_74_GT3_400_ORIGINS;
    LCVC[] LC_74_GT3_410_ORIGINS;
    LCVC[] LC_75_410_ORIGINS;
    LCVC[] LC_76_500_ORIGINS;
    HashMap LCUPGRADES;
    static final QASTATUS DEV = new DEVSTATUS();
    static final QASTATUS COR = new CORSTATUS();
    static final QASTATUS RAMP = new RAMPSTATUS();
    static final QASTATUS NONE = new NONESTATUS();
    static final QASTATUS QAUNKNOWN = new QASTATUS();
    static final QASTATUS HOT = new HOTSTATUS();
    private MakeTableRow middleRelease;
    private Platform platform;
    final Platform UNKNOWNPLATFORM = new UnknownPlatform();

    LCVC lcConditionFor(MakeTableRow makeTableRow, LCMakeTableRow lCMakeTableRow) {
        LCVC lCVC = null;
        int n = 0;
        while (n < this.LCUPGRADETARGETS.length) {
            LCVC lCVC2 = this.LCUPGRADETARGETS[n];
            if (this.LCUPGRADETARGETS[n].matches(makeTableRow, lCMakeTableRow)) {
                lCVC = lCVC2;
                break;
            }
            ++n;
        }
        return lCVC;
    }

    OLTPVC oltpConditionForTarget(MakeTableRow makeTableRow) {
        OLTPVC oLTPVC = null;
        int n = 0;
        while (n < this.OLTPUPGRADETARGETS.length) {
            OLTPVC oLTPVC2 = this.OLTPUPGRADETARGETS[n];
            if (this.OLTPUPGRADETARGETS[n].matches(makeTableRow)) {
                oLTPVC = oLTPVC2;
                break;
            }
            ++n;
        }
        return oLTPVC;
    }

    boolean isInOLTPUpgradeMatrix(MakeTableRow makeTableRow, MakeTableRow makeTableRow2) {
        boolean bl = false;
        OLTPVC oLTPVC = this.oltpConditionForTarget(makeTableRow2);
        if (oLTPVC == null) {
            return false;
        }
        OLTPVC[] oLTPVCArray = (OLTPVC[])this.OLTPUPGRADES.get(oLTPVC);
        int n = 0;
        while (n < oLTPVCArray.length) {
            if (oLTPVCArray[n].matches(makeTableRow)) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    boolean isInLCUpgradeMatrix(MakeTableRow makeTableRow, LCMakeTableRow lCMakeTableRow, MakeTableRow makeTableRow2, LCMakeTableRow lCMakeTableRow2) {
        boolean bl = false;
        LCVC lCVC = this.lcConditionFor(makeTableRow2, lCMakeTableRow2);
        LCVC[] lCVCArray = (LCVC[])this.LCUPGRADES.get(lCVC);
        int n = 0;
        while (n < lCVCArray.length) {
            if (lCVCArray[n].matches(makeTableRow, lCMakeTableRow)) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    String relevantLiveCacheBuilds(String string) {
        return Configuration.buildList((String[])this.LCRELEVANT.get(string));
    }

    String[] lowerRelevantLiveCacheVersions(String string) {
        return Configuration.lowerVersions(this.LCVERSIONS, string, true);
    }

    String[] higherRelevantLiveCacheVersions(String string) {
        return Configuration.higherVersions(this.LCVERSIONS, string, false);
    }

    String relevantOLTPBuilds(String string) {
        return Configuration.buildList((String[])this.OLTPRELEVANT.get(string));
    }

    String[] lowerRelevantOLTPVersions(String string) {
        return Configuration.lowerVersions(this.OLTPVERSIONS, string, true);
    }

    String[] higherRelevantOLTPVersions(String string) {
        return Configuration.higherVersions(this.OLTPVERSIONS, string, false);
    }

    private static String buildList(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String string = "( ";
        int n = 0;
        while (n < stringArray.length) {
            string = string + (stringArray.length - 1 == n ? "'" + stringArray[n] + "'" : "'" + stringArray[n] + "', ");
            ++n;
        }
        string = string + ")";
        return string;
    }

    private static int indexIn(String[] stringArray, String string, boolean bl) {
        int n = -1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.equals(stringArray[n2])) {
                n = n2;
                if (bl) break;
                --n;
                break;
            }
            ++n2;
        }
        return n;
    }

    static String[] higherVersions(String[] stringArray, String string, boolean bl) {
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = bl ? 0 : 1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].compareTo(string) >= n) {
                treeSet.add(stringArray[n2]);
            }
            ++n2;
        }
        String[] stringArray2 = new String[treeSet.size()];
        Iterator iterator = treeSet.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            stringArray2[n3++] = (String)iterator.next();
        }
        return stringArray2;
    }

    static String[] lowerVersions(String[] stringArray, String string, boolean bl) {
        Object object;
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            int n2 = ((String)object).compareTo(string);
            if (n2 == 0 && bl) {
                treeSet.add(stringArray[n]);
            } else if (n2 < 0) {
                treeSet.add(stringArray[n]);
            }
            ++n;
        }
        object = new String[treeSet.size()];
        Iterator iterator = treeSet.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            object[n3++] = (String)iterator.next();
        }
        return object;
    }

    static QASTATUS getQAStatus(int n) {
        QASTATUS qASTATUS = null;
        switch (n) {
            case 1: {
                qASTATUS = DEV;
                break;
            }
            case 2: {
                qASTATUS = COR;
                break;
            }
            case 3: {
                qASTATUS = RAMP;
                break;
            }
            case 4: {
                qASTATUS = NONE;
                break;
            }
            case 5: {
                qASTATUS = HOT;
                break;
            }
            default: {
                qASTATUS = QAUNKNOWN;
            }
        }
        return qASTATUS;
    }

    private void initoltpversions(Platform platform) {
        this.OLTPVERSIONS = new String[]{"7300", "7402", "7403", "7500", "7600", "7700"};
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 3;
        int n5 = 4;
        int n6 = 5;
        this.OLTP7300BUILDS = new String[]{"09", "14", "15", "20", "23", "27", "28", "42", "46"};
        this.OLTP7402BUILDS = new String[]{"03", "07", "17", "20"};
        this.OLTP7403BUILDS = new String[]{"29", "10", "19", "20", "26", "28", "29", "30", "34"};
        this.OLTP7500BUILDS = new String[]{"09", "07", "09", "10", "15", "16"};
        this.OLTP7600BUILDS = new String[]{"07", "08", "09", "10"};
        this.OLTPRELEVANT = new HashMap();
        this.OLTPRELEVANT.put(this.OLTPVERSIONS[n], this.OLTP7300BUILDS);
        this.OLTPRELEVANT.put(this.OLTPVERSIONS[n2], this.OLTP7402BUILDS);
        this.OLTPRELEVANT.put(this.OLTPVERSIONS[n3], this.OLTP7403BUILDS);
        this.OLTPRELEVANT.put(this.OLTPVERSIONS[n4], this.OLTP7500BUILDS);
        this.OLTPRELEVANT.put(this.OLTPVERSIONS[n5], this.OLTP7600BUILDS);
        this.OLTP73MAKES = new MakeTableRow[this.OLTP7300BUILDS.length];
        int n7 = 0;
        while (n7 < this.OLTP73MAKES.length) {
            MakeTableRow makeTableRow = new MakeTableRow();
            makeTableRow.version = "7300";
            makeTableRow.build = this.OLTP7300BUILDS[n7];
            makeTableRow.qastatus = RAMP;
            makeTableRow.platform = platform;
            this.OLTP73MAKES[n7] = makeTableRow;
            ++n7;
        }
    }

    private void initlcversions() {
        this.LCVERSIONS = new String[]{"7402", "7403", "7500", "7600", "7700"};
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 3;
        int n5 = 4;
        this.LC7402BUILDS = new String[]{"10", "15", "17", "20", "21", "23", "25", "27", "28"};
        this.LC7403BUILDS = new String[]{"19", "21", "25", "30", "31", "33", "34", "35", "37"};
        this.LC7500BUILDS = new String[]{"15", "16", "18"};
        this.LC7600BUILDS = new String[]{"07", "08", "09", "10"};
        this.LCRELEVANT = new HashMap();
        this.LCRELEVANT.put(this.LCVERSIONS[n], this.LC7402BUILDS);
        this.LCRELEVANT.put(this.LCVERSIONS[n2], this.LC7403BUILDS);
        this.LCRELEVANT.put(this.LCVERSIONS[n3], this.LC7500BUILDS);
        this.LCRELEVANT.put(this.LCVERSIONS[n4], this.LC7600BUILDS);
    }

    private void initoltpupgrades() {
        this.OLTPUPGRADETARGETS = new OLTPVC[]{new OLTPVC("72", 4, -1), new OLTPVC("73"), new OLTPVC("74", 3, -1), new OLTPVC("75"), new OLTPVC("76"), new OLTPVC("77")};
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 3;
        int n5 = 4;
        int n6 = 5;
        this.OLTP_72_GT4_ORIGINS = new OLTPVC[]{new OLTPVC("72", 4, -1)};
        this.OLTP_73_ORIGINS = new OLTPVC[]{new OLTPVC("72", 4, -1), new OLTPVC("73")};
        this.OLTP_74_GT3_ORIGINS = new OLTPVC[]{new OLTPVC("73", 0, 0, 25), new OLTPVC("74", 3, -1)};
        this.OLTP_75_ORIGINS = new OLTPVC[]{new OLTPVC("73", 0, 0, 25), new OLTPVC("74", 3, -1), new OLTPVC("75")};
        this.OLTP_76_ORIGINS = new OLTPVC[]{new OLTPVC("73", 0, 0, 25), new OLTPVC("74", 3, -1), new OLTPVC("75"), new OLTPVC("76")};
        this.OLTP_77_ORIGINS = new OLTPVC[]{new OLTPVC("73", 0, 0, 25), new OLTPVC("74", 3, -1), new OLTPVC("75"), new OLTPVC("76"), new OLTPVC("7.7")};
        this.OLTPUPGRADES = new HashMap();
        this.OLTPUPGRADES.put(this.OLTPUPGRADETARGETS[n], this.OLTP_72_GT4_ORIGINS);
        this.OLTPUPGRADES.put(this.OLTPUPGRADETARGETS[n2], this.OLTP_73_ORIGINS);
        this.OLTPUPGRADES.put(this.OLTPUPGRADETARGETS[n3], this.OLTP_74_GT3_ORIGINS);
        this.OLTPUPGRADES.put(this.OLTPUPGRADETARGETS[n4], this.OLTP_75_ORIGINS);
        this.OLTPUPGRADES.put(this.OLTPUPGRADETARGETS[n5], this.OLTP_76_ORIGINS);
        this.OLTPUPGRADES.put(this.OLTPUPGRADETARGETS[n6], this.OLTP_77_ORIGINS);
    }

    private void initlcupgrades() {
        this.LCUPGRADETARGETS = new LCVC[]{new LCVC("72", 3, -1, "300"), new LCVC("74", 1, 1, -1, "300"), new LCVC("74", 1, 1, -1, "310"), new LCVC("74", 2, -1, "300"), new LCVC("74", 2, -1, "310"), new LCVC("74", 3, -1, "400"), new LCVC("74", 3, -1, "410"), new LCVC("76", "500")};
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 3;
        int n5 = 4;
        int n6 = 5;
        int n7 = 6;
        int n8 = 7;
        this.LC_72_300_ORIGINS = new LCVC[]{new LCVC("72", "300")};
        this.LC_741_300_ORIGINS = new LCVC[]{new LCVC("74", 1, 1, -1, "300")};
        this.LC_741_310_ORIGINS = new LCVC[]{new LCVC("74", 1, 1, -1, "310")};
        this.LC_74_GT2_300_ORIGINS = new LCVC[]{new LCVC("74", 1, 2, -1, "300"), new LCVC("72", 5, 5, 15, "300")};
        this.LC_74_GT2_310_ORIGINS = new LCVC[]{new LCVC("74", 1, -1, "310"), new LCVC("74", 1, -1, "300"), new LCVC("72", 5, 5, 15, "300")};
        this.LC_74_GT3_400_ORIGINS = new LCVC[]{new LCVC("74", 3, -1, "400"), new LCVC("74", 1, 2, -1, "310"), new LCVC("74", 1, 2, -1, "300"), new LCVC("72", 5, 5, 15, "300")};
        this.LC_74_GT3_410_ORIGINS = new LCVC[]{new LCVC("74", 3, -1, "410")};
        this.LC_75_410_ORIGINS = new LCVC[]{new LCVC("75", "410"), new LCVC("74", 3, -1, "410"), new LCVC("74", 3, -1, "400"), new LCVC("74", 1, 2, -1, "310"), new LCVC("74", 1, 2, -1, "300"), new LCVC("72", 5, 5, 15, "300")};
        this.LC_76_500_ORIGINS = new LCVC[]{new LCVC("72", 5, 5, 15, "300"), new LCVC("74", 1, 2, -1, "300"), new LCVC("74", 3, -1, "310"), new LCVC("74", 3, -1, "400"), new LCVC("75", "410"), new LCVC("75", "500"), new LCVC("76", "500")};
        this.LCUPGRADES = new HashMap();
        this.LCUPGRADES.put(this.LCUPGRADETARGETS[n], this.LC_72_300_ORIGINS);
        this.LCUPGRADES.put(this.LCUPGRADETARGETS[n2], this.LC_741_300_ORIGINS);
        this.LCUPGRADES.put(this.LCUPGRADETARGETS[n3], this.LC_741_310_ORIGINS);
        this.LCUPGRADES.put(this.LCUPGRADETARGETS[n4], this.LC_74_GT2_300_ORIGINS);
        this.LCUPGRADES.put(this.LCUPGRADETARGETS[n5], this.LC_74_GT2_310_ORIGINS);
        this.LCUPGRADES.put(this.LCUPGRADETARGETS[n6], this.LC_74_GT3_400_ORIGINS);
        this.LCUPGRADES.put(this.LCUPGRADETARGETS[n7], this.LC_74_GT3_410_ORIGINS);
        this.LCUPGRADES.put(this.LCUPGRADETARGETS[n8], this.LC_76_500_ORIGINS);
    }

    private void initPlatforms() throws SQLException {
        this.PLATFORMS = new HashSet();
        ResultSet resultSet = Configuration.executeSQL(this.conn.createStatement(), "select * from platforms");
        while (resultSet.next()) {
            Platform platform = new Platform();
            platform.init(resultSet);
            this.PLATFORMS.add(platform);
        }
    }

    Configuration() throws SQLException, ClassNotFoundException, TestCaseException, UnknownHostException {
        this.init();
        InetAddress inetAddress = InetAddress.getLocalHost();
        String string = inetAddress.getHostName();
        Platform platform = null;
        String string2 = "SELECT idplatform FROM servers where host like '" + string + "'";
        ResultSet resultSet = Configuration.executeSQL(this.conn.createStatement(), string2);
        if (resultSet.next()) {
            int n = resultSet.getInt(1);
            platform = this.platform(n);
        }
        if (platform == null) {
            String string3 = System.getProperty("os.name");
            String string4 = System.getProperty("os.arch");
            String string5 = System.getProperty("os.version");
            if (string3.indexOf("Win") >= 0 && "x86".equals(string4)) {
                platform = NTINTEL;
            }
        }
        if (platform == null) {
            throw new TestCaseException("Cannot find out platform  information for host " + string);
        }
        this.platform = platform;
        this.initoltpversions(this.platform);
    }

    Configuration(Platform platform) throws SQLException, ClassNotFoundException, TestCaseException {
        this.init();
        this.platform = platform;
        this.initoltpversions(this.platform);
    }

    void init() throws SQLException, ClassNotFoundException, TestCaseException {
        Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
        this.conn = DriverManager.getConnection("jdbc:sapdb://PTS/QADB", "TESTER", "TESTER");
        this.initPlatforms();
        this.initlcversions();
        this.initoltpupgrades();
        this.initlcupgrades();
    }

    Configuration(String string) throws SQLException, ClassNotFoundException, TestCaseException {
        this.init();
        this.middleRelease = new MakeTableRow(string);
        this.platform = this.middleRelease.platform;
        this.initoltpversions(this.platform);
    }

    MakeTableRow getMiddleRelease() {
        return this.middleRelease;
    }

    void destroy() throws SQLException {
        this.conn.close();
        this.middleRelease = null;
    }

    PlatformRowIterator platforms() {
        return new PlatformRowIteratorImpl(this.PLATFORMS);
    }

    Platform platform(int n) {
        Platform platform = null;
        PlatformRowIterator platformRowIterator = this.platforms();
        while (platformRowIterator.hasNext()) {
            Platform platform2 = platformRowIterator.next();
            if (platform2.id != n) continue;
            platform = platform2;
            break;
        }
        return platform;
    }

    MakeTableRow lastMake(String string, QASTATUS qASTATUS, Platform platform) throws SQLException {
        MakeTableRow makeTableRow = null;
        String string2 = "SELECT MAX(ID) FROM makes  m WHERE m.version = '" + string + "'" + " and m.idplatform = " + platform.toCode() + " and m.idqastatus = " + qASTATUS.toInt() + " and m.idobjstatus >= 1000 ";
        String string3 = "SELECT * FROM makes where ID in (" + string2 + ")";
        ResultSet resultSet = Configuration.executeSQL(this.conn.createStatement(), string3);
        if (resultSet.next()) {
            makeTableRow = new MakeTableRow();
            makeTableRow.init(resultSet);
        }
        return makeTableRow;
    }

    MakeTableRow lastMake(String string, QASTATUS qASTATUS) throws SQLException {
        return this.lastMake(string, qASTATUS, this.platform);
    }

    MakeTableRow lastDevMake(String string) throws SQLException {
        return this.lastMake(string, DEV, this.platform);
    }

    MakeTableRow lastCorMake(String string) throws SQLException {
        return this.lastMake(string, COR, this.platform);
    }

    MakeTableRowIterator lastCorMakes(String[] stringArray) throws SQLException {
        MakeTableRowIteratorImpl2 makeTableRowIteratorImpl2 = null;
        HashSet<MakeTableRow> hashSet = new HashSet<MakeTableRow>();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            MakeTableRow makeTableRow = this.lastCorMake(string);
            hashSet.add(makeTableRow);
            ++n;
        }
        makeTableRowIteratorImpl2 = new MakeTableRowIteratorImpl2(hashSet.iterator());
        return makeTableRowIteratorImpl2;
    }

    MakeTableRowIterator lastDevMakes(String[] stringArray) throws SQLException {
        MakeTableRowIteratorImpl2 makeTableRowIteratorImpl2 = null;
        HashSet<MakeTableRow> hashSet = new HashSet<MakeTableRow>();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            MakeTableRow makeTableRow = this.lastDevMake(string);
            hashSet.add(makeTableRow);
            ++n;
        }
        makeTableRowIteratorImpl2 = new MakeTableRowIteratorImpl2(hashSet.iterator());
        return makeTableRowIteratorImpl2;
    }

    MakeTableRowIterator lastCorOLTPMakes() throws SQLException {
        return this.lastCorMakes(this.OLTPVERSIONS);
    }

    MakeTableRowIterator lastDevOLTPMakes() throws SQLException {
        return this.lastDevMakes(this.OLTPVERSIONS);
    }

    MakeTableRowIterator lastCorLCMakes() throws SQLException {
        return this.lastCorMakes(this.LCVERSIONS);
    }

    MakeTableRowIterator lastDevLCMakes() throws SQLException {
        return this.lastDevMakes(this.LCVERSIONS);
    }

    public MakeTableRowIterator lowerUpgradableLCMakes(String string, MakeTableRow makeTableRow) throws SQLException {
        MakeTableRow makeTableRow2;
        HashSet<MakeTableRow> hashSet = new HashSet<MakeTableRow>();
        MakeTableRowIterator makeTableRowIterator = makeTableRow.relevantLiveCacheMakes(string);
        while ((makeTableRow2 = makeTableRowIterator.next()) != null) {
            LCMakeTableRow lCMakeTableRow = makeTableRow.lastAssociatedLCMake();
            LCMakeTableRow lCMakeTableRow2 = makeTableRow2.lastAssociatedLCMake();
            if (!this.isInLCUpgradeMatrix(makeTableRow2, lCMakeTableRow2, makeTableRow, lCMakeTableRow)) continue;
            hashSet.add(makeTableRow2);
        }
        return new MakeTableRowIteratorImpl2(hashSet.iterator());
    }

    public MakeTableRowIterator higherUpgradableLCMakes(String string, MakeTableRow makeTableRow) throws SQLException {
        MakeTableRow makeTableRow2;
        HashSet<MakeTableRow> hashSet = new HashSet<MakeTableRow>();
        MakeTableRowIterator makeTableRowIterator = makeTableRow.relevantLiveCacheMakes(string);
        while ((makeTableRow2 = makeTableRowIterator.next()) != null) {
            LCMakeTableRow lCMakeTableRow = makeTableRow2.lastAssociatedLCMake();
            LCMakeTableRow lCMakeTableRow2 = makeTableRow.lastAssociatedLCMake();
            if (!this.isInLCUpgradeMatrix(makeTableRow, lCMakeTableRow2, makeTableRow2, lCMakeTableRow)) continue;
            hashSet.add(makeTableRow);
        }
        return new MakeTableRowIteratorImpl2(hashSet.iterator());
    }

    private static void lineout(MakeTableRowIterator makeTableRowIterator, StringBuffer stringBuffer) throws SQLException {
        MakeTableRow makeTableRow;
        while ((makeTableRow = makeTableRowIterator.next()) != null) {
            stringBuffer.append(makeTableRow.toLine() + "\n");
        }
    }

    private static void lineoutlc(MakeTableRowIterator makeTableRowIterator, StringBuffer stringBuffer) throws SQLException {
        MakeTableRow makeTableRow;
        while ((makeTableRow = makeTableRowIterator.next()) != null) {
            stringBuffer.append(makeTableRow.toLine());
            LCMakeTableRow lCMakeTableRow = makeTableRow.lastAssociatedLCMake();
            if (lCMakeTableRow != null) {
                stringBuffer.append(lCMakeTableRow.toLine());
            }
            stringBuffer.append("\n");
        }
    }

    private static ResultSet executeSQL(Statement statement, String string) throws SQLException {
        statement.executeQuery(string);
        ResultSet resultSet = statement.getResultSet();
        return resultSet;
    }

    private static void db(Object object) {
        if (object instanceof MakeTableRowIterator) {
            MakeTableRowIterator makeTableRowIterator = (MakeTableRowIterator)object;
            try {
                MakeTableRow makeTableRow;
                while ((makeTableRow = makeTableRowIterator.next()) != null) {
                    Configuration.db(makeTableRow);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.out.println(object);
        }
    }

    static void outoltp(MakeTableRowIterator makeTableRowIterator, StringBuffer stringBuffer) throws SQLException {
        MakeTableRow makeTableRow;
        while ((makeTableRow = makeTableRowIterator.next()) != null) {
            stringBuffer.append("[" + makeTableRow.version + "]\n");
            stringBuffer.append(makeTableRow.toLine() + "\n");
            stringBuffer.append("[LOWER]\n");
            MakeTableRowIterator makeTableRowIterator2 = makeTableRow.lowerRelevantOLTPMakes();
            Configuration.lineout(makeTableRowIterator2, stringBuffer);
            stringBuffer.append("[HIGHER]\n");
            makeTableRowIterator2 = makeTableRow.higherRelevantOLTPMakes();
            Configuration.lineout(makeTableRowIterator2, stringBuffer);
            stringBuffer.append("\n");
        }
    }

    static void outlc(MakeTableRowIterator makeTableRowIterator, StringBuffer stringBuffer) throws SQLException {
        MakeTableRow makeTableRow;
        while ((makeTableRow = makeTableRowIterator.next()) != null) {
            LCMakeTableRow lCMakeTableRow = makeTableRow.lastAssociatedLCMake();
            stringBuffer.append("[" + makeTableRow.version + "]\n");
            stringBuffer.append(makeTableRow.toLine());
            if (lCMakeTableRow != null) {
                stringBuffer.append(lCMakeTableRow.toLine());
            }
            stringBuffer.append("\n");
            stringBuffer.append("[LOWER]\n");
            MakeTableRowIterator makeTableRowIterator2 = makeTableRow.lowerRelevantLiveCacheMakes();
            Configuration.lineoutlc(makeTableRowIterator2, stringBuffer);
            stringBuffer.append("[HIGHER]\n");
            makeTableRowIterator2 = makeTableRow.higherRelevantLiveCacheMakes();
            Configuration.lineoutlc(makeTableRowIterator2, stringBuffer);
            stringBuffer.append("\n");
        }
    }

    public StringBuffer dump() throws SQLException {
        MakeTableRowIterator makeTableRowIterator = null;
        StringBuffer stringBuffer = new StringBuffer();
        makeTableRowIterator = this.lastCorOLTPMakes();
        stringBuffer.append("[OLTP COR]\n");
        Configuration.outoltp(makeTableRowIterator, stringBuffer);
        makeTableRowIterator = this.lastDevOLTPMakes();
        stringBuffer.append("[OLTP DEV]\n");
        Configuration.outoltp(makeTableRowIterator, stringBuffer);
        makeTableRowIterator = this.lastCorLCMakes();
        stringBuffer.append("[LC COR]\n");
        Configuration.outlc(makeTableRowIterator, stringBuffer);
        stringBuffer.append("[LC DEV]\n");
        makeTableRowIterator = this.lastDevLCMakes();
        Configuration.outlc(makeTableRowIterator, stringBuffer);
        return stringBuffer;
    }

    public static void main(String[] stringArray) throws Exception {
        Configuration configuration = new Configuration();
        StringBuffer stringBuffer = configuration.dump();
        Configuration.db(stringBuffer);
    }

    static class LCVC
    extends OLTPVC {
        String version;

        LCVC(String string, int n, int n2, String string2) {
            super(string, n, n2);
            this.version = string2;
            this.init();
        }

        LCVC(String string, String string2) {
            super(string);
            this.version = string2;
            this.init();
        }

        LCVC(String string, int n, int n2, int n3, String string2) {
            super(string, n, n2, n3);
            this.version = string2;
            this.init();
        }

        private void init() {
            this.hashCode = (this.majorRelease + this.minimalMinorRelease + this.maximalMinorRelease + this.minimalBuild + this.version).hashCode();
        }

        boolean matches(MakeTableRow makeTableRow, LCMakeTableRow lCMakeTableRow) {
            boolean bl = super.matches(makeTableRow);
            boolean bl2 = this.version == null || lCMakeTableRow == null || lCMakeTableRow.version == null ? false : this.version.equals(lCMakeTableRow.version.substring(0, 3));
            return bl && bl2;
        }

        public boolean equals(Object object) {
            try {
                LCVC lCVC = (LCVC)object;
                return super.equals(object) && this.version.equals(lCVC.version);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public String toString() {
            return super.toString() + "/" + this.version;
        }
    }

    static class OLTPVC {
        String majorRelease;
        static final int UNLIMITED = 10000;
        static final int ANYMINORVERSION = -1;
        static final int ANYBUILD = -1;
        int minimalMinorRelease = -1;
        int maximalMinorRelease = 10000;
        int minimalBuild = -1;
        int hashCode;

        private void init() {
            this.hashCode = (this.majorRelease + this.minimalMinorRelease + this.maximalMinorRelease + this.minimalBuild).hashCode();
        }

        OLTPVC(String string, int n, int n2, int n3) {
            this(string, n, n3);
            this.maximalMinorRelease = n2;
            this.init();
        }

        OLTPVC(String string) {
            this.majorRelease = string;
            this.init();
        }

        OLTPVC(String string, int n, int n2) {
            this.majorRelease = string;
            this.minimalMinorRelease = n;
            this.minimalBuild = n2;
            this.init();
        }

        public boolean equals(Object object) {
            try {
                OLTPVC oLTPVC = (OLTPVC)object;
                return this.majorRelease.equals(oLTPVC.majorRelease) && this.minimalMinorRelease == oLTPVC.minimalMinorRelease && this.maximalMinorRelease == oLTPVC.maximalMinorRelease && this.minimalBuild == oLTPVC.minimalBuild;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            return this.hashCode;
        }

        boolean matches(MakeTableRow makeTableRow) {
            boolean bl = true;
            String string = makeTableRow.version.substring(0, 2);
            int n = Integer.parseInt(makeTableRow.version.substring(2, 4));
            int n2 = Integer.parseInt(makeTableRow.build);
            return string.equals(this.majorRelease) && n >= this.minimalMinorRelease && n <= this.maximalMinorRelease && n2 >= this.minimalBuild;
        }

        public String toString() {
            String string = this.minimalMinorRelease < 0 ? "ANY" : (this.maximalMinorRelease == 10000 ? "" + this.minimalMinorRelease + "-ANY" : this.minimalMinorRelease + "-" + this.maximalMinorRelease);
            String string2 = this.minimalBuild == -1 ? "Any build" : "Minimum build " + this.minimalBuild;
            return this.majorRelease + ".(" + string + ") " + string2;
        }
    }

    public class LCMakeTableRow {
        String version;
        String lcpoolid;
        String build;
        String changeList;
        String type;
        String toolcl;
        String patchlevel;
        String branchInfo;
        int objstatus;
        int idServer;
        int makeId;
        int maxdbMakeId;
        int histcount;
        QASTATUS qastatus;
        boolean lcok;
        boolean lcoktrans;
        Timestamp ts;

        void init(ResultSet resultSet) throws SQLException {
            this.makeId = resultSet.getInt(1);
            this.maxdbMakeId = resultSet.getInt(2);
            this.lcpoolid = resultSet.getString(3);
            this.version = resultSet.getString(4);
            this.qastatus = Configuration.getQAStatus(resultSet.getInt(5));
            this.objstatus = resultSet.getInt(6);
            this.changeList = resultSet.getString(7);
            this.ts = resultSet.getTimestamp(8);
            this.lcok = resultSet.getBoolean(9);
            this.lcoktrans = resultSet.getBoolean(10);
            this.histcount = resultSet.getInt(11);
            this.type = resultSet.getString(12);
            this.toolcl = resultSet.getString(13);
            this.patchlevel = resultSet.getString(14);
            this.idServer = resultSet.getInt(15);
            this.branchInfo = resultSet.getString(16);
        }

        public String toString() {
            return "LCMAKE[version=" + this.version + ",build=" + this.build + ",ts=" + this.ts + ",qastatus=" + this.qastatus + ",lcappsmake=" + this.makeId + ",maxdbmake=" + this.maxdbMakeId + "]";
        }

        public String toLine() {
            return "LCMAKE[version=" + this.version + ",build=" + this.build + ",ts=" + this.ts + ",qastatus=" + this.qastatus + ",lcappsmake=" + this.makeId + ",maxdbmake=" + this.maxdbMakeId + ",lcpoolid=" + this.lcpoolid + "]";
        }
    }

    public class MakeTableRow {
        String lcpoolId;
        String version;
        String build;
        int idServer;
        int makeId;
        QASTATUS qastatus;
        BUILDPURPOSE buildPurpose;
        Platform platform;
        Timestamp ts;
        LCMakeTableRow lastAssociatedLCMake;

        public String toString() {
            String string = "";
            if (this.lastAssociatedLCMake != null) {
                string = "(LC " + this.lastAssociatedLCMake.version + ")";
            }
            return "MAKE[version=" + this.version + ",build=" + this.build + ",ts=" + this.ts + ",platform=" + this.platform + ",qastatus=" + this.qastatus + ",makeId=" + this.makeId + "]" + string;
        }

        public String toLine() {
            return "MAKE[version=" + this.version + ",build=" + this.build + ",ts=" + this.ts + ",platform=" + this.platform + ",qastatus=" + this.qastatus + ",buildPurpose=" + this.buildPurpose + ",makeId=" + this.makeId + ",lcpool=" + this.lcpoolId + "]";
        }

        public MakeTableRowIterator lowerUpgradableLCMakes() throws SQLException {
            HashSet<MakeTableRow> hashSet = new HashSet<MakeTableRow>();
            String[] stringArray = this.lowerRelevantLiveCacheVersions();
            MakeTableRow makeTableRow = this;
            int n = 0;
            while (n < stringArray.length) {
                MakeTableRow makeTableRow2;
                MakeTableRowIterator makeTableRowIterator = Configuration.this.lowerUpgradableLCMakes(stringArray[n], makeTableRow);
                while ((makeTableRow2 = makeTableRowIterator.next()) != null) {
                    hashSet.add(makeTableRow2);
                }
                ++n;
            }
            return new MakeTableRowIteratorImpl2(hashSet.iterator());
        }

        public MakeTableRowIterator higherUpgradableLCMakes() throws SQLException {
            MakeTableRow makeTableRow;
            HashSet<MakeTableRow> hashSet = new HashSet<MakeTableRow>();
            MakeTableRowIterator makeTableRowIterator = this.higherRelevantLiveCacheMakes();
            while ((makeTableRow = makeTableRowIterator.next()) != null) {
                if (!makeTableRow.isLiveCacheRelevant()) continue;
                hashSet.add(makeTableRow);
            }
            return new MakeTableRowIteratorImpl2(hashSet.iterator());
        }

        public MakeTableRowIterator lowerUpgradableOLTPMakes() throws SQLException {
            HashSet<MakeTableRow> hashSet = new HashSet<MakeTableRow>();
            String[] stringArray = this.lowerRelevantOLTPVersions();
            int n = 0;
            while (n < stringArray.length) {
                MakeTableRow makeTableRow;
                MakeTableRowIterator makeTableRowIterator = this.lowerUpgradableOLTPMakes(stringArray[n]);
                while ((makeTableRow = makeTableRowIterator.next()) != null) {
                    hashSet.add(makeTableRow);
                }
                ++n;
            }
            return new MakeTableRowIteratorImpl2(hashSet.iterator());
        }

        public MakeTableRowIterator higherUpgradableOLTPMakes() throws SQLException {
            HashSet hashSet = new HashSet();
            MakeTableRowIterator makeTableRowIterator = this.higherRelevantOLTPMakes();
            return makeTableRowIterator;
        }

        public MakeTableRowIterator lowerUpgradableOLTPMakes(String string) throws SQLException {
            MakeTableRow makeTableRow;
            HashSet<MakeTableRow> hashSet = new HashSet<MakeTableRow>();
            MakeTableRowIterator makeTableRowIterator = this.relevantOLTPMakes(string);
            while ((makeTableRow = makeTableRowIterator.next()) != null) {
                if (!Configuration.this.isInOLTPUpgradeMatrix(makeTableRow, this)) continue;
                hashSet.add(makeTableRow);
            }
            return new MakeTableRowIteratorImpl2(hashSet.iterator());
        }

        public MakeTableRowIterator higherUpgradableOLTPMakes(String string) throws SQLException {
            MakeTableRow makeTableRow;
            HashSet<MakeTableRow> hashSet = new HashSet<MakeTableRow>();
            MakeTableRowIterator makeTableRowIterator = this.relevantOLTPMakes(string);
            while ((makeTableRow = makeTableRowIterator.next()) != null) {
                if (!Configuration.this.isInOLTPUpgradeMatrix(this, makeTableRow)) continue;
                hashSet.add(makeTableRow);
            }
            return new MakeTableRowIteratorImpl2(hashSet.iterator());
        }

        public MakeTableRowIterator lowerRelevantOLTPMakes() throws SQLException {
            HashSet<MakeTableRow> hashSet = new HashSet<MakeTableRow>();
            String[] stringArray = this.lowerRelevantOLTPVersions();
            int n = 0;
            while (n < stringArray.length) {
                MakeTableRow makeTableRow;
                MakeTableRowIterator makeTableRowIterator = this.relevantOLTPMakes(stringArray[n]);
                while ((makeTableRow = makeTableRowIterator.next()) != null) {
                    hashSet.add(makeTableRow);
                }
                ++n;
            }
            return new MakeTableRowIteratorImpl2(hashSet.iterator());
        }

        public MakeTableRowIterator higherRelevantOLTPMakes() throws SQLException {
            HashSet<MakeTableRow> hashSet = new HashSet<MakeTableRow>();
            String[] stringArray = this.higherRelevantOLTPVersions();
            int n = 0;
            while (n < stringArray.length) {
                MakeTableRow makeTableRow;
                MakeTableRowIterator makeTableRowIterator = this.relevantOLTPMakes(stringArray[n]);
                while ((makeTableRow = makeTableRowIterator.next()) != null) {
                    int n2;
                    int n3 = Integer.parseInt(this.build);
                    if (n3 > (n2 = Integer.parseInt(makeTableRow.build))) continue;
                    hashSet.add(makeTableRow);
                }
                ++n;
            }
            return new MakeTableRowIteratorImpl2(hashSet.iterator());
        }

        public MakeTableRowIterator relevantOLTPMakes(String string) throws SQLException {
            if (string.equals("7300")) {
                HashSet<MakeTableRow> hashSet = new HashSet<MakeTableRow>();
                int n = 0;
                while (n < Configuration.this.OLTP73MAKES.length) {
                    hashSet.add(Configuration.this.OLTP73MAKES[n]);
                    ++n;
                }
                return new MakeTableRowIteratorImpl2(hashSet.iterator());
            }
            String string2 = Configuration.this.relevantOLTPBuilds(string);
            return this.relevantMakes(string, string2);
        }

        public MakeTableRowIterator relevantLiveCacheMakes(String string) throws SQLException {
            MakeTableRow makeTableRow;
            String string2 = Configuration.this.relevantLiveCacheBuilds(string);
            MakeTableRowIterator makeTableRowIterator = this.relevantMakes(string, string2);
            HashSet<MakeTableRow> hashSet = new HashSet<MakeTableRow>();
            while ((makeTableRow = makeTableRowIterator.next()) != null) {
                if (!makeTableRow.isLiveCacheRelevant()) continue;
                hashSet.add(makeTableRow);
            }
            makeTableRowIterator = new MakeTableRowIteratorImpl2(hashSet.iterator());
            return makeTableRowIterator;
        }

        public MakeTableRowIterator lowerRelevantLiveCacheMakes() throws SQLException {
            HashSet<MakeTableRow> hashSet = new HashSet<MakeTableRow>();
            String[] stringArray = this.lowerRelevantLiveCacheVersions();
            int n = 0;
            while (n < stringArray.length) {
                MakeTableRow makeTableRow;
                MakeTableRowIterator makeTableRowIterator = this.relevantLiveCacheMakes(stringArray[n]);
                while ((makeTableRow = makeTableRowIterator.next()) != null) {
                    hashSet.add(makeTableRow);
                }
                ++n;
            }
            return new MakeTableRowIteratorImpl2(hashSet.iterator());
        }

        public MakeTableRowIterator higherRelevantLiveCacheMakes() throws SQLException {
            HashSet<MakeTableRow> hashSet = new HashSet<MakeTableRow>();
            String[] stringArray = this.higherRelevantLiveCacheVersions();
            int n = 0;
            while (n < stringArray.length) {
                MakeTableRow makeTableRow;
                MakeTableRowIterator makeTableRowIterator = this.relevantLiveCacheMakes(stringArray[n]);
                while ((makeTableRow = makeTableRowIterator.next()) != null) {
                    hashSet.add(makeTableRow);
                }
                ++n;
            }
            return new MakeTableRowIteratorImpl2(hashSet.iterator());
        }

        MakeTableRowIterator relevantMakes(String string, String string2) throws SQLException {
            if (string2 == null) {
                return new MakeTableRowIteratorImpl();
            }
            String string3 = "SELECT MAX(ID) FROM makes  m WHERE version = '" + string + "'" + " and m.idplatform = " + this.platform.toCode() + " and m.idqastatus = " + RAMP.toInt() + " and m.buildpfx in  " + string2 + " group by buildpfx";
            String string4 = "SELECT * FROM makes where ID in (" + string3 + ")";
            ResultSet resultSet = Configuration.executeSQL(Configuration.this.conn.createStatement(), string4);
            MakeTableRowIteratorImpl makeTableRowIteratorImpl = new MakeTableRowIteratorImpl(resultSet);
            return makeTableRowIteratorImpl;
        }

        public String[] higherRelevantOLTPVersions() {
            return Configuration.this.higherRelevantOLTPVersions(this.version);
        }

        public String[] lowerRelevantOLTPVersions() {
            return Configuration.this.lowerRelevantOLTPVersions(this.version);
        }

        public String[] higherRelevantLiveCacheVersions() {
            return Configuration.this.higherRelevantLiveCacheVersions(this.version);
        }

        public String[] lowerRelevantLiveCacheVersions() {
            return Configuration.this.lowerRelevantLiveCacheVersions(this.version);
        }

        boolean isLiveCacheRelevant() throws SQLException {
            boolean bl = this.buildPurpose.isLc();
            String string = "SELECT count(id) FROM lcamakes where idmake = " + this.makeId;
            ResultSet resultSet = Configuration.executeSQL(Configuration.this.conn.createStatement(), string);
            resultSet.next();
            int n = resultSet.getInt(1);
            boolean bl2 = n > 0;
            return bl2 && bl;
        }

        public LCMakeTableRowIterator associatedLCMakes() throws SQLException {
            LCMakeTableRowIteratorImpl lCMakeTableRowIteratorImpl = null;
            String string = "SELECT * FROM lcamakes where idmake = " + this.makeId;
            lCMakeTableRowIteratorImpl = new LCMakeTableRowIteratorImpl(Configuration.executeSQL(Configuration.this.conn.createStatement(), string));
            return lCMakeTableRowIteratorImpl;
        }

        public LCMakeTableRow lastAssociatedLCMake() throws SQLException {
            if (this.lastAssociatedLCMake != null) {
                return this.lastAssociatedLCMake;
            }
            String string = "SELECT MAX(ID) FROM lcamakes WHERE idmake = " + this.makeId;
            String string2 = "SELECT * FROM lcamakes where ID in (" + string + ") and idobjstatus >= 1000";
            ResultSet resultSet = Configuration.executeSQL(Configuration.this.conn.createStatement(), string2);
            if (resultSet.next()) {
                this.lastAssociatedLCMake = new LCMakeTableRow();
                this.lastAssociatedLCMake.init(resultSet);
            }
            return this.lastAssociatedLCMake;
        }

        MakeTableRow(String string) throws SQLException, TestCaseException {
            this.platform = Configuration.this.UNKNOWNPLATFORM;
            String string2 = "SELECT * FROM makes m WHERE m.id = " + string + "";
            ResultSet resultSet = Configuration.executeSQL(Configuration.this.conn.createStatement(), string2);
            if (!resultSet.next()) {
                throw new TestCaseException("Make key  " + string + " not found in QADB");
            }
            this.init(resultSet);
        }

        MakeTableRow() {
            this.platform = Configuration.this.UNKNOWNPLATFORM;
        }

        void init(ResultSet resultSet) throws SQLException {
            this.makeId = resultSet.getInt(1);
            this.lcpoolId = resultSet.getString(2);
            this.version = resultSet.getString(3);
            this.build = resultSet.getString(4);
            this.platform = Configuration.this.platform(resultSet.getInt(5));
            this.qastatus = Configuration.getQAStatus(resultSet.getInt(6));
            this.ts = resultSet.getTimestamp(9);
            this.buildPurpose = BUILDPURPOSE.create(resultSet.getString(15));
            this.idServer = resultSet.getInt(16);
        }
    }

    class UnknownPlatform
    extends Platform {
        UnknownPlatform() {
            this.descText = "";
            this.perlText = "";
            this.readText = "";
            this.osName = "";
            this.osVersion = "";
            this.distribName = "";
        }

        void init(ResultSet resultSet) throws SQLException {
        }

        public String toString() {
            return "unknown platform";
        }

        public String toCode() {
            return "unknown platform";
        }
    }

    static class Platform {
        String descText;
        String perlText;
        String readText;
        String osName;
        String osVersion;
        String distribName;
        int id;

        public Platform() {
        }

        public Platform(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            this.descText = stringTokenizer.nextToken();
            this.perlText = stringTokenizer.nextToken();
            this.readText = stringTokenizer.nextToken();
            this.osName = stringTokenizer.nextToken();
            this.osVersion = stringTokenizer.nextToken();
            this.distribName = stringTokenizer.nextToken();
            this.id = Integer.parseInt(stringTokenizer.nextToken());
        }

        void init(ResultSet resultSet) throws SQLException {
            this.id = resultSet.getInt(1);
            this.descText = resultSet.getString(2);
            this.perlText = resultSet.getString(3);
            this.readText = resultSet.getString(4);
            this.osName = resultSet.getString(5);
            this.osVersion = resultSet.getString(6);
            this.distribName = resultSet.getString(7);
        }

        public String toString() {
            return this.descText;
        }

        public String toCode() {
            return this.id + "";
        }

        public String stringRep() {
            return this.descText + ";" + this.perlText + ";" + this.readText + ";" + this.osName + ";" + this.osVersion + ";" + this.distribName + ";" + this.id;
        }
    }

    static class PlatformRowIteratorImpl
    implements PlatformRowIterator {
        Iterator iter;

        PlatformRowIteratorImpl(Collection collection) {
            this.iter = collection.iterator();
        }

        public Platform next() {
            return (Platform)this.iter.next();
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }
    }

    class LCMakeTableRowIteratorImpl2
    implements LCMakeTableRowIterator {
        Iterator iter;

        LCMakeTableRowIteratorImpl2(Iterator iterator) {
            this.iter = iterator;
        }

        public LCMakeTableRow next() throws SQLException {
            LCMakeTableRow lCMakeTableRow = null;
            if (this.iter.hasNext()) {
                lCMakeTableRow = (LCMakeTableRow)this.iter.next();
            }
            return lCMakeTableRow;
        }
    }

    class LCMakeTableRowIteratorImpl
    implements LCMakeTableRowIterator {
        ResultSet res;

        LCMakeTableRowIteratorImpl(ResultSet resultSet) {
            this.res = resultSet;
        }

        public LCMakeTableRow next() throws SQLException {
            if (!this.res.next()) {
                return null;
            }
            LCMakeTableRow lCMakeTableRow = new LCMakeTableRow();
            lCMakeTableRow.init(this.res);
            return lCMakeTableRow;
        }
    }

    class MakeTableRowIteratorImpl2
    implements MakeTableRowIterator {
        Iterator iter;

        MakeTableRowIteratorImpl2(Iterator iterator) {
            this.iter = iterator;
        }

        public MakeTableRow next() {
            MakeTableRow makeTableRow = null;
            if (this.iter.hasNext()) {
                makeTableRow = (MakeTableRow)this.iter.next();
            }
            return makeTableRow;
        }
    }

    class MakeTableRowIteratorImpl
    implements MakeTableRowIterator {
        ResultSet res;

        MakeTableRowIteratorImpl() {
        }

        MakeTableRowIteratorImpl(ResultSet resultSet) {
            this.res = resultSet;
        }

        public MakeTableRow next() throws SQLException {
            if (this.res == null || !this.res.next()) {
                return null;
            }
            MakeTableRow makeTableRow = new MakeTableRow();
            makeTableRow.init(this.res);
            return makeTableRow;
        }
    }

    public static interface PlatformRowIterator {
        public Platform next();

        public boolean hasNext();
    }

    public static interface LCMakeTableRowIterator {
        public LCMakeTableRow next() throws SQLException;
    }

    public static interface MakeTableRowIterator {
        public MakeTableRow next() throws SQLException;
    }

    static class LCONLY
    extends BUILDPURPOSE {
        LCONLY() {
        }

        public String toString() {
            return "liveCache only";
        }

        public String toCode() {
            return "L";
        }

        boolean isOltp() {
            return false;
        }

        boolean isLc() {
            return true;
        }
    }

    static class OLTPONLY
    extends BUILDPURPOSE {
        OLTPONLY() {
        }

        public String toString() {
            return "OLTP only";
        }

        public String toCode() {
            return "O";
        }

        boolean isOltp() {
            return true;
        }

        boolean isLc() {
            return false;
        }
    }

    static class LCANDOLTP
    extends BUILDPURPOSE {
        final boolean isOltp = true;

        LCANDOLTP() {
        }

        public String toString() {
            return "liveCache/OLTP";
        }

        public String toCode() {
            return "A";
        }

        boolean isOltp() {
            return true;
        }

        boolean isLc() {
            return true;
        }
    }

    static class BUILDPURPOSE {
        private BUILDPURPOSE() {
        }

        static BUILDPURPOSE create(String string) {
            BUILDPURPOSE bUILDPURPOSE = null;
            bUILDPURPOSE = "A".equals(string) ? new LCANDOLTP() : ("O".equals(string) ? new OLTPONLY() : ("L".equals(string) ? new LCONLY() : new BUILDPURPOSE()));
            return bUILDPURPOSE;
        }

        public String toString() {
            return "<UNKNOWN>";
        }

        boolean isOltp() {
            return false;
        }

        boolean isLc() {
            return false;
        }
    }

    static class HOTSTATUS
    extends QASTATUS {
        HOTSTATUS() {
        }

        public String toString() {
            return "HOT";
        }

        public int toInt() {
            return 5;
        }
    }

    static class NONESTATUS
    extends QASTATUS {
        NONESTATUS() {
        }

        public String toString() {
            return "NONE";
        }

        public int toInt() {
            return 4;
        }
    }

    static class RAMPSTATUS
    extends QASTATUS {
        RAMPSTATUS() {
        }

        public String toString() {
            return "RAMP";
        }

        public int toInt() {
            return 3;
        }
    }

    static class CORSTATUS
    extends QASTATUS {
        CORSTATUS() {
        }

        public String toString() {
            return "COR";
        }

        public int toInt() {
            return 2;
        }
    }

    static class DEVSTATUS
    extends QASTATUS {
        DEVSTATUS() {
        }

        public String toString() {
            return "DEV";
        }

        public int toInt() {
            return 1;
        }
    }

    static class QASTATUS {
        private QASTATUS() {
        }

        public String toString() {
            return "<UNKNOWN>";
        }

        public int toInt() {
            return -1;
        }
    }
}

