/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest.config;

import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.upgradetest.config.ConfigReader;
import com.sap.sapdb.upgradetest.config.ConfigurationException;
import com.sap.sapdb.upgradetest.config.MalformedConfigFileException;
import com.sap.sapdb.upgradetest.config.SettingNotFoundException;
import com.sap.sapdb.upgradetest.util.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class xmlConfiguration {
    private static xmlConfiguration myself = null;
    private static Connection conn = null;
    private static String[] knownVersions = new String[]{"7300", "7402", "7403", "7500", "7600"};
    private Document xmlConfigDoc;
    private Node rootNode;
    private int testcount = 0;

    private xmlConfiguration() {
    }

    public static xmlConfiguration getInstance() {
        if (myself == null) {
            myself = new xmlConfiguration();
            return myself;
        }
        return myself;
    }

    public int getTestCount() {
        return this.testcount;
    }

    public void setSetting(String string, String string2) {
        block3: {
            try {
                Node node = this.getNodeMatchingXPath(string, this.rootNode);
                if (node == null) break block3;
                if (node.getNodeType() == 1) {
                    if (node.getChildNodes().item(0).getNodeType() != 3) break block3;
                    node.getChildNodes().item(0).setNodeValue(string2);
                    break block3;
                }
                node.setNodeValue(string2);
            }
            catch (SettingNotFoundException settingNotFoundException) {}
        }
    }

    public String getSetting(String string) throws SettingNotFoundException {
        return this.getStringMatchingXPath(string, this.rootNode);
    }

    public String getStringMatchingXPath(String string, Node node) throws SettingNotFoundException {
        Node node2 = this.getNodeMatchingXPath(string, node);
        if (node2 == null) {
            Logger.log(Logger.DEBUG, "Configuration.getStringMatchingXPath(): Searched for " + string + " found nothing.");
            return null;
        }
        String string2 = node2.getNodeValue();
        if (string2 != null) {
            return string2;
        }
        if (node2.getNodeType() == 1 && node2.hasChildNodes() && node2.getFirstChild().getNodeType() == 3) {
            return node2.getFirstChild().getNodeValue();
        }
        return node2.getNodeName();
    }

    public Node getNodeMatchingXPath(String string, Node node) throws SettingNotFoundException {
        simpleXPathExpression simpleXPathExpression2 = new simpleXPathExpression(string);
        return this.getNodeMatchingXPathExp(simpleXPathExpression2, node);
    }

    public void parseConfiguration(File file, String string) throws FileNotFoundException, ConfigurationException, MalformedConfigFileException {
        try {
            Logger.log(Logger.VERBOSE, "Configuration: starting to read configuration file (" + file.getCanonicalPath() + ")");
            if (file == null) {
                throw new FileNotFoundException("Configuration: config file is null: " + file.toString());
            }
            if (!file.exists()) {
                throw new FileNotFoundException("Configuration: couldn't find the config file " + file.toString());
            }
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.getMessage());
        }
        Logger.log(Logger.DEBUG, "Configuration: parsing general settings XML file ...");
        this.xmlConfigDoc = new ConfigReader(new FileInputStream(file), string).readConfig();
        this.rootNode = this.xmlConfigDoc.getDocumentElement();
        this.rootNode.normalize();
        Logger.log(Logger.VERBOSE, "Configuration: finished reading configuration.");
    }

    public StringBuffer createAutoConfig(String string) throws ConfigurationException {
        Object object;
        int n;
        Object object2;
        ArrayList<DBVersion> arrayList;
        String string2;
        StringBuffer stringBuffer;
        boolean bl2;
        block37: {
            Serializable serializable;
            Logger.log(Logger.STANDARD, "Automagically creating a configuration for make " + string);
            bl2 = TestCase.getParameterBoolean((String)"minimaltest", (boolean)false);
            if (bl2) {
                Logger.log(Logger.VERBOSE, "Creating only a minimal amount of tests");
            }
            stringBuffer = new StringBuffer(4000);
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            stringBuffer.append("<!DOCTYPE testrun SYSTEM \"../testrun.dtd\">\n");
            stringBuffer.append("<testrun description=\"UpgradeTest (automatically generated for make " + string + ")\">\n" + "\t<environment>\n" + "\t\t<os> </os>\n" + "\t\t<bit> </bit>\n" + "\t\t<platform> </platform>\n" + "\t</environment>\n");
            string2 = TestCase.getParameterString((String)"instprofile", (String)"");
            string2 = string2.intern();
            int n2 = 0;
            if (string2.length() == 0 || string2 == "detect") {
                try {
                    n2 = xmlConfiguration.lcaVersion(string);
                    if (n2 != 0) {
                        string2 = "detect";
                        Logger.log(Logger.STANDARD, "Found LC Apps for autocreatefor version, installation profile set to " + string2);
                    }
                    string2 = "Server";
                    Logger.log(Logger.STANDARD, "Installation profile: " + string2);
                }
                catch (SQLException sQLException) {
                    Logger.error("Error when trying to determine if autocreatefor Version has LC Apps");
                    Logger.stackTrace(sQLException);
                    throw new ConfigurationException("SQL Exception when trying to detect installation profile for " + string);
                }
            } else if (string2.equals("APO LiveCache")) {
                Logger.log(Logger.STANDARD, "Installation profile is APO LiveCache, checking if a RAMP LC Apps Version is available for " + string + " ...");
                try {
                    n2 = xmlConfiguration.lcaVersion(string);
                    if (n2 == 0) {
                        throw new ConfigurationException("Installation profile from parameter file is APO LiveCache but there are no RAMP LC Apps for " + string);
                    }
                }
                catch (SQLException sQLException) {
                    throw new ConfigurationException("SQL Exception when trying to find LC Apps for " + string);
                }
                Logger.log(Logger.STANDARD, "... found " + n2 + ".");
                Logger.log(Logger.STANDARD, "Installation profile: " + string2);
            } else if (string2.equals("Server")) {
                Logger.log(Logger.STANDARD, "Installation profile: " + string2);
            } else {
                throw new ConfigurationException("Unknown installation profile \"" + string2 + "\" specified in parameter file (std: UpgradeTest.par)");
            }
            if (string2 == "Server") {
                serializable = new ArrayList<String>(Arrays.asList(knownVersions));
                serializable.remove("7402");
                knownVersions = serializable.toArray(new String[0]);
            }
            conn = null;
            serializable = new StringBuffer("m.version IN (");
            Logger.log(Logger.DEBUG, "Considering versions:");
            int n3 = 0;
            while (n3 < knownVersions.length) {
                ((StringBuffer)serializable).append("'" + knownVersions[n3] + "',");
                Logger.log(Logger.DEBUG, "\t* " + knownVersions[n3]);
                ++n3;
            }
            ((StringBuffer)serializable).deleteCharAt(((StringBuffer)serializable).length() - 1);
            ((StringBuffer)serializable).append(") ");
            arrayList = new ArrayList<DBVersion>();
            Logger.log(Logger.VERBOSE, "Starting to fetch version information from QADB...");
            String string3 = null;
            try {
                if (conn == null) {
                    conn = DriverManager.getConnection("jdbc:sapdb://PTS/QADB", "TESTER", "TESTER");
                }
                int n4 = this.getPlatformId(string);
                object2 = conn.createStatement();
                string3 = "SELECT DISTINCT m.version version, m.buildpfx buildpfx, m.idqastatus idqastatus, MAX(l.version) lcaversion, p.distribname platform FROM (SELECT version, buildpfx ,idplatform, max(id) id,  max (idqastatus) idqastatus FROM makes GROUP BY version, buildpfx, idplatform) m INNER JOIN platforms p on m.idplatform = p.id LEFT OUTER JOIN LCAMAKES l ON m.id = l.idmake WHERE p.id = " + n4 + " AND " + ((StringBuffer)serializable).toString() + " AND m.idplatform = " + n4 + " GROUP BY m.version, m.buildpfx, m.idqastatus, p.distribname " + "ORDER BY m.version, m.buildpfx, m.idqastatus " + (bl2 ? " DESC" : "");
                Logger.log(Logger.CURRDEBUG, "SQL Query is: " + string3);
                if (string2 == "Server") {
                    n = 36;
                    while (n <= 50) {
                        if (n != 41) {
                            arrayList.add(new DBVersion(7, 3, 0, n, 3, -1));
                        }
                        ++n;
                    }
                }
                if (object2.execute(string3)) {
                    object = object2.getResultSet();
                    while (object.next()) {
                        int n5 = object.getInt(1);
                        int n6 = n5 / 1000;
                        int n7 = (n5 - n6 * 1000) / 100;
                        int bl = n5 - n6 * 1000 - n7 * 100;
                        int string4 = object.getInt(2);
                        int n8 = object.getInt(3);
                        int n9 = object.getInt(4);
                        if (n6 == 7 && n7 == 6 && string4 < 5 || n6 == 7 && n7 == 5 && string4 < 7 || n6 == 7 && n7 == 4 && bl == 3 && string4 < 10) continue;
                        if (n9 < 100000) {
                            n9 = xmlConfiguration.fixupLCAVersion(n9);
                        }
                        arrayList.add(new DBVersion(n6, n7, bl, string4, n8, n9));
                    }
                    break block37;
                }
                throw new ConfigurationException("Could not fetch _any_ version information from QADB - something must be wrong. SQL was " + string3);
            }
            catch (SQLException sQLException) {
                Logger.error("Error when fetching version information from QADB");
                Logger.stackTrace(sQLException);
                throw new ConfigurationException("Error when fetching version information from QADB, SQL was " + string3);
            }
        }
        Logger.log(Logger.VERBOSE, "Finished fetching version information from QADB.");
        DBVersion dBVersion = null;
        try {
            dBVersion = this.fromMakeKey(string);
        }
        catch (SQLException sQLException) {
            throw new ConfigurationException("Error retrieving version information for makeKey from QADB: " + sQLException.getMessage());
        }
        object2 = new HashMap();
        n = 0;
        while (n < knownVersions.length) {
            object2.put(knownVersions[n], new Boolean(false));
            ++n;
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            DBVersion dBVersion2;
            DBVersion dBVersion3;
            DBVersion dBVersion4 = (DBVersion)object.next();
            if (dBVersion.isSmallerThan(dBVersion4)) {
                dBVersion3 = dBVersion;
                dBVersion2 = dBVersion4;
            } else {
                dBVersion3 = dBVersion4;
                dBVersion2 = dBVersion;
            }
            if (bl2) {
                if (((Boolean)object2.get(dBVersion4.getMajorString())).booleanValue() || dBVersion4.qastatus < 3) continue;
                object2.put(dBVersion4.getMajorString(), new Boolean(true));
            }
            stringBuffer.append("\t<test>\n");
            stringBuffer.append("\t\t<version role=\"source\">" + dBVersion3.toXMLTag() + "</version>\n");
            stringBuffer.append("\t\t<version role=\"target\">" + dBVersion2.toXMLTag() + "</version>\n");
            if (dBVersion4.updateNeedsNewSecurityConcept(dBVersion)) {
                stringBuffer.append("\t\t<updateNewSecurityConceptBackup/>\n");
            }
            stringBuffer.append("\t\t<instprofile>");
            boolean bl = string2.equals("APO LiveCache");
            if (dBVersion4.isLiveCacheOnly()) {
                bl = true;
            } else if (string2.equals("detect")) {
                bl = dBVersion.hasLiveCache() && dBVersion4.hasLiveCache();
            }
            if (bl) {
                stringBuffer.append("APO LiveCache");
            } else {
                stringBuffer.append("Server");
            }
            stringBuffer.append("</instprofile>\n");
            stringBuffer.append("\t\t<database>\n");
            stringBuffer.append("\t\t\t<type>OLTP</type>\n");
            stringBuffer.append("\t\t\t<script task=\"createdb\">\n");
            stringBuffer.append("\t\t\t\t<path>" + dBVersion3.getCreateDBScript(bl) + "</path>\n");
            stringBuffer.append("\t\t\t</script>\n");
            stringBuffer.append("\t\t\t<script task=\"prepupdate\">\n");
            String string3 = dBVersion3.updateNeedsBackup(dBVersion2) ? "scripts/backup.script" : (bl ? "scripts/fake_lcbackup.script" : "scripts/nothing.script");
            stringBuffer.append("\t\t\t\t<path>" + string3 + "</path>\n");
            stringBuffer.append("\t\t\t\t<dbm>\n");
            stringBuffer.append("\t\t\t\t\t<property name=\"dbname\" value=\"TESTDB\"/>\n");
            stringBuffer.append("\t\t\t\t</dbm>\n");
            stringBuffer.append("\t\t\t</script>\n");
            stringBuffer.append("\t\t\t<script task=\"prepuninst\">\n");
            stringBuffer.append("\t\t\t\t<path>scripts/dbdrop.script</path>\n");
            stringBuffer.append("\t\t\t\t<dbm>\n");
            stringBuffer.append("\t\t\t\t\t<property name=\"dbname\" value=\"TESTDB\"/>\n");
            stringBuffer.append("\t\t\t\t</dbm>\n");
            stringBuffer.append("\t\t\t</script>\n");
            stringBuffer.append("\t\t</database>\n");
            stringBuffer.append("\t</test>\n");
        }
        stringBuffer.append("</testrun>\n");
        Logger.log(Logger.DEBUG, "Dumping automatically generated config:\n------------------- start autoconfig -------------------\n" + stringBuffer.toString() + "\n------------------- end autoconfig -------------------");
        Logger.log(Logger.VERBOSE, "Finished creating the autoconfig.");
        return stringBuffer;
    }

    private int getPlatformId(String string) throws SQLException {
        if (conn == null) {
            conn = DriverManager.getConnection("jdbc:sapdb://PTS/QADB", "TESTER", "TESTER");
        }
        Statement statement = conn.createStatement();
        String string2 = "SELECT idplatform FROM makes m WHERE m.id = " + string;
        statement.execute(string2);
        ResultSet resultSet = statement.getResultSet();
        if (!resultSet.next() || resultSet.getInt(1) == 0) {
            return 0;
        }
        return resultSet.getInt(1);
    }

    private static int fixupLCAVersion(int n) {
        int n2 = n / 1000;
        int n3 = n % 1000;
        int n4 = n2 * 10000 + n3;
        return n4;
    }

    public void dropConfiguration() {
        Logger.log(Logger.DEBUG, "Configuration: dropping all configuration information");
        this.rootNode = null;
        this.xmlConfigDoc = null;
        this.testcount = 0;
        myself = null;
    }

    public static int lcaVersion(String string, String string2) throws SQLException {
        if (string.endsWith("COR")) {
            return xmlConfiguration.lcaVersion(string, string2, 2);
        }
        if (string.endsWith("DEV")) {
            return xmlConfiguration.lcaVersion(string, string2, 1);
        }
        return xmlConfiguration.lcaVersion(string, string2, 0);
    }

    public static int lcaVersion(String string, String string2, String string3) throws SQLException {
        if (string3.equals("COR")) {
            return xmlConfiguration.lcaVersion(string, string2, 2);
        }
        if (string3.equals("DEV")) {
            return xmlConfiguration.lcaVersion(string, string2, 1);
        }
        return xmlConfiguration.lcaVersion(string, string2, 0);
    }

    public static int lcaVersion(String string, String string2, int n) throws SQLException {
        if (conn == null) {
            conn = DriverManager.getConnection("jdbc:sapdb://PTS/QADB", "TESTER", "TESTER");
        }
        Statement statement = conn.createStatement();
        StringBuffer stringBuffer = new StringBuffer("SELECT MAX(l.version) AS max_lcaversion FROM makes m INNER JOIN platforms p ON m.idplatform = p.id INNER JOIN lcamakes l on m.id = l.idmake WHERE m.version = '" + string.substring(0, 4) + "' ");
        if (n == 0) {
            stringBuffer.append("AND m.buildpfx = '" + string.substring(4) + "' " + "AND m.idqastatus = '3' ");
        } else {
            stringBuffer.append("AND m.idqastatus = '" + n + "' ");
        }
        stringBuffer.append("AND p.distribname = '" + string2 + "' ");
        Logger.log(Logger.DEBUG, "Fetching lcaVersion with: " + stringBuffer.toString());
        System.out.println(stringBuffer.toString());
        statement.execute(stringBuffer.toString());
        ResultSet resultSet = statement.getResultSet();
        if (!resultSet.next() || resultSet.getInt(1) == 0) {
            return 0;
        }
        int n2 = resultSet.getInt(1);
        if (n2 < 100000) {
            n2 = xmlConfiguration.fixupLCAVersion(n2);
        }
        return n2;
    }

    public static int lcaVersion(String string) throws SQLException {
        if (conn == null) {
            conn = DriverManager.getConnection("jdbc:sapdb://PTS/QADB", "TESTER", "TESTER");
        }
        Statement statement = conn.createStatement();
        String string2 = "SELECT MAX(l.version) AS max_lcaversion FROM makes m INNER JOIN lcamakes l on m.id = l.idmake WHERE m.id = " + string;
        statement.execute(string2);
        ResultSet resultSet = statement.getResultSet();
        if (!resultSet.next() || resultSet.getInt(1) == 0) {
            return 0;
        }
        int n = resultSet.getInt(1);
        if (n < 100000) {
            n = xmlConfiguration.fixupLCAVersion(n);
        }
        return n;
    }

    public DBVersion fromMakeKey(String string) throws SQLException {
        if (conn == null) {
            conn = DriverManager.getConnection("jdbc:sapdb://PTS/QADB", "TESTER", "TESTER");
        }
        Statement statement = conn.createStatement();
        String string2 = "SELECT m.version, m.buildpfx, m.idqastatus, l.version as lcaVersion FROM makes m LEFT OUTER JOIN lcamakes l ON m.id = l.idmake WHERE m.id = " + string;
        statement.execute(string2);
        ResultSet resultSet = statement.getResultSet();
        if (resultSet.next()) {
            int n = resultSet.getInt(1);
            int n2 = n / 1000;
            int n3 = (n - n2 * 1000) / 100;
            int n4 = n - n2 * 1000 - n3 * 100;
            int n5 = resultSet.getInt(2);
            int n6 = resultSet.getInt(3);
            int n7 = resultSet.getInt(4);
            if (n7 < 100000) {
                n7 = xmlConfiguration.fixupLCAVersion(n7);
            }
            return new DBVersion(n2, n3, n4, n5, n6, n7);
        }
        throw new SQLException("Version not found!");
    }

    public void parseTestConfiguration(InputStream inputStream, String string) throws ConfigurationException, MalformedConfigFileException {
        Logger.log(Logger.DEBUG, "Configuration.retrieveSettings(): reading testrun settings and counting tesruns");
        Document document = new ConfigReader(inputStream, string).readConfig();
        Node node = document.getDocumentElement();
        NodeList nodeList = node.getChildNodes();
        this.testcount = 0;
        int n = 0;
        while (n < nodeList.getLength()) {
            node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                if (node.getNodeName().equals("testrow")) {
                    String string2;
                    String string3;
                    try {
                        Node node2 = this.getNodeMatchingXPath("/version[@role=\"source-start\"]/versionnumber", node);
                        Node node3 = this.getNodeMatchingXPath("/version[@role=\"source-end\"]/versionnumber", node);
                        string3 = node2.getChildNodes().item(0).getNodeValue().trim();
                        string2 = node3.getChildNodes().item(0).getNodeValue().trim();
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new ConfigurationException("Semantically wrong setting on entry #" + n + ": <testrow> MUST contain a <version role=\"source-start\"> and a <version role=\"source-end\"> - either one of them wasn't found or didn't have a versionnumber within");
                    }
                    if (!string3.substring(0, string3.length() - 3).equals(string2.substring(0, string3.length() - 3))) {
                        throw new ConfigurationException("Semantically wrong setting: found <testrow> but start/end versions major, minor and correctionlevel don't match");
                    }
                    String string4 = string3.substring(0, string3.length() - 3);
                    int n2 = 0;
                    int n3 = 0;
                    try {
                        n2 = Integer.parseInt(string3.substring(string3.length() - 2));
                        n3 = Integer.parseInt(string2.substring(string2.length() - 2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ConfigurationException("Semantically wrong setting: found <versionnumber> but couldn't convert the last two characters within it (build number) to an integer");
                    }
                    Logger.log(Logger.VERBOSE, "Found <testrow> from " + string4 + ".xx with xx from " + n2 + " to " + n3);
                    NodeList nodeList2 = node.getChildNodes();
                    NumberFormat numberFormat = NumberFormat.getInstance();
                    numberFormat.setMinimumIntegerDigits(2);
                    while (n2 <= n3) {
                        Node node4;
                        Element element = this.xmlConfigDoc.createElement("test");
                        this.rootNode.appendChild(element);
                        Element element2 = this.xmlConfigDoc.createElement("version");
                        Element element3 = this.xmlConfigDoc.createElement("versionnumber");
                        Text text = this.xmlConfigDoc.createTextNode(string4 + "." + numberFormat.format(n2));
                        Attr attr = this.xmlConfigDoc.createAttribute("role");
                        attr.setNodeValue("source");
                        element3.appendChild(text);
                        element2.appendChild(element3);
                        element2.setAttributeNode(attr);
                        element.appendChild(element2);
                        int n4 = 0;
                        while ((node4 = nodeList2.item(n4)) != null) {
                            node4 = this.xmlConfigDoc.importNode(nodeList2.item(n4), true);
                            element.appendChild(node4);
                            ++n4;
                        }
                        ++this.testcount;
                        ++n2;
                    }
                } else {
                    this.rootNode.appendChild(this.xmlConfigDoc.importNode(node, true));
                    if (node.getNodeName().equals("test")) {
                        ++this.testcount;
                    }
                }
            }
            ++n;
        }
        Logger.log(Logger.DEBUG, "Configuration.retrieveSettings(): " + this.testcount + " test(s) found.");
    }

    private Node getNodeMatchingXPathExp(simpleXPathExpression simpleXPathExpression2, Node node) throws SettingNotFoundException {
        Logger.log(Logger.DEBUG, "Configuration: getNodeMatchingPath called with");
        Logger.log(Logger.DEBUG, "--> path[0] == " + simpleXPathExpression2.get(0));
        if (simpleXPathExpression2.length() > 1) {
            Logger.log(Logger.DEBUG, "--> path[1] == " + simpleXPathExpression2.get(1));
        }
        Logger.log(Logger.DEBUG, "--> parent == " + node.getNodeName());
        if (simpleXPathExpression2.get(0) == null) {
            return node;
        }
        if (simpleXPathExpression2.get(0).charAt(0) == '@') {
            return node.getAttributes().getNamedItem(simpleXPathExpression2.get(0).substring(1));
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            Logger.log(Logger.DEBUG, "Configuration.getNodeMatchingXPathExp(): Nothing found - path was " + simpleXPathExpression2.getExpString());
            return null;
        }
        int n = 0;
        boolean bl = false;
        String string = null;
        String string2 = null;
        if (simpleXPathExpression2.length() > 1 && simpleXPathExpression2.get(1) != null && simpleXPathExpression2.get(1).startsWith("[") && simpleXPathExpression2.get(1).endsWith("]")) {
            try {
                n = Integer.parseInt(simpleXPathExpression2.get(1).substring(1, simpleXPathExpression2.get(1).length() - 1)) - 1;
                simpleXPathExpression2.removeElementAt(1);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
                try {
                    if (simpleXPathExpression2.get(1).charAt(1) != '@') {
                        throw new SettingNotFoundException("Attrib selection used w/o an @ at pos 1");
                    }
                    string = simpleXPathExpression2.get(1).substring(2, simpleXPathExpression2.get(1).indexOf(61));
                    string2 = simpleXPathExpression2.get(1).substring(simpleXPathExpression2.get(1).indexOf(61) + 1, simpleXPathExpression2.get(1).length() - 1);
                    if (!string2.startsWith("\"") || !string2.endsWith("\"")) {
                        throw new SettingNotFoundException("Attrib selection used but value not in quotes");
                    }
                    string2 = string2.substring(1, string2.length() - 1);
                    simpleXPathExpression2.removeElementAt(1);
                    Logger.log(Logger.DEBUG, "We have an attrib selection! " + string + " " + string2 + " " + simpleXPathExpression2.getExpString());
                    bl = true;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    bl = false;
                }
            }
        }
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Logger.log(Logger.DEBUG, "Checking node " + nodeList.item(n2).getNodeName() + " == " + simpleXPathExpression2.get(0));
            if (nodeList.item(n2).getNodeType() == 1 && nodeList.item(n2).getNodeName().equals(simpleXPathExpression2.get(0))) {
                Logger.log(Logger.DEBUG, "Found a match - Node == " + nodeList.item(n2).getNodeName());
                if (n > 0) {
                    Logger.log(Logger.DEBUG, "Config.getNodeMatchingTokenizedXPath(): Skipping on " + nodeList.item(n2).getNodeName());
                    --n;
                } else if (bl) {
                    Logger.log(Logger.DEBUG, "Config.getNodeMatchingTokenizedXPath():Checking for attrib " + string + " == " + string2 + " on " + nodeList.item(n2).getNodeName());
                    try {
                        if (!string2.equals(nodeList.item(n2).getAttributes().getNamedItem(string).getNodeValue())) {
                        }
                    }
                    catch (NullPointerException nullPointerException) {}
                } else {
                    Logger.log(Logger.DEBUG, "Configuration.getNodeMatchingPath(): Recursing - path is " + simpleXPathExpression2.getExpString());
                    Node node2 = this.getNodeMatchingXPathExp(((simpleXPathExpression)simpleXPathExpression2.clone()).removeHead(), nodeList.item(n2));
                    if (node2 != null) {
                        return node2;
                    }
                }
            }
            ++n2;
        }
        Logger.log(Logger.DEBUG, "Configuration.getNodeMatchingTokenizedXPath(): Nothing found - path was " + simpleXPathExpression2.getExpString());
        throw new SettingNotFoundException("Nothing found - path was " + simpleXPathExpression2.getExpString());
    }

    private class simpleXPathExpression
    implements Cloneable {
        private String[] tokenizedXPath;
        private String expString;
        private int position;

        public simpleXPathExpression() {
            this.tokenizedXPath = null;
            this.position = 0;
        }

        public simpleXPathExpression(String string) {
            this.expString = string;
            this.parseXPathExpression(string);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean parseXPathExpression(String string) {
            Vector<String> vector = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            Vector<String> vector2 = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                vector2.add(stringTokenizer.nextToken());
            }
            int n = 0;
            while (n < vector2.size()) {
                int n2 = ((String)vector2.get(n)).indexOf(91);
                if (n2 != -1) {
                    if (!((String)vector2.get(n)).endsWith("]")) return false;
                    vector.add(((String)vector2.get(n)).substring(0, n2));
                    vector.add(((String)vector2.get(n)).substring(n2));
                } else {
                    vector.add((String)vector2.get(n));
                }
                ++n;
            }
            this.position = 0;
            this.tokenizedXPath = vector.toArray(new String[0]);
            this.rebuildExpString();
            return true;
        }

        public simpleXPathExpression removeHead() {
            return this.removeElementAt(0);
        }

        public simpleXPathExpression removeElementAt(int n) {
            while (n < this.tokenizedXPath.length - 1) {
                this.tokenizedXPath[n] = this.tokenizedXPath[n + 1];
                ++n;
            }
            this.tokenizedXPath[n] = null;
            return this;
        }

        private void rebuildExpString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            if (this.tokenizedXPath == null || this.tokenizedXPath.length <= 0 || this.tokenizedXPath.length < n) {
                this.expString = stringBuffer.toString();
            }
            while (n < this.tokenizedXPath.length) {
                if (this.tokenizedXPath[n].startsWith("[")) {
                    stringBuffer.append(this.tokenizedXPath[n]);
                } else {
                    stringBuffer.append("/" + this.tokenizedXPath[n]);
                }
                ++n;
            }
            this.expString = stringBuffer.toString();
        }

        public String get(int n) {
            return this.tokenizedXPath[n];
        }

        public int length() {
            return this.tokenizedXPath.length;
        }

        public boolean hasMoreElements() {
            return this.position < this.tokenizedXPath.length;
        }

        public String nextElement() {
            return this.tokenizedXPath[++this.position];
        }

        public String getExpString() {
            return this.expString;
        }

        public void setExpString(String string) {
            this.expString = string;
            this.parseXPathExpression(string);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    private class DBVersion {
        public int major;
        public int minor;
        public int correction;
        public int build;
        public int qastatus = -1;
        public int lcaVersion = -1;
        public static final int QAUNKNOWN = -1;
        public static final int QARAMP = 3;
        public static final int QACOR = 2;
        public static final int QADEV = 1;

        public DBVersion(int n, int n2, int n3, int n4, int n5, int n6) {
            this.major = n;
            this.minor = n2;
            this.correction = n3;
            this.build = n4;
            this.qastatus = n5;
            this.lcaVersion = n6;
        }

        public DBVersion(int n, int n2, int n3, int n4, int n5) {
            this(n, n2, n3, n4, n5, -1);
        }

        public DBVersion(int n, int n2, int n3, int n4) {
            this(n, n2, n3, n4, -1, -1);
        }

        public DBVersion(int[] nArray) {
            if (nArray.length < 4) {
                throw new ArrayIndexOutOfBoundsException("DBVersion needs at least 4 array values!");
            }
            this.major = nArray[0];
            this.minor = nArray[1];
            this.correction = nArray[2];
            this.build = nArray[3];
            if (nArray.length >= 5) {
                this.qastatus = nArray[4];
            }
            if (nArray.length >= 6) {
                this.lcaVersion = nArray[5];
            }
        }

        public boolean isSmallerThan(DBVersion dBVersion) {
            if (dBVersion.major != this.major) {
                return this.major < dBVersion.major;
            }
            if (dBVersion.minor != this.minor) {
                return this.minor < dBVersion.minor;
            }
            if (dBVersion.correction != this.correction) {
                return this.correction < dBVersion.correction;
            }
            if (dBVersion.build != this.build) {
                return this.build < dBVersion.build;
            }
            return this.qastatus > dBVersion.qastatus;
        }

        public boolean updateNeedsNewSecurityConcept(DBVersion dBVersion) {
            return this.major == 7 && dBVersion.major == 7 && (this.minor < 5 && dBVersion.minor >= 5 || this.minor >= 5 && dBVersion.minor < 5);
        }

        public boolean updateNeedsBackup(DBVersion dBVersion) {
            return this.major == 7 && dBVersion.major == 7 && (this.minor <= 3 && dBVersion.minor > 3 || this.minor > 3 && dBVersion.minor <= 3);
        }

        public boolean hasLiveCache() {
            return this.lcaVersion > 0;
        }

        public boolean isLiveCacheOnly() {
            return this.major == 7 && this.minor == 4 && this.correction == 2;
        }

        public String getCreateDBScript(boolean bl) throws ConfigurationException {
            StringBuffer stringBuffer = new StringBuffer("scripts/create");
            if (bl) {
                stringBuffer.append("lc_");
            } else {
                stringBuffer.append("db_");
            }
            if (this.major == 7) {
                if (this.minor >= 5) {
                    stringBuffer.append("75.script");
                } else {
                    stringBuffer.append("74.script");
                }
                return stringBuffer.toString();
            }
            throw new ConfigurationException("Don't know how to create a database on this version!");
        }

        public String getMajorString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.major);
            stringBuffer.append(this.minor);
            if (this.correction < 10) {
                stringBuffer.append("0");
                stringBuffer.append(this.correction);
            } else {
                stringBuffer.append(this.correction);
            }
            return stringBuffer.toString();
        }

        public String toString() {
            return this.major + "." + this.minor + "." + (this.correction >= 10 ? "" + this.correction : "0" + this.correction) + "." + (this.build >= 10 ? "" + this.build : "0" + this.build);
        }

        public String toXMLTag() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<versionnumber");
            if (this.qastatus == 1) {
                stringBuffer.append(" state=\"DEV\"");
            } else if (this.qastatus == 2) {
                stringBuffer.append(" state=\"COR\"");
            }
            stringBuffer.append('>');
            stringBuffer.append(this.major);
            stringBuffer.append('.');
            stringBuffer.append(this.minor);
            stringBuffer.append('.');
            stringBuffer.append(this.correction >= 10 ? "" + this.correction : "0" + this.correction);
            if (this.qastatus >= 3) {
                stringBuffer.append('.');
                stringBuffer.append(this.build >= 10 ? "" + this.build : "0" + this.build);
            }
            stringBuffer.append("</versionnumber>");
            return stringBuffer.toString();
        }
    }
}

