/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import java.io.UTFDataFormatException;

public class StreamString {
    private String m_string;
    private byte[] m_UTFBuf;
    private int m_hashCode;
    private boolean m_isHashCodeDefined;

    public StreamString(String str) {
        this.m_string = str;
        this.m_UTFBuf = null;
        this.m_hashCode = str.hashCode();
        this.m_isHashCodeDefined = true;
    }

    public StreamString(byte[] UTFByteArray) {
        this.m_string = null;
        this.m_UTFBuf = UTFByteArray;
        this.m_hashCode = 0;
        this.m_isHashCodeDefined = false;
    }

    public StreamString(byte[] UTFByteArray, int hashCodeValue) {
        this.m_string = null;
        this.m_UTFBuf = UTFByteArray;
        this.m_hashCode = hashCodeValue;
        this.m_isHashCodeDefined = true;
    }

    private void convertIntoUTF() {
        int strlen = this.m_string.length();
        char[] charr = new char[strlen];
        int count = 0;
        this.m_string.getChars(0, strlen, charr, 0);
        byte[] buf = new byte[3 * strlen];
        for (int i = 0; i < strlen; ++i) {
            char c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                buf[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                buf[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                buf[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                buf[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            buf[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            buf[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        this.m_UTFBuf = new byte[2 + count];
        this.m_UTFBuf[0] = (byte)(count >>> 8 & 0xFF);
        this.m_UTFBuf[1] = (byte)(count >>> 0 & 0xFF);
        System.arraycopy(buf, 0, this.m_UTFBuf, 2, count);
    }

    private void convertUTFIntoString() throws UTFDataFormatException {
        int utflen = this.m_UTFBuf.length - 2;
        char[] str = new char[utflen];
        int count = 0;
        int strlen = 0;
        block5: while (count < utflen) {
            int c = this.m_UTFBuf[2 + count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = this.m_UTFBuf[2 + count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = this.m_UTFBuf[2 + count - 2];
                    byte char3 = this.m_UTFBuf[2 + count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        this.m_string = new String(str, 0, strlen);
    }

    public static StreamString create(String str) {
        return str == null ? null : new StreamString(str);
    }

    public boolean equals(Object anObject) {
        byte[] otherBuf;
        if (this == anObject) {
            return true;
        }
        if (!(anObject instanceof StreamString)) {
            return false;
        }
        if (this.m_UTFBuf == null) {
            this.convertIntoUTF();
        }
        if (this.m_UTFBuf.length != (otherBuf = ((StreamString)anObject).getUTF()).length) {
            return false;
        }
        for (int i = 0; i < this.m_UTFBuf.length; ++i) {
            if (this.m_UTFBuf[i] == otherBuf[i]) continue;
            return false;
        }
        return true;
    }

    public String getString() {
        if (this.m_string == null) {
            try {
                this.convertUTFIntoString();
            }
            catch (UTFDataFormatException e) {
                this.m_string = null;
            }
        }
        return this.m_string;
    }

    public String toString() {
        return this.getString();
    }

    public static String getString(StreamString str) {
        return str == null ? null : str.getString();
    }

    public byte[] getUTF() {
        if (this.m_UTFBuf == null) {
            this.convertIntoUTF();
        }
        return this.m_UTFBuf;
    }

    public int getUTFLength() {
        if (this.m_UTFBuf == null) {
            this.convertIntoUTF();
        }
        return this.m_UTFBuf.length;
    }

    public int hashCode() {
        if (!this.m_isHashCodeDefined) {
            this.m_hashCode = this.getString().hashCode();
            this.m_isHashCodeDefined = true;
        }
        return this.m_hashCode;
    }

    public void setHashCode(int hashCode) {
        this.m_hashCode = hashCode;
        this.m_isHashCodeDefined = true;
    }
}

