/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.agents.JmsThread;

public class SendingNotificationCounter {
    private int m_used = 0;
    private int m_limit = 10;
    private int m_wanted = 0;
    private static final String WAIT_REASON = "send queue space";

    public SendingNotificationCounter(int limit) {
        if (limit > this.m_limit) {
            this.m_limit = limit;
        }
    }

    public void decr() {
        this.decr(1);
    }

    public synchronized void decr(int counter) {
        this.m_used -= counter;
        if (this.m_used < 0) {
            this.m_used = 0;
        }
        if (this.m_wanted > 0 && this.m_used + this.m_wanted <= this.m_limit) {
            this.m_wanted = 0;
            this.notifyAll();
        }
    }

    public synchronized void incr() {
        ++this.m_used;
    }

    public synchronized void waitForSpace(int wantedNotifications) throws InterruptedException {
        if (wantedNotifications <= 0) {
            return;
        }
        if (this.m_used + this.m_wanted + wantedNotifications > this.m_limit) {
            this.m_wanted += wantedNotifications;
            if (this.m_wanted > this.m_limit) {
                this.m_wanted = this.m_limit;
            }
            JmsThread.performWait(this, 0L, WAIT_REASON);
        }
    }

    public synchronized int used() {
        return this.m_used;
    }
}

