/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.util.AdminNotification;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import java.io.IOException;

public class ResetAdminNotification
extends AdminNotification {
    private boolean myIsQueue;
    private boolean myIsDurable;
    private long myConsumerID;
    private long myMessageID;

    ResetAdminNotification() {
        this.myIsQueue = false;
        this.myConsumerID = 0L;
        this.myMessageID = 0L;
        this.myIsDurable = false;
    }

    public ResetAdminNotification(long messageID, long consumerID, boolean isQueue, boolean isDurable) {
        super(-1);
        this.myMessageID = messageID;
        this.myConsumerID = consumerID;
        this.myIsQueue = isQueue;
        this.myIsDurable = isDurable;
    }

    public boolean getIsDurable() {
        return this.myIsDurable;
    }

    public boolean getIsQueue() {
        return this.myIsQueue;
    }

    public long getConsumerID() {
        return this.myConsumerID;
    }

    public long getMessageID() {
        return this.myMessageID;
    }

    public String toString() {
        return "ResetAdminNotification: " + super.toString();
    }

    void readFromStream(ReceiveStream in) throws IOException {
        super.deserialize(in);
        this.myIsQueue = in.readBoolean();
        this.myIsDurable = in.readBoolean();
        this.myConsumerID = in.readLong();
        this.myMessageID = in.readLong();
    }

    void writeToStream(SendStream out) throws IOException {
        super.serialize(out, 8, 18);
        out.writeBoolean(this.myIsQueue);
        out.writeBoolean(this.myIsDurable);
        out.writeLong(this.myConsumerID);
        out.writeLong(this.myMessageID);
    }
}

