/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.agents.JmsThread;
import com.sap.sdb.msgServer.util.AckOneMessageByClientNotification;
import com.sap.sdb.msgServer.util.ActivateAdminNotification;
import com.sap.sdb.msgServer.util.AdminNotification;
import com.sap.sdb.msgServer.util.BrowserNotification;
import com.sap.sdb.msgServer.util.BrowserRegNotification;
import com.sap.sdb.msgServer.util.ClientEndTransNotification;
import com.sap.sdb.msgServer.util.ClientSessionAddress;
import com.sap.sdb.msgServer.util.DeactivateAdminNotification;
import com.sap.sdb.msgServer.util.DestinationAdminNotification;
import com.sap.sdb.msgServer.util.ErrorNotification;
import com.sap.sdb.msgServer.util.IDNotification;
import com.sap.sdb.msgServer.util.MessageNotification;
import com.sap.sdb.msgServer.util.OkNotification;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.RequestServerTimeAdminNotification;
import com.sap.sdb.msgServer.util.ResetAdminNotification;
import com.sap.sdb.msgServer.util.SendStream;
import com.sap.sdb.msgServer.util.ServerTimeNotification;
import com.sap.sdb.msgServer.util.StreamString;
import com.sap.sdb.msgServer.util.SyncReceiveNotification;
import com.sap.sdb.msgServer.util.TimeOutNotification;
import java.io.IOException;
import java.io.Serializable;

public class Notification
implements Serializable {
    private ClientSessionAddress myClientSessionAddress = new ClientSessionAddress();
    private StreamString myServerQueue = null;
    private int myType = -1;
    private int myDeserializedVersion = 0;
    public static final int UNDEF_NOTIFICATION_TYPE = -1;
    private static final int NOTIFICATION_MAIN_VERSION_01 = -608567295;
    private static final int NOTIFICATION_VERSION_01 = -608501759;
    private static final int NOTIFICATION_END_INCREMENT = 65536;
    private static final int NOTIFICATION = 1;
    static final int ACK_ONE_MSG_BY_CLIENT_NOTIFICATION = 2;
    static final int ADMIN_NOTIFICATION = 3;
    static final int ADMIN_ACTIVATE_NOTIFICATION = 4;
    static final int ADMIN_DEACTIVATE_NOTIFICATION = 5;
    static final int ADMIN_DESTINATION_NOTIFICATION = 6;
    static final int ADMIN_REQ_SERVER_TIME_NOTIFICATION = 7;
    static final int ADMIN_RESET_NOTIFICATION = 8;
    static final int CLIENT_END_TRANS_NOTIFICATION = 9;
    static final int ERROR_NOTIFICATION = 10;
    static final int ID_NOTIFICATION = 11;
    static final int MESSAGE_NOTIFICATION = 12;
    static final int OK_NOTIFICATION = 13;
    static final int PERSISTED_NOTIFICATION = 14;
    static final int BROWSER_NOTIFICATION = 15;
    static final int BROWSER_REG_NOTIFICATION = 16;
    static final int SERVER_TIME_NOTIFICATION = 17;
    static final int SYNC_RECEIVE_NOTIFICATION = 18;
    static final int TIME_OUT_NOTIFICATION = 19;
    static final int VECTOR_NOTIFICATION = 20;

    Notification() {
    }

    public Notification(String serverQueue) {
        this();
        this.setServerQueue(serverQueue);
    }

    public Notification(int type, String serverQueue) {
        this();
        this.myType = type;
        this.setServerQueue(serverQueue);
    }

    int getDeserializedVersion() {
        return this.myDeserializedVersion;
    }

    int getNotificationVersion() {
        return -608501759;
    }

    public int getType() {
        return this.myType;
    }

    public void setType(int type) {
        this.myType = type;
    }

    public ClientSessionAddress getClientSessionAddress() {
        return this.myClientSessionAddress;
    }

    public void setClientSessionAddress(ClientSessionAddress clientSessionAddress) {
        this.myClientSessionAddress.setAddress(clientSessionAddress);
    }

    public void setClientSessionAddress(StreamString clientID, String queueID) {
        this.myClientSessionAddress.setAddress(clientID, queueID);
    }

    public boolean hasClientSessionAddress() {
        return this.myClientSessionAddress.isValid();
    }

    public String getServerQueue() {
        return StreamString.getString(this.myServerQueue);
    }

    protected void setServerQueue(String queue) {
        this.myServerQueue = StreamString.create(queue);
    }

    public String toString() {
        return "(Client:" + this.myClientSessionAddress.toString() + ",ServerAgent:" + this.getServerQueue() + ",Type:" + this.myType + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Notification getFromClient(ReceiveStream in) throws IOException {
        JmsThread ownThread = JmsThread.setAction("receiving notification from client");
        try {
            Notification notification = Notification.newNotificationFromStream(in);
            notification.receiveFromClient(in);
            notification.endDeserialize(in);
            Notification notification2 = notification;
            return notification2;
        }
        finally {
            if (ownThread != null) {
                ownThread.resetAction();
            }
        }
    }

    public static Notification getFromServer(ReceiveStream in) throws IOException {
        Notification notification = Notification.newNotificationFromStream(in);
        notification.receiveFromServer(in);
        notification.endDeserialize(in);
        return notification;
    }

    public void sendToClient(SendStream out) throws IOException {
        this.writeToStream(out);
        this.endSerialize(out);
    }

    public void sendToServer(SendStream out) throws IOException {
        this.writeToStream(out);
        this.endSerialize(out);
    }

    void deserialize(ReceiveStream in) throws IOException {
        this.myClientSessionAddress.deserialize(in);
        this.myServerQueue = in.readStreamString();
        this.myType = in.readInt();
    }

    private void endDeserialize(ReceiveStream in) throws IOException {
        int endVersion = in.readInt();
        if (endVersion != this.myDeserializedVersion + 65536) {
            throw new IOException("unknown end notification version: " + endVersion);
        }
    }

    void endSerialize(SendStream out) throws IOException {
        out.writeInt(this.getNotificationVersion() + 65536);
        out.flush();
    }

    private static Notification newNotificationFromStream(ReceiveStream in) throws IOException {
        Notification notification = null;
        in.readInt();
        int version = in.readInt();
        if (version != -608567295) {
            throw new IOException("unknown notification main version: " + version);
        }
        version = in.readInt();
        byte notificationClassType = in.readByte();
        switch (notificationClassType) {
            case 1: {
                notification = new Notification();
                notification.deserialize(in);
                break;
            }
            case 2: {
                notification = new AckOneMessageByClientNotification();
                break;
            }
            case 3: {
                notification = new AdminNotification();
                break;
            }
            case 4: {
                notification = new ActivateAdminNotification();
                break;
            }
            case 5: {
                notification = new DeactivateAdminNotification();
                break;
            }
            case 6: {
                notification = new DestinationAdminNotification();
                break;
            }
            case 7: {
                notification = new RequestServerTimeAdminNotification();
                break;
            }
            case 8: {
                notification = new ResetAdminNotification();
                break;
            }
            case 10: {
                notification = new ErrorNotification();
                break;
            }
            case 11: {
                notification = new IDNotification();
                break;
            }
            case 12: {
                notification = new MessageNotification();
                break;
            }
            case 13: {
                notification = new OkNotification();
                break;
            }
            case 15: {
                notification = new BrowserNotification();
                break;
            }
            case 16: {
                notification = new BrowserRegNotification();
                break;
            }
            case 17: {
                notification = new ServerTimeNotification();
                break;
            }
            case 18: {
                notification = new SyncReceiveNotification();
                break;
            }
            case 19: {
                notification = new TimeOutNotification();
                break;
            }
            case 9: {
                notification = new ClientEndTransNotification();
                break;
            }
            default: {
                throw new IOException("unknown notification class type: " + notificationClassType);
            }
        }
        if (version != notification.getNotificationVersion()) {
            throw new IOException("unknown notification version: " + version);
        }
        notification.myDeserializedVersion = version;
        return notification;
    }

    void readFromStream(ReceiveStream in) throws IOException {
    }

    void receiveFromClient(ReceiveStream in) throws IOException {
        this.readFromStream(in);
    }

    void receiveFromServer(ReceiveStream in) throws IOException {
        this.readFromStream(in);
    }

    void serialize(SendStream out, int notificationClassType, int streamLengthSubclass) throws IOException {
        int notificationLength = streamLengthSubclass < 0 ? -1 : 9 + this.myClientSessionAddress.getSerializationLength() + SendStream.getStreamStringLength(this.myServerQueue) + 4 + streamLengthSubclass + 4;
        out.writeInt(notificationLength);
        out.writeInt(-608567295);
        out.writeInt(this.getNotificationVersion());
        out.writeByte(notificationClassType);
        this.myClientSessionAddress.serialize(out);
        out.writeStreamString(this.myServerQueue);
        out.writeInt(this.myType);
    }

    void writeToStream(SendStream out) throws IOException {
        if (this.getClass() == Notification.class) {
            this.serialize(out, 1, 0);
            return;
        }
        throw new UnsupportedOperationException("Serialization of an unknown notification not supported");
    }
}

