/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

public class ConnectionTransfer {
    private int _clientStreamType;
    private String _clientID;
    private String _user;
    private String _password;
    private SendStream _clientSendStream;
    private static final int CONNECT_VERSION_01 = -609615871;
    private static final int CONNECT_END_VERSION_01 = -609550335;
    private static final int UNDEF_STREAM = 0;
    private static final int JAVA_STREAM = 1;
    private static final int NATIVE_STREAM = 2;

    public ConnectionTransfer(ReceiveStream in) throws IOException {
        this._clientStreamType = 0;
        this._clientID = null;
        this._clientSendStream = null;
        this._user = null;
        this._password = null;
        this.receiveFromClient(in);
    }

    public ConnectionTransfer(Socket connectionSocket, String user, String password) throws IOException {
        this._clientStreamType = 1;
        this._clientSendStream = this.getSendStream(connectionSocket.getOutputStream());
        this._clientID = connectionSocket.getLocalAddress().getHostAddress() + ":" + connectionSocket.getLocalPort();
        this._user = user;
        this._password = password;
        this.sendToServer();
    }

    public String getClientID() {
        return this._clientID;
    }

    public SendStream getClientSendStream() {
        return this._clientSendStream;
    }

    public SendStream getSendStream(OutputStream out) throws IOException {
        return new SendStream(out, 2048, this._clientStreamType == 2);
    }

    private void receiveFromClient(ReceiveStream in) throws IOException {
        in.readInt();
        int version = in.readInt();
        if (version != -609615871) {
            throw new IOException("unknown connection message version: " + version);
        }
        this._clientStreamType = in.readByte();
        this._clientID = in.readUTF();
        this._user = in.readUTF();
        this._password = in.readUTF();
        version = in.readInt();
        if (version != -609550335) {
            throw new IOException("unknown connection message end version: " + version);
        }
    }

    private void sendToServer() throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(128);
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        dataStream.writeInt(-609615871);
        dataStream.writeByte(this._clientStreamType);
        dataStream.writeUTF(this._clientID);
        dataStream.writeUTF(this._user);
        dataStream.writeUTF(this._password);
        dataStream.writeInt(-609550335);
        dataStream.flush();
        byte[] sendBuf = byteStream.toByteArray();
        this._clientSendStream.writeInt(sendBuf.length);
        this._clientSendStream.write(sendBuf);
        this._clientSendStream.flush();
    }

    public String getUser() {
        return this._user;
    }

    public String getPassword() {
        return this._password;
    }
}

