/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.transientStorage;

import com.sap.sdb.minDB.dataAccess.IndexKey;
import com.sap.sdb.minDB.dataAccess.Table;
import com.sap.sdb.minDB.dataAccess.TableName;
import com.sap.sdb.minDB.dataAccess.TableRow;
import com.sap.sdb.minDB.dataAccessInterface.ConnectionHandle;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseKey;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseTableRow;
import com.sap.sdb.msgServer.transientStorage.TableRowWithIndex;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;

public class TableWithIndex
extends Table {
    private int[] m_indexColNo = null;
    private boolean[] m_indexColAsc = null;
    private TreeMap m_indexTree = null;

    private TableWithIndex(TableName tabname, LinkedList columnNames, LinkedList columnTypeList, LinkedList keyColumnNames) throws SQLException {
        super(tabname, columnNames, columnTypeList, keyColumnNames);
    }

    public static TableWithIndex getNewTableWithIndex(TableName tabname, LinkedList columnNames, LinkedList columnTypeList, LinkedList keyColumnNames, int indexCol1No, boolean indexCol1IsAsc, int indexCol2No, boolean indexCol2IsAsc, int indexCol3No, boolean indexCol3IsAsc) throws SQLException {
        TableWithIndex tab = new TableWithIndex(tabname, columnNames, columnTypeList, keyColumnNames);
        tab.m_indexTree = new TreeMap();
        tab.m_indexColNo = new int[4];
        tab.m_indexColAsc = new boolean[4];
        tab.m_indexColNo[0] = -1;
        tab.m_indexColAsc[0] = false;
        tab.m_indexColNo[1] = indexCol1No;
        tab.m_indexColAsc[1] = indexCol1IsAsc;
        tab.m_indexColNo[2] = indexCol2No;
        tab.m_indexColAsc[2] = indexCol2IsAsc;
        tab.m_indexColNo[3] = indexCol3No;
        tab.m_indexColAsc[3] = indexCol3IsAsc;
        return tab;
    }

    public Iterator getIndexIterator() {
        return this.m_indexTree.values().iterator();
    }

    public TableRow getNewRow() {
        return new TableRowWithIndex(this.getMaxNumericColNo(), this.getMaxObjectColNo(), this.getNewKey());
    }

    public void insertRow(ConnectionHandle connection, TableRow row) throws SQLException {
        super.insertRow(connection, row);
        IndexKey indexKey = new IndexKey(false, -1, row, this.m_indexColNo, this.m_indexColAsc);
        ((TableRowWithIndex)row).setIndexKey(indexKey);
        this.m_indexTree.put(indexKey, row);
    }

    public void removeAll() {
        super.removeAll();
        this.m_indexTree.clear();
    }

    public void removeIndexRow(DatabaseKey indexKey) {
        this.m_indexTree.remove(indexKey);
    }

    public DatabaseTableRow removeRow(DatabaseKey key) {
        TableRowWithIndex row = (TableRowWithIndex)super.removeRow(key);
        this.m_indexTree.remove(row.getIndexKey());
        return row;
    }

    public void replaceRow(TableRow row) {
        super.replaceRow(row);
        this.m_indexTree.put(((TableRowWithIndex)row).getIndexKey(), row);
    }
}

