/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.service;

import com.sap.sdb.msgServer.Server;
import com.sap.sdb.msgServer.agents.SocketListener;
import com.sap.sdb.msgServer.client.AdminConnection;
import com.sap.sdb.msgServer.service.Service;
import com.sap.sdb.msgServer.service.ServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class AdminService
extends Service {
    String mPassWord;
    boolean myAuthorizedFlag = false;
    boolean myConnectedFlag = false;
    private static final int ADMIN_PW_MIN = 8;
    private static final int ADMIN_PW_MAX = 512;

    public AdminService(Server server) throws ServiceException {
        super(server, "AdminService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void serve(InputStream i, OutputStream o) throws IOException {
        String commandLine = null;
        AdminConnection clientConnect = new AdminConnection();
        clientConnect.open(i, o);
        try {
            AdminService adminService = this;
            synchronized (adminService) {
                if (this.myConnectedFlag) {
                    clientConnect.println("ONLY ONE ADMIN CONNECTION ALLOWED AT A TIME.");
                    clientConnect.close();
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 12] lbl10 : MonitorExitStatement: MONITOREXIT : var5_5
                    Object var8_8 = null;
                    clientConnect.close();
                    this.myConnectedFlag = false;
                    this.myAuthorizedFlag = false;
                    return;
                }
                this.myConnectedFlag = true;
            }
            while (!this.isStopped()) {
                if (commandLine != null) {
                    clientConnect.sendLines();
                }
                try {
                    commandLine = clientConnect.receivedMessage();
                }
                catch (Exception e) {
                    clientConnect.println(e.toString());
                    this.stopService();
                }
                if (commandLine == null) {
                    this.stopService();
                    continue;
                }
                try {
                    this.handleCommandLine(clientConnect, commandLine);
                }
                catch (Exception e) {
                    clientConnect.println("EXCEPTION WHILE PARSING OR EXECUTING COMMAND:");
                    clientConnect.println(e.toString());
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            clientConnect.close();
            this.myConnectedFlag = false;
            this.myAuthorizedFlag = false;
            throw throwable;
        }
        Object var8_9 = null;
        clientConnect.close();
        this.myConnectedFlag = false;
        this.myAuthorizedFlag = false;
    }

    private void handleCommandLine(AdminConnection clientConnect, String commandLine) throws ServiceException {
        String[] tokens = this.tokenize(commandLine);
        if (tokens.length == 0) {
            return;
        }
        String command = tokens[0].toLowerCase();
        if (command.equals("password")) {
            String p = tokens[1];
            if (p.equals(this.mPassWord)) {
                clientConnect.println("OK");
                this.myAuthorizedFlag = true;
            } else {
                clientConnect.println("INVALID PASSWORD");
            }
        } else if (command.equals("help")) {
            clientConnect.println("COMMANDS:" + Server.lineSep + "General:" + Server.lineSep + "\tpassword <password>" + Server.lineSep + "\tversion" + "\thelp" + Server.lineSep + "\tquit" + Server.lineSep + "\tping" + Server.lineSep + Server.lineSep + "Password protected:" + Server.lineSep + "---------------------" + Server.lineSep + "\tmax <max-connections>" + Server.lineSep + "\tstatus [debug]" + Server.lineSep + "\tshutdown" + Server.lineSep + this.myServer.getJMSService().doCommand("help"));
        } else if (command.equals("quit")) {
            this.stopService();
        } else if (command.equals("version")) {
            clientConnect.println(Server.getVersion());
        } else if (command.equals("ping")) {
            clientConnect.println("Server is alive. Version: " + Server.getVersion());
        } else if (command.equals("max")) {
            if (!this.isAuthorized(clientConnect)) {
                return;
            }
            int max = Integer.parseInt(tokens[1]);
            this.getServer().getConnectionManager().setMaxConnections(max);
            clientConnect.println("MAX CONNECTIONS CHANGED");
        } else if (command.equals("status")) {
            if (!this.isAuthorized(clientConnect)) {
                return;
            }
            clientConnect.println("Message Server Version: " + Server.getVersion());
            Enumeration keys = this.getServer().getListeners().keys();
            while (keys.hasMoreElements()) {
                Integer port = (Integer)keys.nextElement();
                SocketListener listener = (SocketListener)this.getServer().getListeners().get(port);
                clientConnect.println("SERVICE " + listener.getService().getClass().getName() + " ON PORT " + port);
            }
            this.getServer().getConnectionManager().printConnections(clientConnect);
            clientConnect.println("MAX CONNECTIONS: " + this.getServer().getConnectionManager().getMaxConnections());
            String answer = this.myServer.getJMSService().doCommand(commandLine);
            clientConnect.println(answer);
        } else if (command.equals("shutdown")) {
            if (!this.isAuthorized(clientConnect)) {
                return;
            }
            this.getServer().shutdown();
            this.stopService();
        } else {
            if (!this.isAuthorized(clientConnect)) {
                return;
            }
            String answer = this.myServer.getJMSService().doCommand(commandLine);
            clientConnect.println(answer);
        }
    }

    private boolean isAuthorized(AdminConnection con) {
        if (!this.myAuthorizedFlag) {
            con.println("PASSWORD REQUIRED");
            return false;
        }
        return true;
    }

    public void open(Hashtable global_commandline_options) throws ServiceException {
        String password = "";
        password = this.myServer.getServerConfig().getAdminPassword();
        if (password == null || password.length() < 8) {
            throw new ServiceException(this, "Administration password must have at least 8 characters.");
        }
        if (password == null || password.length() > 512) {
            throw new ServiceException(this, "Administration password too long.");
        }
        this.mPassWord = password;
    }

    public void close() {
    }
}

