/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.msgselector.parsing;

import com.sap.sdb.msgServer.msgselector.parsing.LanguageDefinition;

public class Token
implements LanguageDefinition {
    private String m_strVal = "";
    private double m_doubleVal = 0.0;
    private long m_longVal = 0L;
    private int m_type = -1;
    private int m_tokenNumber = 0;
    private int m_tokenPos = 0;

    private Token(int type, int number, int pos) {
        this.m_type = type;
        this.m_tokenNumber = number;
        this.m_tokenPos = pos;
    }

    public int getNumberOfToken() {
        return this.m_tokenNumber;
    }

    public int getPositionOfToken() {
        return this.m_tokenPos;
    }

    public boolean isWord() {
        return (this.m_type & 0x1000) != 0;
    }

    public String getWord() {
        return this.m_strVal;
    }

    public String getSQLToken() {
        String retval = null;
        switch (this.m_type) {
            case 8194: {
                retval = Token.SQLLiteralize(this.m_strVal);
                break;
            }
            case 8197: {
                retval = "" + this.m_longVal;
                break;
            }
            case 8195: {
                retval = "" + this.m_doubleVal;
                break;
            }
            default: {
                retval = this.m_strVal;
            }
        }
        return retval;
    }

    private static String SQLLiteralize(String inp) {
        StringBuffer sbuf = new StringBuffer("'");
        char[] bbuf = new char[inp.length()];
        inp.getChars(0, inp.length(), bbuf, 0);
        for (int i = 0; i < bbuf.length; ++i) {
            if (bbuf[i] == '\'') {
                sbuf.append('\'');
            }
            sbuf.append(bbuf[i]);
        }
        sbuf.append('\'');
        return new String(sbuf);
    }

    public double getDouble() {
        return this.m_doubleVal;
    }

    public long getLong() {
        return this.m_longVal;
    }

    public String getString() {
        return this.m_strVal;
    }

    public boolean isLiteral() {
        return (this.m_type & 0x2000) != 0;
    }

    public boolean isSyntaxElement() {
        return (this.m_type & 0x800) != 0;
    }

    public int getType() {
        return this.m_type;
    }

    public String toString() {
        switch (this.m_type) {
            case 4096: {
                return this.m_strVal;
            }
            case 8195: 
            case 8197: {
                return "" + this.m_doubleVal;
            }
            case 8194: {
                return "\"" + this.m_strVal + "\"";
            }
        }
        return this.getStringForFixedSyntaxElement(this.m_type);
    }

    public static final Token getWord(int number, int pos, String w) {
        Token t = new Token(4096, number, pos);
        t.m_strVal = w;
        return t;
    }

    public static final Token getDoubleLiteral(int number, int pos, double d) {
        Token t = new Token(8195, number, pos);
        t.m_doubleVal = d;
        return t;
    }

    public static final Token getLongLiteral(int number, int pos, long l) {
        Token t = new Token(8197, number, pos);
        t.m_longVal = l;
        return t;
    }

    public static final Token getStringLiteral(int number, int pos, String s) {
        Token t = new Token(8194, number, pos);
        t.m_strVal = s;
        return t;
    }

    public static final Token getFixedSyntaxElement(int number, int pos, char c) {
        return new Token(Token.getTypeForFixedSyntaxElement(c), number, pos);
    }

    public static int getTypeForFixedSyntaxElement(char c) {
        return Token.getTypeForFixedSyntaxElement("" + c);
    }

    public static int getTypeForFixedSyntaxElement(String s) {
        for (int i = 0; i < SYNTAX_ELEMENTS_STR.length; ++i) {
            if (!SYNTAX_ELEMENTS_STR[i].equals(s)) continue;
            return SYNTAX_ELEMENTS_TYPES[i];
        }
        throw new IllegalArgumentException("Unknown fixed syntax element '" + s + "'");
    }

    public String getStringForFixedSyntaxElement(int type) {
        for (int i = 0; i < SYNTAX_ELEMENTS_TYPES.length; ++i) {
            if (SYNTAX_ELEMENTS_TYPES[i] != type) continue;
            return SYNTAX_ELEMENTS_STR[i];
        }
        throw new IllegalArgumentException("Unknown fixed syntax element type " + type);
    }
}

