/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.msgselector.parsing;

public class OperatorInfo {
    private String m_opWord = "";
    private boolean m_caseSens = true;
    private String[] m_argNames = null;
    private int m_leftArgCount = 0;
    private int m_rightArgCount = 0;
    private int m_binding = 0;

    public OperatorInfo(String word, int left, int right, int binding, boolean casesensitive, String[] argNames) {
        this.m_opWord = word;
        this.m_leftArgCount = left;
        this.m_rightArgCount = right;
        this.m_binding = binding;
        this.m_argNames = argNames;
        this.m_caseSens = casesensitive;
    }

    public OperatorInfo(String word, int left, int right, int binding, boolean casesensitive) {
        this(word, left, right, binding, casesensitive, null);
        this.m_argNames = new String[left + right];
        for (int i = 0; i < this.m_argNames.length; ++i) {
            this.m_argNames[i] = "";
        }
    }

    public String getWord() {
        return this.m_opWord;
    }

    public String getNormalizedWord() {
        return this.m_caseSens ? this.m_opWord : this.m_opWord.toUpperCase();
    }

    public int getLeftArgumentCount() {
        return this.m_leftArgCount;
    }

    public int getRightArgumentCount() {
        return this.m_rightArgCount;
    }

    public int getBindingForce() {
        return this.m_binding;
    }

    public String getArgNameAt(int n) {
        return this.m_argNames[n];
    }

    public boolean isCaseSensitive() {
        return this.m_caseSens;
    }
}

