/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.msgselector;

import com.sap.sdb.msgServer.client.MessageHeaderFields;
import com.sap.sdb.msgServer.client.MessageProperties;
import com.sap.sdb.msgServer.msgselector.GlobalContextSupplier;
import com.sap.sdb.msgServer.msgselector.parsing.AbstractTreeNode;
import com.sap.sdb.msgServer.msgselector.parsing.ExpressionTreeBuilder;
import com.sap.sdb.msgServer.msgselector.parsing.Tokenizer;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.InvalidSelectorException;

public class MsgSelector {
    private static final boolean MSGSELECTOR_OFF = false;
    private AbstractTreeNode m_parsetreeRoot = null;
    private boolean m_haveselector = false;
    private boolean m_parseerror = false;

    public MsgSelector(String sqlstring) throws InvalidSelectorException {
        if (sqlstring != null) {
            int i;
            int len = sqlstring.length();
            char[] buf = new char[len];
            sqlstring.getChars(0, len, buf, 0);
            for (i = 0; i < len && Character.isWhitespace(buf[i]); ++i) {
            }
            if (i < len) {
                this.m_haveselector = true;
                try {
                    this.parse(buf);
                }
                catch (Exception ex) {
                    InvalidSelectorException toThrow = new InvalidSelectorException(ex.getMessage());
                    toThrow.setLinkedException(ex);
                    this.m_parseerror = true;
                    throw toThrow;
                }
            }
        }
    }

    public Hashtable getMatchParameters() {
        return null;
    }

    public boolean isEmpty() {
        return !this.m_haveselector;
    }

    public boolean hasParseerror() {
        return this.m_parseerror;
    }

    public boolean matches(MessageHeaderFields header, MessageProperties props) {
        boolean result = true;
        if (this.m_haveselector) {
            if (this.m_parseerror) {
                result = false;
            } else {
                try {
                    GlobalContextSupplier globCtx = new GlobalContextSupplier(header, props);
                    Object resultobj = this.m_parsetreeRoot.evaluate(globCtx, false);
                    result = resultobj == null || !(resultobj instanceof Boolean) ? false : (Boolean)resultobj;
                }
                catch (Exception ex) {
                    result = false;
                }
            }
        }
        return result;
    }

    private void parse(char[] buf) throws Exception {
        Vector vecTokens = null;
        vecTokens = Tokenizer.tokenize(buf);
        this.m_parsetreeRoot = ExpressionTreeBuilder.buildExpressionTree(vecTokens);
        MessageHeaderFields header = new MessageHeaderFields();
        MessageProperties props = new MessageProperties();
        GlobalContextSupplier globCtx = new GlobalContextSupplier(header, props);
        this.m_parsetreeRoot.evaluate(globCtx, true);
    }
}

