/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.jndi;

import com.sap.sdb.msgServer.Server;
import com.sap.sdb.msgServer.database.DBConnectionPool;
import com.sap.sdb.msgServer.database.DeliveryPreparedStmt;
import com.sap.sdb.msgServer.database.DeliveryResultSet;
import com.sap.sdb.msgServer.database.UserConnection;
import com.sap.sdb.msgServer.jndi.JndiMessage;
import com.sap.sdb.msgServer.service.Service;
import com.sap.sdb.msgServer.service.ServiceException;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.NamingException;

public class JndiService
extends Service {
    public static String getJndiName() {
        return "JNDI";
    }

    public JndiService(Server server) throws ServiceException {
        super(server, JndiService.getJndiName());
    }

    public void serve(InputStream in, OutputStream out) throws IOException {
        SendStream toClient = new SendStream(out);
        ReceiveStream fromClient = new ReceiveStream(in);
        try {
            JndiMessage message = new JndiMessage(fromClient.readString());
            message.putSerializedObject(fromClient.readByteArray());
            Server.log(message);
            Object answer = this.doCommand(message);
            if (answer instanceof JndiMessage) {
                JndiMessage answerMsg = (JndiMessage)answer;
                toClient.writeBoolean(true);
                toClient.writeString(answerMsg.getCommand());
                toClient.writeByteArray(answerMsg.getSerializedObject());
            } else {
                String errorMsg = answer instanceof Exception ? ((Exception)answer).toString() : "Internal JndiService failure, unknown answer type: " + answer.toString();
                toClient.writeBoolean(false);
                toClient.writeString(errorMsg);
            }
            toClient.flush();
        }
        catch (IOException ex) {
            Server.log("JndiService: " + ex.getMessage());
        }
        try {
            fromClient.close();
            toClient.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static JndiMessage lookup(String name) throws ServiceException {
        UserConnection dbConnection = null;
        DeliveryResultSet result = null;
        try {
            dbConnection = DBConnectionPool.useConnection();
            DeliveryPreparedStmt stmt = dbConnection.getAvailablePreparedStmt(2);
            stmt.setString(1, name);
            result = stmt.executeQuery();
            if (result.next()) {
                byte[] content = result.getBytes(2);
                JndiMessage answer = new JndiMessage("");
                answer.putSerializedObject(content);
                result.close();
                result = null;
                JndiMessage jndiMessage = answer;
                return jndiMessage;
            }
            try {
                result.close();
                result = null;
                throw new ServiceException(JndiService.getJndiName(), "Name <" + name + "> not found!");
            }
            catch (SQLException ex) {
                throw new ServiceException(JndiService.getJndiName(), ex.toString());
            }
        }
        finally {
            DBConnectionPool.returnConnection(dbConnection);
        }
    }

    public static void bind(String name, Object object) throws NamingException {
        JndiMessage tmp = new JndiMessage("");
        tmp.setObject(object);
        JndiService.bind(false, name, tmp.getSerializedObject());
    }

    public static void rebind(String name, Object object) throws NamingException {
        JndiMessage tmp = new JndiMessage("");
        tmp.setObject(object);
        JndiService.bind(true, name, tmp.getSerializedObject());
    }

    public static void unbind(String name) throws NamingException {
        JndiService.unbindInternal(name);
    }

    private Object doCommand(JndiMessage message) {
        Serializable answer;
        try {
            String[] tokens = message.parseCommand();
            String command = tokens[0];
            answer = command.equals("lookup") ? JndiService.lookup(tokens[1]) : (command.equals("bind") ? JndiService.bind(false, tokens[1], message.getSerializedObject()) : (command.equals("rebind") ? JndiService.bind(true, tokens[1], message.getSerializedObject()) : (command.equals("unbind") ? JndiService.unbindInternal(tokens[1]) : new NamingException("Command <" + command + "> not yet implemented"))));
        }
        catch (Exception ex) {
            return ex;
        }
        if (!(answer instanceof JndiMessage) && !(answer instanceof Exception)) {
            answer = new NamingException("Internal JNDI error in doCommand()");
        }
        return answer;
    }

    private static JndiMessage bind(boolean rebind, String name, byte[] serializedObject) throws NamingException {
        UserConnection dbConnection = null;
        try {
            dbConnection = DBConnectionPool.useConnection();
            DeliveryPreparedStmt stmt = dbConnection.getAvailablePreparedStmt(2);
            stmt.setString(1, name);
            DeliveryResultSet result = stmt.executeQuery();
            if (result.next()) {
                if (rebind) {
                    stmt = dbConnection.getAvailablePreparedStmt(1);
                    stmt.setObject(1, serializedObject);
                    stmt.setString(2, name);
                    if (stmt.executeUpdate() != 1) {
                        throw new NamingException("Rebind not successful!");
                    }
                    dbConnection.commit();
                    JndiMessage jndiMessage = new JndiMessage("ok");
                    return jndiMessage;
                }
                throw new NamingException("Name <" + name + "> already bound!");
            }
            result.close();
            result = null;
            stmt = dbConnection.getAvailablePreparedStmt(0);
            stmt.setString(1, name);
            stmt.setBytes(2, serializedObject);
            if (stmt.executeUpdate() != 1) {
                throw new NamingException("Bind not successful!");
            }
            dbConnection.commit();
            JndiMessage jndiMessage = new JndiMessage("ok");
            return jndiMessage;
        }
        catch (SQLException ex) {
            throw new NamingException(ex.toString());
        }
        finally {
            DBConnectionPool.returnConnection(dbConnection);
        }
    }

    private static JndiMessage unbindInternal(String name) throws NamingException {
        UserConnection dbConnection = null;
        try {
            dbConnection = DBConnectionPool.useConnection();
            DeliveryPreparedStmt stmt = dbConnection.getAvailablePreparedStmt(3);
            stmt.setString(1, name);
            stmt.executeUpdate();
            dbConnection.commit();
            JndiMessage jndiMessage = new JndiMessage("ok");
            return jndiMessage;
        }
        catch (SQLException ex) {
            throw new NamingException(ex.toString());
        }
        finally {
            DBConnectionPool.returnConnection(dbConnection);
        }
    }

    public void open(Hashtable global_commandline_options) throws ServiceException {
    }

    public void close() throws ServiceException {
    }
}

