/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.jndi;

import com.sap.sdb.msgServer.jndi.JndiMessage;
import com.sap.sdb.msgServer.jndi.JndiNameParser;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class JndiContext
implements Context {
    private Hashtable myEnvironment;
    private String myJndiHost;
    private int myJndiPort;
    private boolean myUseSSL;

    public JndiContext(Hashtable env) {
        this.myEnvironment = env;
        this.myJndiHost = (String)env.get("jndi.host");
        this.myJndiPort = new Integer((String)env.get("jndi.port"));
        this.myUseSSL = false;
        String temp = (String)env.get("jndi.ssl");
        if (temp != null) {
            this.myUseSSL = Integer.parseInt(temp.trim()) == 1;
        }
    }

    public Object lookup(Name name) throws NamingException {
        throw new UnsupportedOperationException("Method lookup() not yet implemented.");
    }

    public Object lookup(String name) throws NamingException {
        JndiMessage command = new JndiMessage("lookup " + name);
        JndiMessage answer = this.request(command);
        Object object = answer.getObject();
        Class[] parameter = new Class[1];
        this.myEnvironment = new Hashtable(this.myEnvironment);
        parameter[0] = this.myEnvironment.getClass();
        try {
            Method init = object.getClass().getDeclaredMethod("init", parameter);
            Object[] args = new Object[]{this.myEnvironment};
            init.invoke(object, args);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return object;
    }

    public void bind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Method bind() not yet implemented.");
    }

    public void bind(String name, Object obj) throws NamingException {
        JndiMessage command = new JndiMessage("bind " + name);
        this.request(command);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Method rebind() not yet implemented.");
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Method rebind() not yet implemented.");
    }

    public void unbind(Name name) throws NamingException {
        throw new UnsupportedOperationException("Method unbind() not yet implemented.");
    }

    public void unbind(String name) throws NamingException {
        throw new UnsupportedOperationException("Method unbind() not yet implemented.");
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        throw new UnsupportedOperationException("Method rename() not yet implemented.");
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new UnsupportedOperationException("Method rename() not yet implemented.");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        throw new UnsupportedOperationException("Method list() not yet implemented.");
    }

    public NamingEnumeration list(String name) throws NamingException {
        throw new UnsupportedOperationException("Method list() not yet implemented.");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        throw new UnsupportedOperationException("Method listBindings() not yet implemented.");
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        throw new UnsupportedOperationException("Method listBindings() not yet implemented.");
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException("Method destroySubcontext() not yet implemented.");
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException("Method destroySubcontext() not yet implemented.");
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException("Method createSubcontext() not yet implemented.");
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException("Method createSubcontext() not yet implemented.");
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException("Method lookupLink() not yet implemented.");
    }

    public Object lookupLink(String name) throws NamingException {
        throw new UnsupportedOperationException("Method lookupLink() not yet implemented.");
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        if (name.equals("sapdb")) {
            return new JndiNameParser();
        }
        throw new NamingException("NameParser <" + name + "> not found!");
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new UnsupportedOperationException("Method composeName() not yet implemented.");
    }

    public String composeName(String name, String prefix) throws NamingException {
        throw new UnsupportedOperationException("Method composeName() not yet implemented.");
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new UnsupportedOperationException("Method addToEnvironment() not yet implemented.");
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new UnsupportedOperationException("Method removeFromEnvironment() not yet implemented.");
    }

    public Hashtable getEnvironment() throws NamingException {
        throw new UnsupportedOperationException("Method getEnvironment() not yet implemented.");
    }

    public void close() throws NamingException {
        throw new UnsupportedOperationException("Method close() not yet implemented.");
    }

    public String getNameInNamespace() throws NamingException {
        throw new UnsupportedOperationException("Method getNameInNamespace() not yet implemented.");
    }

    private JndiMessage request(JndiMessage message) throws NamingException {
        Socket s = null;
        SSLSocket ssl = null;
        SendStream toServer = null;
        ReceiveStream fromServer = null;
        try {
            if (this.myUseSSL) {
                SSLSocketFactory sslFact = (SSLSocketFactory)SSLSocketFactory.getDefault();
                ssl = (SSLSocket)sslFact.createSocket(this.myJndiHost, this.myJndiPort);
                toServer = new SendStream(ssl.getOutputStream());
                fromServer = new ReceiveStream(ssl.getInputStream());
            } else {
                s = new Socket(this.myJndiHost, this.myJndiPort);
                toServer = new SendStream(s.getOutputStream());
                fromServer = new ReceiveStream(s.getInputStream());
            }
            toServer.writeString(message.getCommand());
            toServer.writeByteArray(message.getSerializedObject());
            toServer.flush();
            if (fromServer.readBoolean()) {
                JndiMessage msg = new JndiMessage(fromServer.readString());
                msg.putSerializedObject(fromServer.readByteArray());
                return msg;
            }
            throw new NamingException(fromServer.readString());
        }
        catch (IOException ex) {
            throw new NamingException("com.sap.sdb.msgServer.JndiContext: " + ex.toString());
        }
    }
}

