/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.ClientOID;
import com.sap.sdb.msgServer.client.ConnectionImpl;
import com.sap.sdb.msgServer.client.DestinationImpl;
import com.sap.sdb.msgServer.client.TopicImpl;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import java.io.IOException;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;

public class TemporaryTopicImpl
extends TopicImpl
implements TemporaryTopic,
Serializable {
    private transient ConnectionImpl myConnection;

    private TemporaryTopicImpl() {
        this.myConnection = null;
    }

    public TemporaryTopicImpl(ConnectionImpl aConnection) {
        super(new Long(ClientOID.getNext()).toString());
        this.myConnection = aConnection;
    }

    public void delete() throws JMSException {
        if (this.myConnection == null) {
            throw new JMSException("TemporaryTopic " + this.getDestinationName() + " cannot be deleted after serialization");
        }
        this.myConnection.removeTemporaryTopic(this);
    }

    public static DestinationImpl readFromStream(ReceiveStream in) throws IOException {
        TemporaryTopicImpl tempTopicObj = new TemporaryTopicImpl();
        tempTopicObj.deserialize(in);
        return tempTopicObj;
    }

    public void writeToStream(SendStream out) throws IOException {
        this.serialize(out, 4);
    }
}

