/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.client.SessionImpl;
import com.sap.sdb.msgServer.util.ListNotificationQueue;
import com.sap.sdb.msgServer.util.MessageConsumerInfo;
import com.sap.sdb.msgServer.util.MessageNotification;
import com.sap.sdb.msgServer.util.NotificationQueue;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;

public class SessionThread
extends Thread {
    private boolean myVerbose = false;
    private SessionImpl mySession;
    private boolean myShouldStop;
    private boolean myShouldSuspend;
    private NotificationQueue myQueue;
    private Object waitobj;

    public SessionThread(SessionImpl session) {
        super("SessionThread");
        this.mySession = session;
        this.myShouldStop = true;
        this.myShouldSuspend = true;
        this.myQueue = new ListNotificationQueue();
        this.waitobj = new Object();
    }

    public String getQueueID() {
        return this.myQueue.getID();
    }

    public boolean isQueueDeactivated() {
        return this.myQueue.isDeactivated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void pleaseStart(boolean restart) {
        if (this.myShouldStop || this.myShouldSuspend) {
            this.myShouldStop = false;
            this.myShouldSuspend = false;
            if (restart) {
                Object object = this.waitobj;
                synchronized (object) {
                    this.waitobj.notify();
                }
            } else {
                this.enableQueue();
                this.setDaemon(true);
                this.start();
            }
        }
    }

    public synchronized void pleaseStop(boolean permanently) {
        if (!permanently) {
            this.myShouldSuspend = true;
            return;
        }
        if (this.myShouldStop) {
            return;
        }
        this.myShouldStop = true;
        if (this.isAlive()) {
            this.interrupt();
        }
        this.mySession.getNetworkHandler().log(" Stopping with session queue size: " + this.getQueueSize());
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.disableQueue();
    }

    public void enableQueue() {
        this.mySession.getNetworkHandler().register(this.myQueue);
    }

    public int getQueueSize() {
        return this.myQueue.getQueueSize();
    }

    public void disableQueue() {
        this.mySession.getNetworkHandler().unregister(this.myQueue);
        this.myQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.myShouldStop) {
            while (!this.myShouldSuspend && !this.myShouldStop) {
                try {
                    MessageNotification msgNotification = (MessageNotification)this.myQueue.pop();
                    if ((double)this.myQueue.getQueueSize() < (double)this.mySession.getNetworkHandler().getMaxClientQueueSize() * 0.5 && this.myQueue.isDeactivated()) {
                        if (this.myVerbose) {
                            this.mySession.getNetworkHandler().log("INFO: Queue <" + this.myQueue.getID() + "> fell below size limit.\r\nConsumers of client queue will be reactivated.");
                        }
                        this.mySession.getNetworkHandler().reactivateSessionConsumers(msgNotification);
                        this.myQueue.setIsDeactivated(false);
                    }
                    MessageImpl msg = msgNotification.getMessage();
                    msg.prepareForClient();
                    MessageConsumerInfo aConsumer = msgNotification.getMessageConsumerInfo();
                    MessageListener listener = this.mySession.getMessageListener(aConsumer.getMessageListener());
                    if (this.mySession.isTransactedMsgReceive()) {
                        this.mySession.acknowledgeReceivedTransactionMsg(msgNotification);
                    }
                    if (this.myShouldSuspend) {
                        this.doSuspend();
                    }
                    if (listener != null) {
                        SessionThread sessionThread = this;
                        synchronized (sessionThread) {
                            if (!this.myShouldStop) {
                                listener.onMessage((Message)msg);
                                this.mySession.sendAutoAcknowledgeIfRequired(msgNotification);
                            } else {
                                this.myQueue.pushBack(msgNotification);
                            }
                            continue;
                        }
                    }
                    this.mySession.getNetworkHandler().log("Warning no message listener with id: " + aConsumer.getMessageListener());
                }
                catch (JMSException ex) {
                    ExceptionListener listener = null;
                    try {
                        listener = this.mySession.getConnection().getExceptionListener();
                    }
                    catch (JMSException ex2) {
                        ex2.printStackTrace();
                        this.mySession.getNetworkHandler().log("Unexpected exception in class SessionThread/run: " + (Object)((Object)ex2));
                    }
                    if (listener != null) {
                        listener.onException(ex);
                    }
                    this.mySession.getNetworkHandler().log("Exception in class SessionThread/run: " + ex.toString());
                }
                catch (InterruptedException ex) {
                }
                catch (Exception ex) {
                    this.mySession.getNetworkHandler().log("Unexpected exception " + ex.toString() + " ;Queue Size:" + this.myQueue.getQueueSize());
                }
            }
            if (!this.myShouldSuspend) continue;
            this.doSuspend();
        }
        this.mySession.getNetworkHandler().log("Listener thread stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSuspend() {
        while (this.myShouldSuspend) {
            Object object = this.waitobj;
            synchronized (object) {
                try {
                    this.waitobj.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

