/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.QueueImpl;
import com.sap.sdb.msgServer.client.TemporaryQueueImpl;
import com.sap.sdb.msgServer.client.TemporaryTopicImpl;
import com.sap.sdb.msgServer.client.TopicImpl;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import javax.jms.Destination;

public abstract class DestinationImpl
implements Destination,
Serializable {
    static final int DESTINATION_QUEUE = 1;
    static final int DESTINATION_TOPIC = 2;
    static final int DESTINATION_TEMP_QUEUE = 3;
    static final int DESTINATION_TEMP_TOPIC = 4;
    private String myName;

    DestinationImpl() {
        this.myName = null;
    }

    DestinationImpl(String name) {
        this.myName = name;
    }

    public String getDestinationName() {
        return this.myName;
    }

    void deserialize(ReceiveStream in) throws IOException {
        this.myName = in.readString();
    }

    public static DestinationImpl getDestinationFromStream(ReceiveStream in) throws IOException {
        byte destinationClassType = in.readByte();
        switch (destinationClassType) {
            case 1: {
                return QueueImpl.readFromStream(in);
            }
            case 2: {
                return TopicImpl.readFromStream(in);
            }
            case 3: {
                return TemporaryQueueImpl.readFromStream(in);
            }
            case 4: {
                return TemporaryTopicImpl.readFromStream(in);
            }
        }
        throw new StreamCorruptedException("unknown Destination class type: " + destinationClassType);
    }

    void serialize(SendStream out, int destination) throws IOException {
        out.writeByte(destination);
        out.writeString(this.myName);
    }

    public abstract void writeToStream(SendStream var1) throws IOException;
}

