/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.ClientOID;
import com.sap.sdb.msgServer.client.ConnectionImpl;
import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.util.ConnectionTransfer;
import com.sap.sdb.msgServer.util.DeactivateAdminNotification;
import com.sap.sdb.msgServer.util.ErrorNotification;
import com.sap.sdb.msgServer.util.IDNotification;
import com.sap.sdb.msgServer.util.MessageNotification;
import com.sap.sdb.msgServer.util.Notification;
import com.sap.sdb.msgServer.util.NotificationContainer;
import com.sap.sdb.msgServer.util.NotificationException;
import com.sap.sdb.msgServer.util.NotificationQueue;
import com.sap.sdb.msgServer.util.OkNotification;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.RequestServerTimeAdminNotification;
import com.sap.sdb.msgServer.util.ResetAdminNotification;
import com.sap.sdb.msgServer.util.SendStream;
import com.sap.sdb.msgServer.util.ServerTimeNotification;
import com.sap.sdb.msgServer.util.StreamString;
import com.sap.sdb.msgServer.util.SyncReceiveNotification;
import com.sap.sdb.msgServer.util.TimeOutNotification;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class ClientNetworkHandler {
    private boolean myVerbose = false;
    private boolean we_are_initialized = false;
    private LinkedList myConnections;
    private int myTimeOut = 0;
    private PrintWriter myLogStream;
    private Hashtable myNotificationQueues;
    private Hashtable myTempNotificationQueues;
    private Vector myNQFreelist;
    private StreamString myID;
    private Socket mySocket;
    private SSLSocket mySSLSocket;
    private SendStream myToServer;
    private ReceiveStream myFromServer;
    private Thread myReceivingThread;
    private int myMaxClientQueueSize;
    private boolean myUseSSL;
    private String _user;
    private String _password;

    public ClientNetworkHandler(String host, int port, int timeOut, String logFilename, int maxClientQueueSize, boolean useSSL, boolean verbose, String user, String password) throws IOException {
        this.myTimeOut = timeOut;
        this.myMaxClientQueueSize = maxClientQueueSize;
        this.myUseSSL = useSSL;
        OutputStream out = logFilename == null || logFilename.length() < 1 ? System.out : new FileOutputStream(logFilename, true);
        this.setLogStream(out);
        this.myVerbose = verbose;
        this._user = user;
        this._password = password;
        this.createInstance(host, port);
    }

    private synchronized void createInstance(String host, int port) throws IOException {
        this.myNotificationQueues = new Hashtable(100);
        this.myTempNotificationQueues = new Hashtable(100);
        this.myNQFreelist = new Vector(100);
        ConnectionTransfer connect = null;
        if (this.myUseSSL) {
            SSLSocketFactory sslFact = (SSLSocketFactory)SSLSocketFactory.getDefault();
            this.mySSLSocket = (SSLSocket)sslFact.createSocket(host, port);
            this.myFromServer = new ReceiveStream(this.mySSLSocket.getInputStream(), 2048);
            connect = new ConnectionTransfer(this.mySSLSocket, this._user, this._password);
        } else {
            this.mySocket = new Socket(host, port);
            this.myFromServer = new ReceiveStream(this.mySocket.getInputStream(), 2048);
            connect = new ConnectionTransfer(this.mySocket, this._user, this._password);
        }
        this.myConnections = new LinkedList();
        this.myID = new StreamString(connect.getClientID());
        this.myToServer = connect.getClientSendStream();
        connect = null;
        this.myReceivingThread = new Thread("ClientNetworkHandlerReceivingThread"){

            public void run() {
                NotificationQueue notQueue = null;
                boolean doReceive = true;
                while (doReceive) {
                    try {
                        Notification not = Notification.getFromServer(ClientNetworkHandler.this.myFromServer);
                        notQueue = (NotificationQueue)ClientNetworkHandler.this.myNotificationQueues.get(not.getClientSessionAddress().getQueueID());
                        if (notQueue != null) {
                            notQueue.push(not);
                            if (!(not instanceof MessageNotification) || notQueue.getQueueSize() <= ClientNetworkHandler.this.myMaxClientQueueSize || notQueue.isDeactivated()) continue;
                            if (ClientNetworkHandler.this.myVerbose) {
                                ClientNetworkHandler.this.log("WARNING: Queue <" + notQueue.getID() + "> reached size limit.\r\nConsumers of client queue will temporarily be unregistered.");
                            }
                            ClientNetworkHandler.this.retardSessionConsumers((MessageNotification)not);
                            notQueue.setIsDeactivated(true);
                            continue;
                        }
                        notQueue = (NotificationQueue)ClientNetworkHandler.this.myTempNotificationQueues.remove(not.getClientSessionAddress().getQueueID());
                        if (notQueue != null) {
                            ClientNetworkHandler.this.freeNotContainer(notQueue);
                            continue;
                        }
                        ClientNetworkHandler.this.log("WARNING: ClientNetworkHandler no notQueue for Notification id<" + not.getClientSessionAddress().getQueueID() + "> " + not.toString());
                        if (!(not instanceof MessageNotification)) continue;
                        ClientNetworkHandler.this.resetSendOrder((MessageNotification)not);
                    }
                    catch (OptionalDataException ex) {
                        ClientNetworkHandler.this.log("OptionalDataException in class ClientNetworkHandler/run: eof:" + ex.eof + ", length:" + ex.length + " message" + ex.getMessage());
                        System.exit(1);
                    }
                    catch (IOException ex) {
                        if (ClientNetworkHandler.this.myVerbose) {
                            ClientNetworkHandler.this.log("Terminating connection.");
                        }
                        doReceive = false;
                        ClientNetworkHandler.this.notifyAllExceptionListeners(new JMSException("Exception while receiving from server: " + ClientNetworkHandler.this.getStackTraceAsString(ex)));
                    }
                    catch (InterruptedException ex) {
                        ClientNetworkHandler.this.log("ClientNetworkHandlerReceivingThread interrupted : " + ClientNetworkHandler.this.getStackTraceAsString(ex));
                        doReceive = false;
                    }
                    catch (Throwable ex) {
                        ClientNetworkHandler.this.log("Unexpected exception " + ex.toString() + " in class: Queue Size:" + notQueue.getQueueSize());
                        doReceive = false;
                    }
                }
            }
        };
        this.myReceivingThread.setDaemon(true);
        this.myReceivingThread.start();
        this.we_are_initialized = true;
    }

    public boolean isEstablished() {
        return this.we_are_initialized;
    }

    protected void finalize() {
        this.stop();
    }

    public StreamString getClientID() {
        this.throw_if_not_initialized();
        return this.myID;
    }

    public long getMaxClientQueueSize() {
        return this.myMaxClientQueueSize;
    }

    public String getClientIDString() {
        this.throw_if_not_initialized();
        return StreamString.getString(this.myID);
    }

    public void register(NotificationQueue queue) {
        this.throw_if_not_initialized();
        this.myNotificationQueues.put(queue.getID(), queue);
    }

    public void unregister(NotificationQueue queue) {
        this.throw_if_not_initialized();
        this.myNotificationQueues.remove(queue.getID());
    }

    private synchronized void send(Notification notification) throws IOException {
        this.throw_if_not_initialized();
        try {
            notification.sendToServer(this.myToServer);
        }
        catch (IOException ex) {
            this.notifyAllExceptionListeners(new JMSException("Exception while sending to server: " + ex.toString()));
            throw ex;
        }
        catch (Error er) {
            this.notifyAllExceptionListeners(new JMSException("Exception while sending to server: " + er.toString()));
            throw er;
        }
    }

    public void requestOK(Notification notification) throws NotificationException, InterruptedException {
        Notification answer;
        this.throw_if_not_initialized();
        try {
            answer = this.request(notification, true);
        }
        catch (IOException ex) {
            throw new NotificationException(ex.toString());
        }
        if (answer instanceof OkNotification) {
            if (notification instanceof MessageNotification) {
                ((MessageNotification)notification).getMessage().setMessageID(ClientOID.getNext());
            }
            return;
        }
        if (!(answer instanceof TimeOutNotification)) {
            if (answer instanceof ErrorNotification) {
                if (notification instanceof MessageNotification) {
                    ((MessageNotification)notification).getMessage().setMessageID(ClientOID.getNext());
                }
                throw new NotificationException(((ErrorNotification)answer).toString());
            }
            if (notification instanceof MessageNotification) {
                ((MessageNotification)notification).getMessage().setMessageID(ClientOID.getNext());
            }
            throw new NotificationException("Unknown answer notification type: " + answer.getClass().getName());
        }
        answer = this.requestAgain(notification);
    }

    private Notification requestAgain(Notification notification) throws NotificationException, InterruptedException {
        Notification answer;
        this.throw_if_not_initialized();
        if (notification instanceof MessageNotification) {
            this.log("\nResend message <" + ((MessageNotification)notification).getMessage().getMessageID() + ">");
        }
        try {
            answer = this.request(notification, true);
        }
        catch (IOException ex) {
            throw new NotificationException(ex.toString());
        }
        if (answer instanceof OkNotification) {
            return answer;
        }
        if (answer instanceof TimeOutNotification) {
            throw new NotificationException("\nResend of notification <" + notification.toString() + "> failed due to " + ((TimeOutNotification)answer).getMessage());
        }
        if (answer instanceof ErrorNotification) {
            throw new NotificationException(((ErrorNotification)answer).toString());
        }
        throw new NotificationException("Unknown answer notification type: " + answer.getClass().getName());
    }

    public long requestID(Notification notification) throws NotificationException {
        Notification answer;
        this.throw_if_not_initialized();
        try {
            answer = this.request(notification, true);
        }
        catch (Exception ex) {
            throw new NotificationException(ex.toString());
        }
        if (answer instanceof IDNotification) {
            return ((IDNotification)answer).getID();
        }
        if (answer instanceof ErrorNotification) {
            throw new NotificationException(((ErrorNotification)answer).toString());
        }
        throw new NotificationException("Unknown answer notification type: " + answer.getClass().getName());
    }

    public long requestServerTime() throws NotificationException {
        Notification answer;
        RequestServerTimeAdminNotification notServerTime = new RequestServerTimeAdminNotification();
        this.throw_if_not_initialized();
        try {
            answer = this.request(notServerTime, true);
        }
        catch (Exception ex) {
            throw new NotificationException(ex.toString());
        }
        if (answer instanceof ServerTimeNotification) {
            return ((ServerTimeNotification)answer).getID();
        }
        if (answer instanceof ErrorNotification) {
            throw new NotificationException(((ErrorNotification)answer).toString());
        }
        throw new NotificationException("Unknown answer notification type: " + answer.getClass().getName());
    }

    public MessageImpl requestMessageForBrowser(Notification notification) throws NotificationException {
        Notification answer = null;
        this.throw_if_not_initialized();
        try {
            answer = this.request(notification, true);
        }
        catch (Exception ex) {
            throw new NotificationException(ex.toString());
        }
        if (answer instanceof MessageNotification) {
            MessageImpl msg = ((MessageNotification)answer).getMessage();
            try {
                if (msg != null) {
                    msg.prepareForClient();
                }
            }
            catch (JMSException ex) {
                throw new NotificationException(ex.toString());
            }
            return msg;
        }
        if (answer instanceof ErrorNotification) {
            throw new NotificationException(((ErrorNotification)answer).toString());
        }
        throw new NotificationException("Unknown answer notification type: " + answer.getClass().getName());
    }

    public MessageNotification getAMessage(String destName, int destType, long timeOut, boolean noWait, long consumerID) throws JMSException {
        SyncReceiveNotification command = new SyncReceiveNotification(destName, destType, timeOut, noWait, consumerID);
        Notification reply = null;
        MessageNotification retval = null;
        NotificationContainer receiver = this.getNotContainer();
        try {
            command.setClientSessionAddress(this.myID, receiver.getID());
            this.send(command);
            reply = receiver.pop(0L);
        }
        catch (IOException ex) {
            throw new JMSException("i/o problem while polling for message : " + ex);
        }
        catch (InterruptedException ex) {
            throw new JMSException("interrupted while waiting for time out : " + ex);
        }
        finally {
            this.freeNotContainer(receiver);
        }
        if (reply instanceof MessageNotification) {
            retval = (MessageNotification)reply;
        }
        return retval;
    }

    public void registerConnection(ConnectionImpl conn) {
        this.throw_if_not_initialized();
        this.myConnections.add(conn);
    }

    public void unregisterConnection(ConnectionImpl conn) {
        this.throw_if_not_initialized();
        this.myConnections.remove(conn);
    }

    public synchronized int getConnectionCount() {
        this.throw_if_not_initialized();
        return this.myConnections.size();
    }

    public void stop() {
        this.throw_if_not_initialized();
        this.myReceivingThread.interrupt();
        try {
            this.myToServer.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.myFromServer.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.myConnections.size() == 0) {
            try {
                if (this.myUseSSL) {
                    this.mySSLSocket.close();
                } else {
                    this.mySocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.we_are_initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Notification request(Notification notification, boolean waitForAnswer) throws IOException, InterruptedException {
        Notification retValue = null;
        NotificationContainer receiver = this.getNotContainer();
        if (notification instanceof MessageNotification) {
            int lp = 0;
            lp = this.myUseSSL ? this.mySSLSocket.getLocalPort() : this.mySocket.getLocalPort();
            ((MessageNotification)notification).setPort(lp);
        }
        try {
            notification.setClientSessionAddress(this.myID, receiver.getID());
            this.send(notification);
            if (waitForAnswer) {
                retValue = receiver.pop(this.myTimeOut);
            } else {
                this.myTempNotificationQueues.put(receiver.getID(), receiver);
            }
        }
        finally {
            if (waitForAnswer) {
                this.freeNotContainer(receiver);
            }
        }
        return retValue;
    }

    private void notifyAllExceptionListeners(JMSException ex) {
        ListIterator iter = this.myConnections.listIterator();
        while (iter.hasNext()) {
            try {
                ExceptionListener el = ((ConnectionImpl)iter.next()).getExceptionListener();
                if (el == null) continue;
                el.onException(ex);
            }
            catch (Exception e) {
                this.log("notifyAllExceptionListeners:" + ex.toString());
            }
        }
    }

    private void resetSendOrder(MessageNotification not) throws JMSException, InterruptedException {
        this.throw_if_not_initialized();
        ResetAdminNotification command = new ResetAdminNotification(not.getMessage().getMessageID(), not.getMessageConsumerInfo().getConsumerID(), not.getMessageConsumerInfo().isQueueReceiver(), not.getMessageConsumerInfo().getType() == 2);
        try {
            this.request(command, false);
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
    }

    private void retardSessionConsumers(MessageNotification not) throws JMSException, InterruptedException {
        this.throw_if_not_initialized();
        DeactivateAdminNotification command = new DeactivateAdminNotification(2, not.getClientSessionAddress().toString(), false, not.getMessageConsumerInfo().getConsumerID());
        try {
            this.request(command, false);
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
    }

    public void reactivateSessionConsumers(MessageNotification not) throws JMSException, InterruptedException {
        this.throw_if_not_initialized();
        DeactivateAdminNotification command = new DeactivateAdminNotification(3, not.getClientSessionAddress().toString(), false, not.getMessageConsumerInfo().getConsumerID());
        try {
            this.request(command, false);
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
    }

    public void throw_if_not_initialized() {
        if (!this.we_are_initialized) {
            throw new IllegalStateException("ClientNetworkHandler not initialized !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotificationContainer getNotContainer() {
        NotificationContainer retval = null;
        Vector vector = this.myNQFreelist;
        synchronized (vector) {
            if (this.myNQFreelist.size() > 0) {
                retval = (NotificationContainer)this.myNQFreelist.remove(0);
            }
        }
        if (retval == null) {
            retval = new NotificationContainer();
        }
        this.register(retval);
        return retval;
    }

    private void freeNotContainer(NotificationQueue queue) {
        queue.clear();
        this.myNQFreelist.add(this.myNotificationQueues.remove(queue.getID()));
    }

    private void setLogStream(OutputStream out) {
        this.myLogStream = new PrintWriter(new OutputStreamWriter(out));
    }

    public void log(String s) {
        this.myLogStream.println("[" + new Date() + "]" + s);
        this.myLogStream.flush();
    }

    public String getStackTraceAsString(Throwable ex) {
        ByteArrayOutputStream byteStream = null;
        PrintWriter printWriter = null;
        String stackTrace = null;
        byteStream = new ByteArrayOutputStream();
        printWriter = new PrintWriter(byteStream, true);
        ex.printStackTrace(printWriter);
        printWriter.flush();
        stackTrace = byteStream.toString();
        printWriter.close();
        return stackTrace;
    }
}

