/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.agents;

import com.sap.sdb.msgServer.agents.FreeLists;
import com.sap.sdb.msgServer.agents.JmsOutputManager;
import com.sap.sdb.msgServer.agents.JmsThread;
import com.sap.sdb.msgServer.agents.SendingException;
import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.database.ConsumerList;
import com.sap.sdb.msgServer.database.DBConnectionPool;
import com.sap.sdb.msgServer.database.MessageTable;
import com.sap.sdb.msgServer.database.UserConnection;
import com.sap.sdb.msgServer.service.JmsService;
import com.sap.sdb.msgServer.service.ServiceException;
import com.sap.sdb.msgServer.util.InvalidSocketException;
import com.sap.sdb.msgServer.util.MessageConsumerInfo;
import com.sap.sdb.msgServer.util.MessageNotification;
import com.sap.sdb.msgServer.util.NotificationChannel;
import com.sap.sdb.msgServer.util.SendNotification;
import com.sap.sdb.msgServer.util.SendingNotificationQueue;
import com.sap.sdb.msgServer.util.StreamString;
import java.sql.SQLException;
import javax.jms.JMSException;

public class MessageBuilder
extends JmsThread {
    private UserConnection m_connection = null;

    public MessageBuilder(JmsService service) throws ServiceException {
        super(service, "MessageBuilder");
    }

    public void doWork() throws InterruptedException {
        SendingNotificationQueue sendQueue = this.getJmsService().getSendingQueue();
        SendNotification sendNotification = sendQueue.getNotificationForBuilding();
        if (sendNotification != null) {
            this.doCommand(sendNotification);
        }
    }

    public void finishWork() throws Exception {
        if (this.m_connection != null) {
            this.m_connection.rollback();
            this.m_connection.close();
            this.m_connection = null;
        }
    }

    private void doCommand(SendNotification sendNotification) {
        this.increaseNotificationCount();
        try {
            if (this.m_connection == null) {
                this.m_connection = DBConnectionPool.getNewConnection();
            } else {
                this.m_connection.rollback();
            }
            MessageImpl aMessage = null;
            MessageNotification messageNot = null;
            long messageID = sendNotification.getMessageID();
            long consumerID = sendNotification.getConsumerID();
            int modeDelivery = sendNotification.getDeliveryMode();
            aMessage = MessageTable.findByID(this.m_connection, modeDelivery, messageID);
            this.m_connection.commit();
            if (aMessage == null) {
                throw new SQLException("Message for send order not found  MessageID = " + messageID + " ConsumerID = " + consumerID);
            }
            messageNot = FreeLists.getMessageNot(aMessage);
            messageNot.setRedelivered(sendNotification.getWasAlreadyDelivered());
            MessageConsumerInfo consumerInfo = null;
            consumerInfo = ConsumerList.getActiveConsumer(sendNotification.getReceiverClientAddress(), consumerID);
            if (consumerInfo == null) {
                throw new SendingException("No consumer registered for message <" + messageID + ">, consumer <" + consumerID + ">");
            }
            messageNot.setClientSessionAddress(consumerInfo.getClientSessionAddress());
            if (JmsService.getVerboseMessageBuilder()) {
                this.log(":setClientSessionAddress:" + messageNot.getClientSessionAddress().toString());
            }
            messageNot.setMessageConsumerInfo(consumerInfo);
            sendNotification.setMessage(messageNot);
            NotificationChannel channel = JmsOutputManager.getChannel(sendNotification.getServerChannel());
            if (channel == null) {
                throw new InvalidSocketException(messageID, consumerID, sendNotification.getDeliveryMode(), sendNotification.getIsQueueSendNotification(), sendNotification.getReceiverClientAddress(), "Invalid channel");
            }
            channel.setReadyToSend(sendNotification);
            if (JmsService.getVerboseMessageBuilder()) {
                this.log("doCommand: build message with messageID <" + messageID + ">, consumerID <" + consumerID + ">");
            }
        }
        catch (InvalidSocketException ex) {
            try {
                this.m_connection.rollback();
                ConsumerList.unregisterAndCommit(this.m_connection, this.getJmsService().getSendingQueue(), ex.getConsumerID(), ex.getReceiverClientAddress(), false);
            }
            catch (Exception ex2) {
                this.log("Exception Handler failed due to: " + ex2.toString());
            }
        }
        catch (SendingException ex) {
            try {
                this.exceptionAction(sendNotification, ex);
            }
            catch (Exception ex2) {
                this.log("Exception Handler failed due to: " + ex2.toString());
            }
        }
        catch (JMSException ex) {
            try {
                this.exceptionAction(sendNotification, (Exception)((Object)ex));
            }
            catch (Exception ex2) {
                this.log("Exception Handler failed due to: " + ex2.toString());
            }
        }
        catch (SQLException ex) {
            try {
                this.exceptionAction(sendNotification, ex);
            }
            catch (Exception ex2) {
                this.log("Exception Handler failed due to: " + ex2.toString());
            }
        }
    }

    private void exceptionAction(SendNotification sendNotification, Exception ex) throws SQLException {
        this.m_connection.rollback();
        this.handleSendError(sendNotification.getConsumerID(), sendNotification.getReceiverClientAddress(), ex);
        this.logException(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handleSendError(long consumerID, StreamString receiverClientAddress, Exception ex) {
        block8: {
            if (receiverClientAddress == null) {
                return;
            }
            UserConnection dbConnection = null;
            try {
                this.log("Error while building a message:" + ex.getMessage());
                dbConnection = DBConnectionPool.useConnection();
                ConsumerList.unregisterAndCommit(dbConnection, this.getJmsService().getSendingQueue(), consumerID, receiverClientAddress, false);
                DBConnectionPool.returnConnection(dbConnection);
            }
            catch (SQLException ex2) {
                this.logException(ex2);
            }
            catch (Exception ex3) {
                this.logException(ex3);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                DBConnectionPool.returnConnection(dbConnection);
            }
        }
    }
}

