/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.agents;

import com.sap.sdb.msgServer.util.Notification;
import com.sap.sdb.msgServer.util.NotificationChannel;
import com.sap.sdb.msgServer.util.SendNotification;
import com.sap.sdb.msgServer.util.StreamString;
import java.io.IOException;
import java.util.Hashtable;

public class JmsOutputManager {
    private static JmsOutputManager sManager = null;
    private final Hashtable myNotificationChannels = new Hashtable(10);

    public static synchronized void createInstance() {
        if (sManager != null) {
            throw new IllegalStateException("JmsOutputManager singleton already created.");
        }
        sManager = new JmsOutputManager();
    }

    public static synchronized void destroyInstance() {
        if (sManager == null) {
            throw new IllegalStateException("JmsOutputManager singleton not created.");
        }
        sManager = null;
    }

    private static JmsOutputManager getInstance() {
        if (sManager == null) {
            throw new IllegalStateException("JmsOutputManager singleton not created.");
        }
        return sManager;
    }

    private JmsOutputManager() {
    }

    public static void addNotificationChannel(StreamString clientID, NotificationChannel channel) {
        JmsOutputManager.getInstance().myNotificationChannels.put(clientID, channel);
    }

    public static void closeNotificationChannel(StreamString clientID) throws IOException {
        NotificationChannel channel = (NotificationChannel)JmsOutputManager.getInstance().myNotificationChannels.get(clientID);
        if (channel != null) {
            channel.close();
        }
    }

    public static void removeNotificationChannel(StreamString clientID) {
        NotificationChannel channel = (NotificationChannel)JmsOutputManager.getInstance().myNotificationChannels.remove(clientID);
        if (channel != null) {
            channel.clear();
        }
    }

    public static void send(Notification notification) throws IOException {
        NotificationChannel channel = JmsOutputManager.getValidChannel(notification);
        channel.sendToClient(notification);
    }

    public static SendNotification sendChronological(Notification notification) throws IOException {
        NotificationChannel channel = JmsOutputManager.getValidChannel(notification);
        return channel.sendToClientChronological(notification);
    }

    public static NotificationChannel getChannel(StreamString clientID) {
        if (clientID == null) {
            return null;
        }
        return (NotificationChannel)JmsOutputManager.getInstance().myNotificationChannels.get(clientID);
    }

    private static NotificationChannel getValidChannel(Notification notification) throws IOException {
        StreamString clientID = notification.getClientSessionAddress().getClientID();
        if (clientID == null) {
            throw new IOException("No client specified for sending a notification.");
        }
        NotificationChannel channel = JmsOutputManager.getChannel(clientID);
        if (channel == null) {
            throw new IOException("Unknown client <" + notification.getClientSessionAddress().toString() + "> for sending a notification.");
        }
        return channel;
    }
}

