/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.agents;

import com.sap.sdb.msgServer.Server;
import com.sap.sdb.msgServer.client.AdminConnection;
import com.sap.sdb.msgServer.service.Service;
import com.sap.sdb.msgServer.util.ClientConnection;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;

public class ConnectionManager {
    private HashMap myConnectionMap;
    private int myMaxConnections;

    public ConnectionManager(int maxConnections) {
        this.myMaxConnections = maxConnections;
        this.myConnectionMap = new HashMap();
    }

    public void setMaxConnections(int max) {
        this.myMaxConnections = max;
    }

    public int getMaxConnections() {
        return this.myMaxConnections;
    }

    public synchronized void stopAllConnections() {
        Iterator iter = this.getConnectionIterator();
        while (iter.hasNext()) {
            ClientConnection connection = (ClientConnection)iter.next();
            connection.endCommunication();
        }
    }

    synchronized void addConnection(Socket socket, Service service) {
        if (this.myConnectionMap.size() >= this.myMaxConnections) {
            try {
                socket.close();
                Server.log("Connection refused to " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort() + ": max connections reached.");
            }
            catch (IOException e) {
                Server.log(e);
            }
            return;
        }
        ClientConnection connection = new ClientConnection(this, socket, service);
        this.myConnectionMap.put(connection, null);
        connection.startCommunication();
    }

    public synchronized void removeConnection(ClientConnection connection) {
        this.myConnectionMap.remove(connection);
    }

    private Iterator getConnectionIterator() {
        return this.myConnectionMap.keySet().iterator();
    }

    public synchronized void printConnections(AdminConnection con) {
        Iterator iter = this.getConnectionIterator();
        while (iter.hasNext()) {
            ClientConnection connection = (ClientConnection)iter.next();
            con.println("CONNECTED TO " + connection.getConnectionInfo());
        }
    }
}

