/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.agents;

import com.sap.sdb.msgServer.agents.AdminException;
import com.sap.sdb.msgServer.agents.FreeLists;
import com.sap.sdb.msgServer.agents.JmsOutputManager;
import com.sap.sdb.msgServer.agents.JmsThread;
import com.sap.sdb.msgServer.database.DestinationList;
import com.sap.sdb.msgServer.service.JmsService;
import com.sap.sdb.msgServer.service.ServiceException;
import com.sap.sdb.msgServer.util.DestinationAuth;
import com.sap.sdb.msgServer.util.DestinationEntity;
import com.sap.sdb.msgServer.util.ErrorNotification;
import com.sap.sdb.msgServer.util.MessageNotification;
import com.sap.sdb.msgServer.util.Notification;
import com.sap.sdb.msgServer.util.NotificationChannel;
import com.sap.sdb.msgServer.util.NotificationQueue;
import com.sap.sdb.msgServer.util.OkNotification;
import com.sap.sdb.msgServer.util.StreamString;
import java.io.IOException;
import java.util.Vector;

public abstract class Agent
extends JmsThread {
    private NotificationQueue mNotificationQueue;
    private boolean mAnswerToClient;

    public Agent(JmsService service, String name, NotificationQueue notQueue) throws ServiceException {
        super(service, name);
        if (notQueue == null) {
            throw new ServiceException(service, "Agent constructor failed due to null NotificationQueue parameter");
        }
        this.mNotificationQueue = notQueue;
        this.mAnswerToClient = true;
    }

    public NotificationQueue getNotificationQueue() {
        return this.mNotificationQueue;
    }

    public void doWork() throws Exception {
        Notification notification = this.getNotificationQueue().pop();
        Notification answer = this.doCommand(notification);
        if (answer != null) {
            if (notification.hasClientSessionAddress() && this.mAnswerToClient) {
                this.answerClient(notification, answer);
            }
            if (answer instanceof ErrorNotification) {
                throw ((ErrorNotification)answer).getException();
            }
        }
    }

    public abstract Notification doCommand(Notification var1);

    private void answerClient(Notification question, Notification answer) {
        if (answer != null) {
            try {
                answer.setClientSessionAddress(question.getClientSessionAddress());
                JmsOutputManager.send(answer);
                if (answer instanceof OkNotification) {
                    FreeLists.freeOkNotification((OkNotification)answer);
                }
                if (answer instanceof MessageNotification) {
                    FreeLists.freeMessageNot((MessageNotification)answer);
                }
            }
            catch (IOException ex) {
                this.log("Client <" + answer.getClientSessionAddress().toString() + "> unreachable.");
            }
        }
    }

    public void setAnwerToClient(boolean answerToClient) {
        this.mAnswerToClient = answerToClient;
    }

    protected void checkAuthorization(String destinationName, boolean isQueue, StreamString clientID, boolean readAccess) throws AdminException {
        boolean authMatch = false;
        DestinationEntity dest = DestinationList.getDestination(destinationName, isQueue);
        if (dest == null) {
            throw new AdminException("No destination " + dest.getName() + " on  server");
        }
        NotificationChannel channel = JmsOutputManager.getChannel(clientID);
        if (channel == null) {
            throw new AdminException("No notification channel for destination " + dest.getName() + " on  server");
        }
        Vector auth = dest.getAuthentication();
        for (int i = 0; i < auth.size(); ++i) {
            String destPassword;
            DestinationAuth oneAuth = (DestinationAuth)auth.get(i);
            if (oneAuth.getIsReadPass() != readAccess || (destPassword = oneAuth.getPassword()) == null || destPassword.length() <= 0) continue;
            if (channel.getPassword() == null || !channel.getPassword().equals(destPassword)) {
                authMatch = false;
                continue;
            }
            authMatch = true;
            break;
        }
        if (auth.size() > 0 && !authMatch) {
            throw new AdminException("Invalid authorization for destination " + dest.getName());
        }
    }
}

