/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer;

import com.sap.sdb.msgServer.agents.ConnectionManager;
import com.sap.sdb.msgServer.agents.SocketListener;
import com.sap.sdb.msgServer.database.SqlCmd;
import com.sap.sdb.msgServer.jndi.JndiService;
import com.sap.sdb.msgServer.service.AdminService;
import com.sap.sdb.msgServer.service.JmsService;
import com.sap.sdb.msgServer.service.Service;
import com.sap.sdb.msgServer.util.ServerConfig;
import com.sap.sdb.msgServer.util.ServerException;
import com.sap.sdb.programmargs.AccParams;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Server {
    private static final String SECURITY_PROVIDER = "security_provider";
    private static final String MSG_SERVER_PASSWORD = "msgserver_password";
    private static final String VERSION_MAJOR = "7";
    private static final String VERSION_MINOR = "6";
    private static final String FILE = "-file";
    private static final String HELP = "help";
    private static final String HELP2 = "-help";
    private static final String HELP3 = "-h";
    private static final String HELP4 = "-?";
    private boolean myUseSSL;
    private Hashtable myListeners;
    private ThreadGroup myThreadGroup;
    private static PrintWriter myLogStream;
    private static String myMessagePrefix;
    private ConnectionManager myConnectionManager;
    private Hashtable m_global_commandline_options;
    private ServerConfig m_ServerConfig;
    private JmsService m_JMSService;
    public static final String lineSep;

    public static void main(String[] args) {
        Hashtable<String, String> global_commandline_options = null;
        String aLogFile = null;
        String aConfigFile = null;
        if (global_commandline_options == null) {
            global_commandline_options = new Hashtable<String, String>();
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-LogFilename") && i + 1 < args.length) {
                aLogFile = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equals(HELP) || args[i].equals(HELP2) || args[i].equals(HELP3) || args[i].equals(HELP4)) {
                Server.displayHelp();
                System.exit(0);
                continue;
            }
            if (args[i].equals(FILE) || args[i].equals("-f")) {
                aConfigFile = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].startsWith("-") && i + 1 < args.length) {
                global_commandline_options.put(args[i].substring(1), args[i + 1]);
                i += 2;
                continue;
            }
            try {
                throw new Exception("Invalid Argument");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println(e.toString());
                System.exit(1);
            }
        }
        try {
            if (aConfigFile == null) {
                throw new Exception("No configuration file to start Message Server");
            }
            Server s = new Server(aConfigFile, aLogFile, global_commandline_options);
            s.waitForShutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.toString());
            System.exit(1);
        }
    }

    private static void displayHelp() {
        System.out.println("-?\t\tdisplay help");
        System.out.println("-database_host\t\tdatabase server node");
        System.out.println("-database_name\t\tdatabase");
        System.out.println("-user\t\tdatabase user");
        System.out.println("-password\t\tdatabase password");
        System.out.println("-msgserver_password\t\tmessage server administration password");
    }

    /*
     * WARNING - void declaration
     */
    public Server(String aConfigFile, String aLogFile, Hashtable global_commandline_options) throws ServerException {
        void var5_8;
        OutputStream out;
        block21: {
            this.m_global_commandline_options = null;
            this.m_global_commandline_options = global_commandline_options;
            try {
                String access_key;
                String db;
                this.m_ServerConfig = new ServerConfig(aConfigFile, this.m_global_commandline_options);
                if (global_commandline_options == null) break block21;
                if (global_commandline_options.get(MSG_SERVER_PASSWORD) != null) {
                    global_commandline_options.put("AdminPassword", global_commandline_options.get(MSG_SERVER_PASSWORD));
                }
                if (global_commandline_options.get("u") != null) {
                    StringTokenizer st = new StringTokenizer((String)global_commandline_options.get("u"), ",");
                    if (st.hasMoreTokens()) {
                        global_commandline_options.put("User", st.nextToken());
                    }
                    if (st.hasMoreTokens()) {
                        global_commandline_options.put("Password", st.nextToken());
                    }
                }
                if (global_commandline_options.get("user") != null) {
                    global_commandline_options.put("User", (String)global_commandline_options.get("user"));
                }
                if (global_commandline_options.get("password") != null) {
                    global_commandline_options.put("Password", (String)global_commandline_options.get("password"));
                }
                if (global_commandline_options.get("DatabaseURL") == null && this.m_ServerConfig.getDatabaseURL() == null && (db = (String)global_commandline_options.get("d")) != null) {
                    String host = "127.0.0.1";
                    if (global_commandline_options.get("n") != null) {
                        host = (String)global_commandline_options.get("n");
                    }
                    global_commandline_options.put("DatabaseURL", "jdbc:sapdb://" + host + "/" + db + "?timeout=0");
                }
                if ((access_key = (String)global_commandline_options.get("A")) == null) break block21;
                if (this.m_ServerConfig.getAdminPort() >= 0 || this.m_ServerConfig.getJndiPort() >= 0 || this.m_ServerConfig.getMsgPort() >= 0 || this.m_ServerConfig.getAdminPassword() != null || this.m_ServerConfig.getDatabaseURL() != null || this.m_ServerConfig.getPassword() != null || this.m_ServerConfig.getUser() != null) {
                    throw new ServerException("conflicting specifications: database url, database user name, database password, admin password, or one of the ports conflicts with database key.");
                }
                try {
                    AccParams param = new AccParams(access_key, (String)global_commandline_options.get(SECURITY_PROVIDER));
                    param.loadParameters();
                    global_commandline_options.put("AdminPort", param.getMsgSvrAdminPort());
                    global_commandline_options.put("JndiPort", param.getJndiPort());
                    global_commandline_options.put("MsgPort", param.getMsgPort());
                    global_commandline_options.put("AdminPassword", param.getMsgAdminPassword());
                    global_commandline_options.put("Password", param.getDBPassword());
                    global_commandline_options.put("User", param.getDBUser());
                    global_commandline_options.put("DatabaseURL", "jdbc:sapdb://" + param.getDBHost() + "/" + param.getDBName() + "?timeout=0");
                }
                catch (Exception e) {
                    throw new ServerException(e.toString());
                }
            }
            catch (IOException ex) {
                throw new ServerException(ex.toString());
            }
            catch (ParserConfigurationException pex) {
                throw new ServerException(pex.toString());
            }
            catch (SAXException sax) {
                throw new ServerException(sax.toString());
            }
        }
        SqlCmd.initSQL(this.m_ServerConfig.getSchema());
        this.myUseSSL = this.m_ServerConfig.getSSLSocket() == 1;
        String logFilename = null;
        logFilename = aLogFile == null || aLogFile.equals("") ? this.m_ServerConfig.getLogFile() : aLogFile;
        if (logFilename == null) {
            out = System.out;
        } else {
            try {
                out = new FileOutputStream(logFilename, true);
            }
            catch (IOException ex) {
                throw new ServerException(ex.toString());
            }
        }
        this.setLogStream((OutputStream)var5_8);
        myMessagePrefix = "starting ";
        Server.log("Starting server");
        this.myThreadGroup = new ThreadGroup("Server");
        this.myConnectionManager = new ConnectionManager(this.m_ServerConfig.getMaxConnections());
        this.myListeners = new Hashtable(100);
        AdminService admin = new AdminService(this);
        int aminPort = this.m_ServerConfig.getAdminPort();
        this.addService("Admin Service", admin, aminPort);
        this.m_JMSService = new JmsService(this);
        int msgPort = this.m_ServerConfig.getMsgPort();
        this.addService("Message Server", this.m_JMSService, msgPort);
        JndiService jndiservice = new JndiService(this);
        int jndPort = this.m_ServerConfig.getJndiPort();
        if (jndPort > 0) {
            this.addService("JNDI Server", jndiservice, jndPort);
        }
        myMessagePrefix = "";
        if (this.myUseSSL) {
            Server.log("-- Use SSL Socket --");
        }
        Server.log("=====  S E R V E R   R E A D Y  =====");
    }

    public ConnectionManager getConnectionManager() {
        return this.myConnectionManager;
    }

    public Hashtable getListeners() {
        return this.myListeners;
    }

    public ThreadGroup createSubThreadGroup(String name) {
        return new ThreadGroup(this.myThreadGroup, name);
    }

    private void setLogStream(OutputStream out) {
        myLogStream = out == null ? null : new PrintWriter(new OutputStreamWriter(out));
    }

    public static void log(String s) {
        if (myLogStream != null) {
            myLogStream.println("[" + myMessagePrefix + new Date() + "] " + s);
            myLogStream.flush();
        } else {
            System.out.println("[" + myMessagePrefix + new Date() + "] " + s);
            System.out.flush();
        }
    }

    public static void log(Object o) {
        Server.log(o.toString());
    }

    public static void log(Exception ex, boolean verbose) {
        if (ex instanceof SQLException) {
            SQLException e = (SQLException)ex;
            if (e.getSQLState() == null) {
                Server.log("SQLException " + e.getErrorCode());
            } else {
                Server.log("SQLException " + e.getErrorCode() + ": " + e.getSQLState());
            }
        }
        if (verbose) {
            Server.log(Server.getStackTraceAsString(ex));
        } else {
            Server.log(ex.toString());
        }
    }

    public static String getStackTraceAsString(Exception ex) {
        ByteArrayOutputStream byteStream = null;
        PrintWriter printWriter = null;
        String stackTrace = null;
        byteStream = new ByteArrayOutputStream();
        printWriter = new PrintWriter(byteStream, true);
        ex.printStackTrace(printWriter);
        printWriter.flush();
        stackTrace = byteStream.toString();
        printWriter.close();
        return stackTrace;
    }

    private void addService(String serviceName, Service service, int port) throws ServerException {
        SocketListener listener;
        Integer key = new Integer(port);
        if (this.myListeners.get(key) != null) {
            throw new ServerException("Port " + port + " already in use [" + serviceName + "]");
        }
        try {
            listener = new SocketListener(this.myThreadGroup, port, this.myConnectionManager, service, this.myUseSSL);
        }
        catch (IOException ex) {
            throw new ServerException(ex.getMessage() + " [" + serviceName + ", port " + port + "]");
        }
        this.myListeners.put(key, listener);
        service.open(this.m_global_commandline_options);
        Server.log("Starting service " + service.getClass().getName() + " on port " + port);
        listener.start();
    }

    private boolean removeService(int port) throws ServerException {
        Integer key = new Integer(port);
        SocketListener listener = (SocketListener)this.myListeners.get(key);
        if (listener == null) {
            return false;
        }
        Server.log("remove service " + port + " " + listener.getService().toString());
        listener.pleaseStop();
        listener.getService().close();
        this.myListeners.remove(key);
        Server.log("Stopping service " + listener.getService().getClass().getName() + " on port " + port);
        return true;
    }

    public synchronized void waitForShutdown() throws InterruptedException {
        this.wait();
    }

    public synchronized void shutdown() {
        myMessagePrefix = "shutdown ";
        this.getConnectionManager().stopAllConnections();
        Enumeration list = this.myListeners.elements();
        while (list.hasMoreElements()) {
            SocketListener listener = (SocketListener)list.nextElement();
            try {
                this.removeService(listener.getPort());
            }
            catch (ServerException ex) {
                Server.log("Error while deregistering service <" + listener.getService().getName() + ">: " + ex);
            }
        }
        this.notify();
    }

    public ServerConfig getServerConfig() {
        return this.m_ServerConfig;
    }

    public JmsService getJMSService() {
        return this.m_JMSService;
    }

    public static String getVersion() {
        return "7.6";
    }

    static {
        myMessagePrefix = "";
        lineSep = System.getProperty("line.separator", "\r\n");
    }
}

