/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer;

import com.sap.sdb.msgServer.Resources;
import com.sap.sdb.msgServer.client.AdminConnection;
import com.sap.sdb.programmargs.AccParams;
import com.sap.sdb.programmargs.PasswordPrompt;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class AdminClient {
    private static final String ACCESS_KEY = "-access_key";
    private static final String ENCRYPTION = "-encryption";
    private static final String MSG_SERVER = "-msgserver_host";
    private static final String MSG_SERVER_ADMIN_PORT = "-msgserver_admin_port";
    private static final String PASSWORD = "-password";
    private static final String SECURITY_PROVIDER = "-security_provider";

    public static void main(String[] args) {
        String hostname = null;
        String password = null;
        String access_key = null;
        String security_provider = null;
        String ms_admin_port = null;
        String command = null;
        String ms_ssl = null;
        try {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-A") || args[i].equals(ACCESS_KEY)) {
                    access_key = args[i + 1];
                    i += 2;
                    AccParams param = new AccParams(access_key, security_provider);
                    param.loadParameters();
                    if (password != null && password.length() > 0) {
                        System.out.println("Password " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    password = param.getMsgAdminPassword();
                    if (hostname != null && hostname.length() > 0) {
                        System.out.println("Message Server Host " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    hostname = param.getMsgServer();
                    if (ms_admin_port != null && ms_admin_port.length() > 0) {
                        System.out.println("Message Server Admin Port " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    ms_admin_port = param.getMsgSvrAdminPort();
                    if (ms_ssl != null && ms_ssl.length() > 0) {
                        System.out.println("Message Server Secure " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    ms_ssl = param.getMsg_SSL();
                    continue;
                }
                if (args[i].equals(MSG_SERVER)) {
                    if (hostname != null && hostname.length() > 0) {
                        System.out.println("Message Server Host " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    hostname = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(MSG_SERVER_ADMIN_PORT)) {
                    if (ms_admin_port != null && ms_admin_port.length() > 0) {
                        System.out.println("Message Server Admin Port " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    ms_admin_port = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(SECURITY_PROVIDER)) {
                    security_provider = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals("-p") || args[i].equals(PASSWORD)) {
                    if (password != null && password.length() > 0) {
                        System.out.println("Password " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    try {
                        String tmp = args[i + 1];
                        if (!tmp.startsWith("-")) {
                            password = tmp;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        // empty catch block
                    }
                    if (password == null || password.length() < 1) {
                        ++i;
                        password = PasswordPrompt.getPassword("Message Server Admin Password:\n");
                    } else {
                        i += 2;
                    }
                    password = AdminClient.buildLogonQualifier(password);
                    continue;
                }
                if (args[i].equalsIgnoreCase(ENCRYPTION)) {
                    ms_ssl = args[i + 1];
                    i += 2;
                    continue;
                }
                if (command != null) {
                    throw new Exception("unknown argument in command line at position " + (i + 1) + ": " + args[i]);
                }
                command = args[i];
                ++i;
            }
            if (ms_admin_port == null || ms_admin_port.length() < 1 || hostname == null || hostname.length() < 1 || password == null || password.length() < 1) {
                throw new Exception(Resources.getString("Insufficient_Connect_Parameter"));
            }
        }
        catch (Exception e) {
            System.err.println(e);
            System.err.println();
            System.err.println("Options without access key:");
            System.err.println("   -msgserver_host <hostname> -msgserver_admin_port <portnumber> -password <password> [-encryption SSL] [<command>]");
            System.err.println();
            System.err.println("Options with access key:");
            System.err.println("[-security_provider <provider>] -A <acces key> [<command>]");
            System.err.println();
            System.err.println("The password will be converted to uppercase, if not surrounded with double quotes.");
            System.exit(1);
        }
        try {
            String answer;
            int portnumber = Integer.parseInt(ms_admin_port);
            boolean useSSL = ms_ssl == null ? false : ms_ssl.equalsIgnoreCase("ssl");
            AdminConnection adminConnect = new AdminConnection();
            adminConnect.connectToAdminService(useSSL, hostname, portnumber);
            System.out.print("Connected to " + adminConnect.getInetAddress() + ":" + adminConnect.getPort());
            if (useSSL) {
                System.out.print(" with SSL Connection");
            }
            System.out.println();
            if (password != null) {
                adminConnect.sendMessage("password " + password);
                answer = adminConnect.receivedMessage();
                if (answer != null && !answer.startsWith("OK")) {
                    System.out.println(answer);
                }
            }
            if (command != null) {
                System.out.println(command);
                adminConnect.sendMessage(command);
                answer = adminConnect.receivedMessage();
                if (answer != null) {
                    System.out.println(answer);
                }
            } else {
                String commandLine;
                BufferedReader fromUser = new BufferedReader(new InputStreamReader(System.in));
                System.out.print(">");
                while ((commandLine = fromUser.readLine()) != null) {
                    adminConnect.sendMessage(commandLine);
                    String answer2 = adminConnect.receivedMessage();
                    if (answer2 == null) break;
                    System.out.println(answer2);
                    System.out.print(">");
                }
            }
            adminConnect.close();
            System.out.println("Connection closed");
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
    }

    private static String buildLogonQualifier(String name) {
        if (name == null || name.length() < 1) {
            return name;
        }
        if (name.charAt(0) == '\"') {
            return name.substring(1, name.length() - 1);
        }
        return name.toUpperCase();
    }
}

