/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.dataAccess;

import com.sap.sdb.minDB.common.ColumnType;
import com.sap.sdb.minDB.common.DatabaseRow;
import com.sap.sdb.minDB.dataAccess.DatabaseCatalog;
import com.sap.sdb.minDB.dataAccess.IndexTable;
import com.sap.sdb.minDB.dataAccess.ResultSetImpl;
import com.sap.sdb.minDB.dataAccess.ResultSetOrderBy;
import com.sap.sdb.minDB.dataAccess.Table;
import com.sap.sdb.minDB.dataAccess.TableName;
import com.sap.sdb.minDB.util.ErrorMsg;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;

public abstract class TableMetaData {
    private static final String SCHEMA_NAME = "DatabaseMetaData";
    private static final String TABNAME_GET_CATALOGS = "getCatalogs";
    private static final String TABNAME_GET_COLUMNS = "getColumns";
    private static final String TABNAME_GET_INDEX = "getIndexInfo";
    private static final String TABNAME_GET_KEY = "getPrimaryKeys";
    private static final String TABNAME_GET_SCHEMAS = "getSchemas";
    private static final String TABNAME_GET_TABLES = "getTables";
    private static final String DEFAULT_CATALOG_NAME = "";
    private static final String WILDCARD_SYMBOL = "%";

    public static ResultSetImpl getCatalogsResultSet() throws SQLException {
        boolean MAX_NUM_COL = false;
        boolean MAX_OBJ_COL = true;
        String[] schemaList = new String[]{SCHEMA_NAME};
        String[] tableList = new String[]{TABNAME_GET_CATALOGS};
        String[] colNameList = new String[]{null, "TABLE_CAT"};
        byte[] colTypeList = new byte[]{0, 2};
        ResultSetImpl result = new ResultSetImpl(0, 1, schemaList, tableList, colNameList, colTypeList);
        DatabaseRow row = result.getNewResultRow();
        row.setCharCol(1, DEFAULT_CATALOG_NAME);
        result.addRow(row);
        result.resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSetImpl getColumnsResultSet(DatabaseCatalog catalog, String schemaPattern, String tablePattern, String columnPattern) throws SQLException {
        int MAX_NUM_COL = 17;
        int MAX_OBJ_COL = 18;
        int[] orderByColNo = new int[]{-1, 2, 3, 17};
        boolean[] orderByAsc = new boolean[]{false, true, true, true};
        String[] schemaList = new String[]{SCHEMA_NAME};
        String[] tableList = new String[]{TABNAME_GET_COLUMNS};
        String[] colNameList = new String[]{null, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE"};
        byte[] colTypeList = new byte[]{0, 2, 2, 2, 2, 4, 2, 4, 2, 4, 4, 4, 2, 2, 4, 4, 4, 4, 2};
        ResultSetOrderBy result = new ResultSetOrderBy(false, 17, 18, orderByColNo, orderByAsc, schemaList, tableList, colNameList, colTypeList);
        boolean isAnyColumn = TableMetaData.isWildCardPattern(columnPattern);
        LinkedList tabList = TableMetaData.getTableList(catalog, schemaPattern, tablePattern);
        Iterator iter = tabList.iterator();
        while (iter.hasNext()) {
            Table tab;
            Table table = tab = (Table)iter.next();
            synchronized (table) {
                int maxCols = tab.getMaxColNo();
                for (int colNo = 1; colNo <= maxCols; ++colNo) {
                    String colName = tab.getColumnName(colNo);
                    if (!isAnyColumn && !colName.equals(columnPattern)) continue;
                    DatabaseRow row = result.getNewResultRow();
                    byte colType = tab.getColumnType(colNo);
                    int precision = ColumnType.getPrecision(colType);
                    row.setCharCol(2, tab.getSchemaName());
                    row.setCharCol(3, tab.getTableIdentifier());
                    row.setCharCol(4, tab.getColumnName(colNo));
                    row.setNumericCol(5, ColumnType.getSQLType(colType));
                    row.setCharCol(6, ColumnType.getTypeName(colType));
                    row.setNumericCol(7, precision);
                    row.setNumericCol(11, 2L);
                    row.setNumericCol(17, colNo);
                    row.setCharCol(18, DEFAULT_CATALOG_NAME);
                    if (colType == 3 || colType == 4) {
                        row.setNumericCol(9, precision);
                    }
                    result.addRow(row);
                }
            }
        }
        result.resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSetImpl getIndexResultSet(DatabaseCatalog catalog, String username, String schema, String tabIdentifier, boolean unique) throws SQLException {
        Table tab;
        int MAX_NUM_COL = 12;
        int MAX_OBJ_COL = 13;
        int[] orderByColNo = new int[]{-1, 4, 6, 8};
        boolean[] orderByAsc = new boolean[]{false, true, true, true};
        String[] schemaList = new String[]{SCHEMA_NAME};
        String[] tableList = new String[]{TABNAME_GET_INDEX};
        String[] colNameList = new String[]{null, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
        byte[] colTypeList = new byte[]{0, 2, 2, 2, 4, 2, 2, 4, 4, 2, 2, 4, 4, 2};
        ResultSetOrderBy result = new ResultSetOrderBy(false, 12, 13, orderByColNo, orderByAsc, schemaList, tableList, colNameList, colTypeList);
        Table table = tab = TableMetaData.getTable(catalog, username, schema, tabIdentifier);
        synchronized (table) {
            Enumeration iter = tab.getIndexTableIterator();
            if (iter != null) {
                while (iter.hasMoreElements()) {
                    IndexTable index = (IndexTable)iter.nextElement();
                    if (unique && !index.isUnique()) continue;
                    int isUniqueInt = index.isUnique() ? 1 : 0;
                    int rowCount = index.getRowCount();
                    int maxIndexCols = index.getMaxIndexColumns();
                    for (int indexColNo = 1; indexColNo <= maxIndexCols; ++indexColNo) {
                        DatabaseRow row = result.getNewResultRow();
                        int colNo = index.getRowColumnNo(indexColNo);
                        String ascOrDesc = index.isAscending(indexColNo) ? "A" : "D";
                        row.setCharCol(2, tab.getSchemaName());
                        row.setCharCol(3, tab.getTableIdentifier());
                        row.setNumericCol(4, isUniqueInt);
                        row.setCharCol(6, index.getIndexName());
                        row.setNumericCol(7, 3L);
                        row.setNumericCol(8, indexColNo);
                        row.setCharCol(9, tab.getColumnName(colNo));
                        row.setCharCol(10, ascOrDesc);
                        row.setNumericCol(11, rowCount);
                        result.addRow(row);
                    }
                }
            }
        }
        DatabaseRow row = result.getNewResultRow();
        row.setNumericCol(7, 3L);
        result.resultCreated();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSetImpl getPrimaryKeysResultSet(DatabaseCatalog catalog, String username, String schema, String tabIdentifier) throws SQLException {
        Table tab;
        int MAX_NUM_COL = 5;
        int MAX_OBJ_COL = 6;
        int[] orderByColNo = new int[]{-1, 4};
        boolean[] orderByAsc = new boolean[]{false, true};
        String[] schemaList = new String[]{SCHEMA_NAME};
        String[] tableList = new String[]{TABNAME_GET_KEY};
        String[] colNameList = new String[]{null, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
        byte[] colTypeList = new byte[]{0, 2, 2, 2, 2, 4, 2};
        ResultSetOrderBy result = new ResultSetOrderBy(false, 5, 6, orderByColNo, orderByAsc, schemaList, tableList, colNameList, colTypeList);
        Table table = tab = TableMetaData.getTable(catalog, username, schema, tabIdentifier);
        synchronized (table) {
            int[] keyColNoList = tab.getKeyColumnList();
            if (keyColNoList.length == 1) {
                DatabaseRow row = result.getNewResultRow();
                row.setCharCol(2, tab.getSchemaName());
                row.setCharCol(3, tab.getTableIdentifier());
                row.setCharCol(4, "SYSTEMKEY");
                row.setNumericCol(5, 1L);
                result.addRow(row);
            } else {
                for (int keyColNo = 1; keyColNo < keyColNoList.length; ++keyColNo) {
                    DatabaseRow row = result.getNewResultRow();
                    row.setCharCol(2, tab.getSchemaName());
                    row.setCharCol(3, tab.getTableIdentifier());
                    row.setCharCol(4, tab.getColumnName(keyColNoList[keyColNo]));
                    row.setNumericCol(5, keyColNo);
                    result.addRow(row);
                }
            }
        }
        result.resultCreated();
        return result;
    }

    public static ResultSetImpl getSchemasResultSet(DatabaseCatalog catalog) throws SQLException {
        boolean MAX_NUM_COL = false;
        boolean MAX_OBJ_COL = true;
        String[] schemaList = new String[]{SCHEMA_NAME};
        String[] tableList = new String[]{TABNAME_GET_SCHEMAS};
        String[] colNameList = new String[]{null, "TABLE_SCHEM"};
        byte[] colTypeList = new byte[]{0, 2};
        ResultSetImpl result = new ResultSetImpl(0, 1, schemaList, tableList, colNameList, colTypeList);
        String[] schemas = catalog.getUserOrSchemaList();
        if (schemas != null) {
            TreeMap schemaTree = new TreeMap();
            for (int i = 0; i < schemas.length; ++i) {
                schemaTree.put(schemas[i], null);
            }
            Iterator iter = schemaTree.keySet().iterator();
            while (iter.hasNext()) {
                DatabaseRow row = result.getNewResultRow();
                row.setCharCol(1, (String)iter.next());
                result.addRow(row);
            }
        }
        result.resultCreated();
        return result;
    }

    private static Table getTable(DatabaseCatalog catalog, String username, String schema, String tabIdentifier) throws SQLException {
        if (tabIdentifier == null) {
            throw ErrorMsg.newSQLException("Table identifier not specified", -4004);
        }
        TableName tabName = TableMetaData.isWildCardPattern(schema) ? new TableName(username, tabIdentifier) : new TableName(schema, tabIdentifier);
        Table tab = catalog.getTable(tabName);
        if (tab == null) {
            throw tabName.getNotFoundException();
        }
        return tab;
    }

    private static LinkedList getTableList(DatabaseCatalog catalog, String schemaPattern, String tablePattern) {
        LinkedList<Table> qualifiedTabList = new LinkedList<Table>();
        boolean isAnySchema = TableMetaData.isWildCardPattern(schemaPattern);
        boolean isAnyTable = TableMetaData.isWildCardPattern(tablePattern);
        if (!isAnySchema && !isAnyTable) {
            TableName tabName = new TableName(schemaPattern, tablePattern);
            Table tab = catalog.getTable(tabName);
            if (tab != null) {
                qualifiedTabList.add(tab);
            }
            return qualifiedTabList;
        }
        Table[] tabList = catalog.getTableList();
        if (tabList == null) {
            return qualifiedTabList;
        }
        for (int i = 0; i < tabList.length; ++i) {
            if (!isAnySchema && !tabList[i].getSchemaName().equals(schemaPattern) || !isAnyTable && !tabList[i].getTableIdentifier().equals(tablePattern)) continue;
            qualifiedTabList.add(tabList[i]);
        }
        return qualifiedTabList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSetImpl getTablesResultSet(DatabaseCatalog catalog, String schemaPattern, String tablePattern) throws SQLException {
        boolean MAX_NUM_COL = false;
        int MAX_OBJ_COL = 5;
        int[] orderByColNo = new int[]{-1, 2, 3};
        boolean[] orderByAsc = new boolean[]{false, true, true};
        String[] schemaList = new String[]{SCHEMA_NAME};
        String[] tableList = new String[]{TABNAME_GET_TABLES};
        String[] colNameList = new String[]{null, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS"};
        byte[] colTypeList = new byte[]{0, 2, 2, 2, 2, 2};
        ResultSetOrderBy result = new ResultSetOrderBy(false, 0, 5, orderByColNo, orderByAsc, schemaList, tableList, colNameList, colTypeList);
        LinkedList tabList = TableMetaData.getTableList(catalog, schemaPattern, tablePattern);
        Iterator iter = tabList.iterator();
        while (iter.hasNext()) {
            Table tab = (Table)iter.next();
            DatabaseRow row = result.getNewResultRow();
            Table table = tab;
            synchronized (table) {
                row.setCharCol(2, tab.getSchemaName());
                row.setCharCol(3, tab.getTableIdentifier());
                row.setCharCol(4, "TABLE");
                row.setCharCol(5, tab.getRemarks());
            }
            result.addRow(row);
        }
        result.resultCreated();
        return result;
    }

    private static boolean isWildCardPattern(String pattern) {
        return pattern == null || pattern.equals(DEFAULT_CATALOG_NAME) || pattern.equals(WILDCARD_SYMBOL);
    }
}

